<?php
/*
 * Ajax Chat for TRPG ver.2.4
 * (c)2007-2009 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/pastlog.php';
require_once './lib/member_check.php';

// 設定セット
set_config(read_config());

// アクセスブロック
access_block();

// 直近の過去ログを「流す」場合
if (DELETE_LAST_PASTLOG) {
    exit;
}

// リクエスト受信
$request = request();

foreach($request as $k => $v) {
    $data[$k] = htmlspecialchars($v);
}

// パスワード照合
$hash = "";
$data['pwd_on'] = isset( $data['pwd_on'] ) ? $data['pwd_on'] : NULL ;
$data['name_on'] = isset( $data['name_on'] ) ? $data['name_on'] : NULL ;
$hash = create_hash($data['name_on'], $data['pwd_on']);
// マスターパスワード
if (MASTERPASS && $data['pwd_on'] == MASTERPASS) {
    $hash = MASTERPASS;
}

// 直近の過去ログを参加者にしか表示しない場合
if (UNPUBLIC_LAST_PASTLOG) {
    $flg = false;
    $member = get_member_log();
    // 参加者が居ない/入力ID:パスワードのハッシュで参加者と一致しない場合、停止
    if (!$member) {
        exit;
    } elseif ($hash) {
        foreach ($member as $v) {
            if ($v[1] == $hash) {
                $flg = true;
            }
        }
    } else {
        exit;
    }
    if (!$flg) exit;
}

// ログ取得
$log_datetime = time();
$filename = "chatlog_".date("YmdHis", $log_datetime).".html";

$row = html_header('過去ログ '.date("Y年m月d日 h時i分s秒", $log_datetime), 'pastlog', false, false);
$log = read_log(PAST_LOG, $hash, true, false);
if ($log) {
     foreach ($log as $v) {
          $row .= $v."\n";
     }
}
$row .= html_footer();

// IE対策
//session_cache_limiter('public');

// 出力
header("Content-type: text/html");
header("Content-Disposition: attachment; filename=$filename");
header("Content-length: ".strlen($row));
print $row;

exit;
 ?>
