<?php
/*
 Ajax Chat for TRPG ver.2.6
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*******************
 *  カード機能：表示
 *******************/

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/card.php';
require_once './lib/member_check.php';

// 設定セット
set_config(read_config());

// 使用設定
if (!USE_CARD) {
    error('使用できません');
}

// アクセスブロック
access_block();

// HTML出力
print html_header(CHAT_TITLE.'カード機能', 'card', true, true);

// JavaScript読み込み
require_once './lib/js/trpgchat-js.php';
require_once './lib/js/card-js.php';

 ?>
</head>
<body id="body">

<?php
// カード詳細
$header = '<span class="cardTitle">カード詳細</span>';
$body = '<div class="cardDetailImage"></div><div class="cardText"></div>';
$footer = '<form name="cardDetailConsole"onsubmit="return false;" action="">
<input id="selectCardId" type="hidden" value="">
<input id="selectFrom" type="hidden" value="">
<input id="selectField" type="hidden" value="">
<input id="oneDraw" type="submit" value="このカードを引く" onclick="selectCardDraw();"><br>
<select name="member" id="selectMember">
<option value="deckCardSet" id="deckCardSetSelect" selected>現在のカード</option>
<option value="plName" id="plNameSelect">自分</option>
</select>の
<input id="oneCastField" type="submit" value="場に出す" onclick="selectCardCast(\'Field\');">
<input id="oneCastSecret" type="submit" value="手札に渡す/山に戻す" onclick="selectCardCast(\'Secret\');"><br>
</form>';
write_console('35px', '45px', '200px', 'none', 'cardDetail', $header, $body, '', $footer, false);
?>


<div id="deckType">
<div class="nodisplay"><form action="./#" method="GET" onsubmit="return false;"></div>
<div id="selectCard">
<?php
$card_ini_list = read_card_ini();

if ($card_ini_list) {
    print '<select name="deckSelect" id="deckSelect">'."\n";
    print '<option name="">カード変更</option>'."\n";
    foreach($card_ini_list as $v) {
        print '<option value="'.$v['config']['filename'].'">'.$v['config']['name']."</option>\n";
    }
    print '<option value="noCard">片付ける</option>'."\n";
    print '</select>'."\n";
    $onclick = 'changeDeck();';
    show_icon(CARD_READ_ICON, '', '', '', "新", '', $onclick);
} else {
    print '使用できるカードの設定がありません。';
}
?>
</div>
<div id="nowDeckOpelation">
<ul class="name" id="deckName">
<li class="command"><input name="drawNum" id="deckDrawNum" type="text" value="1" size="2" istyle="4">枚 <input name="submit" class="cardDraw" id="deckDraw" onclick="var cardNum=getCardDrowNum('#deckDrawNum');if(!cardNum){return false;}updateCardStatus('draw', 'deckCardSet', 'Secret',  'plName', 'Secret', cardNum, '', true);" type="submit" value="引く"><input name="submit" id="deckCast" onclick="var cardNum=getCardDrowNum('#deckDrawNum');if(!cardNum){return false;}updateCardStatus('cast', 'deckCardSet', 'Secret', 'deckCardSet', 'Field', cardNum, '', 1);" type="submit" value="出す">
</li></ul>
<div class="nodisplay"></form></div>
</div>
</div>

<form name="cardSubmit" onsubmit="return false;" action="">
<div id="deckPlace">
<ul class="player" id="deckCardSet">
<li class="name" id="deckCardSet">現在のカード：<span class="nameValue" id="name"></span> <span class="name" id="deckSetName"></span><span style="display:none;" id="deckConfig"></span></li>
<li class="position">
<div class="Secret" id="deckSecret">山：<span class="contents"></span></div>
<div class="Field" id="deckField">場：<span class="contents"></span></div>
<li class="command">
<a href="#" onclick="returnCard('#deckField .contents', 'deckCardSet');return false;">場札を山に戻す</a> <a href="#" onclick="returnCard('all', '');return false;">全てのカードを山に戻す</a>
</ul>
</div>

<div id="myPlace">
<ul class="player" id="plName">
<li class="name" id="playerName"></li>
<li class="position">
<div class="Secret" id="mySecret">手：<span class="contents"></span></div></li>
<div class="Field" id="myField">場：<span class="contents"></span></div></li>
<li class="command">
<a href="#" onclick="returnCard('#mySecret .contents', 'plName');return false;">手札を山に戻す</a> <a href="#" onclick="returnCard('#myField .contents', 'plName');return false;">場札を山に戻す</a>
</li>
</ul>
</div>

<div id="oplPlace">
</div>

<div id="noMemberPlace">
<ul class="player" id="noMember">
<li class="name" id="noMemberName">退室者のカード(<span id="noMemberCardsNum">0</span>)</li>
<li class="command"><a href="#" onclick="returnCard('nomember', 'noMember');return false;">山に戻す</a>
</li></ul>
</div>

</div>

<div id="cardSpace" class="nodisplay">
</div>
<div id="cardDetail" class="nodisplay">
</div>

</form>
<noscript>
<p><img src="image/blog_jscript.gif" alt="Javascript" width="80" height="15">本チャットは、JavaScript が有効な環境でのみ使用可能です。</p>
</noscript>

<?php
// フッター
print html_footer('');
 ?>