<?php
/*
 Ajax Chat for TRPG ver.2.6
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/* 携帯用発言書込み */

// デバッグ用設定
ini_set('log_errors', false);
ini_set('error_log', "./php_error.log");

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/write.php';
require_once './lib/member_check.php';
require_once './lib/mobile.php';

// 設定セット
set_config(read_config());

// 携帯使用設定
if (!USE_MOBILE) {
    mobile_error('携帯から利用できません。');
}

if (DICE_MAX != 0) {
    require_once './lib/trpg.php';
}

// 携帯以外のアクセス禁止
if (!is_mobile_access($ua)) {
    mobile_error('携帯以外からはご利用できません。');
}

// 書き込みブロック
write_block();

// アクセスブロック
access_block();

// リクエスト受信
if (!$request = $_GET) {
    mobile_error('ﾃﾞｰﾀ受信できません');
}

// PL名・コメントがなければ書込みはできない(含ロボット対策)
if ((!$request['n'] && !$request['c']) || !$request['m']) mobile_error("書きこみできません");

// ファイルロック
$lfp = fopen(LOCK,"w");
stream_set_write_buffer($lfp, 0);
flock($lfp,LOCK_EX);

// 既存ファイル内容の格納
$log = array();
$log[] = file(RECENT_LOG);

// 受信データの成形
foreach($request as $k => $v) {
    $data[$k] = htmlspecialchars($v);
}

// ログアウト
if ($request['mode'] == 'logout') {
    $data = set_mobile_logout_data($data);
// PC名がない場合、ログイン
// PC名がある場合はPC名＝PL名
} elseif (!$data['c']) {
    $data['c'] = $data['n'];
    // PL名チェック：現状なし
    // ログインデータセット
    $login_data = set_mobile_login_data($data);
} else {
    $data['n'] = $data['c'];
    // PL名チェック：現状なし(入れる場合、UAチェックなど必要）
}

// コメント本文の処理：（予定）ダイス、カード、タグ有効[b,span,i,u]、オートリンク、禁止語句処理など

// ダイス対応
if (DICE_MAX != 0) {
    // コメント欄
    $data['m'] = convert_dice($data['m']);
}

// HTMLタグ
$data['m'] = convert_html_tag($data['m']);

// オートリンク
$data['m'] = convert_autolink($data['m']);

// 既存ログのチェック
if(!is_array($log)){
    $log = array();
} else {
    $stopflag=0;
    foreach ($log[0] as $k => $v){
        $temp[$k] = explode("<>", $v);
    }
}

// 書込み
if ($stopflag==0) {

    // 最新ログNO
    if ($temp[0][0]) {
        $last_id = $temp[0][0]+1;
    } else {
        $last_id = 1;
    }

    // ログに書きこみ追加
    if ($request['mode'] != 'logout' && !empty($login_data)) {
        $log = mobile_set_log($login_data, $log, $last_id, $host, $ua, true);
    }
    $log = mobile_set_log($data, $log, $last_id, $host, $ua, $request['mode']);

    // ログファイル更新
    $fp = @fopen(RECENT_LOG, "w+") or error("ログファイルを開けません。", true);
    //$bom = "\xef\xbb\xbf";
    //fwrite($fp, $bom);

    foreach($log[0] as $k => $v) {
        fwrite($fp, $v);
    }
    fclose($fp);
}

// ロック解除
fflush($lfp);
fclose($lfp);

//参加者チェッカーに書き込み
// 現状なし
//member_checker($dn, $pwd, $request['y'], true);

// 遷移
$params = '/mindex.php';
$self_url = get_self_url();
if ($request['mode'] == 'logout') {
    $params .= '?msg='.urlencode('ﾛｸﾞｱｳﾄしました');
    $url = str_replace('/mwrite.php', '', $self_url).$params;
    header('Location: '. $url);
    exit;
} else {
    $params .= '?c='.urlencode(encode2utf8($data['c'])).'&r='.$data['r'];
    $url = str_replace('/mwrite.php', '', $self_url).$params;
    header('Location: '. $url);
    exit;
}

/* 
 * ログに追加
 */
function mobile_set_log($data, $log, $last_id, $host, $ua, $system=false)
{
    // 書き込み成形
    $write = "";
    $dm = $data['m'];
    $pcname = $data['c'];

    $pwd = ''; // パスワード：なし
    if ($system) {
        $data['l'] = COLOR_SYSTEM; // システム文字色
    } else {
        $data['l'] = ''; // PC文字色：
    }
    $dn = $data['n'];
    $dw = ''; // pwdハッシュ
    $dh = ''; // ステータス表示有無
    $dt = ''; // ステータス
    // 難読化
    if (OBFUSCATION) {
        $pcname = obf_xor(encode2utf8($pcname));
        $dm = obf_xor(encode2utf8($dm));
        $dn = obf_xor(encode2utf8($dn));
        if ($dw) $dw = obf_xor(encode2utf8($dw));
        if ($dt) $dt = obf_xor(encode2utf8($dt));
    }

    $write = $last_id."<>".$dn."<>".$pcname."<>".$data['l']."<>".$dm."<>".time()."<>".$host."<>".$ua."<>".$pwd."<>".$dw."<>".$dh."<>".$data['s']."<>".$dt."<>1\n";


    // 直近の過去ログ更新
    write_recent_past(encode2utf8($write), PAST_LOG);

    // ログ更新
    array_unshift($log[0], encode2utf8($write));

    //最大行数を超えていたら最終行を削除
    if (count($log[0]) >= MAX_NUM) {
        array_pop($log[0]);
    }

    return $log;
}

/* 
 * ログイン
 */
function set_mobile_login_data($data) 
{
    $data['c'] = encode2sjis(SYSTEM);
    $data['m'] = $data['n'].encode2sjis(ONLINE_MSG);
    $data['s'] = 0;

    return $data;
}

/* 
 * ログアウト
 */
function set_mobile_logout_data($data) 
{
    $data['c'] = encode2sjis(SYSTEM);
    $data['m'] = $data['n'].encode2sjis(OFFLINE_MSG);
    $data['s'] = 0;

    return $data;
}
/* SJISへ変換 */
function encode2sjis($str)
{
    return mb_convert_encoding($str, 'SJIS-win', 'UTF-8');
}

/* UTF8へ変換 */
function encode2utf8($str)
{
    return mb_convert_encoding($str, 'UTF-8', 'SJIS-win');
}


?>
