<?php
/*
 Ajax Chat for TRPG ver.2.6
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */
/*****************
 *  かんたんセットアップ
 *****************/
// 設定ファイルの読み込み
require_once './trpgchat-ini-2.php';
require_once './lib/trpgchat.php';
require_once './lib/setup.php';

if (file_exists('./trpgchat-ini.php')) {
    error('セットアップ済みです。再度セットアップする際は、index.phpと同じディレクトリにあるtrpgchat-ini.phpを削除してください', false, false, true);
}

// 受信データの成形
$request = request();
$mode = $request['mode'];
$prev_dir = $request['previous_chat_dir'];

/* セットアップ開始 */
print html_header_setup();
?>
</head>
<body>
<?php
// 入り口
if (!$mode) {
    print '<p>Ajax Chat for TRPGのセットアップを始めます。<br>以下から選択してください。</p>';
    print '<form action="./setup.php" method="'.METHOD.'">';
    print '<table border="1">'."\n";
    print '<tr><td>';
    print input_area('radio', 'mode', 'install', '', '', 'checked'). ":新規インストール<br>\n";
    print input_area('radio', 'mode', 'verup', ''). ":バージョンアップ<br>\n";
    print " * バージョンアップは<font color=\"red\"><b>ver.2.0以降のみ</b></font>対応。<br>\n";
    print "</td></tr>\n";
    print '<tr><td style="text-align:center;">';
    print input_area('submit', 'submit', '次へ');
    print "</td></tr>\n";
    print "</table>\n";
    print '<p align="center"> </p>';
    print "</form>";

// 新規インストール
} elseif ($mode == 'install') {
    print "<h2>重要な設定</h2>\n";
    print "<h3>セキュリティに関わるので、<font color=\"red\">必ず変更してください。</font></h3>\n";
    print '<form action="./setup.php" method="'.METHOD.'">';
    print input_area('hidden', 'mode', 'install_do'). "\n";
    print '<table border="1">'."\n";
    print output_table("管理者用パスワード");
    print input_area('text', 'masterpass', 'password', '10');
    print "<br> * 必ず変更してください。\n";
    print output_table("パスワードの暗号化キー");
    print input_area('text', 'admin_hash', 'ajaxchat', '10');
    print "<br> * 4文字以上入力してください";
    print output_table("クッキー名");
    print input_area('text', 'cookie', 'AjaxChat', 20);
    print "<br> * 空にするとクッキーを使用できません";
    print '<tr><td colspan="2">';
    print '簡易設定のみでＯＫの場合、「次へ」を押してください。<p align="center"> <br>';
    print input_area('submit', 'submit', '次へ');
    print "</p></td></tr>\n";
    print "</table>\n";

    print " <p><br>詳細な設定を行なう場合は以下を設定して「次へ」を押してください。<br> </p> <br> <hr> <br>";

    easy_setup_config_ext1("i");

    print "<h2>ファイルの設定</h2>\n";
    print '<table border="1">'."\n";
    print output_table("重要な設定ファイル");
    print input_area('text', 'imp', './config-data-important.php');
    print output_table("タグの設定ファイル");
    print input_area('text', 'tag', './config-data-tag.php');
    print output_table("TRPG関連の設定ファイル");
    print input_area('text', 'trpg', './config-data-trpg.php');
    print output_table("カード関連の設定ファイル");
    print input_area('text', 'card', './config-data-card.php');
    print output_table("全体の配色設定ファイル");
    print input_area('text', 'bc', './config-data-base-color.php');
    print output_table("チャット画面の配色設定ファイル");
    print input_area('text', 'mc', './config-data-main-color.php');
    print output_table("全般設定ファイル");
    print input_area('text', 'main', './config-data-main.php');
    print output_table("アイコン設定ファイル");
    print input_area('text', 'icon', './config-data-icon.php');
    print output_table("携帯設定ファイル");
    print input_area('text', 'mobile', './config-data-mobile.php');
    print output_table("最新ログファイル");
    print input_area('text', 'rlog', './trpgchat.log');
    print output_table("直近の過去ログファイル");
    print input_area('text', 'plog', './trpgchat_past.log');
    print output_table("HTML化過去ログ保管ディレクトリ");
    print input_area('text', 'pdir', './past/');
    print output_table("管理用過去ログ保管ディレクトリ");
    print input_area('text', 'mpdir', './master_past/');
    print output_table("参加メンバーログファイル");
    print input_area('text', 'mem', './member.log');
    print output_table("ロックファイル");
    print input_area('text', 'l1', './lock.txt');
    print input_area('text', 'l2', './lock2.txt');
    print input_area('text', 'l3', './lock3.txt');
    print output_table("カード設定ディレクトリ");
    print input_area('text', 'cdir', './lib/card/');
    print output_table("現在のカード状態ファイル");
    print input_area('text', 'nd', './deckset.json');
    print input_area('text', 'nds', './deck_status.json');
    print "\n";

    print "</td></tr>\n";
    print '<tr><td style="text-align:center;" colspan="2">';
    print input_area('submit', 'submit', '次へ');
    print '<p align="center"> </p>';
    print "</td></tr>\n";
    print '</table>';
    print "</form>";

// バージョンアップ
} elseif ($mode == 'verup') {
    print "<h2>重要な設定</h2>\n";
    print '<form action="./setup.php" method="GET">';
    print input_area('hidden', 'mode', 'verup_do'). "\n";

    print '<table border="1">'."\n";
    print output_table("前バージョンのディレクトリ");
    print input_area('text', 'previous_chat_dir', '../trpgchat/', '30');
    print "<br> * 設定を引き継ぎたいチャットの設置場所（パス）を指定してください。<br>\n";
    print output_table("管理者用パスワード");
    print input_area('text', 'masterpass', 'password', '10');
    print "<br> * 設定を引き継ぎたいチャットで用いているパスワードを入力してください。\n";
    print output_table("直近の過去ログをコピーする");
    print input_area('radio', 'clog', '1', '', '', 'checked')." : はい<br>\n";
    print input_area('radio', 'clog', '0', '', '')." : いいえ";
    print output_table("過去ログは手動で設定する");
    print input_area('radio', 'mlog', '1', '', '')." : はい<br>\n";
    print input_area('radio', 'mlog', '0', '', '', 'checked')." : いいえ";
    print '<tr><td colspan="2">';
    print '簡易設定のみでＯＫの場合、「次へ」を押してください。<p align="center"> <br>';
    print input_area('submit', 'submit', '次へ');
    print "</p></td></tr>\n";
    print "</table>\n";

    print " <p><br>詳細な設定を行なう場合は以下を設定して「次へ」を押してください。<br> </p> <br> <hr> <br>";

    easy_setup_config_ext1("v");

    print "</form>";

// セットアップ
} elseif ($mode == 'install_do' || $mode == 'verup_do') {
    if (!$request['masterpass']) {
        error("管理者用パスワードを入力してください", true);
    }
    if ($mode == 'install_do' && !$request['admin_hash']) {
        error("暗号化キーを入力してください", true);
    }

    // デモモード
    if (DEMO_SETUP) {
        setup_end($request);
    }
    // ファイル名・ディレクトリ名チェック
    foreach ($request as $k => $v) {
        if ($k != 'submit' && $k != '777' && $k != '666' && $k != 'htaccess' && $k != 'clog' && $k != 'mlog' && $k != 'obf' && $k != 'ht_domain') check_name2($v);
        if ($request['htaccess'] == "1" && $k == 'ht_domain') {
            check_name2(preg_replace('/^(http\:\/\/)|(https\:\/\/)/', '', $v), "チャットのドメインを入力してください。");
        }
    }

    // trpgchat-ini.phpの出力と読み込み
    // バージョンアップの場合
    if ($mode == 'verup_do') {
        // 前バージョンの設定
        if (!is_readable($prev_dir)) error("指定のディレクトリ $prev_dir にアクセスできません", true);

        $prev_ini = $prev_dir.'/trpgchat-ini.php';
        if (!file_exists($prev_ini)) error($prev_ini."にアクセスできません", true);

        if (!defined('CONFIG_MOBILE')) {
            define('CONFIG_MOBILE', './config-data-mobile.php');
        }
        if (!defined('CONFIG_CARD')) {
            define('CONFIG_CARD', './config-data-card.php');
        }
        if (!defined('LOCK3')) {
            define('LOCK3', './lock3.txt');
        }
        if (!defined('CARD_DIR')) {
            define('CARD_DIR', './lib/card/');
        }
        if (!defined('NOW_DECK')) {
            define('NOW_DECK', './deckset.json');
        }
        if (!defined('NOW_DECK_STATUS')) {
            define('NOW_DECK_STATUS', './deck_status.json');
        }

        require_once $prev_ini;
        $data = array(
            'masterpass' => MASTERPASS,
            'admin_hash' => ADMIN_HASH_KEY,
            'cookie' => COOKIE,
            'imp' => CONFIG_IMPORTANT,
            'tag' => CONFIG_TAG,
            'trpg' => CONFIG_TRPG,
            'card' => CONFIG_CARD,
            'bc' => CONFIG_BASE_COLOR,
            'mc' => CONFIG_MAIN_COLOR,
            'main' => CONFIG_MAIN,
            'icon' => CONFIG_ICON,
            'mobile' => CONFIG_MOBILE,
            'rlog' => RECENT_LOG,
            'plog' => PAST_LOG,
            'pdir' => PAST_DIR,
            'mpdir' => MASTER_PAST_DIR,
            'mem' => NOW_MEMBER,
            'l1' => LOCK,
            'l2' => LOCK2,
            'l3' => LOCK3,
            'cdir' => CARD_DIR,
            'nd' => NOW_DECK,
            'nds' => NOW_DECK_STATUS,
        );

        if ($data['masterpass'] != $request['masterpass']) error("パスワードが合致しません", true);

        if ($request['obf']) $data['obf'] = '1';

        set_ini($data);
    } elseif ($mode == 'install_do') {
        set_ini($request);
        require_once './trpgchat-ini.php';
    }

    // configファイルの設定
    $GLOBALS['AJAX_CHAT_TRPG']['CONFIGFILES_NAME'] = array(
        CONFIG_IMPORTANT,
        CONFIG_TAG,
        CONFIG_TRPG,
        CONFIG_CARD,
        CONFIG_BASE_COLOR,
        CONFIG_MAIN_COLOR,
        CONFIG_MAIN,
        CONFIG_ICON,
        CONFIG_MOBILE,
    );

    foreach($GLOBALS['AJAX_CHAT_TRPG']['CONFIGFILES_NAME'] as $k => $v) {
        if (($mode == 'install_do' && copy(SETUP_ORIGFILE_DIR.$GLOBALS['AJAX_CHAT_TRPG']['ORIG_CONFIGFILES_NAME'][$k], $v))
            || ($mode == 'verup_do' && setup_config($prev_dir, $k, $v))) {
            set_permission_666($v, $request['666']);
        } else {
            unlink('./trpgchat-ini.php');
            error($v."の設定に失敗しました", true);
        }
    }

    if ($data) $request = array_merge($request, $data);

    // ログファイルの設定
    if (!($request['mode'] == 'verup_do' && $request['mlog']) && !set_logs($request)) {
        unlink('./trpgchat-ini.php');
        error("過去ログ関連の設定に失敗しました", true);
    }

    // .htaccessの設定
    if ($request['htaccess'] && $request['ht_domain']) {
        $contents = output_file_string(SETUP_DIR.'.htaccess');
        write_string_to_file('./.htaccess', sprintf($contents, quotemeta($request['ht_domain'])));
    }

    // setup.phpを削除してメッセージを表示
    setup_end($request);

} else {
    error('パラメータが不正です。');
}

// フッター
print html_footer();
exit;
?>