<?php
/*
 Ajax Chat for TRPG ver.2.6.1
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*****************
 *  PHPライブラリ：過去ログ用
 *****************/

require_once './lib/admin.php';
require_once './lib/log.php';

/*
 * ログの成形
 */
function read_log($logfile, $hash, $d, $html_icon=true)
{
    // ログの読み込み
    $log = array();
    $log = file($logfile);
    if (is_array($log)) {
        // データの成形
        foreach($log as $k => $v) {
            if ($v[0] != 0) {

                // 基本整形
                list($num, $name, $pc, $color, $com, $datetime, $host, $whisper_from_pass, $whisper_to_name, $whisper_to_pass, $w, $status, $isMobile) = format_log($v, $hash, $d, false);

                // 難読化
                if (OBFUSCATION) {
                    list($pc, $com, $name, $whisper_to_name, $status) = decode_obf_log($pc, $com, $name, $whisper_to_name, $status);
                }

                // 行の成形
                if ($num && $w != 'y') {
                    $row[$k] = '<div class="com_row"><span style="font-weight:bold; color:#'.$color.';" title="'.$name.'">【'.$pc.'】</span>';
                    if (SHOW_MOBILE_COM && $isMobile == 1) {
                        if (!$html_icon) {
                            $row[$k] .= '(M)';
                        } else {
                            $row[$k] .= show_mobile_icon(MOBILE_ICON, '', '', '', '(M)', '', '', false);
                        }
                    }
                    $row[$k] .= '：';

                    if ($w == 'to' || $w == 'from') {
                        $row[$k] .= '<span style="color:#'.COLOR_SYSTEM.'">(';
                        if ($w == 'to') $row[$k] .= $whisper_to_name.'さんへ';
                        if ($w == 'from') $row[$k] .= $com.'さんから';
                        $row[$k] .= 'のささやき) </span>';
                    }
                    if ($d && !SHOW_DATETIME) $row[$k] .= '<span title="'.$datetime.'">';
                    $row[$k] .= $com;
                    if ($d && !SHOW_DATETIME) $row[$k] .= '</span>';
                    if ($status) {
                        $row[$k] .= ' <span style="color:#'.STATUS_COLOR.';">('.$status.')</span>';
                    }
                    if ($d && SHOW_DATETIME) $row[$k] .= ' <span style="color:#'.COLOR_SYSTEM.';">['.$datetime.']</span>';
                    $row[$k] .= $host;
                    $row[$k] .= '</div>';
                }
            }
        }
    }
    return $row;
}

/*
 * ディレクトリ開閉タグの出力
 */
function print_toggle_dir($id, $dir_name, $child = false, $default = 'close', $title = 'クリックで開閉', $form = 'false', $past = '') {
    print '<div style="margin:0px;">';
    if ($child) { print "├";}
    if ($form) { print '<input type="radio" name="dir" value="'.$id.'">';};
    print '<span onclick="toggleColumn(\''.$id.$past.'\');toggleColumn(\'icon_'.$id.$past.'_s\');toggleColumn(\'icon_'.$id.$past.'_h\');" title="'.$title.'">';
    print '<image src="'.PASTLOG_DIR_CLOSE_ICON.'" id="icon_'.$id.$past.'_h" style="margin:0px;';
    if ($default == 'open') {
        print ' display:none;';
    }
    print '">'.
        '<image src="'.PASTLOG_DIR_OPEN_ICON.'" id="icon_'.$id.$past.'_s" style="margin:0px;';
    if ($default != 'open') {
        print ' display:none;';
    }
    print '">'.
        $dir_name.
        "</span></div>\n";
    print '<div id="'.$id.$past.'" style="padding:0px;';
    if ($default != 'open') {
        print 'display:none;';
    }
    print '">'."\n";

}


/*
 * 過去ログファイルリスト表示
 */
function print_pastloglist($files, $dir, $child = false, $form = false, $target = '_blank') {
    foreach($files as $v) {
        if ($child) { print '│'; }
        print '├';
        if ($form) { print '<input type="checkbox" name="file[]" value="'.$dir.$v.'">';}
        print '<a href="'.$dir.$v.'" target="'.$target.'">'.substr($v, 0, strlen($v)-5)."</a><br>\n";
    }
}

/*
 * 指定ディレクトリ内のファイル・ディレクトリ一覧
 */
function print_pastlog_contents_list($dir, $root_name, $sort = 'DESC', $form = '', $path = '', $past = '', $open_root = 'open', $open_child = 'close', $root_name = 'ルートディレクトリ', $title = 'クリックで開閉', $target = '_blank') {
    $list = get_dir_contents_list($dir, $sort);
    if ($list['dirs'] || $list['files']) {

        if ($form) {
            print '<form action="'.$path.'" method="'.METHOD.'">'."\n";
            print '<input type="hidden" name="type" value="'.$dir.'">'."\n";
        }

        // ルートディレクトリ
        print_toggle_dir($dir, $root_name, false, $open_root, $title, $form);

        // 子ディレクトリ
        if ($list['dirs'][0]) {
            foreach ($list['dirs'] as $k => $v) {
                $child[$k] = get_dir_contents_list($dir.$v."/", $sort);
                print_toggle_dir($v, $v, true, $open_child, $title, $form, $past);
                if ($child[$k]['files']) {
                    print_pastloglist($child[$k]['files'], $dir.$v.'/', true, $form, $target);
                }
                print "</div>\n";
            }
        }

        // ルートファイル一覧表示
        if ($list['files']) {
            print_pastloglist($list['files'], $dir, false, $form, $target);
        }
        print "</div>\n";

        if ($form) {
            print "<p>\n";
            print '<input type="submit" name="mode" value="削除確認">　';
            print '<input type="submit" name="mode" value="移動"></p>';
            print '<p><input type="text" name="new_filename" value="">.html　';
            print '<input type="submit" name="mode" value="ファイル名変更"><br>ファイル名に使える文字は、半角英数字とハイフン(-)、アンダーバー(_)のみです。<br>
</p>';
            print '<input type="reset">';
            print '</form>'."\n";
        }

    } else {
        print 'ログファイルはありません';
    }
}


?>