<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Controller
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class SiteConfigsController extends AppController {

	var $name = 'SiteConfigs';
	var $helpers = array(
	);

	var $disableTokenActions = array(
	);

	/* メソッド */
	function beforeFilter()
	{
		parent::beforeFilter();

		// Cache
		$this->cacheAction = array(
			'view' => Configure::read('Cache.expireLong'),
		);

		// 認証なしアクセス可
		$this->AuthPlus->allow('view');
	}

	function beforeRender()
	{
		parent::beforeRender();
	}

	function view($page = null)
	{
		switch ($page) {
			case 'help':
			case 'userAgreement':
			case 'privacyPolicy':
				$this->set('page', $page);
				break;
			default: 
				$this->error(__('Invalid data.', true));
		}

		$this->set('title_for_layout', " - ". __('Site Settings', true));
	}

	function admin_edit() {
		if (!empty($this->data) && !empty($this->data['SiteConfig'])) {
			$error_flg = false;
			foreach($this->data['SiteConfig'] as $k => $v) {
				if ($k == '__Token') {
					continue;
				}

				if (CorePlus::is_valid($v, 'id')) {
					$this->SiteConfig->id = $v['id'];
					$fields = $this->SiteConfig->fields['edit'];
				} else {
					$v['key_name'] = $k;
					$this->SiteConfig->create();
					$fields = $this->SiteConfig->fields['add'];
				}

				if (
					$k == 'Upload.imagefile.FileSizeMax' || 
					$k == 'Upload.imagefile.WidthMax' || 
					$k == 'Upload.imagefile.HeightMax'
				) {
					$v['value'] = intval($v['value']);
					if ($v['value'] < 0) {
						$v['value'] = NULL;
					}
				}

				$data['SiteConfig'] = $v;

				switch ($k) {
					case 'Design.customCss':
					case 'Site.siteDescription':
						$this->SiteConfig->fields['escape']['value']['all'] = false;
				}

				if (!$this->SiteConfig->save($data, true, $fields)) {
					$error_flg = true;
					break;
				}
			}

			if ($error_flg === true) {
				$this->Session->setFlash(__('The data could not be saved. Please, try again.', true));
			} else {
				$this->Session->setFlash(__('The SiteConfig has been saved', true));

				if (isset($this->data['design_submit'])) {
					$this->redirect(array('action'=>'edit_customcss'));
				} elseif (isset($this->data['html_submit'])) {
					$this->redirect(array('action'=>'edit_inserthtml'));
				} else {
					$sharp = null;
				}

				$this->redirect(array('action'=>'edit', '#' => $sharp));
			}
			unset($this->data['SiteConfig']['__Token']);
		}

		if (empty($this->data)) {
			$site_config = $this->site_configs;
			foreach ($site_config as $k => $v) {
				switch ($k) {
					case 'Site.siteDescription':
						$this->data['SiteConfig'][$k] = $this->_restore_html_site_config($v, true);
				}
			}

			$this->data['SiteConfig'] = $site_config;
		}

		$this->set('title_for_layout', " - ". __('Site Settings', true));
	}

	function admin_edit_customcss() {
		$site_config = $this->site_configs;
		foreach($site_config as $k => $v) {
			switch ($k) {
				case 'Design.customCss':
					$this->data['SiteConfig'][$k] = $this->_restore_html_site_config($v, true);
			}
		}

		$this->set('title_for_layout', " - ". __('Custom CSS', true));
	}

	function admin_edit_inserthtml() {
		$site_config = $this->site_configs;
		foreach($site_config as $k => $v) {
			if (strpos($k, 'InsertHTML.') === 0) {
				$this->data['SiteConfig'][$k] = $this->_restore_html_site_config($v, true);
			}
		}

		$this->set('title_for_layout', " - ". __('Insert HTML', true));
	}

	function admin_delete_allcache() {
		if (isset($this->data['Cache']['DelConfirm']) && $this->data['Cache']['DelConfirm'] == 'yes') {
			$this->SiteConfig->deleteCacheAll();
			

			$this->Session->setFlash(__('All Cache has been deleted.', true));
			$this->redirect(array('controller' => 'site_configs', 'action'=>'edit_customcss'));
		}
	}


	/* restore_html */
	function _restore_html_site_config($data, $nl2br = false) {
		$data['value'] = $this->{$this->modelClass}->restore_html($data['value'], false);
		if ($nl2br) {
			$data['value'] = str_replace('<br />', "\n", $data['value']);
		}

		return $data;
	}

}
?>