<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Model
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class CharactersHasProfile extends AppModel {

	var $name = 'CharactersHasProfile';

	var $fields = array(
		'add' => array('character_id', 'profile_id', 'profile_select_id', 'profile_table_id', 'profile_table_static_id', 'value', 'public_flag', 'link_value'),
		'escape' => array(
		),
	);

	var $validate = array(
		'public_flag' => array(
			'publicFlag' => array(
				'rule' => 'publicFlag',
				'allowEmpty' => true,
			),
		),
		'link_value' => array(
			'url' => array(
				'rule' => 'url',
				'allowEmpty' => true,
			),
		),
	);


	//The Associations below have been created with all possible keys, those that are not needed can be removed
	var $belongsTo = array(
		'Character' => array(
			'className' => 'Character',
			'foreignKey' => 'character_id',
			'conditions' => '',
			'fields' => '',
		),
		'Profile' => array(
			'className' => 'Profile',
			'foreignKey' => 'profile_id',
			'conditions' => '',
			'fields' => '',
		),
		'ProfileSelect' => array(
			'className' => 'ProfileSelect',
			'foreignKey' => 'profile_select_id',
			'conditions' => '',
			'fields' => '',
		),
		'ProfileTable' => array(
			'className' => 'ProfileTable',
			'foreignKey' => 'profile_table_id',
			'conditions' => '',
			'fields' => '',
		),
		'ProfileTableStatic' => array(
			'className' => 'ProfileTableStatic',
			'foreignKey' => 'profile_table_static_id',
			'conditions' => '',
			'fields' => '',
		)
	);

	/* Validation */
	function validProfileId($data, $system_id)
	{
		return (bool)$this->Profile->find('count', array(
			'conditions' => array(
				'Profile.id'  => $data['profile_id'],
				'Profile.system_id'  => $system_id,
			),
			'recursive' => -1,
		));
	}

	function validProfileSelectId($data, $system_id)
	{
		return $this->Profile->ProfileSelect->find('count', array(
			'conditions' => array(
				'ProfileSelect.id'  => $data['profile_select_id'],
				'Profile.system_id'  => $system_id,
			),
		));
	}

	function validProfiletableId($data, $system_id)
	{
		return $this->Profile->ProfileTable->find('count', array(
			'conditions' => array(
				'ProfileTable.id'  => $data['profile_table_id'],
				'Profile.system_id'  => $system_id,
			),
		));
	}

}
