<?php
/**
 * キャラクター画像表示用
 */

// アップロード済み画像の表示サイズ
if (!isset($previewVersion)) {
	$previewVersion = 'll';
}

/* Set $assocAlias and $model if you're using this element multiple times in one form */
if (!isset($assocAlias)) {
	$assocAlias = 'Attachment';
} else {
	$assocAlias = Inflector::singularize($assocAlias);
}

$model = 'CharacterPicture';
$modelId = $form->value($form->model().'.id');

if (!isset($item['CharacterPicture'])) {
	$item['CharacterPicture'] = $item;
}
if (isset($this->data[$assocAlias][0]['basename'])) {
	array_unshift($this->data[$assocAlias], array());
}

/* ラベル */
if (!isset($label)) {
	$label = __('File', true);
}

/* 表示モード */
if (!isset($mode)) {
	$mode = 'view';
}

/* $isOwnerフラグ */
if (!isset($isOwner)) {
	$isOwner = false;
}
if (!isset($isAdmin)) {
	$isAdmin = false;
}

?>

<div class="attachments">

<?php
	$file = $upfile->file(
		$previewVersion, 
		CorePlus::get_value($item, $assocAlias.'.0'),
		array(
			'model_name' => $model, 
			'mime_type' => 'original',
		)
	);
?>

<?php if (!empty($file)): ?>
<!-- Existing Attachments -->
<div class="existing">
<?php
	echo $upfile->embed(
		$file,
		array(
			'linkTo' => array('action' => 'view', $item['CharacterPicture']['id']),
			'alt' => $item['Attachment'][0]['alternative'],
			'class' => 'shadow',
			'restrict' => array('image')
		)
	);
?>

<?php if ($mode == 'edit' && $isOwner): ?>
<?php
	// ファイル情報出力
	echo $upfile->fileInfo($file, $item['Attachment'][0]);

	// caption
	echo $form->hidden($assocAlias . '.1.id', array('value' => $item['Attachment'][0]['id']));
	echo $form->input($assocAlias . '.1.alternative', array(
		'label' => __('Caption', true),
		'value' => $item['Attachment'][0]['alternative'],
	));
?>
</div>
<?php endif; ?>
<?php else: ?>

<?php if ($mode == 'edit' && $isOwner): ?>
<!-- New Attachment -->
<div class="new">
<?php
	echo $form->hidden($assocAlias . '.0.model', array('value' => $model));
	echo $form->hidden($assocAlias . '.0.group', array('value' => strtolower($assocAlias)));
	echo $form->input($assocAlias . '.0.file', array(
		'label' => $label,
		'type'  => 'file',
	));
	echo $form->input($assocAlias . '.0.alternative', array(
		'label' => $label." ".__('Caption', true),
		'value' => '',
	));
?>
</div>
<?php endif ?>

<?php endif ?>
</div>

