<?php if (isset($character['Character']['full_length']) && !empty($character['Character']['full_length'])): ?>
<?php 
echo $this->element('character_picture_full', array(
	'basename' => $character['Character']['full_length'],
	'options' => array(
		'previewVersion' => 'orig',
		'class' => '',
		'nodata' => '',
	)
));
?>
<?php endif; ?>
<div class="characters view">

<div class="box">
<div class="boxHeader"><h3>
<?php echo $character['Character']['name'];?>

<?php if ((($isOwner && $systemValid == 'public') || $isAdmin) && $isArchive !== true): ?>
<?php
	echo $html->tag(
		'span',
		$html->link(__('Edit', true), array('action' => 'edit', $character['Character']['id'])),
		array('class' => 'text')
	); 
?>
<?php endif; ?>
</h3></div>
<div class="boxBody <?php if (!empty($site_configs['Character.fullLengthView']['value'])): ?>
fullLength<?php endif; ?>">

<table class="CharacterSheet">
<tbody>
<!-- Header -->
<tr id="CharacterStatusRow">
<td colspan="2" class="SystemRow">
<!-- System -->
<table class="System">
<tbody>
<tr>
<td>
<label><?php __('System') ?></label>
<?php if (isset($character['System'])): ?>
<?php if ($systemValid == 'public'): ?>
<?php
	echo $html->div(
		'CharacterSheetHeader',
		$html->link(
			$character['System']['name'], 
			array('controller' => 'systems', 'action' => 'view', $character['System']['id']), array('escape' => false)
		)
	);
?>
<?php else: ?>
<?php if ($systemValid == 'unpublic'): ?>
<?php
	echo $html->div(
		'publicFlag', 
		$select->get_i18n_unpublic_flag($character['System']['public_flag'], $public_flags)
	);

?>
<?php endif; ?>
<?php if ($isOwner && $isArchive !== true): ?>
<?php
	echo $html->div(
		'CharacterSheetHeader',
		$html->link(
			__('Select New System', true), 
			array('controller' => 'characters', 'action' => 'change_system', $character['Character']['id'])
		)
	);
?>
<?php endif; ?>
<?php endif; ?>
<?php endif; ?>
</td>
<td>
<label><?php __('Status') ?></label>
<?php 
	echo $html->div(
		'CharacterSheetHeader',
		$select->get_i18n_status($character['Character']['status'], $status)
	);
 ?>
</td>
<?php if ($isOwner || $isAdmin): ?>
<td>
<label><?php __('Public Flag') ?></label>
<?php 
	echo $html->div(
		'CharacterSheetHeader publicFlag',
		$select->get_i18n_public_flag($character['Character']['public_flag'], $public_flags)
	);
 ?>
</td>
<?php endif; ?>
<?php if ($isArchive !== true): ?>
<td>
<label><?php __('Modified') ?></label>
<?php
	echo $html->div(
		'CharacterSheetHeader date',
		$time->niceshort(
			$character['Character']['modified'],
			array(
				'format' => 'Y/m/d H:i',
			)
		)
	);
?>
</td>
<?php endif; ?>
</tr>
</table>
</td>
<!-- キャラ画像 -->
<td rowspan="4" class="image160" style="text-align:center;">
<div class="image150" id="CharacterMainPicture">
<?php 
	$main_picture = $this->element('character_picture_image', array(
		'basename' => $character['Character']['main_picture'],
		'options' => array(
			'class' => 'mainImage',
			'alt' => $text->truncate($character['Character']['name'], 64),
		)
	));

	if (!$main_picture) {
		$main_picture = $this->element('character_picture_image', array(
			'basename' => '',
			'options' => array(
				'class' => 'mainImage',
				'alt' => $text->truncate($character['Character']['name'], 64),
			)
		));
	}
	echo $main_picture;
 ?>
</div>
<?php
	if ($isOwner && $isArchive !== true) {
		echo $html->div('editImageLink text', 
			$html->link(__('Edit Image', true),
				array('controller' => 'character_pictures', 'action' => 'listview', $character['Character']['id'])
			)
		);
	}
?>
</td>
</tr>
<!-- Characters -->
<tr>
<th class="profileName">
<?php
	__('Charater Name');
?>
</th>
<td class="CharacterBasicData">
<div id="CharacterName">
<?php 
	echo $html->tag('span',
		$character['Character']['name']
	);
?>
</div>
</td>
</tr>
<tr>
<th class="profileName">
<?php
	__('Player Name');
?>
</th>
<td class="CharacterBasicData">
<div id="UserName">
<?php 
	echo $html->tag('span', $html->link(
		$character['User']['name'], 
		array(
			'controller' => 'users', 
			'action' => 'view', 
			$character['User']['id']
		),
		array(
			'escape' => false
		)
	));
?>
</div>
</td>
</tr>
<!-- キャラ画像:サムネイル -->
<tr>
<th class="profileName">
	<?php __('Pictures'); ?>
</th>
<td class="CharacterBasicData">
<div id="CharacterPictures">
<?php
	$num = 0;
	$isDeleted = false;
	foreach ($character['CharacterPicture'] as  $k => $v) {
		if ($num > 4) {
			break;
		}
		$picture = $this->element('character_picture_image', array(
			'attachment' => $v['Attachment'][0],
			'options' => array(
				'previewVersion' => 's',
				'class' => 'shadow',
				'url' => array('controller' => 'character_pictures', 'action' => 'view', $v['id']),
				'alternative' => $v['Attachment'][0]['alternative'],
			)
		));

		if (empty($picture)) {
			$isDeleted = true;
		} else {
			echo $html->div('attachments', $picture);
			$num++;
		}
	}

	if (count($character['CharacterPicture']) > 0 && $isArchive !== true) {
		if ($isOwner) {
			$url = array('controller' => 'character_pictures', 'action' => 'listview', $character['Character']['id']);
		} else {
			$url = array('controller' => 'character_pictures', 'action' => 'index', $character['Character']['id']);
		}

		echo $html->tag(
			'span',
			$html->link(
				__(' ...More', true), $url
			),
			array('class' => 'text')
		);
	} elseif ($isOwner && $isArchive !== true) {
		echo $html->tag(
			'span',
			$html->link(
				__('Add Pictures', true),
				array('controller' => 'character_pictures', 'action' => 'listview', $character['Character']['id'])
			),
			array('class' => 'text')
		);
	}

	if ($isArchive === true && $isDeleted === true) {
		echo $html->div(
			'notice noticeNarrow',
			__('Some pictures cannot be viewable on the archive.', true)
		);
	}

?>
</div>
</td>
</tr>

<!-- Profiles -->
<?php if (isset($character['System']['Profile'])): ?>
<?php
// profile設定の表示
$profiles = $character['System']['Profile'];

foreach($profiles as $key =>$profile):
	$profiledisp->set_profile_type4view($profile);
 ?>
<tr>
<th class="profileName">
	<?php echo $profile['name']; ?>
</th>
<td colspan="3" class="CharacterProfileData<?php if ($profiledisp->profile_type['is_table']): ?> table<?php endif; ?>">
<div id="<?php echo $key; ?>">

<?php 
	if  ((isset($isArchive) && $isArchive === true) || $isAdmin === true) {
		$disp_add_link = false;
	} else {
		$disp_add_link = $isOwner;
	}
	if ($isOwner === true || $isAdmin === true) {
		$publicOnly = false;
	} else {
		$publicOnly = true;
	}
	$profiledisp->disp_values4characters_has_profiles($profile, 2, $disp_add_link, $character['Character']['id'], $publicOnly);
 ?>
</div>
</td>
</tr>
<?php endforeach; ?>
<?php endif; ?>

<!-- Notes -->
<tr>
<th class="profileName">
	<?php __('Notes'); ?>
</th>
<td colspan="3" class="CharacterProfileData">
<div id="Notes">
<?php 
	echo $html->tag('span',
		$profiledisp->autoLinkProf($character['Character']['notes'])
	);
 ?>
</div>
</td>
</tr>

<?php if ($isOwner || $admin): ?>
<!-- Secret Notes -->
<tr>
<th class="profileName">
	<?php __('Secret Notes'); ?>
</th>
<td colspan="3" class="CharacterProfileData">
<div id="SecretNotes">
<?php 
	echo $html->tag('span',
		$profiledisp->autoLinkProf($character['Character']['secret_notes']),
		array(
			'class' => 'publicFlagBg',
		)
	);
 ?>
</div>
</td>
</tr>
<?php endif; ?>

<?php if ($isArchive !== true): ?>
<!-- Archives -->
<tr>
<th class="profileName">
	<?php __('Archives'); ?>
</th>
<td colspan="3" class="CharacterProfileData">
<div>
<?php if (!empty($character['CharacterProfileArchive'])): ?>
<dl id="ArchiveList">
<?php foreach($character['CharacterProfileArchive'] as $characterArchive): ?>
<dt class="characterArcive">
<?php 
	echo $html->tag(
		'span',
		$html->link(
			$time->format(
				'Y/m/d H:i',
				$characterArchive['disp_date']
			), 
			 array(
			 	'controller' => 'character_profile_archives',
			 	'action' => 'view',
				$characterArchive['id']
			),
			array(
				'class' => 'text',
			 	'id' => 'characterArciveDate'. $characterArchive['id']
			)
		)
	);
 ?>
</dt>
<dd class="title">
<?php if (!empty($characterArchive['title'])): ?>
<?php 
	echo $html->tag('span',
		 $html->link(
			 $characterArchive['title'],
			 array(
			 	'controller' => 'character_profile_archives',
			 	'action' => 'view',
				$characterArchive['id']
			),
			array(
				'class' => 'text',
		 		'id' => 'characterArciveTitle'. $characterArchive['id']
			)
		)
	);
 ?>
<?php endif; ?>
<?php if (($isOwner || $admin) && $characterArchive['public_flag'] != 'public'): ?>
<?php 
	echo $html->tag(
		'span',
		$select->get_i18n_unpublic_flag($characterArchive['public_flag'], $public_flags),
		array('class' => 'publicFlag')
	);
 ?>
<?php endif; ?>
&nbsp;</dd>
<?php endforeach; ?>
</dl>
<?php endif; ?>
<?php
if ($isOwner) {
	$archive_url = array('controller' => 'character_profile_archives', 'action' => 'index', $character['Character']['id']);
} else {
	$archive_url = array('controller' => 'character_profile_archives', 'action' => 'index', $character['Character']['id']);
}
	echo $html->tag(
		'span',
		$html->link(
			__(' ...More', true),
			$archive_url
		),
		array('class' => 'text')
	);
 ?>
<?php if ($isOwner && $character['Character']['public_flag'] != 'public'): ?>
<?php 
	echo $html->div(
	'notice noticeNarrow',
	__(' * Unpublic archive data will be shown at the "...More" data list.', true)
	);
?>
<?php endif; ?>
</div>
</td>
</tr>
<?php endif; ?>

</tbody>
</table>

</div>
<div class="boxFooter">
<?php if ((($isOwner && $systemValid == 'public') || $isAdmin) && $isArchive !== true): ?>
<?php
	echo $html->tag(
		'span',
		$html->link(__('Edit Character', true), array('action' => 'edit', $character['Character']['id'])),
		array('class' => 'text')
	); 
?>
<?php endif; ?>

</div>
</div>

</div>
