<?php
/* 
 * プルダウン表示用Helper
 * i18n対応
 */
class SelectHelper extends Helper {
	var $helpers = array(
		'Form',
	);

	/**
	 * public_flagの設定をview表示形式に変換
	 *
	 * @param string $public_flag, array $public_flags
	 * @return String
	 */
	function get_i18n_public_flag($public_flag, $public_flags)
	{
		if (empty($public_flag)) {
			return null;
		}

		$public_flags = CorePlus::set_publicflag($public_flags);
		return $public_flags[$public_flag];
	}

	/**
	 * public_flag=public以外のみ状態を表示
	 *
	 * @param string $public_flag, array $public_flags, $header
	 * @return String
	 */
	function get_i18n_unpublic_flag($public_flag, $public_flags, $header = '* ')
	{
		if (empty($public_flag) || $public_flag =='public') {
			return null;
		}

		$public_flags = CorePlus::set_publicflag($public_flags);
		return $header. $public_flags[$public_flag];
	}
	/**
	 * public_flagの選択プルダウン出力
	 * i18n対応
	 *
	 * @param array $public_flags
	 * @return String
	 */
	function create_publicflag_select($public_flags = array(), $fieldName = 'public_flag', $options = array('type' => 'select'))
	{
		if (!isset($options['type'])) {
			$options['type'] = 'select';
		}
		if (!isset($options['options'])) {
			$options['options'] = array();
		}
		$options['options'] = CorePlus::set_publicflag($public_flags, $options['options']);

		return $this->Form->input($fieldName, $options);
	}

	/**
	 * statusの設定をview表示形式に変換
	 */
	function get_i18n_status($status, $status_list)
	{
		if (empty($status)) {
			return null;
		}

		$status_list = CorePlus::set_status($status_list);

		if (isset($status_list[$status])) {
			return $status_list[$status];
		} else {
			return null;
		}
	}
	/**
	 * statusの選択プルダウン出力
	 * i18n対応
	 */
	function create_status_select($status_list = array(), $fieldName = 'status', $options = array('type' => 'select'))
	{
		if (!isset($options['type'])) {
			$options['type'] = 'select';
		}
		if (!isset($options['options'])) {
			$options['options'] = array();
		}
		$options['options'] = CorePlus::set_status($status_list, $options['options']);

		return $this->Form->input($fieldName, $options);
	}

	/**
	 * booleanの選択プルダウン
	 * i18n対応
	 */
	function create_boolean_select($fieldName, $options = array('type' => 'select'))
	{
		if (empty($fieldName)) {
			return null;
		}

		$options = array_merge(array(
			'type' => 'select',
			'options' => array(
				true => __('ON' ,true),
				false => __('OFF' ,true),
			),
			'label' => false,
			'field' => false,
		), $options);

		if (!isset($options['options']) || empty($options['options'])) {
			$options['options'] = array(
			);
		}

		return $this->Form->input($fieldName, $options);
	}

}

