<div class="systems index">
<h2><?php __('Systems');?></h2>
<p>
<?php
$paginator->options(array('url' => $this->passedArgs));

echo $paginator->counter(array(
'format' => __('Page %page% of %pages%, showing %current% records out of %count% total, starting on record %start%, ending on %end%', true)
));
?></p>
<?php echo $form->create('System', array('url' => array(
	'controller' => 'systems',
	'action' => 'admin_edit_all',
)));?>
<table>
<tr>
<tr>
	<th><?php echo $paginatorEx->sortAllow('id');?></th>
	<th><?php echo $paginatorEx->sortAllow(__('Name', true), 'name');?></th>
	<th><?php echo $paginatorEx->sortAllow(__('Order', true), 'sort_order');?></th>
	<th><?php echo $paginatorEx->sortAllow(__('Public', true), 'public_flag');?></th>
</tr>
<?php
$i = 0;
foreach ($systems as $system):
	$class = null;
?>
<tr>
<td>
	<?php echo $system['System']['id']; ?>
</td>
<td>
<?php
	$system_name =  $html->link($system['System']['name'], array('action' => 'view', $system['System']['id']), array('escape' => false), false);

	$total =  $html->tag('span', sprintf(__('Total Characters %d', true), $system['System']['character_num']), array('class' => 'total_chara_num'));

	echo $this->element('character_picture_table', array(
		'header' => $system_name. $total,
		'characters' => $system['Character'],
		'previewVersion' => 's',
		'colNum' => 5,
		'id' => null,
		'isUser' => false,
		'isCharacter' => true,
		'isSystem' => false,
		'isModified' => false,
		'more_url' => array(
			'controller' => 'systems', 
			'action' => 'view',
			$system['System']['id'],
		),
	));
?>
</td>
<td>
<?php 
	echo $form->input($system['System']['id'].'.sort_order', array(
		'type' => 'text',
		'label' => false,
		'style' => 'ime-mode:inactive;',
		'value' => $system['System']['sort_order'],
		'class' => 'editAll',
	));
?>
</td>
<td>
	<?php echo $select->get_i18n_public_flag($system['System']['public_flag'], $public_flags) ?>
</td>
</tr>
<?php endforeach; ?>
</table>
<?php	echo $token->create(); ?>
<?php echo $form->end(__('Edit All', true));?>
</div>

<div class="paging">
<?php echo $paginator->prev('<< '.__('previous', true), array(), null, array('class'=>'disabled'));?>
 | 	<?php echo $paginator->numbers();?> | 
<?php echo $paginator->next(__('next', true).' >>', array(), null, array('class' => 'disabled'));?>
</div>
