/*
 * Decompiled with CFR 0.152.
 */
package ts.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Range<T extends Comparable<T>> {
    private T start_;
    private T end_;

    public Range(T t, T t2) {
        this.setRange(t, t2);
    }

    public void setRange(T t, T t2) {
        assert (t != null) : "@param:start is null.";
        assert (t2 != null) : "@param:end is null.";
        if (t.compareTo(t2) <= 0) {
            this.start_ = t;
            this.end_ = t2;
        } else {
            this.start_ = t2;
            this.end_ = t;
        }
    }

    public T getStart() {
        return this.start_;
    }

    public T getEnd() {
        return this.end_;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Range)) {
            return false;
        }
        Range range = (Range)object;
        if (!this.getStart().equals(range.getStart())) {
            return false;
        }
        return this.getEnd().equals(range.getEnd());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append(this.getStart().toString());
        stringBuffer.append("~");
        stringBuffer.append(this.getEnd().toString());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public boolean encompass(T t) {
        assert (t != null) : "@param:value is null.";
        if (this.getStart().compareTo(t) > 0) {
            return false;
        }
        return this.getEnd().compareTo(t) >= 0;
    }

    public boolean encompass(Range<T> range) {
        assert (range != null) : "@param:range is null.";
        if (this.getStart().compareTo(range.getStart()) > 0) {
            return false;
        }
        return this.getEnd().compareTo(range.getEnd()) >= 0;
    }

    public Range<T> intersectsWith(Range<T> range) {
        T t;
        assert (range != null) : "@param:range is null.";
        T t2 = this.getStart().compareTo(range.getStart()) > 0 ? this.getStart() : range.getStart();
        T t3 = t = this.getEnd().compareTo(range.getEnd()) < 0 ? this.getEnd() : range.getEnd();
        if (t2.compareTo(t) > 0) {
            return null;
        }
        return new Range<T>(t2, t);
    }

    public Range<T> expandsWith(T t) {
        assert (t != null) : "@param:value is null.";
        if (this.getStart().compareTo(t) > 0) {
            return new Range<T>(t, this.getEnd());
        }
        if (this.getEnd().compareTo(t) < 0) {
            return new Range<T>(this.getStart(), t);
        }
        return new Range<T>(this.getStart(), this.getEnd());
    }

    public Range<T> expandsWith(Range<T> range) {
        assert (range != null) : "@param:range is null.";
        T t = this.getStart().compareTo(range.getStart()) < 0 ? this.getStart() : range.getStart();
        T t2 = this.getEnd().compareTo(range.getEnd()) > 0 ? this.getEnd() : range.getEnd();
        return new Range<T>(t, t2);
    }
}

