/*
 * Decompiled with CFR 0.152.
 */
package ts.util.resource;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import ts.util.resource.IllegalKeyException;
import ts.util.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResource
implements Resource {
    private char elementSeparator_ = (char)46;
    private char[] attributeParenthesis_ = new char[]{'(', ')'};
    private char attributeSeparator_ = (char)44;
    private char attributeMatchMark_ = (char)61;
    private String path_ = null;

    public AbstractResource() {
    }

    public AbstractResource(AbstractResource abstractResource) {
        assert (abstractResource != null) : "@param:res is null.";
        this.setElementSeparator(abstractResource.getElementSeparator());
        this.setAttributeSeparator(abstractResource.getAttributeSeparator());
        this.setAttributeMatchMark(abstractResource.getAttributeMatchMark());
        char[] cArray = abstractResource.getAttributeParenthesis();
        this.setAttributeParenthesis(cArray[0], cArray[1]);
        this.path_ = abstractResource.path_;
    }

    protected void setElementSeparator(char c) {
        this.elementSeparator_ = c;
    }

    public char getElementSeparator() {
        return this.elementSeparator_;
    }

    protected void setAttributeParenthesis(char c, char c2) {
        this.attributeParenthesis_[0] = c;
        this.attributeParenthesis_[1] = c2;
    }

    public char[] getAttributeParenthesis() {
        return this.attributeParenthesis_;
    }

    public void setAttributeSeparator(char c) {
        this.attributeSeparator_ = c;
    }

    public char getAttributeSeparator() {
        return this.attributeSeparator_;
    }

    protected void setAttributeMatchMark(char c) {
        this.attributeMatchMark_ = c;
    }

    public char getAttributeMatchMark() {
        return this.attributeMatchMark_;
    }

    protected String getNameOfKeyElement(String string) {
        assert (string != null) : "@param:keyElem is null.";
        int n = string.indexOf(this.getAttributeParenthesis()[0]);
        return n < 0 ? string : string.substring(0, n);
    }

    protected List<String[]> listAttributesOfKeyElement(String string) {
        int n;
        assert (string != null) : "@param:keyElem is null";
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n2 = string.indexOf(this.getAttributeParenthesis()[0]);
        if (n2 < 0) {
            return arrayList;
        }
        String[] stringArray = new String[2];
        for (int i = n = n2 + 1; i < string.length() - 1; ++i) {
            char c = string.charAt(i);
            if (c == this.getAttributeMatchMark()) {
                stringArray[0] = string.substring(n, i);
                n = i + 1;
                continue;
            }
            if (c != this.getAttributeSeparator()) continue;
            stringArray[1] = string.substring(n, i);
            arrayList.add(stringArray);
            stringArray = new String[2];
            n = i + 1;
        }
        if (stringArray[0].length() > 0) {
            stringArray[1] = string.substring(n, string.length() - 1);
            arrayList.add(stringArray);
        }
        return arrayList;
    }

    protected List<String> splitKey(String string) throws IllegalKeyException {
        assert (string != null) : "@param:key is null.";
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.length() == 0) {
            return arrayList;
        }
        int n = 0;
        int n2 = -1;
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (n2 >= 0) {
                if (c == this.getAttributeParenthesis()[1]) {
                    if (n2 == i) {
                        throw new IllegalKeyException(string, "Attribute name must not be empty.");
                    }
                    if (!bl) {
                        throw new IllegalKeyException(string, "Attribute need a match mark at least.");
                    }
                    if (i + 1 != string.length() && string.charAt(i + 1) != this.getElementSeparator()) {
                        throw new IllegalKeyException(string, "Element must end after close parenthesis of attribute");
                    }
                    n2 = -1;
                    continue;
                }
                if (c == this.getAttributeSeparator()) {
                    if (n2 == i) {
                        throw new IllegalKeyException(string, "Attribute name must not be empty.");
                    }
                    if (!bl) {
                        throw new IllegalKeyException(string, "Attribute need a match mark at least.");
                    }
                    n2 = i + 1;
                    bl = false;
                    continue;
                }
                if (c != this.getAttributeMatchMark()) continue;
                if (n2 == i) {
                    throw new IllegalKeyException(string, "Attribute name must not be empty.");
                }
                bl = true;
                continue;
            }
            if (c == this.getAttributeParenthesis()[0]) {
                if (n == i) {
                    throw new IllegalKeyException(string, "Element name must not be empty.");
                }
                n2 = i + 1;
                bl = false;
                continue;
            }
            if (c != this.getElementSeparator()) continue;
            if (n == i) {
                throw new IllegalKeyException(string, "Element name must not be empty.");
            }
            arrayList.add(string.substring(n, i));
            n = i + 1;
        }
        if (n2 >= 0) {
            throw new IllegalKeyException(string, "Parenthesis of attribute must be closed.");
        }
        if (n == string.length()) {
            throw new IllegalKeyException(string, "Element name must not be empty.");
        }
        if (n <= string.length() - 1) {
            arrayList.add(string.substring(n));
        }
        return arrayList;
    }

    public String getPath() {
        return this.path_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(String string) throws FileNotFoundException, IOException {
        assert (string != null) : "@param:path is null.";
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream(string);
            this.load(inputStream);
            this.path_ = string;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    protected InputStream getInputStream(String string) throws FileNotFoundException, IOException {
        assert (string != null) : "@param:path is null.";
        return new FileInputStream(string);
    }

    protected abstract void load(InputStream var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save(String string) throws IOException {
        assert (string != null) : "@param:path is null.";
        OutputStream outputStream = null;
        try {
            outputStream = this.getOutputStream(string);
            this.save(outputStream);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    protected OutputStream getOutputStream(String string) throws IOException {
        assert (string != null) : "@param:path is null.";
        return new FileOutputStream(string);
    }

    protected abstract void save(OutputStream var1) throws IOException;
}

