/*
 * Decompiled with CFR 0.152.
 */
package ts.util.resource;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import ts.util.resource.AbstractResource;
import ts.util.resource.IllegalKeyException;
import ts.util.resource.Resource;
import ts.util.resource.hierarchy.AttributeMap;
import ts.util.resource.hierarchy.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultResource
extends AbstractResource {
    private Element rootElement_;
    private Element baseElement_;

    public DefaultResource() {
        this.baseElement_ = this.rootElement_ = Element.createRootElement();
    }

    public DefaultResource(DefaultResource defaultResource) {
        super(defaultResource);
        this.rootElement_ = defaultResource.getRootElement();
        this.baseElement_ = defaultResource.getBaseElement();
    }

    protected void renew() {
        this.baseElement_ = this.rootElement_ = Element.createRootElement();
    }

    protected Element getRootElement() {
        return this.rootElement_;
    }

    protected Element getBaseElement() {
        return this.baseElement_;
    }

    protected abstract DefaultResource createResource();

    protected Element findFirstElement(String string) throws IllegalKeyException {
        assert (string != null) : "@param:key is null.";
        if (string.length() == 0) {
            return this.getBaseElement();
        }
        return this.findFirstElement(this.getBaseElement(), this.splitKey(string), 0);
    }

    private Element findFirstElement(Element element, List<String> list, int n) throws NullPointerException, IndexOutOfBoundsException {
        if (n >= list.size()) {
            return element;
        }
        String string = list.get(n);
        String string2 = this.getNameOfKeyElement(string);
        List<String[]> list2 = this.listAttributesOfKeyElement(string);
        List<Element> list3 = element.getChildren(string2);
        block0: for (Element element2 : list3) {
            AttributeMap attributeMap = element2.getAttributes();
            for (String[] stringArray : list2) {
                if (stringArray[1].equals(attributeMap.get(stringArray[0]))) continue;
                continue block0;
            }
            Element element3 = this.findFirstElement(element2, list, n + 1);
            if (element3 == null) continue;
            return element3;
        }
        return null;
    }

    protected List<Element> findAllElements(String string) throws IllegalKeyException {
        assert (string != null) : "@param:key is null.";
        LinkedList<Element> linkedList = new LinkedList<Element>();
        if (string.length() == 0) {
            linkedList.add(this.getBaseElement());
            return linkedList;
        }
        List<String> list = this.splitKey(string);
        this.findAllElements(linkedList, this.getBaseElement(), list, 0);
        return linkedList;
    }

    private void findAllElements(List<Element> list, Element element, List<String> list2, int n) throws NullPointerException, IndexOutOfBoundsException {
        if (n >= list2.size()) {
            list.add(element);
            return;
        }
        String string = list2.get(n);
        String string2 = this.getNameOfKeyElement(string);
        List<String[]> list3 = this.listAttributesOfKeyElement(string);
        List<Element> list4 = element.getChildren(string2);
        block0: for (Element element2 : list4) {
            if (list3.size() > 0) {
                AttributeMap attributeMap = element2.getAttributes();
                for (String[] stringArray : list3) {
                    if (stringArray[1].equals(attributeMap.get(stringArray[0]))) continue;
                    continue block0;
                }
            }
            this.findAllElements(list, element2, list2, n + 1);
        }
    }

    protected Element findOrCreateFirstElement(String string) throws IllegalKeyException {
        assert (string != null) : "@param:key is null.";
        if (string.length() == 0) {
            return this.getBaseElement();
        }
        return this.findOrCreateFirstElement(this.splitKey(string));
    }

    protected Element findOrCreateFirstElement(List<String> list) {
        Object object;
        int n;
        assert (list != null) : "@param:keyElemLst is null.";
        Object object2 = this.getBaseElement();
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("");
        for (n = 0; n < list.size(); ++n) {
            arrayList.set(0, list.get(n));
            object = this.findFirstElement((Element)object2, arrayList, 0);
            if (object == null) break;
            object2 = object;
        }
        while (n < list.size()) {
            object = list.get(n);
            String string = this.getNameOfKeyElement((String)object);
            List<String[]> list2 = this.listAttributesOfKeyElement((String)object);
            Element element = new Element(string);
            for (String[] stringArray : list2) {
                element.putAttribute(stringArray[0], stringArray[1]);
            }
            ((Element)object2).addChild(element);
            object2 = element;
            ++n;
        }
        return object2;
    }

    @Override
    public synchronized String getFirstValue(String string) throws IllegalKeyException {
        Element element = this.findFirstElement(string);
        if (element == null) {
            return "";
        }
        String string2 = element.getValue();
        return string2 != null ? string2 : "";
    }

    @Override
    public synchronized List<String> getValues(String string) throws IllegalKeyException {
        List<Element> list = this.findAllElements(string);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Element element : list) {
            String string2 = element.getValue();
            arrayList.add(string2 != null ? string2 : "");
        }
        return arrayList;
    }

    @Override
    public synchronized String getFirstAttribute(String string, String string2) throws IllegalKeyException {
        assert (string2 != null) : "@param:attr is null.";
        Element element = this.findFirstElement(string);
        if (element == null) {
            return "";
        }
        AttributeMap attributeMap = element.getAttributes();
        String string3 = (String)attributeMap.get(string2);
        if (string3 == null) {
            return "";
        }
        return string3;
    }

    @Override
    public synchronized List<String> getAttributes(String string, String string2) throws IllegalKeyException {
        assert (string2 != null) : "@param:attr is null.";
        List<Element> list = this.findAllElements(string);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Element element : list) {
            AttributeMap attributeMap = element.getAttributes();
            String string3 = (String)attributeMap.get(string2);
            arrayList.add(string3 != null ? string3 : "");
        }
        return arrayList;
    }

    @Override
    public synchronized Resource getFirstChild(String string) throws IllegalKeyException {
        Element element = this.findFirstElement(string);
        if (element == null) {
            return Resource.EMPTY;
        }
        DefaultResource defaultResource = this.createResource();
        defaultResource.baseElement_ = element;
        return defaultResource;
    }

    @Override
    public synchronized List<Resource> getChildren(String string) throws IllegalKeyException {
        List<Element> list = this.findAllElements(string);
        ArrayList<Resource> arrayList = new ArrayList<Resource>(list.size());
        for (Element element : list) {
            DefaultResource defaultResource = this.createResource();
            defaultResource.baseElement_ = element;
            arrayList.add(defaultResource);
        }
        return arrayList;
    }

    @Override
    public synchronized void setFirstValue(String string, String string2) throws IllegalKeyException {
        assert (string2 != null) : "@param:value is null.";
        try {
            Element element = this.findOrCreateFirstElement(string);
            if (element == this.getRootElement()) {
                throw new IllegalKeyException(string);
            }
            element.setValue(string2);
        }
        catch (IllegalKeyException illegalKeyException) {
            throw illegalKeyException;
        }
        catch (Exception exception) {
            throw new IllegalKeyException(string, exception);
        }
    }

    @Override
    public synchronized Resource getOrCreateFirstChild(String string) throws IllegalKeyException {
        Element element = this.findOrCreateFirstElement(string);
        DefaultResource defaultResource = this.createResource();
        defaultResource.baseElement_ = element;
        return defaultResource;
    }

    @Override
    public synchronized void removeChildren(String string) throws IllegalKeyException {
        List<Element> list = this.findAllElements(string);
        for (Element element : list) {
            Element element2 = element.getParent();
            if (element2 != null) {
                element2.removeChildren(element.getName());
                continue;
            }
            this.renew();
        }
    }
}

