/*
 * Decompiled with CFR 0.152.
 */
package ts.util.text;

import java.text.Format;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import ts.util.text.StringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringConcatenator {
    protected StringConcatenator() {
    }

    public static String concatenate(String[] stringArray, String string) {
        assert (stringArray != null) : "@param:strings is null.";
        assert (string != null) : "@param:delimiter is null.";
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length > 0) {
            stringBuffer.append(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append(string).append(stringArray[i]);
            }
        }
        return stringBuffer.toString();
    }

    public static String concatenate(Enumeration<String> enumeration, String string) {
        assert (enumeration != null) : "@param:enm is null.";
        assert (string != null) : "@param:delimiter is null.";
        StringBuffer stringBuffer = new StringBuffer();
        if (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement());
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(string).append(enumeration.nextElement());
            }
        }
        return stringBuffer.toString();
    }

    public static String concatenate(Collection<String> collection, String string) {
        assert (collection != null) : "@param:coll is null.";
        assert (string != null) : "@param;delimiter is null.";
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = collection.iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuffer.append(string).append(iterator.next());
            }
        }
        return stringBuffer.toString();
    }

    public static String repeat(char c, int n) {
        assert (n >= 0) : "@param:count is negative.";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String repeat(String string, int n, String string2) {
        assert (string != null) : "@param:repeated is null.";
        assert (string2 != null) : "@param:delimiter is null.";
        assert (n >= 0) : "@param:count is negative.";
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0) {
            stringBuffer.append(string);
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(string2).append(string);
            }
        }
        return stringBuffer.toString();
    }

    public static String concatenate(Object[] objectArray, Format format, String string) throws IllegalArgumentException {
        assert (objectArray != null) : "@param:objs is null.";
        assert (format != null) : "@param:fmt is null.";
        assert (string != null) : "@param:delim is null.";
        if (format instanceof MessageFormat) {
            MessageFormat messageFormat = (MessageFormat)format;
            Object[] objectArray2 = new Object[1];
            StringBuffer stringBuffer = new StringBuffer();
            if (objectArray.length > 0) {
                objectArray2[0] = objectArray[0];
                stringBuffer.append(MessageFormat.format(messageFormat.toPattern(), objectArray2));
                for (int i = 1; i < objectArray.length; ++i) {
                    objectArray2[0] = objectArray[i];
                    stringBuffer.append(string).append(MessageFormat.format(messageFormat.toPattern(), objectArray2));
                }
            }
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray.length > 0) {
            stringBuffer.append(format.format(objectArray[0]));
            for (int i = 1; i < objectArray.length; ++i) {
                stringBuffer.append(string).append(format.format(objectArray[i]));
            }
        }
        return stringBuffer.toString();
    }

    public static String concatenate(Enumeration<Object> enumeration, Format format, String string) throws IllegalArgumentException {
        assert (enumeration != null) : "@param:enm is null.";
        assert (format != null) : "@param:fmt is null.";
        assert (string != null) : "@param:delim is null.";
        if (format instanceof MessageFormat) {
            MessageFormat messageFormat = (MessageFormat)format;
            Object[] objectArray = new Object[1];
            StringBuffer stringBuffer = new StringBuffer();
            if (enumeration.hasMoreElements()) {
                objectArray[0] = enumeration.nextElement();
                stringBuffer.append(MessageFormat.format(messageFormat.toPattern(), objectArray));
                while (enumeration.hasMoreElements()) {
                    objectArray[0] = enumeration.nextElement();
                    stringBuffer.append(string).append(MessageFormat.format(messageFormat.toPattern(), objectArray));
                }
            }
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (enumeration.hasMoreElements()) {
            stringBuffer.append(format.format(enumeration.nextElement()));
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(string).append(format.format(enumeration.nextElement()));
            }
        }
        return stringBuffer.toString();
    }

    public static String concatenate(Collection collection, Format format, String string) throws IllegalArgumentException {
        assert (collection != null) : "@param:coll is null.";
        assert (format != null) : "@param:fmt is null.";
        assert (string != null) : "@param:delim is null.";
        if (format instanceof MessageFormat) {
            MessageFormat messageFormat = (MessageFormat)format;
            Object[] objectArray = new Object[1];
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = collection.iterator();
            if (iterator.hasNext()) {
                objectArray[0] = iterator.next();
                stringBuffer.append(MessageFormat.format(messageFormat.toPattern(), objectArray));
                while (iterator.hasNext()) {
                    objectArray[0] = iterator.next();
                    stringBuffer.append(string).append(MessageFormat.format(messageFormat.toPattern(), objectArray));
                }
            }
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(format.format(iterator.next()));
            while (iterator.hasNext()) {
                stringBuffer.append(string).append(format.format(iterator.next()));
            }
        }
        return stringBuffer.toString();
    }

    public static String concatenate(String[] stringArray, char c, char c2) {
        assert (stringArray != null) : "@param:strs is null.";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(c);
        StringBuffer stringBuffer2 = new StringBuffer();
        if (stringArray.length > 0) {
            stringBuffer2.append(StringConverter.toWriteString(stringArray[0], c2, stringBuffer));
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer2.append(c);
                stringBuffer2.append(StringConverter.toWriteString(stringArray[i], c2, stringBuffer));
            }
        }
        return stringBuffer2.toString();
    }

    public static String concatenate(Enumeration<String> enumeration, char c, char c2) {
        assert (enumeration != null) : "@param:enm is null.";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(c);
        StringBuffer stringBuffer2 = new StringBuffer();
        if (enumeration.hasMoreElements()) {
            stringBuffer2.append(StringConverter.toWriteString(enumeration.nextElement(), c2, stringBuffer));
            while (enumeration.hasMoreElements()) {
                stringBuffer2.append(c);
                stringBuffer2.append(StringConverter.toWriteString(enumeration.nextElement(), c2, stringBuffer));
            }
        }
        return stringBuffer2.toString();
    }

    public static String concatenate(Collection<String> collection, char c, char c2) {
        assert (collection != null) : "@param:coll is null.";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(c);
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator<String> iterator = collection.iterator();
        if (iterator.hasNext()) {
            stringBuffer2.append(StringConverter.toWriteString(iterator.next(), c2, stringBuffer));
            while (iterator.hasNext()) {
                stringBuffer2.append(c);
                stringBuffer2.append(StringConverter.toWriteString(iterator.next(), c2, stringBuffer));
            }
        }
        return stringBuffer2.toString();
    }

    public static String concatenate(String[] stringArray, char c, char c2, char c3, char c4) {
        assert (stringArray != null) : "@param:strs is null.";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(c);
        stringBuffer.append(c2);
        stringBuffer.append(c3);
        StringBuffer stringBuffer2 = new StringBuffer();
        if (stringArray.length > 0) {
            stringBuffer2.append(c2);
            stringBuffer2.append(StringConverter.toWriteString(stringArray[0], c4, stringBuffer));
            stringBuffer2.append(c3);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer2.append(c);
                stringBuffer2.append(c2);
                stringBuffer2.append(StringConverter.toWriteString(stringArray[i], c4, stringBuffer));
                stringBuffer2.append(c3);
            }
        }
        return stringBuffer2.toString();
    }

    public static String concatenate(Enumeration<String> enumeration, char c, char c2, char c3, char c4) {
        assert (enumeration != null) : "@param:enm is null.";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(c);
        stringBuffer.append(c2);
        stringBuffer.append(c3);
        StringBuffer stringBuffer2 = new StringBuffer();
        if (enumeration.hasMoreElements()) {
            stringBuffer2.append(c2);
            stringBuffer2.append(StringConverter.toWriteString(enumeration.nextElement(), c4, stringBuffer));
            stringBuffer2.append(c3);
            while (enumeration.hasMoreElements()) {
                stringBuffer2.append(c);
                stringBuffer2.append(c2);
                stringBuffer2.append(StringConverter.toWriteString(enumeration.nextElement(), c4, stringBuffer));
                stringBuffer2.append(c3);
            }
        }
        return stringBuffer2.toString();
    }

    public static String concatenate(Collection<String> collection, char c, char c2, char c3, char c4) {
        assert (collection != null) : "@param:coll is null.";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(c);
        stringBuffer.append(c2);
        stringBuffer.append(c3);
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator<String> iterator = collection.iterator();
        if (iterator.hasNext()) {
            stringBuffer2.append(c2);
            stringBuffer2.append(StringConverter.toWriteString(iterator.next(), c4, stringBuffer));
            stringBuffer2.append(c3);
            while (iterator.hasNext()) {
                stringBuffer2.append(c);
                stringBuffer2.append(c2);
                stringBuffer2.append(StringConverter.toWriteString(iterator.next(), c4, stringBuffer));
                stringBuffer2.append(c3);
            }
        }
        return stringBuffer2.toString();
    }
}

