/*
 * DuoTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.tester.util.ObjectSerializer;

/**
 * <code>Duo</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/15 15:28:03 $
 */
public class DuoTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      group.addPrinter(new ConsolePrinter());
      setPrinter(group);

      run(DuoTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- text case -- */

  public void constructor()
  {
    MSG("ftHgRXgN^̊mFB");

    Duo<Object,Object> duo = new Duo<Object,Object>();
    NULL(duo.getFirst());
    NULL(duo.getSecond());
  }

  public void constructor_first_second()
  {
    MSG("̃IuWFNg̒lɂƂRXgN^̊mFB");

    Object o1 = new Object();
    Object o2 = new Object();

    Duo<Object,Object> duo = new Duo<Object,Object>(o1, o2);
    EQUAL(duo.getFirst(), o1);
    EQUAL(duo.getSecond(), o2);

    duo = new Duo<Object,Object>(new Integer(1234), "");
    EQUAL(duo.getFirst(), new Integer(1234));
    EQUAL(duo.getSecond(), "");

    duo = new Duo<Object,Object>("", null);
    EQUAL(duo.getFirst(), "");
    NULL(duo.getSecond());

    duo = new Duo<Object,Object>(null, "");
    NULL(duo.getFirst());
    EQUAL(duo.getSecond(), "");

    duo = new Duo<Object,Object>(null, null);
    NULL(duo.getFirst());
    NULL(duo.getSecond());
  }

  public void set_first_second()
  {
    MSG("̃IuWFNg̒lݒ肷郁\bh̊mFB");

    Object o1 = new Object();
    Object o2 = new Object();

    Duo<Object,Object> duo = new Duo<Object,Object>();
    duo.set(o1, o2);
    EQUAL(duo.getFirst(), o1);
    EQUAL(duo.getSecond(), o2);

    duo.set(new Long(12345L), "");
    EQUAL(duo.getFirst(), new Long(12345L));
    EQUAL(duo.getSecond(), "");

    duo.set("", null);
    EQUAL(duo.getFirst(), "");
    NULL(duo.getSecond());

    duo.set(null, "");
    NULL(duo.getFirst());
    EQUAL(duo.getSecond(), "");
    
    duo.set(null, null);
    NULL(duo.getFirst());
    NULL(duo.getSecond());
  }

  public void setFirst()
  {
    MSG("IuWFNgݒ肷郁\bh̊mFB");

    Object o1 = new Object();
    Object o2 = new Object();

    Duo<Object,Object> duo = new Duo<Object,Object>();
    duo.setFirst(o1);
    EQUAL(duo.getFirst(), o1);

    duo.setFirst(o2);
    EQUAL(duo.getFirst(), o2);

    duo.setFirst(new Long(12345L));
    EQUAL(duo.getFirst(), new Long(12345L));

    duo.setFirst("");
    EQUAL(duo.getFirst(), "");

    duo.setFirst("");
    EQUAL(duo.getFirst(), "");

    duo.setFirst(null);
    EQUAL(duo.getFirst(), null);
  }

  public void setSecond()
  {
    MSG("IuWFNgݒ肷郁\bh̊mFB");

    Object o1 = new Object();
    Object o2 = new Object();

    Duo<Object,Object> duo = new Duo<Object,Object>();
    duo.setSecond(o1);
    EQUAL(duo.getSecond(), o1);

    duo.setSecond(o2);
    EQUAL(duo.getSecond(), o2);

    duo.setSecond(new Long(12345L));
    EQUAL(duo.getSecond(), new Long(12345L));

    duo.setSecond("");
    EQUAL(duo.getSecond(), "");

    duo.setSecond("");
    EQUAL(duo.getSecond(), "");

    duo.setSecond(null);
    EQUAL(duo.getSecond(), null);
  }

  public void _equals()
  {
    MSG("IuWFNg̓eǂmFB");

    Duo<Object,Object> duo0 = new Duo<Object,Object>();
    Duo<Object,Object> duo1 = new Duo<Object,Object>("1", "2");
    Duo<Object,Object> duo2 = new Duo<Object,Object>("1", "1");
    Duo<Object,Object> duo3 = new Duo<Object,Object>("2", "2");
    Duo<Object,Object> duo4 = new Duo<Object,Object>("1", "2");
    Duo<Object,Object> duo5 = new Duo<Object,Object>("1", null);

    TRUE(duo0.equals(duo0));
    TRUE(duo1.equals(duo1));
    TRUE(duo2.equals(duo2));
    TRUE(duo3.equals(duo3));
    TRUE(duo4.equals(duo4));
    TRUE(duo5.equals(duo5));

    TRUE(duo0.equals(new Duo()));
    FALSE(duo0.equals(null));
    FALSE(duo0.equals(duo1));
    FALSE(duo0.equals(duo2));
    FALSE(duo0.equals(duo3));
    FALSE(duo0.equals(duo4));
    FALSE(duo0.equals(duo5));

    FALSE(duo1.equals(duo0));
    FALSE(duo1.equals(duo2));
    FALSE(duo1.equals(duo3));
    TRUE(duo1.equals(duo4));
    FALSE(duo1.equals(duo5));

    FALSE(duo5.equals(duo1));
  }

  public void _hashCode()
  {
    MSG("nbVR[h擾郁\bh̊mFB");

    Duo<Object,Object> duo00 = new Duo<Object,Object>();
    Duo<Object,Object> duo01 = new Duo<Object,Object>();
    EQUAL(duo00.hashCode(), duo01.hashCode());

    Duo<Object,Object> duo11 = new Duo<Object,Object>(new Integer(123), null);
    Duo<Object,Object> duo12 = new Duo<Object,Object>(new Integer(123), null);
    EQUAL(duo11.hashCode(), duo12.hashCode());

    Duo<Object,Object> duo21 =
      new Duo<Object,Object>(null, new Double(3.14159));
    Duo<Object,Object> duo22 =
      new Duo<Object,Object>(null, new Double(3.14159));
    EQUAL(duo21.hashCode(), duo22.hashCode());

    Duo<Object,Object> duo31 = new Duo<Object,Object>("ABC", new Long(1234L));
    Duo<Object,Object> duo32 = new Duo<Object,Object>("ABC", new Long(1234L));
    EQUAL(duo31.hashCode(), duo32.hashCode());
  }

  public void serializable()
  {
    MSG("VACY̊mFB");

    ObjectSerializer os = new ObjectSerializer();

    Duo<Object,Object> duo = new Duo<Object,Object>("AAA", new Long(222L));
    try {
      byte[] bytes = os.serializeToByteArray(duo);
      Duo<Object,Object> newDuo = (Duo<Object,Object>) os.deserialize(bytes);
      EQUAL(newDuo, duo);
    } catch (Exception e) {
      NG(e);
    }
  }
}
