/*
 * DirectoryNotEmptyExceptionTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import java.io.IOException;

/**
 * <code>DirectoryNotEmptyException</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/15 15:28:03 $
 */
public class DirectoryNotEmptyExceptionTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(DirectoryNotEmptyExceptionTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- test case -- */

  public void constructor_path()
  {
    MSG("ʏ̑̏ꍇ");

    try {
      throw new DirectoryNotEmptyException("/aaa/bbb/ccc");
    } catch (DirectoryNotEmptyException e) {
      EQUAL(e.getPath(), "/aaa/bbb/ccc");
      NULL(e.getMessage());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_path_01()
  {
    MSG("k̏ꍇ");
    try {
      throw new DirectoryNotEmptyException(null);
    } catch (DirectoryNotEmptyException e) {
      NULL(e.getPath());
      NULL(e.getMessage());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_path_msg()
  {
    MSG("ʏ̑̏ꍇ");
    try {
      throw new DirectoryNotEmptyException("/aaa/bbb", "");
    } catch (DirectoryNotEmptyException e) {
      EQUAL(e.getPath(), "/aaa/bbb");
      EQUAL(e.getMessage(), "");
    } catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_path_msg_01()
  {
    MSG("k̏ꍇ");
    try {
      throw new DirectoryNotEmptyException(null, null);
    } catch (DirectoryNotEmptyException e) {
      NULL(e.getPath());
      NULL(e.getMessage());
    } catch (Exception e) {
      NG(e);
    }

    try {
      throw new DirectoryNotEmptyException(null, "");
    } catch (DirectoryNotEmptyException e) {
      NULL(e.getPath());
      EQUAL(e.getMessage(), "");
    } catch (Exception e) {
      NG(e);
    }

    try {
      throw new DirectoryNotEmptyException("aaa/bbb", null);
    } catch (DirectoryNotEmptyException e) {
      EQUAL(e.getPath(), "aaa/bbb");
      NULL(e.getMessage());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void super_class()
  {
    MSG("IOExceptionpĂ邩ǂ");
    try {
      throw new DirectoryNotEmptyException("aaa/bbb", "");
    } catch (IOException e) {
      EQUAL(e.getMessage(), "");
    } catch (Exception e) {
      NG(e);
    }
  }

  public void _toString()
  {
    MSG("ObZ[Ww肵ĂȂꍇ");

    try {
      throw new DirectoryNotEmptyException("aaa/bbb");
    } catch (Exception e) {
      EQUAL(e.toString(), "ts.util.file.DirectoryNotEmptyException: The directory is not empty: aaa/bbb");
    }
  }

  public void _toString_1()
  {
    MSG("ObZ[Ww肵ꍇB");

    try {
      throw new DirectoryNotEmptyException("aaa/bbb", "ccc");
    } catch (Exception e) {
      EQUAL(e.toString(),
        "ts.util.file.DirectoryNotEmptyException: ccc: aaa/bbb");
    }

    try {
      throw new DirectoryNotEmptyException("aaa/bbb", null);
    } catch (Exception e) {
      EQUAL(e.toString(), "ts.util.file.DirectoryNotEmptyException: The directory is not empty: aaa/bbb");
    }
  }
}
