/*
 * StringConverter class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.text;

import java.text.ParseException;

/**
 * ϊ郁\bhW߂NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/15 15:28:06 $
 */
public class StringConverter
{
  /**
   * ftHgRXgN^B
   */
  protected StringConverter()
  {}

  /**
   * t@Cǂݍ񂾕Ȃǂʏ̕ɕϊB
   * <br>
   * ̕񂩂GXP[vAgsB
   * AAGXP[v̂ɂ󔒕̓g̑ΏۂƂȂB
   * <br>
   * w肳ꂽꕶ̑OɃGXP[v݂邩ǂ̃`FbN
   * sA݂ȂΗOX[B
   * <br>
   * ꕶȊȎ̕OɃGXP[v݂ꍇ̓GXP[v
   * 邾ƂB
   *
   * @param  readStr ǂݍ񂾕B
   * @param  escape GXP[vB
   * @param  specChars ꕶ̏WB
   * @return ϊ̕B
   * @throws EndWithEscapeCharException GXP[vŏIꍇB
   * @throws StringConvertException ̕ϊȂꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static String fromReadString(
    String readStr, char escape, CharSequence specChars
  ) throws EndWithEscapeCharException, StringConvertException
  {
    assert (readStr != null) : "@param:readStr is null.";
    assert (specChars != null) : "@param:specChars is null.";

    int len = readStr.length();
    int nSpec = specChars.length();

    StringBuffer buf = new StringBuffer(len);

    int i = 0;
    for ( ; i<len; i++) {
      char ch = readStr.charAt(i);
      if (!Character.isWhitespace(ch)) {
        break;
      }
    }

    int beginSpace = len;
    boolean isEsc = false;
    for ( ; i<len; i++) {
      char ch = readStr.charAt(i);
      if (isEsc) {
        buf.append(ch);
        beginSpace = buf.length();
        isEsc = false;
      }
      else if (ch == escape) {
        beginSpace = buf.length();
        isEsc = true;
      }
      else {
        for (int j=0; j<nSpec; j++) {
          if (ch == specChars.charAt(j)) {
            throw new StringConvertException(i, buf.toString(),
              "A special character is not escaped.");
          }
        }
        buf.append(ch);
        if (! Character.isWhitespace(ch)) {
          beginSpace = buf.length();
        }
      }
    }

    String convStr = buf.substring(0, beginSpace);
    if (isEsc) {
      throw new EndWithEscapeCharException(len - 1, convStr);
    }

    return convStr;
  }

  /**
   * t@Cǂݍ񂾊ʂň͂܂ꂽȂǂʏ̕ɕϊB
   * <br>
   * ̕񂩂痼[̊ʂAGXP[vB
   * <br>
   * [ɊʂȂꍇ͗OX[B
   * <br>
   * w肳ꂽꕶ̑OɃGXP[v݂邩ǂ̃`FbN
   * sA݂ȂΗOX[B
   * ȂAꕶɂ͊ʂIɊ܂܂悤ɂĂB
   * <br>
   * ꕶȊȎ̕OɃGXP[v݂ꍇ̓GXP[v
   * 邾ƂB
   *
   * @param  readStr ǂݍ񂾕B
   * @param  escape GXP[vB
   * @param  openPar JʕB
   * @param  closePar ʕB
   * @param  specChars ꕶ̏WB
   * @return ϊ̕B
   * @throws ParseException ǂݍ񂾕̏sȏꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static String fromReadString(String readStr,
    char openPar, char closePar, char escape, CharSequence specChars
  ) throws EndWithEscapeCharException, StringConvertException
  {
    assert (readStr != null) : "@param:readStr is null.";
    assert (specChars != null) : "@param:specChars is null.";

    if (!readStr.startsWith(String.valueOf(openPar))) {
      throw new StringConvertException(0, "",
        "The specified string does not start with the parenthesis.");
    }
    if (!readStr.endsWith(String.valueOf(closePar))) {
      throw new StringConvertException(0, "",
        "The specified string does not end with the parenthesis.");
    }

    int len = readStr.length() - 1;
    int i = 1;

    int nSpec = specChars.length();

    StringBuffer buf = new StringBuffer();

    boolean isEsc = false;
    for (; i<len; i++) {
      char ch = readStr.charAt(i);
      if (isEsc) {
        buf.append(ch);
        isEsc = false;
      }
      else if (ch == escape) {
        isEsc = true;
      }
      else if (ch == openPar) {
        throw new StringConvertException(i, buf.toString(),
          "A special character is not escaped.");
      }
      else if (ch == closePar) {
        throw new StringConvertException(i, buf.toString(),
          "A special character is not escaped.");
      }
      else {
        for (int j=0; j<nSpec; j++) {
          if (ch == specChars.charAt(j)) {
            throw new StringConvertException(i, buf.toString(),
              "A special character is not escaped.");
          }
        }
        buf.append(ch);
      }
    }

    if (isEsc) {
      throw new EndWithEscapeCharException(len - 1, buf.toString());
    }

    return buf.toString();
  }

  /**
   * ʏ̕t@Co͗p̕ɕϊB
   * <br>
   * ̕Ɋ܂܂ꕶ̑OɃGXP[v}B
   * <br>
   * ̕񂪋󔒂ŊJnĂꍇ́Aŏ̋󔒕̑OɃGXP[v
   * }B
   * ̕񂪋󔒂ŏIĂꍇ́AŌ̋󔒕̑OɃGXP[v
   * }B
   *
   * @param  str B
   * @param  escape GXP[vB
   * @param  specChars ꕶ̏WB
   * @return ϊ̕B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static String toWriteString(
    String str, char escape, CharSequence specChars)
  {
    assert (str != null) : "@param:str is null.";
    assert (specChars != null) : "@param:specChars is null.";

    int nSpec = specChars.length();
    int len = str.length();
    if (len == 0) {
      return "";
    }
    if (Character.isWhitespace(str.charAt(len-1))) {
      len --;
    }

    int i = 0;
    StringBuffer buf = new StringBuffer(len);
    if (Character.isWhitespace(str.charAt(0))) {
      buf.append(escape).append(str.charAt(0));
      i ++;
    }

    LOOP1:
    for (; i<len; i++) {
      char ch = str.charAt(i);
      if (ch == escape) {
        buf.append(escape).append(ch);
      }
      else {
        for (int j=0; j<nSpec; j++) {
          if (ch == specChars.charAt(j)) {
            buf.append(escape).append(ch);
            continue LOOP1;
          }
        }
        buf.append(ch);
      }
    }

    if (len > 0 && len == str.length() - 1) {
      buf.append(escape).append(str.charAt(len));
    }

    return buf.toString();
  }

  /**
   * ʏ̕ʂň͂܂ꂽt@Co͗p̕ɕϊB
   * <br>
   * ̗̕[ɊʂtB
   * <br>
   * ̕Ɋ܂܂ꕶ̑OɃGXP[v}B
   * ̕Ɋʂ܂܂ꍇȂOɃGXP[v}B
   *
   * @param  str B
   * @param  openPar JʁB
   * @param  closePar ʁB
   * @param  escape GXP[vB
   * @param  specChars ꕶ̏WB
   * @return ϊ̕B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static String toWriteString(String str, char openPar, char closePar,
    char escape, CharSequence specChars)
  {
    assert (str != null) : "@param:str is null.";
    assert (specChars != null) : "@param:specChars is null.";

    int nSpec = specChars.length();
    int len = str.length();

    StringBuffer buf = new StringBuffer(len + 2);
    buf.append(openPar);

    LOOP1:
    for (int i=0; i<len; i++) {
      char ch = str.charAt(i);
      if (ch == escape) {
        buf.append(escape).append(ch);
      }
      else if (ch == openPar) {
        buf.append(escape).append(ch);
      }
      else if (ch == closePar) {
        buf.append(escape).append(ch);
      }
      else {
        for (int j=0; j<nSpec; j++) {
          if (ch == specChars.charAt(j)) {
            buf.append(escape).append(ch);
            continue LOOP1;
          }
        }
        buf.append(ch);
      }
    }

    buf.append(closePar);
    return buf.toString();
  }
}
