/*
 * AbstractResource class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.resource;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.ArrayList;

/**
 * \[XNX̒ۃNXB
 * <br>
 * \[XNXɋʂ̎`B
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/15 15:28:04 $
 */
public abstract class AbstractResource implements Resource
{
  /** L[̗vf̋؂蕶B */
  private char elementSeparator_ = '.';

  /** L[̑͂ޕ̔zB */
  private char[] attributeParenthesis_ = { '(', ')' };

  /** L[̑̋؂蕶B */
  private char attributeSeparator_ = ',';

  /** L[̖̑Oƒlѕt镶B */
  private char attributeMatchMark_ = '=';

  /** \[Xt@CpXB */
  private String path_ = null;

  /**
   * ftHgRXgN^B
   */
  public AbstractResource()
  {}

  /**
   * Rs[RXgN^B
   *
   * @param  res Rs[̃\[XIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public AbstractResource(AbstractResource res)
  {
    assert (res != null) : "@param:res is null.";

    setElementSeparator(res.getElementSeparator());
    setAttributeSeparator(res.getAttributeSeparator());
    setAttributeMatchMark(res.getAttributeMatchMark());

    char[] par = res.getAttributeParenthesis();
    setAttributeParenthesis(par[0], par[1]);

    path_ = res.path_;
  }

  /**
   * L[̗vf̋؂蕶ݒ肷B
   *
   * @param  separator L[̗vf̋؂蕶B
   */
  protected void setElementSeparator(char separator)
  {
    elementSeparator_ = separator;
  }

  /**
   * L[̗vf̋؂蕶擾B
   *
   * @return L[̗vf̋؂蕶B
   */
  public char getElementSeparator()
  {
    return elementSeparator_ ;
  }

  /**
   * L[̑͂ޕݒ肷B
   *
   * @param  openPar L[̑͂ފJʁB
   * @param  closePar L[̑͂ޕʁB
   */
  protected void setAttributeParenthesis(char openPar, char closePar)
  {
    attributeParenthesis_[0] = openPar;
    attributeParenthesis_[1] = closePar;
  }

  /**
   * L[̑͂ޕ擾B
   *
   * @return L[̑͂ޕ̔zB
   */
  public char[] getAttributeParenthesis()
  {
    return attributeParenthesis_ ;
  }

  /**
   * L[̑̋؂蕶ݒ肷B
   *
   * @param  separator L[̑̋؂蕶B
   */
  public void setAttributeSeparator(char separator)
  {
    attributeSeparator_ = separator;
  }

  /**
   * L[̑̋؂蕶擾B
   *
   * @return L[̑̋؂蕶B
   */
  public char getAttributeSeparator()
  {
    return attributeSeparator_ ;
  }

  /**
   * L[̖̑Oƒlѕt镶ݒ肷B
   *
   * @param  mark L[̖̑Oƒlѕt镶B
   */
  protected void setAttributeMatchMark(char mark)
  {
    attributeMatchMark_ = mark;
  }

  /**
   * L[̖̑Oƒlѕt镶擾B
   *
   * @return L[̖̑Oƒlѕt镶擾B
   */
  public char getAttributeMatchMark()
  {
    return attributeMatchMark_ ;
  }

  /**
   * w肳ꂽL[vf̗vf擾B
   * <br>
   * {#splitKey(String) splitKey}\bhɂĕꂽL[vf
   * vfoB
   *
   * @param  keyElem L[vfB
   * @return vfB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected String getNameOfKeyElement(String keyElem)
  {
    assert (keyElem != null) : "@param:keyElem is null.";

    int index = keyElem.indexOf(getAttributeParenthesis()[0]);
    return (index < 0) ? keyElem : keyElem.substring(0, index);
  }

  /**
   * w肳ꂽL[vf̖̑Oƒl̑g񋓂B
   * <br>
   * {#splitKey(String) splitKey}\bhɂĕꂽL[vf
   * oA̖Oƒl̔z񋓃IuWFNgɊi[ĕԂB
   *
   * @param  keyElem L[vfB
   * @return ̖Oƒl̔zi[񋓃IuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected List<String[]> listAttributesOfKeyElement(String keyElem)
  {
    assert (keyElem != null) : "@param:keyElem is null";

    List<String[]> attrLst = new ArrayList<String[]>();

    int index = keyElem.indexOf(getAttributeParenthesis()[0]);
    if (index < 0) {
      return attrLst;
    }

    String[] attr = new String[2];
    int bgn = index + 1;
    for (int i=bgn; i<keyElem.length()-1; i++) {
      char ch = keyElem.charAt(i);
      if (ch == getAttributeMatchMark()) {
        attr[0] = keyElem.substring(bgn, i);
        bgn = i + 1;
      }
      else if (ch == getAttributeSeparator()) {
        attr[1] = keyElem.substring(bgn, i);
        attrLst.add(attr);
        attr = new String[2];
        bgn = i + 1;
      }
    }

    if (attr[0].length() > 0) {
      attr[1] = keyElem.substring(bgn, keyElem.length() - 1);
      attrLst.add(attr);
    }

    return attrLst;
  }

  /**
   * L[vfƂɕB
   * <br>
   * ۂɃL[̏̌؂sAȉɔꍇɗOX[B
   * <ul>
   * <li>L[󕶎łLƂivf\j</li>
   * <li>vf́A̕ʂŏIĂȂ΂ȂȂ</li>
   * <li>̊ʂJ܂܁AvfIĂ͂ȂȂ</li>
   * <li>̗vf͋Ȃ</li>
   * <li>̑͋Ȃ</li>
   * <li>̑̒ɖOƒl݂̓Ȃ΂ȂȂB
   *     ݂Ȃꍇ͍ŏ̓̂ݗLƂAԖڈȍ~͒l̈ꕔƂ
   *     ߂B</li>
   * </ul>
   *
   * @param  key L[B
   * @throws IllegalKeyException L[sȏꍇB
   */
  protected List<String> splitKey(String key) throws IllegalKeyException
  {
    assert (key != null) : "@param:key is null.";

    List<String> elemLst = new ArrayList<String>();
    if (key.length() == 0) {
      return elemLst;
    }

    int elemBegin = 0;
    int attrBegin = -1;
    boolean isAttrMatchMark = false;
    for (int i=0; i<key.length(); i++) {
      char ch = key.charAt(i);

      if (attrBegin >= 0) {
        if (ch == getAttributeParenthesis()[1]) {
          if (attrBegin == i) {
            throw new IllegalKeyException(
              key, "Attribute name must not be empty.");
          }
          else if (! isAttrMatchMark) {
            throw new IllegalKeyException(
              key, "Attribute need a match mark at least.");
          }
          else if (i+1 == key.length()) {
            ; /* none */
          }
          else if (key.charAt(i+1) == getElementSeparator()) {
            ; /* none */
          }
          else {
            throw new IllegalKeyException(
              key, "Element must end after close parenthesis of attribute");
          }
          attrBegin = -1;
        }
        else if (ch == getAttributeSeparator()) {
          if (attrBegin == i) {
            throw new IllegalKeyException(
              key, "Attribute name must not be empty.");
          }
          else if (! isAttrMatchMark) {
            throw new IllegalKeyException(
              key, "Attribute need a match mark at least.");
          }
          attrBegin = i + 1;
          isAttrMatchMark = false;
        }
        else if (ch == getAttributeMatchMark()) {
          if (attrBegin == i) {
            throw new IllegalKeyException(
              key, "Attribute name must not be empty.");
          }
          isAttrMatchMark = true;
        }
      }
      else if (ch == getAttributeParenthesis()[0]) {
        if (elemBegin == i) {
          throw new IllegalKeyException(
            key, "Element name must not be empty.");
        }
        attrBegin = i + 1;
        isAttrMatchMark = false;
      }
      else if (ch == getElementSeparator()) {
        if (elemBegin == i) {
          throw new IllegalKeyException(
            key, "Element name must not be empty.");
        }
        elemLst.add(key.substring(elemBegin, i));
        elemBegin = i + 1;
      }
    }

    if (attrBegin >= 0) {
      throw new IllegalKeyException(
        key, "Parenthesis of attribute must be closed.");
    }
    else if (elemBegin == key.length()) {
      throw new IllegalKeyException(
        key, "Element name must not be empty.");
    }
    else if (elemBegin <= key.length() - 1) {
      elemLst.add(key.substring(elemBegin));
    }

    return elemLst;
  }

  /**
   * [h\[Xt@C̃pX擾B
   * <br>
   * ܂x\[Xt@C̓ǂݍ݂sĂȂꍇ́A󕶎ԂB
   *
   * @return [h\[Xt@C̃pXB
   */
  public String getPath()
  {
    return path_ ;
  }

  /**
   * w肳ꂽpX̃\[Xt@CǂݍށB
   *
   * @param  path \[Xt@C̃pXB
   * @throws FileNotFoundException w肳ꂽpX̃t@CȂ
   *          ꍇB
   * @throws IOException t@C̓ǂݍݒɗOꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public synchronized void load(String path)
    throws FileNotFoundException, IOException
  {
    assert (path != null) : "@param:path is null.";

    InputStream in = null;
    try {
      in = getInputStream(path);
      load(in);
      path_ = path;
    }
    finally {
      if (in != null) in.close();
    }
  }

  /**
   * w肳ꂽpX̓Xg[擾B
   *
   * @param  path \[Xt@C̃pXB
   * @return ̃pXɑ΂̓Xg[B 
   * @throws FileNotFoundException w肳ꂽpX̃t@CȂ
   *          ꍇB
   * @throws IOException ̓Xg[̃I[vɗOꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected InputStream getInputStream(String path)
    throws FileNotFoundException, IOException
  {
    assert (path != null) : "@param:path is null.";

    return new FileInputStream(path);
  }

  /**
   * ̓̓Xg[烊\[Xt@C̓eǂݍށB
   *
   * @param  stream ̓Xg[B
   * @throws IOException ǂݍݒɗOꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected abstract void load(InputStream stream) throws IOException;

  /**
   * w肳ꂽpX̃t@CɁÃIuWFNgێĂeۑB
   *
   * @param  path ۑ̃t@C̃pXB
   * @throws IOException t@C̕ۑɗOꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public synchronized void save(String path) throws IOException
  {
    assert (path != null) : "@param:path is null.";

    OutputStream out = null;
    try {
      out = getOutputStream(path);
      save(out);
    } 
    finally {
      if (out != null) out.close();
    }
  }

  /**
   * w肳ꂽpX̏o̓Xg[擾B
   *
   * @param  path ۑ̃t@C̃pXB
   * @return ̃pXɑ΂o̓Xg[B
   * @throws IOException w肳ꂽpX̃I[vɗOꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected OutputStream getOutputStream(String path) throws IOException
  {
    assert (path != null) : "@param:path is null.";

    return new FileOutputStream(path);
  }

  /**
   * ̏o̓Xg[ɁÃIuWFNgێĂeۑB
   *
   * @param  stream ۑ̏o̓Xg[B
   * @throws IOException t@C̕ۑɗOꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected abstract void save(OutputStream stream)
    throws IOException;
}
