/*
 * StringConcatenator class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.text;

import java.text.Format;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;

/**
 * ANXB
 * <br>
 * ̕A؂蕶gĘAAw񐔕JԂ
 * ĘAȂǁAlXȕ@ŕA邽߂̃\bhpӂB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/15 15:28:05 $
 */
public class StringConcatenator
{
  /**
   * ftHgRXgN^B
   */
  protected StringConcatenator()
  {}

  /**
   * w肳ꂽ̔zA؂蕶gĘAB
   * <br>
   * z̗vfɃk܂܂Ăꍇ́A̗vf<tt>"null"</tt>Ƃ
   * AB
   *
   * @param  strings ̔zB
   * @param  delimiter ؂蕶B
   * @return A̕B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static String concatenate(String[] strings, String delimiter)
  {
    assert (strings != null) : "@param:strings is null.";
    assert (delimiter != null) : "@param:delimiter is null.";

    StringBuffer buf = new StringBuffer();
    if (strings.length > 0) {
      buf.append(strings[0]);
      for (int i=1; i<strings.length; i++) {
        buf.append(delimiter).append(strings[i]);
      }
    }
    return buf.toString();
  }

  /**
   * w肳ꂽ񋓃IuWFNgɊ܂܂镶A؂蕶gĘA
   * B
   * <br>
   * 񋓃IuWFNg̗vfɃk܂܂Ăꍇ́A̗vf
   * <tt>"null"</tt>ƂĘAB
   *
   * @param  enm AΏۂ̕܂ޗ񋓃IuWFNgB
   * @param  delimiter ؂蕶B
   * @return A̕B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static String concatenate(Enumeration<String> enm, String delimiter)
  {
    assert (enm != null) : "@param:enm is null.";
    assert (delimiter != null) : "@param:delimiter is null.";

    StringBuffer buf = new StringBuffer();
    if (enm.hasMoreElements()) {
      buf.append(enm.nextElement());
      while (enm.hasMoreElements()) {
        buf.append(delimiter).append(enm.nextElement());
      }
    }
    return buf.toString();
  }

  /**
   * w肳ꂽRNVIuWFNgɊ܂܂镶A؂蕶g
   * AB
   * <br>
   * RNVIuWFNg̗vf̃k܂܂Ăꍇ́A̗vf
   * <tt>"null"</tt>ƂĘAB
   *
   * @param  coll AΏ̕܂ރRNVIuWFNgB
   * @param  delimiter ؂蕶B
   * @return A̕B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static String concatenate(Collection<String> coll, String delimiter)
  {
    assert (coll != null) : "@param:coll is null.";
    assert (delimiter != null) : "@param;delimiter is null.";

    StringBuffer buf = new StringBuffer();
    Iterator<String> it = coll.iterator();
    if (it.hasNext()) {
      buf.append(it.next());
      while (it.hasNext()) {
        buf.append(delimiter).append(it.next());
      }
    }
    return buf.toString();
  }

  /**
   * w肳ꂽAw񐔕JԂAB
   * <br>
   * z̗vfɃk܂܂Ăꍇ́A̗vf<tt>"null"</tt>Ƃ
   * AB
   *
   * @param  repeated JԂ̑ΏەB
   * @param  count JԂ񐔁B
   * @return A̕B
   * @throws AssertionError JԂ񐔂̏ꍇifobO[ĥ݁jB
   */
  public static String repeat(char repeated, int count)
  {
     assert (count >= 0) : "@param:count is negative.";

     StringBuffer buf = new StringBuffer();
     for (int i=0; i<count; i++) {
       buf.append(repeated);
     }
     return buf.toString();
  }

  /**
   * w肳ꂽA؂蕶tāAw񐔕JԂAB
   *
   * @param  repeated JԂ̑ΏەB
   * @param  count JԂ񐔁B
   * @param  delimiter ؂蕶B
   * @return A̕B
   * @throws AssertionError k̏ꍇA͌JԂ񐔂̏ꍇ
   *           ifobO[ĥ݁jB
   */
  public static String repeat(String repeated, int count, String delimiter)
  {
    assert (repeated != null) : "@param:repeated is null.";
    assert (delimiter != null) : "@param:delimiter is null.";
    assert (count >= 0) : "@param:count is negative.";

    StringBuffer buf = new StringBuffer();
    if (count > 0) {
      buf.append(repeated);
      for (int i=1; i<count; i++) {
        buf.append(delimiter).append(repeated);
      }
    }
    return buf.toString();
  }

  /**
   * w肳ꂽz̃IuWFNgAIuWFNggĕɕϊA
   * ؂蕶tĘAB
   *
   * @param  objs  IuWFNg̔zB
   * @param  fmt   IuWFNgB
   * @param  delim ؂蕶B
   * @return A̕B
   * @throws IllegalArgumentException IuWFNgɂ镶ւ̕ϊ
   *           sꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static String concatenate(Object[] objs, Format fmt, String delim)
    throws IllegalArgumentException
  {
    assert (objs != null) : "@param:objs is null.";
    assert (fmt != null) : "@param:fmt is null.";
    assert (delim != null) : "@param:delim is null.";

    if (fmt instanceof MessageFormat) {
      MessageFormat mf = (MessageFormat) fmt;
      Object[] args = new Object[1];
      StringBuffer sb = new StringBuffer();
      if (objs.length > 0) {
        args[0] = objs[0];
        sb.append(MessageFormat.format(mf.toPattern(), args));
        for (int i=1; i<objs.length; i++) {
          args[0] = objs[i];
          sb.append(delim).append(MessageFormat.format(mf.toPattern(), args));
        }
      }
      return sb.toString();
    }
    else {
      StringBuffer sb = new StringBuffer();
      if (objs.length > 0) {
        sb.append(fmt.format(objs[0]));
        for (int i=1; i<objs.length; i++) {
          sb.append(delim).append(fmt.format(objs[i]));
        }
      }
      return sb.toString();
    }
  }

  /**
   * w肳ꂽ񋓃IuWFNg̗vfIuWFNgAIuWFNgg
   * ɕϊA؂蕶tĘAB
   *
   * @param  enm 񋓃IuWFNgB
   * @param  fmt IuWFNgB
   * @param  delim ؂蕶B
   * @return A̕B
   * @throws IllegalArgumentException IuWFNgɂ镶ւ̕ϊ
   *           sꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static String concatenate(Enumeration<Object> enm, Format fmt,
    String delim) throws IllegalArgumentException
  {
    assert (enm != null) : "@param:enm is null.";
    assert (fmt != null) : "@param:fmt is null.";
    assert (delim != null) : "@param:delim is null.";

    if (fmt instanceof MessageFormat) {
      MessageFormat mf = (MessageFormat) fmt;
      Object[] args = new Object[1];
      StringBuffer sb = new StringBuffer();
      if (enm.hasMoreElements()) {
        args[0] = enm.nextElement();
        sb.append(MessageFormat.format(mf.toPattern(), args));
        while (enm.hasMoreElements()) {
          args[0] = enm.nextElement();
          sb.append(delim).append(MessageFormat.format(mf.toPattern(), args));
        }
      }
      return sb.toString();
    }
    else {
      StringBuffer sb = new StringBuffer();
      if (enm.hasMoreElements()) {
        sb.append(fmt.format(enm.nextElement()));
        while (enm.hasMoreElements()) {
          sb.append(delim).append(fmt.format(enm.nextElement()));
        }
      }
      return sb.toString();
    }
  }

  /**
   * w肳ꂽRNVIuWFNg̗vfIuWFNgAIuWFNg
   * gĕɕϊA؂蕶tĘAB
   *
   * @param  coll RNVIuWFNgB
   * @param  fmt IuWFNgB
   * @param  delim ؂蕶B
   * @return A̕B
   * @throws IllegalArgumentException IuWFNgɂ镶ւ̕ϊ
   *           sꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB 
   */
  public static String concatenate(Collection coll, Format fmt,
    String delim) throws IllegalArgumentException
  {
    assert (coll != null) : "@param:coll is null.";
    assert (fmt != null) : "@param:fmt is null.";
    assert (delim != null) : "@param:delim is null.";

    if (fmt instanceof MessageFormat) {
      MessageFormat mf = (MessageFormat) fmt;
      Object[] args = new Object[1];
      StringBuffer sb = new StringBuffer();
      Iterator it = coll.iterator();
      if (it.hasNext()) {
        args[0] = it.next();
        sb.append(MessageFormat.format(mf.toPattern(), args));
        while (it.hasNext()) {
          args[0] = it.next();
          sb.append(delim).append(MessageFormat.format(mf.toPattern(), args));
        }
      }
      return sb.toString();
    }
    else {
      StringBuffer sb = new StringBuffer();
      Iterator it = coll.iterator();
      if (it.hasNext()) {
        sb.append(fmt.format(it.next()));
        while (it.hasNext()) {
          sb.append(delim).append(fmt.format(it.next()));
        }
      }
      return sb.toString();
    }
  }

  /**
   * w肳ꂽ̔zA؂蕶gĘAB
   * <br>
   * ؂蕶񒆂Ɍꍇ́ÃGXP[v̒Oɑ}
   * B
   * <br>
   * z̗vfɃk܂܂Ăꍇ́A̗vf<tt>"null"</tt>Ƃ
   * AB
   *
   * @param  strs ̔zB
   * @param  delim ؂蕶B
   * @param  escape GXP[vB
   * @return A̕B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static String concatenate(String[] strs, char delim, char escape)
  {
    assert (strs != null) : "@param:strs is null.";

    StringBuffer specChars = new StringBuffer();
    specChars.append(delim);

    StringBuffer buf = new StringBuffer();
    if (strs.length > 0) {
      buf.append(StringConverter.toWriteString(strs[0], escape, specChars));
      for (int i=1; i<strs.length; i++) {
        buf.append(delim);
        buf.append(StringConverter.toWriteString(strs[i], escape, specChars));
      }
    }
    return buf.toString();
  }

  /**
   * w肳ꂽ񋓃IuWFNg̗vfA؂蕶gĘAB
   * <br>
   * ؂蕶񒆂Ɍꍇ́ÃGXP[v̒Oɑ}
   * B
   *
   * @param  enm 񋓃IuWFNgB
   * @param  delim ؂蕶B
   * @param  esc GXP[vB
   * @return A̕B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static String concatenate(
    Enumeration<String> enm, char delim, char esc)
  {
    assert (enm != null) : "@param:enm is null.";

    StringBuffer spe = new StringBuffer();
    spe.append(delim);
    
    StringBuffer buf = new StringBuffer();
    if (enm.hasMoreElements()) {
      buf.append(StringConverter.toWriteString(enm.nextElement(), esc, spe));
      while (enm.hasMoreElements()) {
        buf.append(delim);
        buf.append(StringConverter.toWriteString(enm.nextElement(), esc, spe));
      }
    }
    return buf.toString();
  }

  /**
   * w肳ꂽRNVIuWFNg̗vfA؂蕶g
   * AB
   * <br>
   * ؂蕶񒆂Ɍꍇ́ÃGXP[v̒Oɑ}
   * B
   *
   * @param  coll RNVIuWFNgB
   * @param  delim ؂蕶B
   * @param  esc GXP[vB
   * @return A̕B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static String concatenate(
    Collection<String> coll, char delim, char esc)
  {
    assert (coll != null) : "@param:coll is null.";

    StringBuffer spe = new StringBuffer();
    spe.append(delim);

    StringBuffer buf = new StringBuffer();
    Iterator<String> it = coll.iterator();
    if (it.hasNext()) {
      buf.append(StringConverter.toWriteString(it.next(), esc, spe));
      while (it.hasNext()) {
        buf.append(delim);
        buf.append(StringConverter.toWriteString(it.next(), esc, spe));
      }
    }
    return buf.toString();
  }

  /**
   * w肳ꂽ̔zAʂň͂݁A؂蕶gĘAB
   * <br>
   * ؂蕶⊇ʂ񒆂Ɍꍇ́ÃGXP[v̒O
   * ɑ}B
   *
   * @param  strs ̔zB
   * @param  delim ؂蕶B
   * @param  openPar JʁB
   * @param  closePar ʁB
   * @param  escape GXP[vB
   * @return A̕B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static String concatenate(String[] strs, char delim,
    char openPar, char closePar, char escape)
  {
    assert (strs != null) : "@param:strs is null.";

    StringBuffer specChars = new StringBuffer();
    specChars.append(delim);
    specChars.append(openPar);
    specChars.append(closePar);

    StringBuffer buf = new StringBuffer();
    if (strs.length > 0) {
      buf.append(openPar);
      buf.append(StringConverter.toWriteString(strs[0], escape, specChars));
      buf.append(closePar);
      for (int i=1; i<strs.length; i++) {
        buf.append(delim);
        buf.append(openPar);
        buf.append(StringConverter.toWriteString(strs[i], escape, specChars));
        buf.append(closePar);
      }
    }
    return buf.toString();
  }

  /**
   * w肳ꂽ񋓃IuWFNg̗vfAʂň͂݁A؂蕶
   * gĘAB
   * <br>
   * ؂蕶⊇ʂ񒆂Ɍꍇ́ÃGXP[v̒O
   * ɑ}B
   *
   * @param  enm 񋓃IuWFNgB
   * @param  delim ؂蕶B
   * @param  openPar JʁB
   * @param  closePar ʁB
   * @param  escape GXP[vB
   * @return A̕B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static String concatenate(Enumeration<String> enm, char delim,
    char openPar, char closePar, char escape)
  {
    assert (enm != null) : "@param:enm is null.";

    StringBuffer specChars = new StringBuffer();
    specChars.append(delim);
    specChars.append(openPar);
    specChars.append(closePar);

    StringBuffer buf = new StringBuffer();
    if (enm.hasMoreElements()) {
      buf.append(openPar);
      buf.append(StringConverter.toWriteString(
        enm.nextElement(), escape, specChars));
      buf.append(closePar);
      while (enm.hasMoreElements()) {
        buf.append(delim);
        buf.append(openPar);
        buf.append(StringConverter.toWriteString(
          enm.nextElement(), escape, specChars));
        buf.append(closePar);
      }
    }
    return buf.toString();
  }

  /**
   * w肳ꂽRNVIuWFNg̗vfAʂň͂݁A؂蕶
   * gĘAB
   * <br>
   * ؂蕶⊇ʂ񒆂Ɍꍇ́ÃGXP[v̒O
   * }B
   *
   * @param  coll RNVIuWFNgB
   * @param  delim ؂蕶B
   * @param  openPar JʁB
   * @param  closePar ʁB
   * @param  escape GXP[vB
   * @return A̕B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static String concatenate(Collection<String> coll, char delim,
    char openPar, char closePar, char escape)
  {
    assert (coll != null) : "@param:coll is null.";

    StringBuffer specChars = new StringBuffer();
    specChars.append(delim);
    specChars.append(openPar);
    specChars.append(closePar);

    StringBuffer buf = new StringBuffer();
    Iterator<String> it = coll.iterator();
    if (it.hasNext()) {
      buf.append(openPar);
      buf.append(StringConverter.toWriteString(it.next(), escape, specChars));
      buf.append(closePar);
      while (it.hasNext()) {
        buf.append(delim);
        buf.append(openPar);
        buf.append(StringConverter.toWriteString(it.next(), escape, specChars));
        buf.append(closePar);
      }
    }
    return buf.toString();
  }
}
