/*
 * MethodInvoker class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester;

import ts.tester.Tester;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.Arrays;
import java.util.StringTokenizer;

/**
 * P[X\bhsNXB
 * <br>
 * w肳ꂽsNXɎĂ鎎P[X\bhP͑S
 * sł悤ɂNXłB
 * ŎP[X\bhƂ́A߂lȂpubNȃ\bh
 * B
 * ܂Aw肳ꂽsNXɒڒ`ꂽ\bĥ݂ΏۂƂA
 * eNXŒ`ꂽ\bh͎sȂB
 * <br>
 * P[X\bȟĂяoɍۂāȂO
 * {@link ts.tester.Tester#initInvocation(String) initInvocation}A
 * {@link ts.tester.Tester#preInvocation(String) preInvocation}A
 * {@link ts.tester.Tester#postInvocation(String) postInvocation}A
 * {@link ts.tester.Tester#endInvocation(String) endInvocation}
 * ̂S̃\bhĂяoB
 * ̂A
 * {@link ts.tester.Tester#preInvocation(String) preInvocation}A
 * {@link ts.tester.Tester#postInvocation(String) postInvocation}
 *  sNX̎Ҍɗpӂꂽ烁\bhł̂ŁA
 * KvȑO㏈ꍇ͂I[o[Ch΂悢B
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:48 $
 */
public class MethodInvoker
{
  /**
   * ftHgRXgN^B
   */
  public MethodInvoker()
  {}

  /**
   * w肳ꂽsIuWFNg̎P[X\bhsB
   * <br>
   * P[X\bhƂ́A̎sIuWFNgɎĂA
   * yі߂lȂpubNȃ\bhłB
   * iAAeNX̃\bh͑ΏۂƂȂjB
   * <br>
   * P[X\bhĂяoOɁA
   * {@link ts.tester.Tester#initInvocation(String) initInvocation}A
   * {@link ts.tester.Tester#preInvocation(String) preInvocation}A
   * {@link ts.tester.Tester#postInvocation(String) postInvocation}A
   * {@link ts.tester.Tester#endInvocation(String) endInvocation}
   * 4̃\bhĂяoB 
   * <br>
   * w肳ꂽO̎P[X\bh݂Ȃꍇ́AOX[B
   * \bh̃ANZXwqpubNłȂꍇ́AOX[B
   *
   * @param  tester {@link ts.tester.Tester Tester}IuWFNgB
   * @param  methodName \bhB
   * @throws NoSuchMethodException w肳ꂽÓAE߂lȂ̃\bh
   *           ݂ȂꍇB
   * @throws IllegalAccessException w肳ꂽÕ\bh̃ANZXwq
   *           pubNłȂꍇB
   * @throws Exception \bh̎sɗOX[ꂽꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static void invokeMethod(Tester tester, String methodName)
    throws NoSuchMethodException, IllegalAccessException, Exception
  {
    assert (tester != null) : "@param:tester is null.";
    assert (methodName != null) : "@param:tester is null.";

    Class[] types = new Class[0];
    Object[] args = new Object[0];

    Method method = tester.getClass().getDeclaredMethod(methodName, types);
    method.setAccessible(true);

    if (! method.getReturnType().equals(Void.TYPE))
      throw new NoSuchMethodException(methodName);

    int modifier = method.getModifiers();
    if (! Modifier.isPublic(modifier))
      throw new IllegalAccessException(methodName);

    invokeMethod(tester, method, args);
  }

  /**
   * w肳ꂽsIuWFNg̑SĂ̎P[X\bhsB
   * <br>
   * P[X\bhƂ́A̎sIuWFNgɎĂA
   * yі߂lȂpubNȃ\bhłB
   * iAAeNX̃\bh͑ΏۂƂȂjB
   * <br>
   * P[X\bȟĂяóA\bh̖OijłB
   * <br>
   * P[X\bhĂяoOɁA
   * {@link ts.tester.Tester#initInvocation(String) initInvocation}A
   * {@link ts.tester.Tester#preInvocation(String) preInvocation}A
   * {@link ts.tester.Tester#postInvocation(String) postInvocation}A
   * {@link ts.tester.Tester#endInvocation(String) endInvocation}
   * ̂S̃\bhĂяoB 
   *
   * @param  tester {@link ts.tester.Tester Tester}IuWFNgB
   * @throws Exception \bh̎sɗOX[ꂽꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static void invokeAllMethods(Tester tester) throws Exception
  {
    assert (tester != null) : "@param:tester is null.";

    Class[] types = new Class[0];
    Object[] args = new Object[0];

    Method[] methods = tester.getClass().getDeclaredMethods();

    Comparator<Method> comparator = new Comparator<Method>() {
      public int compare(Method m1, Method m2) {
        return m1.getName().compareTo(m2.getName());
      }
    };
    Arrays.sort(methods, comparator);

    for (int i=0; i<methods.length; i++) {
      methods[i].setAccessible(true);

      if (methods[i].getParameterTypes().length != 0)
        continue;

      if (! methods[i].getReturnType().equals(Void.TYPE))
        continue;

      int modifier = methods[i].getModifiers();
      if (! Modifier.isPublic(modifier))
        continue;

      invokeMethod(tester, methods[i], args);
    }
  }

  /**
   * sNX{@link ts.tester.Tester Tester}̃IuWFNg̃\bh
   * sB
   * <br>
   * w肳ꂽ\bhĂяoOɁA
   * {@link ts.tester.Tester#initInvocation(String) initInvocation}A
   * {@link ts.tester.Tester#preInvocation(String) preInvocation}A
   * {@link ts.tester.Tester#postInvocation(String) postInvocation}A
   * {@link ts.tester.Tester#endInvocation(String) endInvocation}
   * ̂S̃\bhĂяoB 
   *
   * @param  tester sIuWFNgB
   * @param  method s郁\bhIuWFNgB
   * @param  args s郁\bhɓn̔zB
   * @throws Exception \bh̎sɗOX[ꂽꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  private static void invokeMethod(
    Tester tester, Method method, Object[] args) throws Exception
  {
    assert (tester != null) : "@param:tester is null.";
    assert (method != null) : "@param:method is null.";
    assert (args != null) : "@param:args is null.";

    tester.initInvocation(method.getName());
    tester.preInvocation(method.getName());

    try {
      method.invoke(tester, args);
    }
    catch (InvocationTargetException e) {
      Throwable t = e.getCause();
      if (t instanceof Exception) {
        throw (Exception) t;
      }
      else if (t instanceof Error) {
        throw (Error) t;
      }
    }

    tester.postInvocation(method.getName());
    tester.endInvocation(method.getName());
  }
}
