/*
 * ObjectWriter class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.coverage;

import ts.tester.util.ObjectSerializer;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.InvalidClassException;
import java.io.IOException;

/**
 * JobWsvZXIuWFNgo߂̎dg݂񋟂
 * NXB
 * <br>
 * {@link
 * ts.tester.coverage.Coverage#setObjectWriter(ts.tester.coverage.ObjectWriter) 
 * Coverage#setObjectWriter}\bhgăJobWIuWFNgɐݒ肷B
 * āAJobWsvZXŁÃNX static \bh {@link
 * ts.tester.coverage.ObjectWriter#outputObject outputObject} sƁA
 * Ɏw肳ꂽIuWFNg
 * {@link ts.tester.coverage.ObjectWriter#writeObject writeObject}\bh
 * ƂĎoƂłB
 * <br>
 * AAoIuWFNg {@link java.io.Serializable Serializable}
 * C^[tFCXCvgĂKvB
 *
 * @author  VB
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:49 $
 */
public class ObjectWriter
{
  /** ɃVACYꂽIuWFNg̊JnB */
  private static final char START_CHAR = '\u0002';

  /** ɃVACYꂽIuWFNg̏IB */
  private static final char END_CHAR = '\u0003';

  /** VACYꂽIuWFNg̕i[obt@B */
  private StringBuffer objBuf_ = null;

  /** kVACY\ȃIuWFNgB */
  private final static Null NULL = new Null();

  /** Xg[o̓IuWFNgB */
  private OutputStreamWriter streamWriter_ = null;

  /**
   * IuWFNgJobWsvZXO֏o͂B
   *
   * @param  obj JobWsvZXO֏o͂IuWFNgB
   * @throws java.io.InvalidClassException w肳ꂽIuWFNg̃NX
   *           VACYɕKvȏ𖞂ĂȂꍇB
   * @throws java.io.IOException VACYɓo̓G[ꍇB
   */
  public static void outputObject(Serializable obj)
    throws InvalidClassException, IOException
  {
    if (obj == null) {
      obj = NULL;
    }
    String s = ObjectSerializer.serializeToString(obj);
    System.out.print(START_CHAR + s + END_CHAR);
    System.out.flush();
  }

  /**
   * Xg[o̓IuWFNgݒ肷B
   *
   * @param streamWriter Xg[o̓IuWFNgB
   */
  void setStreamWriter(OutputStreamWriter streamWriter)
  {
    streamWriter_ = streamWriter;
  }

  /**
   * JobWsvZXoꂽXg[A
   * IuWFNgo̓IuWFNg܂̓Xg[o̓IuWFNgɐU蕪
   * o͂B
   *
   * @param  cBuf JobWsvZXoꂽXg[B
   * @param  len  Xg[̒B
   * @throws ClassNotFoundException fVACYIuWFNg̃NX
   *           ȂꍇB
   * @throws IOException o͏ɗOꍇB
   * @throws AssertionError ̃Xg[񂪃k̏ꍇA͈
   *           Xg[̒sȏꍇA̓Xg[o̓IuWFN
   *           gk̏ꍇifobO[ĥ݁jB
   */
  final void writeObjectOrStream(char[] cBuf, int len)
    throws ClassNotFoundException, IOException
  {
    assert (cBuf != null) : "@param:cBuf is null.";
    assert (len >= 0) : "@param:len is negative.";
    assert (len <= cBuf.length) : "@param:len is too large.";
    assert (streamWriter_ != null) : "@param:streamWriter_ is null.";

    int bgn = 0;
    for (int i=0; i<len; i++) {
      if (cBuf[i] == START_CHAR) {
        if (objBuf_ == null) {
          streamWriter_.write(cBuf, bgn, (i - bgn));
          streamWriter_.flush();
        }
        objBuf_ = new StringBuffer();
      }
      else if (cBuf[i] == END_CHAR) {
        if (objBuf_ != null) {
          Object obj = ObjectSerializer.deserialize(objBuf_.toString());
          writeObject((obj instanceof Null) ? null : obj);
          objBuf_ = null;
        }
        bgn = i + 1;
      }
      else {
        if (objBuf_ != null) {
          objBuf_.append(cBuf[i]);
        }
      }
    }

    if (objBuf_ == null && bgn < len) {
      streamWriter_.write(cBuf, bgn, (len - bgn));
      streamWriter_.flush();
    }
  }

  /**
   * JobWsvZXoꂽIuWFNg̏o͏sB
   *
   * @param  obj JobWsvZXoꂽIuWFNgB
   */
  protected void writeObject(Object obj)
  {}

  /* -- inner class --*/

  /**
   * k̑ƂȂVACY\NXB
   */
  private static class Null implements Serializable
  {
    static final long serialVersionUID = 862525238995100138L;
  }
}
