/*
 * ObjectWriterTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.coverage;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.tester.util.ObjectSerializer;
import java.io.*;

/**
 * <code>ObjectWriter</code>NX̋@\NXB
 *
 * @author  VB
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:49 $
 */
public class ObjectWriterTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try { 
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(ObjectWriterTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("ObjectWriterNX̋@\sB");
  }

  public void outputObject()
  {
    MSG("IuWFNg̏o͂̊mFB");

    PrintStream oldOut = System.out;

    ByteArrayOutputStream baos = null;
    try {
      baos = new ByteArrayOutputStream();
      PrintStream ps = new PrintStream(baos);
      System.setOut(ps);

      ObjectWriter.outputObject(new Integer(123));
      byte[] bs = baos.toByteArray();
      Object obj = ObjectSerializer.deserialize(new String(bs, 1, bs.length-2));
      TRUE(obj instanceof Integer);
      EQUAL(obj.toString(), "123");
    }
    catch (Exception e) {
      NG(e);
    }
    finally {
      if (baos != null) try { baos.close(); } catch (Exception e) {}
    }

    System.setOut(oldOut);
  }

  public void outputObject_1()
  {
    MSG("k̏ꍇB");

    PrintStream oldOut = System.out;

    ByteArrayOutputStream baos = null;
    try {
      baos = new ByteArrayOutputStream();
      PrintStream ps = new PrintStream(baos);
      System.setOut(ps);

      ObjectWriter.outputObject(null);
      byte[] bs = baos.toByteArray();
      Object obj = ObjectSerializer.deserialize(new String(bs, 1, bs.length-2));
      EQUAL(obj.getClass().getName(), "ts.tester.coverage.ObjectWriter$Null");
    }
    catch (Exception e) {
      NG(e);
    }
    finally {
      if (baos != null) try { baos.close(); } catch (Exception e) {}
    }

    System.setOut(oldOut);
  }

  public void writeObjectOrStream()
  {
    MSG("Xg[̏o͂̊mFB");

    PrintStream oldOut = System.out;

    try {
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      PrintStream ps = new PrintStream(baos);
      System.setOut(ps);

      ObjectWriter.outputObject(new Integer(123));
      byte[] bs = baos.toByteArray();

      final ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
      final OutputStreamWriter osw = new OutputStreamWriter(baos2);

      class ObjectWriterEx extends ObjectWriter {
        protected void writeObject(Object obj) {
          try {
            osw.write("[" + String.valueOf(obj) + "]");
            osw.flush();
          } catch (Exception e) {
            e.printStackTrace();
          }
        }
      }
      ObjectWriterEx owex = new ObjectWriterEx();
      owex.setStreamWriter(osw);

      String s = new String(bs);
      char[] cs = new char[s.length()];
      for (int i=0; i<cs.length; i++) {
        cs[i] = s.charAt(i);
      }
      owex.writeObjectOrStream(cs, cs.length);
      EQUAL(new String(baos2.toByteArray()), "[123]");
    }
    catch (Exception e) {
      NG(e);
    }

    System.setOut(oldOut);
  }

  public void writeObjectOrStream_1()
  {
    MSG("obt@ɑ̕񂪍ĂꍇB");

    PrintStream oldOut = System.out;

    try {
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      PrintStream ps = new PrintStream(baos);
      System.setOut(ps);

      System.out.print("");
      ObjectWriter.outputObject(new Double(3.14159));
      System.out.print("");
      byte[] bs = baos.toByteArray();

      final ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
      final OutputStreamWriter osw = new OutputStreamWriter(baos2);

      class ObjectWriterEx extends ObjectWriter {
        protected void writeObject(Object obj) {
          try {
            osw.write("[" + String.valueOf(obj) + "]");
            osw.flush();
          } catch (Exception e) {
            e.printStackTrace();
          }
        }
      }
      ObjectWriterEx owex = new ObjectWriterEx();
      owex.setStreamWriter(osw);

      String s = new String(bs);
      char[] cs = new char[s.length()];
      for (int i=0; i<cs.length; i++) {
        cs[i] = s.charAt(i);
      }
      owex.writeObjectOrStream(cs, cs.length);
      EQUAL(new String(baos2.toByteArray()), "[3.14159]");
    }
    catch (Exception e) {
      NG(e);
    }

    System.setOut(oldOut);
  }

  public void writeObjectOrStream_2()
  {
    MSG("NX̃VACY񂪕ɕĎ擾ꍇ");

    PrintStream oldOut = System.out;

    try {
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      PrintStream ps = new PrintStream(baos);
      System.setOut(ps);

      System.out.print("");
      ObjectWriter.outputObject(new Float(1.618));
      System.out.print("͂܂");
      ObjectWriter.outputObject(new Long(987654321L));
      System.out.print("");
      System.out.flush();
      byte[] bs = baos.toByteArray();

      String s = new String(bs);
      int slice = s.length() / 5;
      char[] cs1 = new char[slice];
      char[] cs2 = new char[slice];
      char[] cs3 = new char[slice];
      char[] cs4 = new char[slice];
      char[] cs5 = new char[s.length() - slice * 4];

      int i=0;
      for (; i<cs1.length; i++) {
        cs1[i] = s.charAt(i);
      }
      for (int j=0; j<cs2.length; i++, j++) {
        cs2[j] = s.charAt(i);
      }
      for (int j=0; j<cs3.length; i++, j++) {
        cs3[j] = s.charAt(i);
      }
      for (int j=0; j<cs4.length; i++, j++) {
        cs4[j] = s.charAt(i);
      }
      for (int j=0; j<cs5.length; i++, j++) {
        cs5[j] = s.charAt(i);
      }

      final ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
      final OutputStreamWriter osw = new OutputStreamWriter(baos2);

      class ObjectWriterEx extends ObjectWriter {
        protected void writeObject(Object obj) {
          try {
            osw.write("[" + String.valueOf(obj) + "]");
            osw.flush();
          } catch (Exception e) {
            e.printStackTrace();
          }
        }
      }
      ObjectWriterEx owex = new ObjectWriterEx();
      owex.setStreamWriter(osw);

      owex.writeObjectOrStream(cs1, cs1.length);
      owex.writeObjectOrStream(cs2, cs2.length);
      owex.writeObjectOrStream(cs3, cs3.length);
      owex.writeObjectOrStream(cs4, cs4.length);
      owex.writeObjectOrStream(cs5, cs5.length);

      EQUAL(new String(baos2.toByteArray()),
        "[1.618]͂܂[987654321]");
    }
    catch (Exception e) {
      NG(e);
    }

    System.setOut(oldOut);
  }

  public void writeObjectOrStream_3()
  {
    MSG("̃Xg[񂪃k̏ꍇB");

    PrintStream oldOut = System.out;

    try {
      final ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
      final OutputStreamWriter osw = new OutputStreamWriter(baos2);

      class ObjectWriterEx extends ObjectWriter {
        protected void writeObject(Object obj) {
          try {
            osw.write("[" + String.valueOf(obj) + "]");
            osw.flush();
          } catch (Exception e) {
            e.printStackTrace();
          }
        }
      }
      ObjectWriterEx owex = new ObjectWriterEx();
      owex.setStreamWriter(osw);

      try {
        owex.writeObjectOrStream(null, 0);
        NG();
      } catch (AssertionError e) {
        OK(e);
      } catch (Exception e) {
        NG(e);
      }
    }
    catch (Exception e) {
      NG(e);
    }

    System.setOut(oldOut);
  }

  public void writeObjectOrStream_4()
  {
    MSG("̃Xg[̒sȏꍇB");

    PrintStream oldOut = System.out;

    try {
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      PrintStream ps = new PrintStream(baos);
      System.setOut(ps);

      ObjectWriter.outputObject(new Integer(123));
      byte[] bs = baos.toByteArray();

      final ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
      final OutputStreamWriter osw = new OutputStreamWriter(baos2);

      class ObjectWriterEx extends ObjectWriter {
        protected void writeObject(Object obj) {
          try {
            osw.write("[" + String.valueOf(obj) + "]");
            osw.flush();
          } catch (Exception e) {
            e.printStackTrace();
          }
        }
      }
      ObjectWriterEx owex = new ObjectWriterEx();
      owex.setStreamWriter(osw);

      String s = new String(bs);
      char[] cs = new char[s.length()];
      for (int i=0; i<cs.length; i++) {
        cs[i] = s.charAt(i);
      }

      try {
        owex.writeObjectOrStream(cs, -1);
        NG();
      } catch (AssertionError e) {
        OK(e);
      } catch (Exception e) {
        NG(e);
      }

      try {
        owex.writeObjectOrStream(cs, cs.length + 1);
        NG();
      } catch (AssertionError e) {
        OK(e);
      } catch (Exception e) {
        NG(e);
      }
    }
    catch (Exception e) {
      NG(e);
    }

    System.setOut(oldOut);
  }
}
