/*
 * _PrintEventWriter class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.coverage;

import ts.tester.function.print.Printer;
import ts.tester.function.Result;
import ts.tester.function.CaseResult;
import ts.tester.function.CheckResult;
import ts.tester.coverage.ObjectWriter;
import java.util.Map;
import java.util.HashMap;

/**
 * P[XʃCxgIuWFNg̏o̓NXB
 * <br>
 * JobWsvZX󂯎P[XʃCxgIuWFNg
 * ɁAP[X茋ʂ̏o͂sB
 *
 * @author  VB
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:50 $
 */
class _PrintEventWriter extends ObjectWriter
{
  /** ʏo̓IuWFNgB */
  private Printer printer_ ;
  
  /** JobWsvZXO̎P[XΉÂ}bvB */
  private Map<_CaseIdentifier, CaseResult> caseMap_ =
    new HashMap<_CaseIdentifier, CaseResult>();

  /**
   * ʏo̓IuWFNgɂƂRXgN^B
   *
   * @param  printer ʏo̓IuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public _PrintEventWriter(Printer printer)
  {
    assert (printer != null) : "@param:printer is null.";

    printer_ = printer;
  }

  /**
   * JobWsvZX擾P[XʃCxgIuWFNg
   * B
   * 
   * @param  obj P[XʃCxgIuWFNgB
   */
  @Override
  protected void writeObject(Object obj)
  {
    if (obj == null || !(obj instanceof _PrintEvent)) {
      return;
    }

    _PrintEvent event = (_PrintEvent) obj;
    _CaseIdentifier id = event.getCaseIdentifier();

    switch (event.getType()) {
    case CREATE_CASE_RESULT :
      _CaseIdentifier parentId = (_CaseIdentifier) event.getAdditional();
      CaseResult parent = caseMap_.get(parentId);
      if (parent == null) {
        parent = CaseResult.NULL;
      }
      CaseResult cur = printer_.createCaseResult(id.getCaseName(), parent);
      caseMap_.put(id, cur);
      break;

    case TEST_STARTED :
      printer_.testStarted(caseMap_.get(id));
      break;

    case TEST_ENDED :
      printer_.testEnded(caseMap_.get(id));
      break;

    case CASE_STARTED :
      printer_.caseStarted(caseMap_.get(id));
      break;

    case CASE_ENDED :
      printer_.caseEnded(caseMap_.get(id));
      break;

    case CHECK_OCCURED :
      CheckResult check = (CheckResult) event.getAdditional();
      printer_.checkOccured(check, caseMap_.get(id));
      break;

    case MESSAGE_NOTED :
      String msg = (String) event.getAdditional();
      CaseResult caze = caseMap_.get(id);
      if (caze != null) {
        caze.addMessage(msg);
      }
      printer_.messageNoted(msg, caze);
      break;

    case TEST_STOPPED :
      printer_.testStopped(caseMap_.get(id));
      break;

    case CHILD_RESULT_ADDED :
      if (event.getAdditional() instanceof _CaseIdentifier) {
        _CaseIdentifier childId = (_CaseIdentifier) event.getAdditional();
        CaseResult result = caseMap_.get(id);
        if (result != null) {
          result.addChildResult(caseMap_.get(childId));
        }
      }
      else if (event.getAdditional() instanceof Result) {
        Result child = (Result) event.getAdditional();
        CaseResult result = caseMap_.get(id);
        if (result != null) {
          result.addChildResult(child);
        }
      }
      break;
    }
  }
}

