/*
 * _PrintEventWriterTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.coverage;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.tester.function.*;

/**
 * <code>_PrintEventWriter</code>NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:51 $
 */
public class _PrintEventWriterTest extends FunctionTester
{
  public static void main(String[] args) 
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(_PrintEventWriterTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("_PrintEventWriterNX̋@\sB");
  }

  String caseResultLog_ = "";
  class CaseResultEx extends CaseResult {
    CaseResultEx(String name, CaseResult parent) {
      super(name, parent);
    }
    public int count(ResultType type) {
      return 0;
    }
    public void addChildResult(Result child) {
      caseResultLog_ = "[" + _PrintEventType.CHILD_RESULT_ADDED + "]";
    }
  }

  class PrinterEx extends AbstractPrinter {
    String log_ = "";
    CaseResult case_ = null;
    CheckResult check_ = null;
    String message_ = null;
    public CaseResult createCaseResult(String name, CaseResult parent) {
      case_ = new CaseResultEx(name, parent);
      log_ = "[" + _PrintEventType.CREATE_CASE_RESULT.toString() + "]";
      check_ = null;
      message_ = null;
      return case_ ;
    }
    public void testStarted(CaseResult caseResult) {
      case_ = caseResult;
      log_ = "[" + _PrintEventType.TEST_STARTED.toString() + "]";
      check_ = null;
      message_ = null;
    }
    public void testEnded(CaseResult caseResult) {
      case_ = caseResult;
      log_ = "[" + _PrintEventType.TEST_ENDED.toString() + "]";
      check_ = null;
      message_ = null;
    }
    public void caseStarted(CaseResult caseResult) {
      case_ = caseResult;
      log_ = "[" + _PrintEventType.CASE_STARTED.toString() + "]";
      check_ = null;
      message_ = null;
    }
    public void caseEnded(CaseResult caseResult) {
      case_ = caseResult;
      log_ = "[" + _PrintEventType.CASE_ENDED.toString() + "]";
      check_ = null;
      message_ = null;
    }
    public void checkOccured(CheckResult check, CaseResult caseResult) {
      case_ = caseResult;
      check_ = check;
      log_ = "[" + _PrintEventType.CHECK_OCCURED.toString() + "]";
      message_ = null;
    }
    public void messageNoted(String msg, CaseResult caseResult) {
      case_ = caseResult;
      message_ = msg;
      log_ = "[" + _PrintEventType.MESSAGE_NOTED.toString() + "]";
      check_ = null;
    }
    public void testStopped(CaseResult caseResult) {
      case_ = caseResult;
      log_ = "[" + _PrintEventType.TEST_STOPPED.toString() + "]";
      check_ = null;
      message_ = null;
    }
  }

  /* -- test case -- */

  public void constructor_printer()
  {
    MSG("PrinterIuWFNgɂƂRXgN^B");

    _PrintEventWriter pew = new _PrintEventWriter(new PrinterEx());
    NOTNULL(pew);
  }

  public void constructor_printer_1()
  {
    MSG("k̏ꍇB");

    try {
      _PrintEventWriter pew = new _PrintEventWriter(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void writObject()
  {
    MSG("k̏ꍇB");

    PrinterEx prex = new PrinterEx();
    _PrintEventWriter pew = new _PrintEventWriter(prex);
    pew.writeObject(null);
    EQUAL(prex.log_, "");
    NULL(prex.case_);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");
  }

  public void writeObject_1()
  {
    MSG("_PrintEventIuWFNgłȂꍇB");

    PrinterEx prex = new PrinterEx();
    _PrintEventWriter pew = new _PrintEventWriter(prex);
    pew.writeObject(new Integer(123));

    EQUAL(prex.log_, "");
    NULL(prex.case_);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");
  }

  public void writeObject_2()
  {
    MSG("CREATE_CASE_RESULTCxg̏ꍇB");

    _CaseIdentifier rootId = new _CaseIdentifier("");
    _PrintEvent event = new _PrintEvent(
      _PrintEventType.CREATE_CASE_RESULT, rootId);
 
    PrinterEx prex = new PrinterEx();
    _PrintEventWriter pew = new _PrintEventWriter(prex);
    pew.writeObject(event);

    EQUAL(prex.log_, "[CREATE_CASE_RESULT]");
    EQUAL(prex.case_.getName(), "");
    EQUAL(prex.case_.getParentCaseResult(), CaseResult.NULL);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");
  }

  public void writeObject_3()
  {
    MSG("TeST_STARTEDCxg̏ꍇB");

    _CaseIdentifier id1 = new _CaseIdentifier("");
    _CaseIdentifier id2 = new _CaseIdentifier("");

    _PrintEvent ev1 = new _PrintEvent(_PrintEventType.CREATE_CASE_RESULT, id1);
    _PrintEvent ev2 = new _PrintEvent(_PrintEventType.TEST_STARTED, id1);
    _PrintEvent ev3 = new _PrintEvent(_PrintEventType.TEST_STARTED, id2);

    PrinterEx prex = new PrinterEx();
    _PrintEventWriter pew = new _PrintEventWriter(prex);

    pew.writeObject(ev2);
    EQUAL(prex.log_, "[TEST_STARTED]");
    NULL(prex.case_);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev3);
    EQUAL(prex.log_, "[TEST_STARTED]");
    NULL(prex.case_);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev1);
    EQUAL(prex.log_, "[CREATE_CASE_RESULT]");
    EQUAL(prex.case_.getName(), "");
    EQUAL(prex.case_.getParentCaseResult(), CaseResult.NULL);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev2);
    EQUAL(prex.log_, "[TEST_STARTED]");
    EQUAL(prex.case_.getName(), "");
    EQUAL(prex.case_.getParentCaseResult(), CaseResult.NULL);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev3);
    EQUAL(prex.log_, "[TEST_STARTED]");
    NULL(prex.case_);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");
  }

  public void writeObject_4()
  {
    MSG("TEST_ENDEDCxg̏ꍇB");

    _CaseIdentifier id1 = new _CaseIdentifier("");
    _CaseIdentifier id2 = new _CaseIdentifier("");

    _PrintEvent ev1 = new _PrintEvent(_PrintEventType.CREATE_CASE_RESULT, id1);
    _PrintEvent ev2 = new _PrintEvent(_PrintEventType.TEST_ENDED, id1);
    _PrintEvent ev3 = new _PrintEvent(_PrintEventType.TEST_ENDED, id2);

    PrinterEx prex = new PrinterEx();
    _PrintEventWriter pew = new _PrintEventWriter(prex);

    pew.writeObject(ev2);
    EQUAL(prex.log_, "[TEST_ENDED]");
    NULL(prex.case_);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev3);
    EQUAL(prex.log_, "[TEST_ENDED]");
    NULL(prex.case_);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev1);
    EQUAL(prex.log_, "[CREATE_CASE_RESULT]");
    EQUAL(prex.case_.getName(), "");
    EQUAL(prex.case_.getParentCaseResult(), CaseResult.NULL);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev2);
    EQUAL(prex.log_, "[TEST_ENDED]");
    EQUAL(prex.case_.getName(), "");
    EQUAL(prex.case_.getParentCaseResult(), CaseResult.NULL);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev3);
    EQUAL(prex.log_, "[TEST_ENDED]");
    NULL(prex.case_);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");
  }

  public void writeObject_5()
  {
    MSG("CASE_STARTEDCxg̏ꍇB");

    _CaseIdentifier id1 = new _CaseIdentifier("");
    _CaseIdentifier id2 = new _CaseIdentifier("");

    _PrintEvent ev1 = new _PrintEvent(_PrintEventType.CREATE_CASE_RESULT, id1);
    _PrintEvent ev2 = new _PrintEvent(_PrintEventType.CASE_STARTED, id1);
    _PrintEvent ev3 = new _PrintEvent(_PrintEventType.CASE_STARTED, id2);

    PrinterEx prex = new PrinterEx();
    _PrintEventWriter pew = new _PrintEventWriter(prex);

    pew.writeObject(ev2);
    EQUAL(prex.log_, "[CASE_STARTED]");
    NULL(prex.case_);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev3);
    EQUAL(prex.log_, "[CASE_STARTED]");
    NULL(prex.case_);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev1);
    EQUAL(prex.log_, "[CREATE_CASE_RESULT]");
    EQUAL(prex.case_.getName(), "");
    EQUAL(prex.case_.getParentCaseResult(), CaseResult.NULL);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev2);
    EQUAL(prex.log_, "[CASE_STARTED]");
    EQUAL(prex.case_.getName(), "");
    EQUAL(prex.case_.getParentCaseResult(), CaseResult.NULL);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev3);
    EQUAL(prex.log_, "[CASE_STARTED]");
    NULL(prex.case_);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");
  }

  public void writeObject_6()
  {
    MSG("CASE_ENDEDCxg̏ꍇB");

    _CaseIdentifier id1 = new _CaseIdentifier("");
    _CaseIdentifier id2 = new _CaseIdentifier("");

    _PrintEvent ev1 = new _PrintEvent(_PrintEventType.CREATE_CASE_RESULT, id1);
    _PrintEvent ev2 = new _PrintEvent(_PrintEventType.CASE_ENDED, id1);
    _PrintEvent ev3 = new _PrintEvent(_PrintEventType.CASE_ENDED, id2);

    PrinterEx prex = new PrinterEx();
    _PrintEventWriter pew = new _PrintEventWriter(prex);

    pew.writeObject(ev2);
    EQUAL(prex.log_, "[CASE_ENDED]");
    NULL(prex.case_);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev3);
    EQUAL(prex.log_, "[CASE_ENDED]");
    NULL(prex.case_);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev1);
    EQUAL(prex.log_, "[CREATE_CASE_RESULT]");
    EQUAL(prex.case_.getName(), "");
    EQUAL(prex.case_.getParentCaseResult(), CaseResult.NULL);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev2);
    EQUAL(prex.log_, "[CASE_ENDED]");
    EQUAL(prex.case_.getName(), "");
    EQUAL(prex.case_.getParentCaseResult(), CaseResult.NULL);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev3);
    EQUAL(prex.log_, "[CASE_ENDED]");
    NULL(prex.case_);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");
  }

  public void writeObject_7()
  {
    MSG("CHECK_OCCUREDCxg̏ꍇB");

    _CaseIdentifier id1 = new _CaseIdentifier("");
    _CaseIdentifier id2 = new _CaseIdentifier("");

    _PrintEvent ev1 = new _PrintEvent(_PrintEventType.CREATE_CASE_RESULT, id1);
    _PrintEvent ev2 = new _PrintEvent(_PrintEventType.CHECK_OCCURED, id1,
      CheckResult.Incomplete());
    _PrintEvent ev3 = new _PrintEvent(_PrintEventType.CHECK_OCCURED, id2,
      CheckResult.Empty());

    PrinterEx prex = new PrinterEx();
    _PrintEventWriter pew = new _PrintEventWriter(prex);

    pew.writeObject(ev2);
    EQUAL(prex.log_, "[CHECK_OCCURED]");
    NULL(prex.case_);
    TRUE(prex.check_.is(ResultType.Incomplete));
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev3);
    EQUAL(prex.log_, "[CHECK_OCCURED]");
    NULL(prex.case_);
    TRUE(prex.check_.is(ResultType.Empty));
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev1);
    EQUAL(prex.log_, "[CREATE_CASE_RESULT]");
    EQUAL(prex.case_.getName(), "");
    EQUAL(prex.case_.getParentCaseResult(), CaseResult.NULL);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev2);
    EQUAL(prex.log_, "[CHECK_OCCURED]");
    EQUAL(prex.case_.getName(), "");
    EQUAL(prex.case_.getParentCaseResult(), CaseResult.NULL);
    TRUE(prex.check_.is(ResultType.Incomplete));
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev3);
    EQUAL(prex.log_, "[CHECK_OCCURED]");
    NULL(prex.case_);
    TRUE(prex.check_.is(ResultType.Empty));
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");
  }

  public void writeObject_8()
  {
    MSG("MESSAGE_NOTEDCxg̏ꍇB");

    _CaseIdentifier id1 = new _CaseIdentifier("");
    _CaseIdentifier id2 = new _CaseIdentifier("");

    _PrintEvent ev1 = new _PrintEvent(_PrintEventType.CREATE_CASE_RESULT, id1);
    _PrintEvent ev2 = new _PrintEvent(_PrintEventType.MESSAGE_NOTED, id1, "");
    _PrintEvent ev3 = new _PrintEvent(_PrintEventType.MESSAGE_NOTED, id2, "");

    PrinterEx prex = new PrinterEx();
    _PrintEventWriter pew = new _PrintEventWriter(prex);

    pew.writeObject(ev2);
    EQUAL(prex.log_, "[MESSAGE_NOTED]");
    NULL(prex.case_);
    NULL(prex.check_);
    EQUAL(prex.message_, "");
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev3);
    EQUAL(prex.log_, "[MESSAGE_NOTED]");
    NULL(prex.case_);
    NULL(prex.check_);
    EQUAL(prex.message_, "");
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev1);
    EQUAL(prex.log_, "[CREATE_CASE_RESULT]");
    EQUAL(prex.case_.getName(), "");
    EQUAL(prex.case_.getParentCaseResult(), CaseResult.NULL);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev2);
    EQUAL(prex.log_, "[MESSAGE_NOTED]");
    EQUAL(prex.case_.getName(), "");
    EQUAL(prex.case_.getParentCaseResult(), CaseResult.NULL);
    NULL(prex.check_);
    EQUAL(prex.message_, "");
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev3);
    EQUAL(prex.log_, "[MESSAGE_NOTED]");
    NULL(prex.case_);
    NULL(prex.check_);
    EQUAL(prex.message_, "");
    EQUAL(caseResultLog_, "");
  }

  public void writeObject_9()
  {
    MSG("TEST_STOPPEDCxg̏ꍇB");

    _CaseIdentifier id1 = new _CaseIdentifier("");
    _CaseIdentifier id2 = new _CaseIdentifier("");

    _PrintEvent ev1 = new _PrintEvent(_PrintEventType.CREATE_CASE_RESULT, id1);
    _PrintEvent ev2 = new _PrintEvent(_PrintEventType.TEST_STOPPED, id1);
    _PrintEvent ev3 = new _PrintEvent(_PrintEventType.TEST_STOPPED, id2);

    PrinterEx prex = new PrinterEx();
    _PrintEventWriter pew = new _PrintEventWriter(prex);

    pew.writeObject(ev2);
    EQUAL(prex.log_, "[TEST_STOPPED]");
    NULL(prex.case_);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev3);
    EQUAL(prex.log_, "[TEST_STOPPED]");
    NULL(prex.case_);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev1);
    EQUAL(prex.log_, "[CREATE_CASE_RESULT]");
    EQUAL(prex.case_.getName(), "");
    EQUAL(prex.case_.getParentCaseResult(), CaseResult.NULL);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev2);
    EQUAL(prex.log_, "[TEST_STOPPED]");
    EQUAL(prex.case_.getName(), "");
    EQUAL(prex.case_.getParentCaseResult(), CaseResult.NULL);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev3);
    EQUAL(prex.log_, "[TEST_STOPPED]");
    NULL(prex.case_);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");
  }

  public void writeObject_a()
  {
    MSG("CHILD_RESULT_ADDEDCxg̏ꍇB");

    _CaseIdentifier id1 = new _CaseIdentifier("");
    _CaseIdentifier id2 = new _CaseIdentifier("");

    _PrintEvent ev1 = new _PrintEvent(_PrintEventType.CREATE_CASE_RESULT, id1);
    _PrintEvent ev2 = new _PrintEvent(_PrintEventType.CREATE_CASE_RESULT, id2);
    _PrintEvent ev3 = new _PrintEvent(_PrintEventType.CHILD_RESULT_ADDED,
      id1, id2);
    _PrintEvent ev4 = new _PrintEvent(_PrintEventType.CHILD_RESULT_ADDED,
      id2, CheckResult.NG());

    PrinterEx prex = new PrinterEx();
    _PrintEventWriter pew = new _PrintEventWriter(prex);

    pew.writeObject(ev3);
    EQUAL(prex.log_, "");
    NULL(prex.case_);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev4);
    EQUAL(prex.log_, "");
    NULL(prex.case_);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev1);
    EQUAL(prex.log_, "[CREATE_CASE_RESULT]");
    EQUAL(prex.case_.getName(), "");
    EQUAL(prex.case_.getParentCaseResult(), CaseResult.NULL);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev2);
    EQUAL(prex.log_, "[CREATE_CASE_RESULT]");
    EQUAL(prex.case_.getName(), "");
    EQUAL(prex.case_.getParentCaseResult(), CaseResult.NULL);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "");

    pew.writeObject(ev3);
    EQUAL(prex.log_, "[CREATE_CASE_RESULT]");
    EQUAL(prex.case_.getName(), "");
    EQUAL(prex.case_.getParentCaseResult(), CaseResult.NULL);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "[CHILD_RESULT_ADDED]");

    caseResultLog_ = "";

    pew.writeObject(ev4);
    EQUAL(prex.log_, "[CREATE_CASE_RESULT]");
    EQUAL(prex.case_.getName(), "");
    EQUAL(prex.case_.getParentCaseResult(), CaseResult.NULL);
    NULL(prex.check_);
    NULL(prex.message_);
    EQUAL(caseResultLog_, "[CHILD_RESULT_ADDED]");
  }
}
