/*
 * AbstractPrinterTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.print;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.tester.function.*;

/**
 * <code>AbstractPrinter</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:51 $
 */
public class AbstractPrinterTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(AbstractPrinterTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- inner classes -- */

  class PrinterEx extends AbstractPrinter {
    public CaseResult createCaseResult(String name, CaseResult parent)
    {
      return new CaseResult(name, parent) {
        @Override public int count(ResultType type) {
          return 0;
        }
        @Override public void addChildResult(Result result) {
        }
      };
    }
    @Override public void testStarted(CaseResult root)
    { super.testStarted(root); }
    @Override public void testEnded(CaseResult root)
    { super.testEnded(root); }
    @Override public void caseStarted(CaseResult current)
    { super.caseStarted(current); }
    @Override public void caseEnded(CaseResult current)
    { super.caseEnded(current); }
    @Override public void checkOccured(CheckResult check, CaseResult current)
    { super.checkOccured(check, current); }
    @Override public void messageNoted(String msg, CaseResult current)
    { super.messageNoted(msg, current); }
    @Override public void testStopped(CaseResult current)
    { super.testStopped(current); }
  }

  /* -- test case -- */

  public void constructor()
  {
    MSG("ftHgRXgN^̊mF");

    PrinterEx printer = new PrinterEx();
    NOTNULL(printer);
  }

  public void setStopped()
  {
    MSG("true/falseꂼݒ肵ꍇ");

    PrinterEx printer = new PrinterEx();
    FALSE(printer.isStopped());
    printer.setStopped(true);
    TRUE(printer.isStopped());
    printer.setStopped(false);
    FALSE(printer.isStopped());
  }

  public void createCaseResult()
  {
    MSG("k̏ꍇ");

    PrinterEx printer = new PrinterEx();
    try {
      printer.createCaseResult(null, null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.createCaseResult("aaa", null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.createCaseResult(null, CaseResult.NULL);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void testStarted()
  {
    MSG("ʏ̑̏ꍇ");
   
    PrinterEx printer = new PrinterEx();
    CaseResult c = printer.createCaseResult("aaa", CaseResult.NULL);
    printer.testStarted(c);
    OK();
  }

  public void testStarted_null()
  {
    MSG("k̏ꍇ");

    PrinterEx printer = new PrinterEx();
    try {
      printer.testStarted(null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void testEnded()
  {
    MSG("ʏ̑");

    PrinterEx printer = new PrinterEx();
    CaseResult c = printer.createCaseResult("aaa", CaseResult.NULL);
    printer.testEnded(c);
    OK();
  }

  public void testEnded_null()
  {
    MSG("k̏ꍇ");

    PrinterEx printer = new PrinterEx();
    try {
      printer.testEnded(null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void caseStarted()
  {
    MSG("ʏ̑");

    PrinterEx printer = new PrinterEx();
    CaseResult c0 = printer.createCaseResult("aaa", CaseResult.NULL);
    printer.caseStarted(c0);
    OK();
  }

  public void caseStarted_null()
  {
    MSG("k̏ꍇ");

    PrinterEx printer = new PrinterEx();
    try {
      printer.caseStarted(null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void caseEnded()
  {
    MSG("ʏ̏ꍇ");

    PrinterEx printer = new PrinterEx();
    CaseResult c = printer.createCaseResult("aaa", CaseResult.NULL);
    printer.caseEnded(c);
    OK();
  }

  public void caseEnded_null()
  {
    MSG("k̏ꍇ");

    PrinterEx printer = new PrinterEx();
    try {
      printer.caseEnded(null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void checkOccured()
  {
    MSG("ʏ̏ꍇ");

    PrinterEx printer = new PrinterEx();
    CaseResult c = printer.createCaseResult("aaa", CaseResult.NULL);
    printer.checkOccured(CheckResult.NG(), c);
    OK();
  }

  public void checkOccured_null_null()
  {
    MSG("k̏ꍇ");

    PrinterEx printer = new PrinterEx();
    try {
      printer.checkOccured(null, null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.checkOccured(null, CaseResult.NULL);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.checkOccured(CheckResult.OK(), null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void messageNoted()
  {
    MSG("ʏꍇ");

    PrinterEx printer = new PrinterEx();
    CaseResult c = printer.createCaseResult("aaa", CaseResult.NULL);
    printer.messageNoted("XXX", c);
    OK();
  }

  public void messageNoted_null_null()
  {
    MSG("k̏ꍇ");

    PrinterEx printer = new PrinterEx();
    try {
      printer.messageNoted(null, null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.messageNoted(null, CaseResult.NULL);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.messageNoted("", null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void testStopped()
  {
    MSG("ʏ̏ꍇ");

    PrinterEx printer = new PrinterEx();
    CaseResult c = printer.createCaseResult("aaa", CaseResult.NULL);
    printer.testStopped(c);
    OK();
  }

  public void testStopped_null()
  {
    MSG("k̏ꍇ");

    PrinterEx printer = new PrinterEx();
    try {
      printer.testStopped(null);
      NG();
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }
}
