/*
 * ObjectInspector class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.HashMap;
import java.util.HashSet;

/**
 * IuWFNgNXB
 * <br>
 * w肳ꂽIuWFNg̑̒lҒlƓǂB
 * l̔ɂ́A{@link ts.tester.function.FunctionTester FunctionTester}
 * NX̃\bhgpB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:49 $
 */
public class ObjectInspector
{
  /** Ғli[}bvBlƊҒl̑ΉێB*/
  private HashMap<String, Object> expectedMap_ = new HashMap<String, Object>();

  /** 肩珜O鑮̃}bvB */
  private HashSet<String> ignoredFieldSet_ = new HashSet<String>();

  /** Ɏgp{@link ts.tester.function.FunctionTester FunctionTester}
   * IuWFNgB
   */
  private FunctionTester tester_ ;

  /**
   * {@link ts.tester.function.FunctionTester FunctionTester}IuWFNg
   * ɂƂRXgN^B
   * <br>
   * {@link ts.tester.function.FunctionTester FunctionTester}́A̒l
   * Ғlǂ̔ɗpB
   *
   * @param  tester {@link ts.tester.function.FunctionTester FunctionTester}
   *           IuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public ObjectInspector(FunctionTester tester)
  {
    assert (tester != null) : "@param:tester is null.";

    tester_ = tester;
  }

  /**
   * Ғlo^B
   *
   * @param  fieldName B
   * @param  expected ̊ҒlB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void expect(String fieldName, Object expected)
  {
    assert (fieldName != null) : "@param:fieldName is null.";

    expectedMap_.put(fieldName, expected);
  }

  /**
   * Ғl擾B
   * <br>
   * w肳ꂽo^ĂȂꍇ͗OX[B
   *
   * @param  fieldName B
   * @return ̊ҒlB
   * @throws NoSuchFieldException w肳ꂽo^ĂȂꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public Object getExpected(String fieldName) throws NoSuchFieldException
  {
    assert (fieldName != null) : "@param:fieldName is null.";

    if (! expectedMap_.containsKey(fieldName)) {
      throw new NoSuchFieldException(fieldName);
    }

    return expectedMap_.get(fieldName);
  }

  /**
   * <code>boolean</code>^̊Ғlo^B
   *
   * @param  fieldName B
   * @param  expected ̊ҒlB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void expect(String fieldName, boolean expected)
  {
    expect(fieldName, expected ? Boolean.TRUE : Boolean.FALSE);
  }

  /**
   * <code>byte</code>^̊Ғlo^B
   *
   * @param  fieldName B
   * @param  expected ̊ҒlB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void expect(String fieldName, byte expected)
  {
    expect(fieldName, new Byte(expected));
  }

  /**
   * <code>char</code>^̊Ғlo^B
   *
   * @param  fieldName B
   * @param  expected ̊ҒlB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void expect(String fieldName, char expected)
  {
    expect(fieldName, new Character(expected));
  }

  /**
   * <code>short</code>^̊Ғlo^B
   *
   * @param  fieldName B
   * @param  expected ̊ҒlB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void expect(String fieldName, short expected)
  {
    expect(fieldName, new Short(expected));
  }

  /**
   * <code>int</code>^̊Ғlo^B
   *
   * @param  fieldName B
   * @param  expected ̊ҒlB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void expect(String fieldName, int expected)
  {
    expect(fieldName, new Integer(expected));
  }

  /**
   * <code>long</code>^̊Ғlo^B
   *
   * @param  fieldName B
   * @param  expected ̊ҒlB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void expect(String fieldName, long expected)
  {
    expect(fieldName, new Long(expected));
  }

  /**
   * <code>float</code>^̊Ғlo^B
   *
   * @param  fieldName B
   * @param  expected ̊ҒlB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void expect(String fieldName, float expected)
  {
    expect(fieldName, new Float(expected));
  }

  /**
   * <code>double</code>^̊Ғlo^B
   *
   * @param  fieldName B
   * @param  expected ̊ҒlB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void expect(String fieldName, double expected)
  {
    expect(fieldName, new Double(expected));
  }

  /**
   * 肩珜O鑮ݒ肷B
   * <br>
   * AAɊҒlݒ肳Ăꍇ́AҒl̕D悳
   * 肪sB
   *
   * @param  fieldName B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void ignore(String fieldName)
  {
    assert (fieldName != null) : "@param:fieldName is null.";

    ignoredFieldSet_.add(fieldName);
  }

  /**
   * w肳ꂽȎIuWFNg擾B
   * <br>
   * w肳ꂽȎÃNXɑ݂Ȃꍇ͗OX[B
   *
   * @param  clazz 擾NXB
   * @param  fieldName B
   * @return IuWFNgB
   * @throws NoSuchFieldException w肳ꂽ݂ȂꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected Field findField(Class clazz, String fieldName)
    throws NoSuchFieldException
  {
    assert (clazz != null) : "@param;clazz is null.";
    assert (fieldName != null) : "@param:fieldName is null."; 

    Class cls = clazz;
    for (;;) {
      try {
        return cls.getDeclaredField(fieldName);
      }
      catch (NoSuchFieldException e) {
        cls = cls.getSuperclass();
        if (cls != null) {
          continue;
        }
      }
      catch (Exception e) {
        break;
      }
    }
    throw new NoSuchFieldException(fieldName);
  }

  /**
   * ̃NXIuWFNgÃNXIuWFNg̔hNX
   * ǂ𒲂ׂB
   *
   * @param  clazz Ώۂ̃NXB
   * @param  superClass h̃NXB
   * @return <code>clazz</code><code>superClass</code>̔hNX̏ꍇ
   *           <tt>true</tt>AłȂꍇ<tt>false</tt>ԂB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public boolean isInheritance(Class clazz, Class superClass)
  {
    assert (clazz != null) : "@param:clazz is null.";
    assert (superClass != null) : "@param:superClass is null.";

    if (clazz.equals(superClass)) {
      return true;
    }

    Class[] interfaces = clazz.getInterfaces();
    for (int i=0; i<interfaces.length; i++) {
      if (isInheritance(interfaces[i], superClass)) {
        return true;
      }
    }

    Class c = clazz.getSuperclass();
    if (c == null) {
      return false;
    }

    return (isInheritance(c, superClass));
  }

  /**
   * w肳ꂽȎlB
   * <br>
   * Ɏw肳ꂽIuWFNg̑lAOɓo^ꂽҒlƓ
   * ǂ肷B
   *
   * @param  obj Ώۂ̃IuWFNgB
   * @param  fieldName B
   * @throws NoSuchFieldException ݂ȂA͑̊Ғlo^
   *           ĂȂꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void inspect(Object obj, String fieldName) throws NoSuchFieldException
  {
    assert (obj != null) : "@param:obj is null.";
    assert (fieldName != null) : "@param:fieldName is null.";

    Object expected = null;
    Object value = null;
    Field field = null;

    try {
      expected = getExpected(fieldName);
      field = findField(obj.getClass(), fieldName);
      field.setAccessible(true);
      value = field.get(obj);
    }
    catch (NoSuchFieldException e) {
      throw e;
    }
    catch (Exception e) {
      tester_.NG(e);
    }

    inspect(field, value, expected);
  }

  /**
   * IuWFNg̑SĂ̑lB
   * <br>
   * IuWFNg̑lAOɓo^ꂽҒlƓǂ肷B
   *
   * @param  obj Ώۂ̃IuWFNgB
   */
  public void inspect(Object obj)
  {
    assert (obj != null) : "@param:obj is null.";

    Set<String> appearedNameSet = new HashSet<String>();
    Class cls = obj.getClass();
    do {
      Field[] fields = cls.getDeclaredFields();
      for (int i=0; i<fields.length; i++) {
        if (fields[i].isSynthetic()) {
          continue;
        }

        String name = fields[i].getName();

        if (appearedNameSet.contains(name)) {
          continue;
        }
        appearedNameSet.add(name);

        Object expected = null;
        try {
          expected = getExpected(name);
        }
        catch (NoSuchFieldException e) {
          if (! ignoredFieldSet_.contains(name)) {
            tester_.NG(e);
          }
          continue;
        }
        catch (Exception e) {
          tester_.NG(e);
          continue;
        }

        Object value = null;
        try {
          fields[i].setAccessible(true);
          value = fields[i].get(obj);
        }
        catch (Exception e) {
          tester_.NG(e);
          continue;
        }

        inspect(fields[i], value, expected);
      }

      cls = cls.getSuperclass();

    } while (cls != null && ! cls.equals(Object.class));
  }

  /**
   * w肳ꂽ̒lAҒlƓǂ𔻒肷B
   *
   * @param  field IuWFNgB
   * @param  value lB
   * @param  expected ҒlB
   */
  private void inspect(Field field, Object value, Object expected)
  {
    if (expected == null || value == null) {
      tester_.EQUAL(value, expected);
    }
    else if (field.getType().isArray()) {
      if (value instanceof boolean[]) {
        tester_.EQUAL((boolean[]) value, (boolean[]) expected);
      }
      else if (value instanceof byte[]) {
        tester_.EQUAL((byte[]) value, (byte[]) expected);
      }
      else if (value instanceof char[]) {
        tester_.EQUAL((char[]) value, (char[]) expected);
      }
      else if (value instanceof short[]) {
        tester_.EQUAL((short[]) value, (short[]) expected);
      }
      else if (value instanceof int[]) {
        tester_.EQUAL((int[]) value, (int[]) expected);
      }
      else if (value instanceof long[]) {
        tester_.EQUAL((long[]) value, (long[]) expected);
      }
      else if (value instanceof float[]) {
        tester_.EQUAL((float[]) value, (float[]) expected);
      }
      else if (value instanceof double[]) {
        tester_.EQUAL((double[]) value, (double[]) expected);
      }
      else {
        tester_.EQUAL((Object[]) value, (Object[]) expected);
      }
    }
    else if (isInheritance(field.getType(), List.class)) {
      tester_.EQUAL((List<?>) value, (List<?>) expected);
    }
    else if (isInheritance(field.getType(), Collection.class)) {
      tester_.EQUAL((Collection<?>) value, (Collection<?>) expected);
    }
    else if (isInheritance(field.getType(), Map.class)) {
      tester_.EQUAL((Map<?,?>) value, (Map<?,?>) expected);
    }
    else if (value instanceof StringBuffer) {
      tester_.MATCH((StringBuffer) value, (StringBuffer) expected);
    }
    else {
      tester_.EQUAL(value, expected);
    }
  }

  /**
   * w肳ꂽIuWFNg̃\bhsB
   * <br>
   * \bh̃ANZXwqɊւ炸Ã\bhsĖ߂lԂB
   * ̃\bhł́AȂ\bhs邱ƂłB
   * <br>
   * \bh̖߂l{f[^^̏ꍇ́AΉ郉bvNXɒli[
   * ĕԂB
   * ߂lȂ(<code>void</code>^)̏ꍇ́A{@link java.lang.Void#TYPE 
   * Void.TYPE}ԂB
   * <br>
   * w肳ꂽÕ\bhIuWFNgɑ݂Ȃꍇ͗OX[B
   *
   * @param  obj \bhsIuWFNgB
   * @param  methodName s郁\bhB
   * @return sꂽ\bh̖߂lB
   * @throws NoSuchMethodException w肳ꂽÕ\bh݂ȂꍇB
   * @throws Exception \bh̎sɗOꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public Object invokeMethod(Object obj, String methodName)
    throws NoSuchMethodException, Exception
  {
    return invokeMethod(obj, methodName, new Class[0], new Object[0]);
  }

  /**
   * w肳ꂽIuWFNg̃\bhsB
   * <br>
   * \bh̃ANZXwqɊւ炸Ã\bhsĖ߂lԂB
   * ̃\bhł́A̈Ƃ郁\bhs邱ƂłB
   * <br>
   * \bh̖߂l{f[^^̏ꍇ́AΉ郉bvNXɒli[
   * ĕԂB
   * ߂lȂ(<code>void</code>^)̏ꍇ́A{@link java.lang.Void#TYPE 
   * Void.TYPE}ԂB
   * <br>
   * w肳ꂽÕ\bhIuWFNgɑ݂Ȃꍇ͗OX[B
   *
   * @param  obj \bhsIuWFNgB
   * @param  methodName s郁\bhB
   * @param  argType \bhɓň^B
   * @param  argValue \bhɓn̒lB
   * @return sꂽ\bh̖߂lB
   * @throws NoSuchMethodException w肳ꂽÕ\bh݂ȂꍇB
   * @throws Exception \bh̎sɗOꍇB
   * @throws AssertionError argValuek̏ꍇ
   *           ifobO[ĥ݁jB
   */
  public Object invokeMethod(
    Object obj, String methodName, Class argType, Object argValue
  ) throws NoSuchMethodException, Exception
  {
    Class[] types = new Class[1];
    types[0] = argType;
    return invokeMethod(obj, methodName, types, argValue);
  }

  /**
   * w肳ꂽIuWFNg̃\bhsB
   * <br>
   * \bh̃ANZXwqɊւ炸Ã\bhsĖ߂lԂB
   * \bḧ́A^yђlꂼꏇԂɔzɊi[Ďw肷B
   * <br>
   * \bh̖߂l{f[^^̏ꍇ́AΉ郉bvNXɒli[
   * ĕԂB
   * ߂lȂ(<code>void</code>^)̏ꍇ́A{@link java.lang.Void#TYPE 
   * Void.TYPE}ԂB
   * <br>
   * w肳ꂽÕ\bhIuWFNgɑ݂Ȃꍇ͗OX[B
   *
   * @param  obj \bhsIuWFNgB
   * @param  methodName s郁\bhB
   * @param  argTypes \bhɓň^B
   * @param  argValues \bhɓn̒lB
   * @return sꂽ\bh̖߂lB
   * @throws NoSuchMethodException w肳ꂽÕ\bh݂ȂꍇB
   * @throws Exception \bh̎sɗOꍇB
   * @throws AssertionError k̏ꍇǍ͈^ƒl̐Ȃ
   *           ꍇifobO[ĥ݁jB
   */
  public Object invokeMethod(
    Object obj, String methodName, Class[] argTypes, Object... argValues
  ) throws NoSuchMethodException, Exception
  {
    assert (obj != null) : "@param;obj is null.";
    assert (methodName != null) : "@param:methodName is null.";
    assert (argTypes != null) : "@param;argTypes is null.";
    assert (argValues != null) : "@param;argValues is null.";
    assert (argTypes.length == argValues.length) :
      "Both numbers of @param:argTypes and @param:argValues are different.";
    assert(! Arrays.asList(argTypes).contains(null)) :
      "@param:argTypes has null elements.";

    Class cls = obj.getClass();
    Method method = null;
    do {
      try {
        method = cls.getDeclaredMethod(methodName, argTypes);
        method.setAccessible(true);
        break;
      }
      catch (NoSuchMethodException e) {
        cls = cls.getSuperclass();
      }
    }
    while (cls != null && !cls.equals(Object.class));

    if (method == null) {
      throw new NoSuchMethodException(methodName);
    }

    try {
      Object ret = method.invoke(obj, argValues);
      if (method.getReturnType().equals(Void.TYPE)) {
        ret = Void.TYPE;
      }

      return ret;
    }
    catch (InvocationTargetException e) {
      Throwable t = e.getTargetException();
      if (t instanceof Exception) {
        throw (Exception) t;
      }
      else if (t instanceof Error) {
        throw (Error) t;
      }
      else {
        throw e;
      }
    }
  }

  /**
   * w肳ꂽIuWFNg̃\bhsB
   * <br>
   * \bh̃ANZXwqɊւ炸Ã\bhsĖ߂lԂB
   * \bḧ́A^yђlꂼꏇԂɃXgIuWFNgɊi[
   * w肷B
   * <br>
   * \bh̖߂l{f[^^̏ꍇ́AΉ郉bvNXɒli[
   * ĕԂB
   * ߂lȂ(<code>void</code>^)̏ꍇ́A{@link java.lang.Void#TYPE 
   * Void.TYPE}ԂB
   * <br>
   * w肳ꂽÕ\bhIuWFNgɑ݂Ȃꍇ͗OX[B
   *
   * @param  obj \bhsIuWFNgB
   * @param  methodName s郁\bhB
   * @param  argTypes \bhɓň^B
   * @param  argValues \bhɓn̒lB
   * @return sꂽ\bh̖߂lB
   * @throws NoSuchMethodException w肳ꂽÕ\bh݂ȂꍇB
   * @throws Exception \bh̎sɗOꍇB
   * @throws AssertionError k̏ꍇǍ͈^ƒl̐Ȃ
   *           ꍇifobO[ĥ݁jB
   */
  public Object invokeMethod(
    Object obj, String methodName, List<Class> argTypes, Object... argValues
  ) throws NoSuchMethodException, Exception
  {
    assert (argTypes != null) : "@param:argTypes is null.";

    Class[] types = argTypes.toArray(new Class[ argTypes.size() ]);
    return invokeMethod(obj, methodName, types, argValues);
  }
}
