/*
 * FunctionTester class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.coverage;

import ts.tester.Tester;
import ts.tester.function.ResultType;
import ts.tester.function.Result;
import ts.tester.function.CaseResult;
import ts.tester.function.CheckResult;
import ts.tester.function.print.Printer;
import ts.tester.function.print.AbstractPrinter;
import ts.tester.function.print.ConsolePrinter;
import ts.tester.coverage.Coverage;
import ts.tester.coverage.CoveragePrinter;
import ts.tester.coverage.LineCoverage;
import java.lang.reflect.Constructor;

/**
 * sJobWvs@\sNXB 
 *
 * @author  V. 
 * @version $Revision: 1.3 $, $Date: 2007/05/07 15:20:00 $
 * @see ts.tester.function.FunctionTester
 */
public class FunctionTester extends ts.tester.function.FunctionTester
{
  /** JobWv̑ΏۂƂȂNXB */
  private static Class targetClass_ = null;

  /** JobWvsNXB */
  private static Class<? extends Coverage> coverageClass_ = LineCoverage.class;

  /**
   * JobWvIuWFNgĂ΂郁C֐B
   *
   * @param  args R}hCB
   */
  public static void main(String[] args)
  {
    try {
      ts.tester.function.FunctionTester.setPrinter(new _Printer());

      Class<?> cls = Class.forName(args[0]);
      Tester tester = Tester.class.cast(cls.newInstance());
      String arg = (args.length > 1) ? args[1] : null;
      ts.tester.function.FunctionTester.run(tester, arg);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * JobWv̑ΏۂƂȂNXݒ肷B
   * <br>
   * Ƀkw肵ꍇ́A
   * {@link ts.tester.function.coverage.FunctionTester#run(java.lang.Class,
   * java.lang.String) run}\bhɓnꂽNXA
   * <code>"Test"</code>ÕNXJobWv̑ΏۂƂB
   * ANX̖<code>"Test"</code>łȂꍇ́ANX
   * ̂̂ΏۂƂȂB
   *
   * @param  c JobWv̑ΏۂƂȂNXB
   */
  public static void setTargetClass(Class<?> c)
  {
    targetClass_ = c;
  }

  /**
   * ftHgRXgN^B
   */
  public FunctionTester()
  {}

  /**
   * w肳ꂽsIuWFNg̎P[XAJobWvt
   * sB
   *
   * @param  testerClass sNXB
   * @param  methodName s鎎P[X\bhB
   * @throws NoSuchMethodException w肳ꂽÖȂE߂lȂ
   *           \bh݂ȂꍇB
   * @throws IllegalAccessException w肳ꂽÕ\bh̃ANZXwq
   *           pubNłȂꍇB
   * @throws Exception \bhsɗOX[ꂽꍇB
   * @throws AssertionError sNXk̏ꍇifobO[ĥ݁jB
   */
  public static void run(Class<? extends Tester> testerClass, String methodName)
    throws NoSuchMethodException, IllegalAccessException, Exception
  {
    assert (testerClass != null) : "@param:testerClass is null.";

    StringBuffer buf = new StringBuffer();
    buf.append(testerClass.getName());
    if (methodName != null) {
      buf.append(" ");
      buf.append(methodName);
    }
    String cmdArgs = buf.toString();
    Class<? extends Tester> ftc = FunctionTester.class;

    String targetName;
    if (targetClass_ != null) {
      targetName = targetClass_.getName() ;
    }
    else {
      targetName = testerClass.getName();
      if (targetName.endsWith("Test")) {
        targetName = targetName.substring(0, targetName.length() - 4);
      }
    }

    Constructor con = coverageClass_.getConstructor(Class.class, String.class);
    Coverage coverage = (Coverage) con.newInstance(ftc, cmdArgs);
    coverage.setVMOptions("-enableassertions");
    coverage.setClassFilterType(Coverage.FilterType.DENY_ALLOW_DENY);
    coverage.addTargetClassPattern(targetName);
    coverage.addTargetClassPattern(targetName + "$*");
    coverage.addClassPath(System.getProperty("java.class.path"));

    Printer printer = getSpecifiedOrDefaultPrinter();
    coverage.setObjectWriter(new _PrintEventWriter(printer));

    if (printer instanceof CoveragePrinter) {
      coverage.setPrinter((CoveragePrinter) printer);
    }

    coverage.run();
  }
}

