/*
 * CheckResult class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function;

import ts.tester.util.ObjectSerializer;
import java.io.Serializable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.IOException;

/**
 * 茋ʂi[NXB
 * <br>
 * {@link ts.tester.function.Result Result}NXpĂB
 * P[X̌X̔茋ʂێB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:49 $
 */
public class CheckResult extends Result implements Serializable
{
  /** VAԍB */
  static final long serialVersionUID = -9139232646213087026L;

  /** Ғl͌ʒlɒlݒ肳ĂȂƂIuWFNgB*/
  public final static transient Object UNSET = new Unset();

  /** Ғl͌ʒl݂ȂƂIuWFNgB*/
  public final static transient Object NODATA = new Nodata();

  /** ʂ̃^CvB */
  private ResultType type_ = ResultType.OK;

  /** 茋ʂɑ΂郁bZ[WB */
  private String message_ = "";

  /** ҒlB */
  private transient Object expectValue_ = UNSET;

  /** lB */
  private transient Object resultValue_ = UNSET;

  /** 肪sꂽt@CB */
  private String fileName_ = "";

  /** 肪sꂽsԍB */
  private int lineNumber_ = 1;

  /**
   * ftHgRXgN^B
   * <br>
   * ANZXwq protected ƂāÃ\bh炵CX^X
   * 𐶐łȂ悤ɂĂB
   */
  protected CheckResult()
  {}

  /**
   * 茋ʂɂĂ̖̂ɂƂRXgN^B
   *
   * @param  name 茋ʂɂẮ̖B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public CheckResult(String name)
  {
    setName(name);
  }

  /**
   * w肳ꂽʃ^Cv̌ʐ擾B
   *
   * @param  type ʃ^CvB
   * @return ʐB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  @Override public int count(ResultType type)
  {
    assert (type != null) : "@param:type is null.";

    return is(type) ? 1 : 0;
  }

  /**
   * ̃IuWFNg̔茋ʂAw肳ꂽʃ^CvƓǂԂB
   *
   * @param  type ʃ^CvB
   * @return ̃IuWFNg̔茋ʂw肳ꂽʃ^CvƓꍇ
   *           <tt>true</tt>ԂB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public boolean is(ResultType type)
  {
    assert (type != null) : "@param:type is null.";

    return (type_.equals(type)) ? true : false;
  }

  /**
   * bZ[Wݒ肷B
   *
   * @param  message bZ[WB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void setMessage(String message)
  {
    assert (message != null) : "@param:message is null.";

    message_ = message;
  }

  /**
   * 莞Ɉꏏɐݒ肳ꂽbZ[W擾B
   *
   * @return  bZ[WB
   */
  public String getMessage() 
  {
    return message_;
  }

  /**
   * lݒ肷B
   *
   * @param  value lB
   * @throws AssertionError {@link ts.tester.function.CheckResult#UNSET
   *           CheckResult.UNSET}ꍇifobO[ĥ݁jB
   */
  public void setResultValue(Object value)
  {
    assert (value != UNSET) : "@param:value is not allowed to set UNSET.";

    resultValue_ = value;
  }

  /**
   * l擾B
   *
   * @return lB
   */
  public Object getResultValue()
  {
    return resultValue_ ;
  }
  
  /**
   * Ғlݒ肷B
   *
   * @param  value ҒlB
   * @throws AssertionError {@link ts.tester.function.CheckResult#UNSET
   *           CheckResult.UNSET}ꍇifobO[ĥ݁jB
   */
  public void setExpectValue(Object value)
  {
    assert (value != UNSET) : "@param:value is not allowed to set UNSET.";

    expectValue_ = value;
  }

  /**
   * Ғl擾B
   * 
   * @return ҒlB
   */
  public Object getExpectValue()
  {
    return expectValue_ ;
  }

  /**
   * 肪sꂽsNX̃\[Xt@C擾B
   *
   * @return 肪sꂽt@CB
   */
  public String getFileName()
  {
    return fileName_ ;
  }

  /**
   * 肪sꂽsNX̃\[Xt@Cł̍sԍ擾B
   *
   * @return 肪sꂽsԍB
   */
  public int getLineNumber()
  {
    return lineNumber_ ;
  }

  /**
   * 肪sꂽsNX̃t@Cƍsԍ߂B
   *
   * @param  testerClass sNXB
   * @param  methodName P[X\bhB
   * @throws AssertionException k̏ꍇB
   */
  final void obtainFilePosition(
    Class<? extends FunctionTester> testerClass, String methodName)
  {
    assert (testerClass != null) : "@param:testerClass is null.";
    assert (methodName != null) : "@param:methodName is null.";

    fileName_ = "";
    lineNumber_ = 1;

    try {
      throw new Throwable();
    }
    catch (Throwable t) {
      try {
        StackTraceElement[] ste = t.getStackTrace();
        for (int i=0; i<ste.length; i++) {
          if (! ste[i].getClassName().equals(testerClass.getName())) {
            continue;
          }

          if (! ste[i].getMethodName().equals(methodName)) {
            continue;
          }

          fileName_ = ste[i].getFileName();
          lineNumber_ = ste[i].getLineNumber();
          break;
        }
      }
      catch (Throwable t2) {}
    }
  }

  /**
   * 茋ʂił邱Ƃ
   * {@link ts.tester.function.CheckResult CheckResult}IuWFNg쐬B
   *
   * @return {@link ts.tester.function.CheckResult CheckResult}IuWFNgB
   */
  public static CheckResult OK()
  {
    return new CheckResult();
  }

  /**
   * 茋ʂił邱Ƃ
   * {@link ts.tester.function.CheckResult CheckResult}IuWFNg쐬B
   * <br>
   * ɔ茋ʂɂĂ̖̂ݒ肷B
   *
   * @param  name 茋ʂɂẮ̖B
   * @return {@link ts.tester.function.CheckResult CheckResult}IuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static CheckResult OK(String name)
  {
    return new CheckResult(name);
  }

  /**
   * 茋ʂsił邱Ƃ
   * {@link ts.tester.function.CheckResult CheckResult}IuWFNg쐬B
   *
   * @return {@link ts.tester.function.CheckResult CheckResult}IuWFNgB
   */
  public static CheckResult NG()
  {
    CheckResult r = new CheckResult();
    r.type_ = ResultType.NG;
    return r;
  }

  /**
   * 茋ʂsił邱Ƃ
   * {@link ts.tester.function.CheckResult CheckResult}IuWFNg쐬B
   * <br>
   * ɔ茋ʂɂĂ̖̂ݒ肷B
   *
   * @param  name 茋ʂɂẮ̖B
   * @return {@link ts.tester.function.CheckResult CheckResult}IuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static CheckResult NG(String name)
  {
    CheckResult r = new CheckResult(name);
    r.type_ = ResultType.NG;
    return r;
  }

  /**
   * 茋ʂmsł邱Ƃ
   * {@link ts.tester.function.CheckResult CheckResult}IuWFNgB
   *
   * @return {@link ts.tester.function.CheckResult CheckResult}IuWFNgB
   */
  public static CheckResult KnownBug()
  {
    CheckResult r = new CheckResult();
    r.type_ = ResultType.KnownBug;
    return r;
  }

  /**
   * 茋ʂmsł邱Ƃ
   * {@link ts.tester.function.CheckResult CheckResult}IuWFNgB
   * <br>
   * ɔ茋ʂɂĂ̖̂ݒ肷B
   *
   * @param  name 茋ʂɂẮ̖B
   * @return {@link ts.tester.function.CheckResult CheckResult}IuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static CheckResult KnownBug(String name)
  {
    CheckResult r = new CheckResult(name);
    r.type_ = ResultType.KnownBug;
    return r;
  }

  /**
   * P[X\bhł邱Ƃ
   * {@link ts.tester.function.CheckResult CheckResult}IuWFNg쐬B
   *
   * @return {@link ts.tester.function.CheckResult CheckResult}IuWFNgB
   */
  public static CheckResult Empty()
  {
    CheckResult r = new CheckResult();
    r.type_ = ResultType.Empty;
    return r;
  }

  /**
   * P[X\bhrł邱Ƃ
   * {@link ts.tester.function.CheckResult CheckResult}IuWFNg쐬B
   *
   * @return {@link ts.tester.function.CheckResult CheckResult}IuWFNgB
   */
  public static CheckResult Incomplete()
  {
    CheckResult r = new CheckResult();
    r.type_ = ResultType.Incomplete;
    return r;
  }

  /**
   * Ғl⌋ʒlVACYăXg[ɏo͂B
   * <br>
   * ̃IuWFNgVACYłȂꍇ́A̕lVACY
   * ĕԂB
   *
   * @param  out o͐̃Xg[B
   * @param  value VACYIuWFNgB
   * @throws IOException ɓo̓G[ꍇB
   */
  protected void writeValue(ObjectOutputStream out, Object value)
    throws IOException
  {
    if (value instanceof Unset) {
      out.writeObject(new Unset());
      return;
    }
    else if (value instanceof Nodata) {
      out.writeObject(new Nodata());
      return;
    }
    else if (value == null) {
      out.writeObject(null);
      return;
    }
    else {
      out.writeObject(String.valueOf(value));
      return;
    }
  }

  /**
   * ̃IuWFNg̏ԂXg[ɏށB
   *
   * @param  out IuWFNgރXg[B
   * @throws IOException ɗOꍇB
   */
  private void writeObject(ObjectOutputStream out) throws IOException
  {
    out.defaultWriteObject();
    writeValue(out, expectValue_);
    writeValue(out, resultValue_);
  }

  /**
   * ̃NX̃IuWFNgXg[畜B
   *
   * @param  in IuWFNgǂݍރXg[B
   * @throws IOException ɗOꍇB
   */
  private void readObject(ObjectInputStream in)
    throws IOException, ClassNotFoundException
  {
    in.defaultReadObject();

    Object o1 = in.readObject();
    if (o1 instanceof Unset) {
      expectValue_ = UNSET;
    }
    else if (o1 instanceof Nodata) {
      expectValue_ = NODATA;
    }
    else {
      expectValue_ = o1;
    }

    Object o2 = in.readObject();
    if (o2 instanceof Unset) {
      resultValue_ = UNSET;
    }
    else if (o2 instanceof Nodata) {
      resultValue_ = NODATA;
    }
    else {
      resultValue_ = o2;
    }
  }

  /* -- inner class  -- */

  /** 
   * Ғl͌ʒlɒlݒ肳ĂȂƂIuWFNgB
   */
  static final class Unset implements Serializable
  {
    /** VAԍB */
    static final long serialVersionUID = 2099622104584147518L;

    /**
     * ̃IuWFNg̓e\擾B
     *
     * @return ̃IuWFNg̓e\B
     */
    public String toString()
    {
      return "(unset)";
    }
  }

  /** 
   * Ғl͌ʒlɒlݒ肳ĂȂƂNXB
   * <br>
   * RNVIuWFNg̔rňɗvf݂ȂꍇȂǂɎgp
   * B
   */
  static final class Nodata implements Serializable
  {
    /** VAԍB */
    static final long serialVersionUID = -8631151308995972485L;

    /**
     * ̃IuWFNg̓e\擾B
     *
     * @return ̃IuWFNg̓e\B
     */
    public String toString()
    {
      return "(none)";
    }
  }
}
