/*
 * FileOperationTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.ObjectInspector;
import ts.tester.function.print.*;
import java.io.*;

/**
 * {@link ts.util.file.FileOperation FileOperation}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.3 $, $Date: 2007/05/27 16:13:11 $
 */
public class FileOperationTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);
      run(FileOperationTest.class, (args.length > 0) ? args[0] : null);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("FileOperation NX̋@\sB");

    addPart(new FileOperation00EtcTest());
    addPart(new FileOperation01TempTest());
    addPart(new FileOperation02InnerTest());
    addPart(new FileOperation03ListTest());
    addPart(new FileOperation04DeleteTest());
    addPart(new FileOperation05CopyTest());
    addPart(new FileOperation06MoveTest());
  }


  private static Process lockProcess_ = null;
  private static Thread outThread_ = null;

  static void lockFile(String mode, File lockedFile)
    throws Exception
  {
    File lockCtlFile = new File("test/data/lk");
    try {
      lockCtlFile.createNewFile();
    } catch (Exception e) {
      e.printStackTrace();
    }

    lockProcess_ = Runtime.getRuntime().exec(
      "java -classpath test ts.util.file.FileOperation__FileLockTest " +
      mode + " " + lockedFile.getPath() + " " + lockCtlFile);

    outThread_ = new Thread() {
      public void run() {
        BufferedReader br = null;
        try {
          br = new BufferedReader(
            new InputStreamReader(lockProcess_.getInputStream()));

          String line = null;
          while ((line = br.readLine()) != null) {
            System.out.println(line);
            System.out.flush();
          }
        } catch (Exception e) {
          e.printStackTrace();
        } finally {
          if (br != null) try { br.close(); } catch (Exception e) {}
        }
      }
    };
    outThread_.start();
  }

  static void releaseLock()
  {
    File lockCtlFile = new File("test/data/lk");

    try {
      lockCtlFile.delete();
      lockProcess_.waitFor();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
}

