/*
 * Decompiled with CFR 0.152.
 */
package ts.tester.coverage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import ts.tester.coverage.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseResult<K>
extends Result<K> {
    private Result<K> parentResult_;
    private Set<K> keySet_ = new TreeSet<K>();

    public CaseResult(Result<K> result) {
        assert (result != null) : "@param:result is null.";
        this.parentResult_ = result;
    }

    @Override
    public void addResult(K k) {
        this.parentResult_.addResult(k);
        this.keySet_.add(k);
    }

    @Override
    public int countAllResults() {
        return this.keySet_.size();
    }

    @Override
    public int countPassedResults() {
        int n = 0;
        for (K k : this.keySet_) {
            if (this.parentResult_.getPassCountOfResult(k) <= 0) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void incrementPassCountOfResult(K k) {
        assert (k != null) : "@param:resultKey is null.";
        this.parentResult_.incrementPassCountOfResult(k);
    }

    @Override
    public boolean containsKeyOfResult(K k) {
        return this.parentResult_.containsKeyOfResult(k);
    }

    @Override
    public int getPassCountOfResult(K k) {
        return this.parentResult_.getPassCountOfResult(k);
    }

    @Override
    public Enumeration<K> enumAllResultKeys() {
        return Collections.enumeration(this.keySet_);
    }

    @Override
    public Enumeration<K> enumPassedResultKeys() {
        ArrayList<K> arrayList = new ArrayList<K>(this.keySet_.size());
        for (K k : this.keySet_) {
            if (this.parentResult_.getPassCountOfResult(k) <= 0) continue;
            arrayList.add(k);
        }
        return Collections.enumeration(arrayList);
    }

    @Override
    public Enumeration<K> enumNotPassedResultKeys() {
        ArrayList<K> arrayList = new ArrayList<K>(this.keySet_.size());
        for (K k : this.keySet_) {
            if (this.parentResult_.getPassCountOfResult(k) > 0) continue;
            arrayList.add(k);
        }
        return Collections.enumeration(arrayList);
    }
}

