/*
 * Decompiled with CFR 0.152.
 */
package ts.tester.function.print;

import java.io.PrintWriter;
import ts.tester.function.CaseResult;
import ts.tester.function.CheckResult;
import ts.tester.function.Result;
import ts.tester.function.ResultType;
import ts.tester.function.print.AbstractPrinter;

public class ConsolePrinterBase
extends AbstractPrinter {
    private PrintWriter writer_;

    public ConsolePrinterBase() {
        this.writer_ = new PrintWriter(System.out);
    }

    public ConsolePrinterBase(PrintWriter printWriter) {
        assert (printWriter != null) : "@param:writer is null";
        this.writer_ = printWriter;
    }

    protected PrintWriter writer() {
        return this.writer_;
    }

    public CaseResult createCaseResult(String string, CaseResult caseResult) {
        return new _CaseResult(string, caseResult);
    }

    public void testStarted(CaseResult caseResult) {
        assert (caseResult != null) : "@param:root is null.";
        assert (caseResult instanceof _CaseResult) : "@param:root is an instance of unsupported CaseResult class.";
        _CaseResult _CaseResult2 = (_CaseResult)caseResult;
        _CaseResult2.printAsTestStarted();
    }

    public void testEnded(CaseResult caseResult) {
        assert (caseResult != null) : "@param:root is null.";
        assert (caseResult instanceof _CaseResult) : "@param:root is an instance of unsupported CaseResult class.";
        _CaseResult _CaseResult2 = (_CaseResult)caseResult;
        _CaseResult2.printAsTestEnded();
    }

    public void caseStarted(CaseResult caseResult) {
        assert (caseResult != null) : "@param:current is null.";
        assert (caseResult instanceof _CaseResult) : "@param:current is an instance of unsupported CaseResult class.";
        _CaseResult _CaseResult2 = (_CaseResult)caseResult;
        _CaseResult2.printAsCaseStarted();
    }

    public void caseEnded(CaseResult caseResult) {
        assert (caseResult != null) : "@param:current is null.";
        assert (caseResult instanceof _CaseResult) : "@param:current is an instance of unsupported CaseResult class.";
        _CaseResult _CaseResult2 = (_CaseResult)caseResult;
        _CaseResult2.printAsCaseEnded();
    }

    public void checkOccured(CheckResult checkResult, CaseResult caseResult) {
        assert (checkResult != null) : "@param:check is null.";
        assert (caseResult != null) : "@param:current is null.";
        assert (caseResult instanceof _CaseResult) : "@param:current is an instance of unsupported CaseResult class.";
        _CaseResult _CaseResult2 = (_CaseResult)caseResult;
        _CaseResult2.printCheck(checkResult);
    }

    public void messageNoted(String string, CaseResult caseResult) {
        assert (string != null) : "@param:message is null.";
        assert (caseResult != null) : "@param:current is null.";
        assert (caseResult instanceof _CaseResult) : "@param:current is an instance of unsupported CaseResult class.";
        _CaseResult _CaseResult2 = (_CaseResult)caseResult;
        _CaseResult2.printMessage(string);
    }

    private class _CaseResult
    extends CaseResult {
        private int level_;
        private int[] countByResultType_;

        _CaseResult(String string, CaseResult caseResult) {
            super(string, caseResult);
            this.countByResultType_ = new int[ResultType.values().length];
            this.level_ = caseResult instanceof _CaseResult ? ((_CaseResult)caseResult).getLevel() + 1 : 0;
        }

        private int getLevel() {
            return this.level_;
        }

        public int count(ResultType resultType) {
            assert (resultType != null) : "@param:type is null.";
            return this.countByResultType_[resultType.ordinal()];
        }

        public void addChildResult(Result result) {
            assert (result != null) : "@param:result is null.";
            for (ResultType resultType : ResultType.values()) {
                int n = resultType.ordinal();
                this.countByResultType_[n] = this.countByResultType_[n] + result.count(resultType);
            }
        }

        private void printAsTestStarted() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getLevel() > 0) {
                for (int i = 1; i < this.getLevel(); ++i) {
                    stringBuffer.append("\uff5c ");
                }
                stringBuffer.append("\u251c ");
            }
            stringBuffer.append(this.getName());
            ConsolePrinterBase.this.writer().println(stringBuffer.toString());
            ConsolePrinterBase.this.writer().flush();
        }

        private void printAsTestEnded() {
            int n = this.count(ResultType.NG);
            int n2 = this.count(ResultType.KnownBug);
            int n3 = this.count(ResultType.Empty);
            int n4 = this.count(ResultType.Incomplete);
            if (n > 0) {
                ConsolePrinterBase.this.writer().println("xxxxxxxxxx " + n + " NGs exist. xxxxxxxxxx");
                ConsolePrinterBase.this.writer().println("(T_T)(T_T)(T_T)(T_T)(T_T)(T_T)(T_T)");
            } else {
                ConsolePrinterBase.this.writer().println("=============== OK! ===============");
                ConsolePrinterBase.this.writer().println("(^o^)(^o^)(^o^)(^o^)(^o^)(^o^)(^o^)");
            }
            if (n2 > 0) {
                ConsolePrinterBase.this.writer().println("... and " + n2 + " known bugs exist.");
            }
            if (n3 > 0) {
                ConsolePrinterBase.this.writer().println("... and " + n3 + " empty cases exist.");
            }
            if (n4 > 0) {
                ConsolePrinterBase.this.writer().println("... and " + n4 + " incomplete cases exist.");
            }
            ConsolePrinterBase.this.writer().flush();
        }

        private void printAsCaseStarted() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getLevel() > 0) {
                for (int i = 1; i < this.getLevel(); ++i) {
                    stringBuffer.append("\u2502 ");
                }
                stringBuffer.append("\u251c ");
            }
            stringBuffer.append(this.getName());
            ConsolePrinterBase.this.writer().println(stringBuffer.toString());
            ConsolePrinterBase.this.writer().flush();
        }

        private void printAsCaseEnded() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getLevel() > 0) {
                for (int i = 1; i < this.getLevel(); ++i) {
                    stringBuffer.append("\u2502 ");
                }
                stringBuffer.append("\u2502 ");
            }
            stringBuffer.append("\u2514\u2500< ");
            if (this.count(ResultType.Empty) > 0) {
                stringBuffer.append("*EMPTY*");
            } else {
                stringBuffer.append("NG:").append(this.count(ResultType.NG));
                stringBuffer.append(", Known bug:").append(this.count(ResultType.KnownBug));
                if (this.count(ResultType.Incomplete) > 0) {
                    stringBuffer.append(", *INCOMPLETE*");
                }
            }
            stringBuffer.append(" >");
            ConsolePrinterBase.this.writer().println(stringBuffer.toString());
            ConsolePrinterBase.this.writer().flush();
        }

        private void printCheck(CheckResult checkResult) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.getLevel(); ++i) {
                stringBuffer.append("\u2502 ");
            }
            stringBuffer.append("\u251c ");
            if (checkResult.getName().equals("Match")) {
                stringBuffer.append("match: ").append(checkResult.getResultValue());
            } else {
                if (checkResult.getName().length() > 0) {
                    stringBuffer.append(checkResult.getName()).append(" ");
                }
                if (checkResult.getResultValue() != CheckResult.UNSET) {
                    if (checkResult.getExpectValue() == CheckResult.UNSET) {
                        stringBuffer.append("result: ").append(checkResult.getResultValue());
                    } else {
                        stringBuffer.append("result: ").append(checkResult.getResultValue());
                        stringBuffer.append(" / expect: ").append(checkResult.getExpectValue());
                    }
                }
            }
            if (checkResult.is(ResultType.NG)) {
                stringBuffer.append(" ... NG");
                stringBuffer.append(" (line:").append(checkResult.getLineNumber()).append(")");
            } else if (checkResult.is(ResultType.KnownBug)) {
                stringBuffer.append(" ... known bug");
                stringBuffer.append(" (line:").append(checkResult.getLineNumber()).append(")");
            } else if (checkResult.is(ResultType.Incomplete)) {
                stringBuffer.append(" ... incomplete");
                stringBuffer.append(" (line:").append(checkResult.getLineNumber()).append(")");
            } else {
                if (checkResult.is(ResultType.Empty)) {
                    return;
                }
                stringBuffer.append(" ... OK");
            }
            if (checkResult.getMessage().length() > 0) {
                stringBuffer.append(" ").append(checkResult.getMessage());
            }
            ConsolePrinterBase.this.writer().println(stringBuffer.toString());
            ConsolePrinterBase.this.writer().flush();
        }

        private void printMessage(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.getLevel(); ++i) {
                stringBuffer.append("\u2502 ");
            }
            stringBuffer.append("\u251c ").append(string);
            ConsolePrinterBase.this.writer().println(stringBuffer.toString());
            ConsolePrinterBase.this.writer().flush();
        }
    }
}

