/*
 * LineCoverage class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.coverage;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.Method;
import com.sun.jdi.Location;
import com.sun.jdi.AbsentInformationException;
import java.util.Collection;
import java.util.List;
import java.util.LinkedList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.HashMap;
import java.util.TreeMap;

/**
 * sJobW̌vsNXB 
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:48 $
 */
public class LineCoverage extends Coverage
{
  /** \[Xt@C̃JobWʂi[}bvB */
  TreeMap<String, PassResult<Integer>> sourcePassMap_ =
    new TreeMap<String, PassResult<Integer>>();

  /** NX̃JobWʂi[}bvB */
  TreeMap<String, Result<Integer>> classPassMap_ =
    new TreeMap<String, Result<Integer>>();

  /** \bh̃JobWʂi[}bvB */
  Map<String, Map<MethodKey, Result<Integer>>> methodPassMap_ =
    new HashMap<String, Map<MethodKey, Result<Integer>>>();

  /**
   * sNXɂƂRXgN^B
   *
   * @param  execClass sNXB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public LineCoverage(Class<?> execClass)
  {
    super(execClass);

    setEventOfEntryMethodEnabled(false);
    setEventOfExitMethodEnabled(false);
  }

  /**
   * sNXƂ<code>main</code>֐ɓnR}hC
   * ɂƂRXgN^B
   *
   * @param  execClass sNXB
   * @param  commandArgs R}hCB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public LineCoverage(Class<?> execClass, String commandArgs)
  {
    super(execClass, commandArgs);

    setEventOfEntryMethodEnabled(false);
    setEventOfExitMethodEnabled(false);
  }

  /**
   * JobW̏ɂāA\[XR[h̊es̓o^s߂ɌĂ΂
   * \bhłB
   *
   * @param  location  \[XR[h̍sIuWFNgB
   */
  @Override protected void entryLine(Location location)
  {
    try {
      PassResult<Integer> passResult = getPassResult(location.sourcePath());

      ReferenceType type = location.declaringType();
      Method method = location.method();

      Result<Integer> classResult = getClassResult(type.name(), passResult);
      Result<Integer> methodResult = getMethodResult(method, classResult);

      methodResult.addResult(location.lineNumber());
    }
    catch (AbsentInformationException e) {}
  }

  /**
   * w肳ꂽ\bhEL[ɑΉ郁\bh
   * {@link ts.tester.coverage.CaseResult CaseResult}IuWFNg擾B
   * <br>
   * Ή{@link ts.tester.coverage.CaseResult CaseResult}IuWFNg
   * o^ĂȂꍇ́AVɓo^ĕԂB
   *
   * @param methodKey \bhEL[B
   * @param parent eƂȂJobWʃIuWFNgB
   * @return {@link ts.tester.coverage.CaseResult CaseResult}IuWFNgB
   */
  public Result<Integer> getMethodResult(
    MethodKey methodKey, Result<Integer> parent)
  {
    String className = methodKey.getClassName();

    Map<MethodKey, Result<Integer>> map = methodPassMap_.get(className);
    if (map == null) {
      map = new HashMap<MethodKey, Result<Integer>>();
      methodPassMap_.put(className, map);
    }

    Result<Integer> methodResult = map.get(methodKey);
    if (methodResult == null) {
      methodResult = new CaseResult<Integer>(parent);
      map.put(methodKey, methodResult);
    }

    return methodResult;
  }

  /**
   * w肳ꂽ\bhɑΉtꂽ{@link ts.tester.coverage.CaseResult 
   * CaseResult}IuWFNg擾B
   * <br>
   * Ή{@link ts.tester.coverage.CaseResult CaseResult}IuWFNg
   * o^ĂȂꍇ́AVɓo^ĕԂB
   *
   * @param method \bhB
   * @param parent eƂȂJobWʃIuWFNgB
   * @return {@link ts.tester.coverage.CaseResult CaseResult}IuWFNgB
   */
  public Result<Integer> getMethodResult(Method method, Result<Integer> parent)
  {
    String className = method.declaringType().name();
    String methodName = method.name();

    List<String> lst = method.argumentTypeNames();
    StringBuffer buf = new StringBuffer();
    Iterator<String> it = lst.iterator();
    if (it.hasNext()) {
      buf.append(it.next());
      while (it.hasNext()) {
        buf.append(",").append(it.next());
      }
    }

    MethodKey key = new MethodKey(className, methodName, buf.toString());
    return getMethodResult(key, parent);
  }

  /**
   * NX{@link ts.tester.coverage.CaseResult CaseResult}IuWFNg
   * 擾B
   * <br>
   * w肳ꂽNXɑΉtꂽ{@link ts.tester.coverage.CaseResult
   * CaseResult}IuWFNgo^ĂȂꍇ́AVɓo^ĕԂB
   *
   * @param className NXB
   * @param parent eƂȂJobWʃIuWFNgB
   * @return {@link ts.tester.coverage.CaseResult CaseResult}IuWFNgB
   */
  public Result<Integer> getClassResult(
    String className, Result<Integer> parent)
  {
    Result<Integer> classResult = classPassMap_.get(className);
    if (classResult == null) {
      classResult = new CaseResult<Integer>(parent);
      classPassMap_.put(className, classResult);
    }
    return classResult;
  }

  /**
   * \[Xt@CpX{@link ts.tester.coverage.PassResult PassResult}
   * IuWFNg擾B
   * <br>
   * w肳ꂽ\[Xt@CpXɑΉtꂽ
   * {@link ts.tester.coverage.PassResult PassResult}
   * IuWFNgo^ĂȂꍇ́AVɓo^ĕԂB
   *
   * @param  srcPath \[Xt@CpXB
   * @return {@link ts.tester.coverage.PassResult PassResult}IuWFNgB
   */
  public PassResult<Integer> getPassResult(String srcPath)
  {
    PassResult<Integer> passResult = sourcePassMap_.get(srcPath);
    if (passResult == null) {
      passResult = new PassResult<Integer>();
      sourcePassMap_.put(srcPath, passResult);
    }
    return passResult;
  }

  /**
   * JobWvɂāA\[XR[h̊esʉ߂ۂɌĂ΂郁\bh
   * łB
   *
   * @param location  \[XR[h̍sIuWFNgB
   */
  @Override protected void passLine(Location location)
  {
    try {
      PassResult<Integer> passResult;
      passResult = sourcePassMap_.get(location.sourcePath());
      if (passResult != null) {
        passResult.incrementPassCountOfResult(location.lineNumber());
      }
    }
    catch (AbsentInformationException e) {}
  }

  /**
   * JobWvɂāANX̓o^ɌĂ΂郁\bhłB
   *
   * @param  refType o^ꂽNX̓C^[tFCXIuWFNgB
   */
  @Override protected void entryClass(ReferenceType refType)
  {}

  /** 
   * JobWvɂāA\bȟĂяoɌĂ΂郁\bhłB
   *
   * @param  method \bhB
   */
  @Override protected void entryMethod(Method method)
  {}

  /**
   * JobWvɂāA\bh̏IɌĂ΂郁\bhłB
   *
   * @param  method \bhB
   */
  @Override protected void exitMethod(Method method)
  {}

  /**
   * JobW̑ΏۂƂȂS\[Xt@C̃RNV擾B
   *
   * @return \[Xt@Ci[RNVB
   */
  @Override public Collection<String> allSourcePaths()
  {
    return sourcePassMap_.keySet();
  }

  /**
   * JobW̑ΏۂƂȂSNX̖ÕRNV擾B
   *
   * @return NXi[RNVB
   */
  @Override public Collection<String> allClassNames()
  {
    return classPassMap_.keySet();
  }

  /**
   * JobW̑ΏۂƂȂSẴ\bh̃Xg擾B
   *
   * @return  \bhIuWFNgi[郊XgB
   */
  @Override public Collection<MethodKey> methodKeysOf(String className)
  {
    Map<MethodKey, Result<Integer>> map = methodPassMap_.get(className);
    if (map != null) {
      return map.keySet();
    }
    else {
      return new ArrayList<MethodKey>(0);
    }
  }
}
