/*
 * FileOperation06MoveTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import ts.tester.function.FunctionTester;
import java.io.*;
import java.util.*;

/**
 * {@link ts.util.file.FileOperation06Move FileOperation06Move}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/05/27 16:13:11 $
 */
public class FileOperation06MoveTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      run(FileOperation06MoveTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  final File WORKDIR = new File("test/data/ts/util/file/FileOperation");
  File[] DIRS = new File[6];
  File[] FILES = new File[10];

  protected void preInvocation(String method)
  {
    WORKDIR.mkdirs();
    DIRS[0] = new File(WORKDIR, "DIRS0");
    DIRS[1] = new File(DIRS[0], "DIRS1");
    DIRS[2] = new File(DIRS[0], "DIRS2");
    DIRS[3] = new File(DIRS[1], "DIRS3");
    DIRS[4] = new File(DIRS[2], "DIRS4");
    DIRS[5] = new File(DIRS[2], "DIRS5");
    FILES[0] = new File(DIRS[0], "FILES0");
    FILES[1] = new File(DIRS[1], "FILES1");
    FILES[2] = new File(DIRS[2], "FILES2");
    FILES[3] = new File(DIRS[3], "FILES3");
    FILES[4] = new File(DIRS[4], "FILES4");
    FILES[5] = new File(DIRS[0], "FILES5");
    FILES[6] = new File(DIRS[1], "FILES6");
    FILES[7] = new File(DIRS[2], "FILES7");
    FILES[8] = new File(DIRS[3], "FILES8");
    FILES[9] = new File(DIRS[4], "FILES9");
    try {
      for (File d : DIRS) d.mkdirs();
      for (File f : FILES) f.createNewFile();
    } catch (Exception e) {}

    /*
       DIRS[0]
        +- DIRS[1]
          +- DIRS[3]
            +- FILES[3]
            +- FILES[8]
          +- FILES[1]
          +- FILES[6]
        +- DIRS[2]
          +- DIRS[4]
            +- FILES[4]
            +- FILES[9]
          +- DIRS[5]
          +- FILES[2]
          +- FILES[7]
        +- FILES[0]
        +- FILES[5]
    */
  }

  protected void postInvocation(String method)
  {
    try {
      FileOperation.deleteRecursive(WORKDIR);
    } catch (Exception e) {}
  }
  

  /* -- test case -- */

  public void move()
  {
    MSG("ʏ̃t@C𓯂fBNgɕʖňړꍇB");

    File src = FILES[4];
    File dst = new File(DIRS[4], "aaa");
    TRUE(src.exists());
    FALSE(dst.exists());

    try {
      FileOperation.move(src, dst);
    } catch (Exception e) {
      NG(e);
    }

    FALSE(src.exists());
    TRUE(dst.exists());
  }

  public void move_001()
  {
    MSG("ʏ̃t@Cʂ̃fBNgɈړꍇB");

    File src = FILES[3];
    File dst = new File(WORKDIR, "aaa/bbb/f3");

    TRUE(src.exists());
    FALSE(dst.exists());
    FALSE(dst.getParentFile().exists());

    try {
      FileOperation.move(src, dst);
    } catch (Exception e) {
      NG(e);
    }

    FALSE(src.exists());
    TRUE(dst.exists());
  }

  public void move_002()
  {
    MSG("̃fBNg𓯂fBNgɕʖňړꍇB");

    File src = DIRS[5];
    File dst = new File(DIRS[2], "sss");

    TRUE(src.exists());
    TRUE(src.isDirectory());
    TRUE(src.listFiles().length == 0);
    FALSE(dst.exists());

    try {
      FileOperation.move(src, dst);
    } catch (Exception e) {
      NG(e);
    }

    FALSE(src.exists());
    TRUE(dst.exists());
    TRUE(dst.isDirectory());
    TRUE(dst.listFiles().length == 0);
  }

  public void move_003()
  {
    MSG("̃fBNgʂ̃fBNgɈړꍇB");

    File src = DIRS[5];
    File dst = new File(DIRS[3], "f5");

    TRUE(src.exists());
    TRUE(src.isDirectory());
    TRUE(src.listFiles().length == 0);
    FALSE(dst.exists());

    try {
      FileOperation.move(src, dst);
    } catch (Exception e) {
      NG(e);
    }

    FALSE(src.exists());
    TRUE(dst.exists());
    TRUE(dst.isDirectory());
    TRUE(dst.listFiles().length == 0);
  }

  public void move_004()
  {
    MSG("łȂfBNgړꍇB");

    File src = DIRS[3];
    File dst = new File(DIRS[2], "xxx");

    TRUE(src.exists());
    TRUE(src.isDirectory());
    TRUE(src.listFiles().length > 0);
    FALSE(dst.exists());

    try {
      FileOperation.move(src, dst);
    } catch (Exception e) {
      NG(e);
    }

    FALSE(src.exists());
    TRUE(dst.exists());
    TRUE(dst.isDirectory());
    TRUE(dst.listFiles().length > 0);
  }

  public void move_005()
  {
    MSG("ړ̃t@Ciʏ̃t@Cjɑ݂ꍇB");

    File src = FILES[1];
    File dst = FILES[6];

    TRUE(src.exists());
    FALSE(src.isDirectory());
    TRUE(dst.exists());
    FALSE(dst.isDirectory());

    try {
      FileOperation.move(src, dst);
      NG();
    } catch (FileAlreadyExistsException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
      e.printStackTrace();
    }

    src = FILES[1];
    dst = FILES[2];

    TRUE(src.exists());
    FALSE(src.isDirectory());
    TRUE(dst.exists());
    FALSE(dst.isDirectory());

    try {
      FileOperation.move(src, dst);
      NG();
    } catch (FileAlreadyExistsException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    src = DIRS[5];
    dst = FILES[2];

    TRUE(src.exists());
    TRUE(src.isDirectory());
    TRUE(dst.exists());
    FALSE(dst.isDirectory());

    try {
      FileOperation.move(src, dst);
      NG();
    } catch (FileAlreadyExistsException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void move_006()
  {
    MSG("ړ̃t@CifBNgjɑ݂ꍇB");

    File src = DIRS[5];
    File dst = DIRS[3];

    TRUE(src.exists());
    TRUE(src.isDirectory());
    TRUE(dst.exists());
    TRUE(dst.isDirectory());

    try {
      FileOperation.move(src, dst);
      NG();
    } catch (FileAlreadyExistsException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    src = FILES[1];
    dst = DIRS[5];

    TRUE(src.exists());
    FALSE(src.isDirectory());
    TRUE(dst.exists());
    TRUE(dst.isDirectory());

    try {
      FileOperation.move(src, dst);
      NG();
    } catch (FileAlreadyExistsException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void move_007()
  {
    MSG("k̏ꍇB");

    File f = FILES[1];

    try {
      FileOperation.move(null, f);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      FileOperation.move(f, null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void move_008()
  {
    MSG("ړ̃t@CLbNĂꍇB");

    File src = FILES[1];
    File dst = new File(WORKDIR, "ffff");

    TRUE(src.exists());
    FALSE(src.isDirectory());
    FALSE(dst.exists());

    try {
      FileOperationTest.lockFile("shared", src);
      Thread.sleep(1000);
    } catch (Exception e) {
      NG(e);
    }

    try {
      FileOperation.move(src, dst);
      NG();
    } catch (IOException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    } finally {
      FileOperationTest.releaseLock();
    }

    TRUE(src.exists());
    FALSE(src.isDirectory());
    FALSE(dst.exists());
  }

  public void move_009()
  {
    MSG("ړ̃t@CrbNĂꍇB");

    File src = FILES[1];
    File dst = new File(WORKDIR, "ggggg");

    TRUE(src.exists());
    FALSE(src.isDirectory());
    FALSE(dst.exists());

    try {
      FileOperationTest.lockFile("exclusive", src);
      Thread.sleep(1000);
    } catch (Exception e) {
      NG(e);
    }

    try {
      FileOperation.move(src, dst);
      NG();
    } catch (IOException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    } finally {
      FileOperationTest.releaseLock();
    }

    TRUE(src.exists());
    FALSE(src.isDirectory());
    FALSE(dst.exists());
  }

  public void move_010()
  {
    MSG("ړ̃t@C݂ȂꍇB");

    File src = new File(WORKDIR, "aaa");
    File dst = new File(WORKDIR, "bbb");

    try {
      FileOperation.move(src, dst);
      NG();
    } catch (FileNotFoundException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void move_withFilter()
  {
    MSG("ʏ̃t@C𓯂fBNgɕʖňړꍇB");

    File src = FILES[4];
    File dst = new File(DIRS[4], "aaa");
    TRUE(src.exists());
    FALSE(dst.exists());

    FileFilter filterX = new FileTypeFilter(FileType.Directory);
    try {
      FileOperation.move(src, dst, filterX);
    } catch (Exception e) {
      NG(e);
    }

    src = FILES[4];
    dst = new File(DIRS[4], "aaa");
    TRUE(src.exists());
    FALSE(dst.exists());

    FileFilter filter = new FileTypeFilter(FileType.File);
    try {
      FileOperation.move(src, dst, filter);
    } catch (Exception e) {
      NG(e);
    }

    FALSE(src.exists());
    TRUE(dst.exists());
  }

  public void move_withFilter001()
  {
    MSG("ʏ̃t@Cʂ̃fBNgɈړꍇB");

    File src = FILES[3];
    File dst = new File(WORKDIR, "aaa/bbb/f3");

    TRUE(src.exists());
    FALSE(dst.exists());
    FALSE(dst.getParentFile().exists());

    FileFilter filter = new FileTypeFilter(FileType.File);
    try {
      FileOperation.move(src, dst, filter);
    } catch (Exception e) {
      NG(e);
    }

    FALSE(src.exists());
    TRUE(dst.exists());
  }

  public void move_withFilter002()
  {
    MSG("̃fBNg𓯂fBNgɕʖňړꍇB");

    File src = DIRS[5];
    File dst = new File(DIRS[2], "sss");

    TRUE(src.exists());
    TRUE(src.isDirectory());
    TRUE(src.listFiles().length == 0);
    FALSE(dst.exists());

    FileFilter filterX = new FileTypeFilter(FileType.File);
    try {
      FileOperation.move(src, dst, filterX);
    } catch (Exception e) {
      NG(e);
    }

    TRUE(src.exists());
    TRUE(src.isDirectory());
    TRUE(src.listFiles().length == 0);
    FALSE(dst.exists());

    FileFilter filter = new FileTypeFilter(FileType.Directory);
    try {
      FileOperation.move(src, dst, filter);
    } catch (Exception e) {
      NG(e);
    }

    FALSE(src.exists());
    TRUE(dst.exists());
    TRUE(dst.isDirectory());
    TRUE(dst.listFiles().length == 0);
  }

  public void move_withFilter003()
  {
    MSG("̃fBNgʂ̃fBNgɈړꍇB");

    File src = DIRS[5];
    File dst = new File(DIRS[3], "f5");

    TRUE(src.exists());
    TRUE(src.isDirectory());
    TRUE(src.listFiles().length == 0);
    FALSE(dst.exists());

    FileFilter filter = new FileTypeFilter(FileType.Directory);
    try {
      FileOperation.move(src, dst, filter);
    } catch (Exception e) {
      NG(e);
    }

    FALSE(src.exists());
    TRUE(dst.exists());
    TRUE(dst.isDirectory());
    TRUE(dst.listFiles().length == 0);
  }

  public void move_withFilter004()
  {
    MSG("łȂfBNgړꍇB");

    File src = DIRS[1];
    File dst = new File(DIRS[2], "xxx");

    TRUE(src.exists());
    TRUE(src.isDirectory());
    TRUE(src.listFiles().length > 0);
    FALSE(dst.exists());

    FileFilter filter = new FileTypeFilter(FileType.Directory);
    try {
      FileOperation.move(src, dst, filter);
    } catch (Exception e) {
      NG(e);
    }

    FALSE(src.exists());
    TRUE(dst.exists());
    TRUE(dst.isDirectory());
    TRUE(dst.listFiles().length > 0);
  }

  public void move_withFilter004a()
  {
    MSG("łȂfBNgړꍇB");

    File src = DIRS[2];
    File dst = new File(DIRS[1], "xxx");

    FALSE(dst.exists());

    FileFilter filter = new FileTypeFilter(FileType.File);
    try {
      FileOperation.move(src, dst, filter);
    } catch (Exception e) {
      NG(e);
    }

    FALSE(dst.exists());
  }

  public void move_withFilter005()
  {
    MSG("ړ̃t@Ciʏ̃t@Cjɑ݂ꍇB");

    File src = FILES[1];
    File dst = FILES[6];

    TRUE(src.exists());
    FALSE(src.isDirectory());
    TRUE(dst.exists());
    FALSE(dst.isDirectory());

    FileFilter filter = new FileTypeFilter(FileType.File);
    try {
      FileOperation.move(src, dst, filter);
      NG();
    } catch (FileAlreadyExistsException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
      e.printStackTrace();
    }

    src = FILES[1];
    dst = FILES[2];

    TRUE(src.exists());
    FALSE(src.isDirectory());
    TRUE(dst.exists());
    FALSE(dst.isDirectory());

    filter = new FileTypeFilter(FileType.File);
    try {
      FileOperation.move(src, dst, filter);
      NG();
    } catch (FileAlreadyExistsException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    src = DIRS[5];
    dst = FILES[2];

    TRUE(src.exists());
    TRUE(src.isDirectory());
    TRUE(dst.exists());
    FALSE(dst.isDirectory());

    filter = new FileTypeFilter(FileType.Directory);
    try {
      FileOperation.move(src, dst, filter);
      NG();
    } catch (FileAlreadyExistsException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void move_withFilter006()
  {
    MSG("ړ̃t@CifBNgjɑ݂ꍇB");

    File src = DIRS[5];
    File dst = DIRS[3];

    TRUE(src.exists());
    TRUE(src.isDirectory());
    TRUE(dst.exists());
    TRUE(dst.isDirectory());

    FileFilter filter = new FileTypeFilter(FileType.Directory);
    try {
      FileOperation.move(src, dst, filter);
      NG();
    } catch (FileAlreadyExistsException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    src = FILES[1];
    dst = DIRS[5];

    TRUE(src.exists());
    FALSE(src.isDirectory());
    TRUE(dst.exists());
    TRUE(dst.isDirectory());

    filter = new FileTypeFilter(FileType.File);
    try {
      FileOperation.move(src, dst, filter);
      NG();
    } catch (FileAlreadyExistsException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void move_withFilter007()
  {
    MSG("k̏ꍇB");

    File f = FILES[1];
    FileFilter filter = new FileTypeFilter(FileType.File);
    
    try {
      FileOperation.move(null, f, filter);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      FileOperation.move(f, null, filter);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      FileOperation.move(f, f, null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void move_withFilter008()
  {
    MSG("ړ̃t@CLbNĂꍇB");

    File src = FILES[1];
    File dst = new File(WORKDIR, "ffff");
    FileFilter filter = new FileTypeFilter(FileType.File);

    TRUE(src.exists());
    FALSE(src.isDirectory());
    FALSE(dst.exists());

    try {
      FileOperationTest.lockFile("shared", src);
      Thread.sleep(1000);
    } catch (Exception e) {
      NG(e);
    }

    try {
      FileOperation.move(src, dst, filter);
      NG();
    } catch (IOException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    } finally {
      FileOperationTest.releaseLock();
    }

    TRUE(src.exists());
    FALSE(src.isDirectory());
    FALSE(dst.exists());
  }

  public void move_withFilter009()
  {
    MSG("ړ̃t@CrbNĂꍇB");

    File src = FILES[1];
    File dst = new File(WORKDIR, "ggggg");
    FileFilter filter = new FileTypeFilter(FileType.File);

    TRUE(src.exists());
    FALSE(src.isDirectory());
    FALSE(dst.exists());

    try {
      FileOperationTest.lockFile("exclusive", src);
      Thread.sleep(1000);
    } catch (Exception e) {
      NG(e);
    }

    try {
      FileOperation.move(src, dst, filter);
      NG();
    } catch (IOException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    } finally {
      FileOperationTest.releaseLock();
    }

    TRUE(src.exists());
    FALSE(src.isDirectory());
    FALSE(dst.exists());
  }

  public void move_withFilter010()
  {
    MSG("ړ̃t@C݂ȂꍇB");

    File src = new File(WORKDIR, "aaa");
    File dst = new File(WORKDIR, "bbb");

    FALSE(src.exists());
    FALSE(dst.exists());

    FileFilter filter = new FileTypeFilter(FileType.File);
    try {
      FileOperation.move(src, dst, filter);
      NG();
    } catch (FileNotFoundException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void moveRecursive()
  {
    MSG("łȂfBNgړꍇB");
    
    File src = DIRS[0];
    File dst = new File(WORKDIR, "aaa/bbb/ccc");

    List<File> lst = new ArrayList<File>(20);
    lst.add(src);
    try {
      lst.addAll(FileOperation.listRecursive(src));
    } catch (Exception e) {
      NG(e);
    }
    EQUAL(lst.size(), 16);
    for (File d : DIRS) TRUE(lst.contains(d));
    for (File f : FILES) TRUE(lst.contains(f));

    FALSE(dst.exists());

    try {
      FileOperation.moveRecursive(src, dst);
    } catch (Exception e) {
      NG(e);
    }

    FALSE(src.exists());
    FileOperation fo = new FileOperation();
    try {
      lst.clear();
      lst.add(dst);
      lst.addAll(FileOperation.listRecursive(dst));

      EQUAL(lst.size(), 16);
      for (File d : DIRS) TRUE(lst.contains(fo.getDestinationFile(d,src,dst)));
      for (File f : FILES) TRUE(lst.contains(fo.getDestinationFile(f,src,dst)));
    } catch (Exception e) {
      NG(e);
    }
  }

  public void moveRecursive_withFilter()
  {
    MSG("łȂfBNgRs[ꍇB");

    File src = DIRS[0];
    File dst = new File(WORKDIR, "aaa/bbb/ccc");

    FALSE(dst.exists());
    List<File> lst = new ArrayList<File>(20);
    lst.add(src);
    try {
      lst.addAll(FileOperation.listRecursive(src));
    } catch (Exception e) {
      NG(e);
    }
    EQUAL(lst.size(), 16);
    for (File d : DIRS) TRUE(lst.contains(d));
    for (File f : FILES) TRUE(lst.contains(f));

    FileFilter filter = new FileTypeFilter(FileType.File);
    try {
      FileOperation.moveRecursive(src, dst, filter);
    } catch (Exception e) {
      NG(e);
    }

    FileOperation fo = new FileOperation();
    try {
      lst.clear();
      lst.add(src);
      lst.addAll(FileOperation.listRecursive(src));

      EQUAL(lst.size(), 6);
      for (File d : DIRS) TRUE(lst.contains(d));
      for (File f : FILES) FALSE(lst.contains(f));
    } catch (Exception e) {
      NG(e);
    }
    try {
      lst.clear();
      lst.add(dst);
      lst.addAll(FileOperation.listRecursive(dst));

      EQUAL(lst.size(), 15);
      for (File d : DIRS) {
        if (d.equals(DIRS[5])) continue;
        TRUE(lst.contains(fo.getDestinationFile(d,src,dst)));
      }
      for (File f : FILES) TRUE(lst.contains(fo.getDestinationFile(f,src,dst)));
    } catch (Exception e) {
      NG(e);
    }
  }

  public void moveRecursive_withFilter001()
  {
    MSG("łȂfBNgRs[ꍇB");

    File src = DIRS[0];
    File dst = new File(WORKDIR, "aaa/bbb/ccc");

    FALSE(dst.exists());
    List<File> lst = new ArrayList<File>(20);
    lst.add(src);
    try {
      lst.addAll(FileOperation.listRecursive(src));
    } catch (Exception e) {
      NG(e);
    }
    EQUAL(lst.size(), 16);
    for (File d : DIRS) TRUE(lst.contains(d));
    for (File f : FILES) TRUE(lst.contains(f));

    FileFilter filter = new FileTypeFilter(FileType.Directory);
    try {
      FileOperation.moveRecursive(src, dst, filter);
    } catch (Exception e) {
      NG(e);
    }

    FileOperation fo = new FileOperation();
    FALSE(src.exists());
    try {
      lst.clear();
      lst.add(dst);
      lst.addAll(FileOperation.listRecursive(dst));

      EQUAL(lst.size(), 16);
      for (File d : DIRS) TRUE(lst.contains(fo.getDestinationFile(d,src,dst)));
      for (File f : FILES) TRUE(lst.contains(fo.getDestinationFile(f,src,dst)));
    } catch (Exception e) {
      NG(e);
    }
  }
}

