/*
 * FunctionTesterPartTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function;

import ts.tester.function.FunctionTester;
import ts.tester.function.print.*;
import java.util.*;

/**
 * <code>FunctionTester</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.3 $, $Date: 2007/10/08 16:11:08 $
 */
public class FunctionTesterPartTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      run(FunctionTesterPartTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- inner classes -- */

  class NullPrinter extends AbstractPrinter {
    public CaseResult createCaseResult(String name, CaseResult parent) {
      assert (name != null) : "@param:name is null.";
      assert (parent != null) : "@param:parent is null.";
      return null;
    }
  }

  class MyCaseResult extends CaseResult {
    public MyCaseResult(String name, CaseResult parent) {
      super(name, parent);
    }
    public int count(ResultType type) {
      return 0;
    }
    public void addChildResult(Result result) {}
  }

  class MyPrinter extends AbstractPrinter {
    public CaseResult createCaseResult(String name, CaseResult parent) {
      CaseResult c = new MyCaseResult(name, parent);
      OK("createCaseResult:");
      return c;
    }
    public void testStarted(CaseResult root) {
      super.testStarted(root);
      OK("testStarted:");
    }
    public void testEnded(CaseResult root) {
      super.testEnded(root);
      OK("testEnded:");
    }
    public void caseStarted(CaseResult current) {
      super.caseStarted(current);
      OK("caseStarted:");
    }
    public void caseEnded(CaseResult current) {
      super.caseEnded(current);
      OK("caseEnded:");
    }
    public void checkOccured(CheckResult check, CaseResult current) {
      super.checkOccured(check, current);
      OK("checkOccured:");
    }
    public void messageNoted(String msg, CaseResult current) {
      super.messageNoted(msg, current);
      OK("messageNoted:");
    }
    public void testStopped(CaseResult current) {
      super.testStopped(current);
      OK("testStopped:");
    }
  }

  /* -- test case -- */

  public void constructor()
  {
    FunctionTester tester = new FunctionTester();
    NOTNULL(tester);
  }

  public void methodSequence()
  {
    MSG("");
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.endTesting();
    MSG("");
  }

  public void methodSequence_1()
  {
    MSG("");
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    tester.endInvocation("bbb");
    tester.initInvocation("ccc");
    tester.endInvocation("ddd");
    tester.endTesting();
    MSG("");
  }

  public void methodSequence_2()
  {
    MSG("");
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    tester.MSG("");
    tester.endInvocation("bbb");
    tester.initInvocation("ccc");
    tester.OK("!!!");
    tester.endInvocation("ddd");
    tester.endTesting();
    MSG("");
  }

  public void methodSequence_3()
  {
    MSG("");
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    tester.KNOWNBUG("KKK");
    tester.endInvocation("bbb");
    tester.initInvocation("ccc");
    tester.NG("xxx");
    tester.NG("yxx");
    tester.NG("zzz");
    tester.endInvocation("ddd");
    tester.endTesting();
    MSG("");
  }

  public void setPrinter()
  {
    FunctionTester tester = new FunctionTester();
    Printer p0 = tester.printer();
    EQUAL(p0.getClass(), ConsolePrinter.class);

    Printer p1 = new NullPrinter();
    FunctionTester.setPrinter(p1);

    FunctionTester tester1 = new FunctionTester();
    EQUAL(tester1.printer(), p1);
    EQUAL(tester.printer(), p0);

    Printer p2 = new ConsolePrinter();
    FunctionTester.setPrinter(p2);

    FunctionTester tester2 = new FunctionTester();
    EQUAL(tester.printer(), p0);
    EQUAL(tester1.printer(), p1);
    EQUAL(tester2.printer(), p2);
  }

  public void MSG()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    tester.MSG("");
    try {
      tester.MSG(null); NG();
    } catch (AssertionError e) {
      OK(e);
    }
    tester.endInvocation("ddd");
    tester.endTesting();
    MSG("");
  }

  public void OK()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    tester.OK();
    tester.OK();
    tester.OK();
    tester.OK();
    tester.endInvocation("ddd");
    tester.endTesting();
    MSG("");
  }

  public void NG()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    tester.NG();
    tester.NG();
    tester.NG();
    tester.NG();
    tester.endInvocation("ddd");
    tester.endTesting();
    MSG("");
  }

  public void KNOWNBUG()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("AAA");
    tester.KNOWNBUG();
    tester.KNOWNBUG();
    tester.KNOWNBUG();
    tester.KNOWNBUG();
    tester.endInvocation("BBB");
    tester.endTesting();
    MSG("");
  }

  public void INCOMPLETE()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("AAA");
    tester.INCOMPLETE();
    tester.endInvocation("BBB");
    tester.endTesting();
    MSG("");
  }

  public void OK_String()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("AAA");
    tester.OK("");
    tester.endInvocation("BBB");
    tester.endTesting();
    MSG("");
  }

  public void OK_String_1()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    try {
      tester.OK((String)null); NG();
    } catch (AssertionError e) {
      OK(e);
    }
    tester.endInvocation("bbb");
    tester.endTesting();
    MSG("");
  }

  public void NG_String()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    tester.NG("");
    tester.endInvocation("bbb");
    tester.endTesting();
    MSG("");
  }

  public void NG_String_1()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    try {
      tester.NG((String)null); NG();
    } catch (AssertionError e) {
      OK(e);
    }
    tester.endInvocation("bbb");
    tester.endTesting();
    MSG("");
  }

  public void KNOWNBUG_String()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    tester.KNOWNBUG("");
    tester.endInvocation("bbb");
    tester.endTesting();
    MSG("");
  }

  public void KNOWNBUG_String_1()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    try {
      tester.KNOWNBUG((String) null); NG();
    } catch (AssertionError e) {
      OK(e);
    }
    tester.endInvocation("bbb");
    tester.endTesting();
    MSG("");
  }

  public void OK_Throwable()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    try {
      throw new NullPointerException();
    } catch (NullPointerException e) {
      tester.OK(e);
    }
    try {
      throw new IllegalAccessError();
    } catch (IllegalAccessError e) {
      tester.OK(e);
    }
    tester.endInvocation("bbb");
    tester.endTesting();
    MSG("");
  }

  public void OK_Throwable_1()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    try {
      tester.OK((Throwable) null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
    tester.endInvocation("bbb");
    tester.endTesting();
    MSG("");
  }

  public void NG_Throwable()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    try {
      throw new NullPointerException();
    } catch (NullPointerException e) {
      tester.NG(e);
    }
    try {
      throw new IllegalAccessError();
    } catch (IllegalAccessError e) {
      tester.NG(e);
    }
    tester.endInvocation("bbb");
    tester.endTesting();
    MSG("");
  }

  public void NG_Throwable_1()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    try {
      tester.NG((Throwable) null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
    tester.endInvocation("bbb");
    tester.endTesting();
    MSG("");
  }

  public void KNOWNBUG_Throwable()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    try {
      throw new NullPointerException();
    } catch (NullPointerException e) {
      tester.KNOWNBUG(e);
    }
    try {
      throw new IllegalAccessError();
    } catch (IllegalAccessError e) {
      tester.KNOWNBUG(e);
    }
    tester.endInvocation("bbb");
    tester.endTesting();
    MSG("");
  }

  public void KNOWNBUG_Throwable_1()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    try {
      tester.KNOWNBUG((Throwable) null);
    } catch (AssertionError e) {
      OK(e);
    }
    tester.endInvocation("bbb");
    tester.endTesting();
    MSG("");
  }

  public void NULL_result()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    tester.NULL(null);
    tester.endInvocation("aaa");
    tester.initInvocation("bbb");
    tester.NULL(new Object());
    tester.endInvocation("bbb");
    tester.endTesting();
    MSG("");
  }

  public void NULL_result_reason()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.NULL(null, "");
    tester.endInvocation("a");
    tester.initInvocation("a");
    tester.NULL(new Integer("123"), "");
    tester.endInvocation("a");
    tester.endTesting();
    MSG("");
  }

  public void NOTNULL_result()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    tester.NOTNULL(null);
    tester.endInvocation("aaa");
    tester.initInvocation("bbb");
    tester.NOTNULL(new Object());
    tester.endInvocation("bbb");
    tester.endTesting();
    MSG("");
  }

  public void NOTNULL_result_reason()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.NOTNULL(null, "");
    tester.endInvocation("a");
    tester.initInvocation("a");
    tester.NOTNULL(new Integer("123"), "");
    tester.endInvocation("a");
    tester.endTesting();
    MSG("");
  }

  public void TRUE_boolean()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    tester.TRUE(true);
    tester.endInvocation("aaa");
    tester.initInvocation("bbb");
    tester.TRUE(false);
    tester.endInvocation("bbb");
    tester.endTesting();
    MSG("");
  }

  public void TRUE_boolean_reason()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.TRUE(true, "");
    tester.endInvocation("a");
    tester.initInvocation("a");
    tester.TRUE(false, "");
    tester.endInvocation("a");
    tester.endTesting();
    MSG("");
  }

  public void FALSE_boolean()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("aaa");
    tester.FALSE(true);
    tester.endInvocation("aaa");
    tester.initInvocation("bbb");
    tester.FALSE(false);
    tester.endInvocation("bbb");
    tester.endTesting();
    MSG("");
  }

  public void FALSE_boolean_reason()
  {
    MSG("");
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.FALSE(true, "");
    tester.endInvocation("a");
    tester.initInvocation("a");
    tester.FALSE(false, "");
    tester.endInvocation("a");
    tester.endTesting();
    MSG("");
  }

  public void EQUAL_Object_Object()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL("ABC", "ABC");
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.EQUAL("ABC", "XYZ");
    tester.endInvocation("b");
    tester.initInvocation("c");
    tester.EQUAL("ABC", null);
    tester.endInvocation("c");
    tester.initInvocation("d");
    tester.EQUAL(null, "XYZ");
    tester.endInvocation("d");
    tester.endTesting();
  }

  public void EQUAL_Object_Object_reason()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL("ABC", "ABC", "");
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.EQUAL("ABC", "XYZ", "");
    tester.endInvocation("b");
    tester.initInvocation("c");
    tester.EQUAL("ABC", null, "");
    tester.endInvocation("c");
    tester.initInvocation("c");
    tester.EQUAL(null, "XYZ", "Ă");
    tester.endInvocation("c");
    tester.initInvocation("d");
    tester.EQUAL("A", "A", null);
    tester.endInvocation("d");
    tester.endTesting();
  }

  public void NOTEQUAL_Object_Object()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.NOTEQUAL("ABC", "ABC");
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.NOTEQUAL("ABC", "XYZ");
    tester.endInvocation("b");
    tester.initInvocation("c");
    tester.NOTEQUAL("ABC", null);
    tester.endInvocation("c");
    tester.initInvocation("d");
    tester.NOTEQUAL(null, "XYZ");
    tester.endInvocation("d");
    tester.initInvocation("e");
    tester.NOTEQUAL(null, null);
    tester.endInvocation("e");
    tester.endTesting();
  }

  public void NOTEQUAL_Object_Object_reason()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.NOTEQUAL("ABC", "ABC", "");
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.NOTEQUAL("ABC", "XYZ", "");
    tester.endInvocation("b");
    tester.initInvocation("c");
    tester.NOTEQUAL("ABC", null, "");
    tester.endInvocation("c");
    tester.initInvocation("d");
    tester.NOTEQUAL(null, "XYZ", "Ă");
    tester.endInvocation("d");
    tester.initInvocation("e");
    tester.NOTEQUAL(null, null, "Ȃɂʂ˂");
    tester.endInvocation("e");
    tester.endTesting();
  }

  public void EQUAL_boolean_boolean()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(true, true);
    tester.EQUAL(false, false);
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.EQUAL(true, false);
    tester.EQUAL(false, true);
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void EQUAL_boolean_boolean_reason()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(true, true, "");
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.EQUAL(false, false, "");
    tester.endInvocation("b");
    tester.initInvocation("c");
    tester.EQUAL(true, false, "");
    tester.endInvocation("c");
    tester.initInvocation("c");
    tester.EQUAL(false, true, "Ă");
    tester.endInvocation("c");
    tester.endTesting();
  }

  public void NOTEQUAL_boolean_boolean()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.NOTEQUAL(true, true);
    tester.NOTEQUAL(false, false);
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.NOTEQUAL(true, false);
    tester.NOTEQUAL(false, true);
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void NOTEQUAL_boolean_boolean_reason()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.NOTEQUAL(true, true, "");
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.NOTEQUAL(false, false, "");
    tester.endInvocation("b");
    tester.initInvocation("c");
    tester.NOTEQUAL(true, false, "");
    tester.endInvocation("c");
    tester.initInvocation("c");
    tester.NOTEQUAL(false, true, "Ă");
    tester.endInvocation("c");
    tester.endTesting();
  }

  public void EQUAL_byte_byte()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL((byte)0x01, (byte)0x01);
    tester.EQUAL((byte)0xff, (byte)0xff);
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.EQUAL((byte)0x01, (byte)0x02);
    tester.EQUAL((byte)0xff, (byte)0xf0);
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void EQUAL_byte_byte_reason()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL((byte)0x01, (byte)0x01, "");
    tester.EQUAL((byte)0xff, (byte)0xff, "");
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.EQUAL((byte)0x01, 0x02, "");
    tester.EQUAL((byte)0x44, 0x66, "");
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void NOTEQUAL_byte_byte()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.NOTEQUAL((byte)0x01, (byte)0x01);
    tester.NOTEQUAL((byte)0x02, (byte)0x02);
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.NOTEQUAL((byte)0x0f, (byte)0x0e);
    tester.NOTEQUAL((byte)0x01, (byte)0x02);
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void NOTEQUAL_byte_byte_reason()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.NOTEQUAL((byte)0x11, (byte)0x11, "");
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.NOTEQUAL((byte)0xee, (byte)0xff, "");
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void EQUAL_char_char()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL('a', 'a');
    tester.EQUAL('\n', '\n');
    tester.EQUAL('', '');
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.EQUAL('a', 'g');
    tester.EQUAL('\n', '\t');
    tester.EQUAL('', '');
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void EQUAL_char_char_reason()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL('a', 'a', "");
    tester.EQUAL('\n', '\n', "");
    tester.EQUAL('', '', "");
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.EQUAL('a', 'g', "");
    tester.EQUAL('\n', '\t', "");
    tester.EQUAL('', '', "");
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void NOTEQUAL_char_char()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.NOTEQUAL('a', 'a');
    tester.NOTEQUAL('\n', '\n');
    tester.NOTEQUAL('', '');
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.NOTEQUAL('a', 'g');
    tester.NOTEQUAL('\n', '\t');
    tester.NOTEQUAL('', '');
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void NOTEQUAL_char_char_reason()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.NOTEQUAL('a', 'a', "");
    tester.NOTEQUAL('\n', '\n', "");
    tester.NOTEQUAL('', '', "");
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.NOTEQUAL('a', 'g', "");
    tester.NOTEQUAL('\n', '\t', "");
    tester.NOTEQUAL('', '', "");
    tester.endInvocation("c");
    tester.endTesting();
  }


  public void EQUAL_short_short()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL((short)0, (short)0);
    tester.EQUAL((short)1, (short)1);
    tester.EQUAL((short)-1, (short)-1);
    tester.EQUAL(Short.MAX_VALUE, Short.MAX_VALUE);
    tester.EQUAL(Short.MIN_VALUE, Short.MIN_VALUE);
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.EQUAL((short)0, (short)1);
    tester.EQUAL((short)1, (short)-1);
    tester.EQUAL((short)-1, (short)1);
    tester.EQUAL(Short.MAX_VALUE, Short.MIN_VALUE);
    tester.EQUAL(Short.MIN_VALUE, Short.MAX_VALUE);
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void EQUAL_short_short_reason()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL((short)0, (short)0, "");
    tester.EQUAL((short)1, (short)1, "");
    tester.EQUAL((short)-1, (short)-1, "");
    tester.EQUAL(Short.MAX_VALUE, Short.MAX_VALUE, "");
    tester.EQUAL(Short.MIN_VALUE, Short.MIN_VALUE, "");
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.EQUAL((short)0, (short)1, "");
    tester.EQUAL((short)1, (short)-1, "");
    tester.EQUAL((short)-1, (short)1, "");
    tester.EQUAL(Short.MAX_VALUE, Short.MIN_VALUE, "");
    tester.EQUAL(Short.MIN_VALUE, Short.MAX_VALUE, "");
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void NOTEQUAL_short_short()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.NOTEQUAL((short)0, (short)0);
    tester.NOTEQUAL((short)1, (short)1);
    tester.NOTEQUAL((short)-1, (short)-1);
    tester.NOTEQUAL(Short.MAX_VALUE, Short.MAX_VALUE);
    tester.NOTEQUAL(Short.MIN_VALUE, Short.MIN_VALUE);
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.NOTEQUAL((short)0, (short)1);
    tester.NOTEQUAL((short)1, (short)-1);
    tester.NOTEQUAL((short)-1, (short)1);
    tester.NOTEQUAL(Short.MAX_VALUE, Short.MIN_VALUE);
    tester.NOTEQUAL(Short.MIN_VALUE, Short.MAX_VALUE);
    tester.endTesting();
  }

  public void NOTEQUAL_short_short_reason()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.NOTEQUAL((short)0, (short)0, "");
    tester.NOTEQUAL((short)1, (short)1, "");
    tester.NOTEQUAL((short)-1, (short)-1, "");
    tester.NOTEQUAL(Short.MAX_VALUE, Short.MAX_VALUE, "");
    tester.NOTEQUAL(Short.MIN_VALUE, Short.MIN_VALUE, "");
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.NOTEQUAL((short)0, (short)1, "");
    tester.NOTEQUAL((short)1, (short)-1, "");
    tester.NOTEQUAL((short)-1, (short)1, "");
    tester.NOTEQUAL(Short.MAX_VALUE, Short.MIN_VALUE, "");
    tester.NOTEQUAL(Short.MIN_VALUE, Short.MAX_VALUE, "");
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void EQUAL_int_int()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(0,0);
    tester.EQUAL(1,1);
    tester.EQUAL(-1, -1);
    tester.EQUAL(Integer.MAX_VALUE, Integer.MAX_VALUE);
    tester.EQUAL(Integer.MIN_VALUE, Integer.MIN_VALUE);
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.EQUAL(0, 1);
    tester.EQUAL(1, -1);
    tester.EQUAL(-1, 1);
    tester.EQUAL(Integer.MAX_VALUE, Integer.MIN_VALUE);
    tester.EQUAL(Integer.MIN_VALUE, Integer.MAX_VALUE);
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void EQUAL_int_int_reason()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(0, 0, "");
    tester.EQUAL(1, 1, "");
    tester.EQUAL(-1, -1, "");
    tester.EQUAL(Integer.MAX_VALUE, Integer.MAX_VALUE, "");
    tester.EQUAL(Integer.MIN_VALUE, Integer.MIN_VALUE, "");
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.EQUAL( 0,  1, "");
    tester.EQUAL( 1, -1, "");
    tester.EQUAL(-1,  1, "");
    tester.EQUAL(Integer.MAX_VALUE, Integer.MIN_VALUE, "");
    tester.EQUAL(Integer.MIN_VALUE, Integer.MAX_VALUE, "");
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void NOTEQUAL_int_int()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.NOTEQUAL(0,0);
    tester.NOTEQUAL(1,1);
    tester.NOTEQUAL(-1, -1);
    tester.NOTEQUAL(Integer.MAX_VALUE, Integer.MAX_VALUE);
    tester.NOTEQUAL(Integer.MIN_VALUE, Integer.MIN_VALUE);
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.NOTEQUAL(0, 1);
    tester.NOTEQUAL(1, -1);
    tester.NOTEQUAL(-1, 1);
    tester.NOTEQUAL(Integer.MAX_VALUE, Integer.MIN_VALUE);
    tester.NOTEQUAL(Integer.MIN_VALUE, Integer.MAX_VALUE);
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void NOTEQUAL_int_int_reason()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.NOTEQUAL(0, 0, "");
    tester.NOTEQUAL(1, 1, "");
    tester.NOTEQUAL(-1, -1, "");
    tester.NOTEQUAL(Integer.MAX_VALUE, Integer.MAX_VALUE, "");
    tester.NOTEQUAL(Integer.MIN_VALUE, Integer.MIN_VALUE, "");
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.NOTEQUAL( 0,  1, "");
    tester.NOTEQUAL( 1, -1, "");
    tester.NOTEQUAL(-1,  1, "");
    tester.NOTEQUAL(Integer.MAX_VALUE, Integer.MIN_VALUE, "");
    tester.NOTEQUAL(Integer.MIN_VALUE, Integer.MAX_VALUE, "");
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void EQUAL_long_long()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(0L,0L);
    tester.EQUAL(1L,1L);
    tester.EQUAL(-1L, -1L);
    tester.EQUAL(Long.MAX_VALUE, Long.MAX_VALUE);
    tester.EQUAL(Long.MIN_VALUE, Long.MIN_VALUE);
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.EQUAL(0L, 1L);
    tester.EQUAL(1L, -1L);
    tester.EQUAL(-1L, 1L);
    tester.EQUAL(Long.MAX_VALUE, Long.MIN_VALUE);
    tester.EQUAL(Long.MIN_VALUE, Long.MAX_VALUE);
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void EQUAL_long_long_reason()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(0L, 0L, "");
    tester.EQUAL(1L, 1L, "");
    tester.EQUAL(-1L, -1L, "");
    tester.EQUAL(Long.MAX_VALUE, Long.MAX_VALUE, "");
    tester.EQUAL(Long.MIN_VALUE, Long.MIN_VALUE, "");
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.EQUAL( 0L,  1L, "");
    tester.EQUAL( 1L, -1L, "");
    tester.EQUAL(-1L,  1L, "");
    tester.EQUAL(Long.MAX_VALUE, Long.MIN_VALUE, "");
    tester.EQUAL(Long.MIN_VALUE, Long.MAX_VALUE, "");
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void NOTEQUAL_long_long()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.NOTEQUAL(0L,0L);
    tester.NOTEQUAL(1L,1L);
    tester.NOTEQUAL(-1L, -1L);
    tester.NOTEQUAL(Long.MAX_VALUE, Long.MAX_VALUE);
    tester.NOTEQUAL(Long.MIN_VALUE, Long.MIN_VALUE);
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.NOTEQUAL(0L, 1L);
    tester.NOTEQUAL(1L, -1L);
    tester.NOTEQUAL(-1L, 1L);
    tester.NOTEQUAL(Long.MAX_VALUE, Long.MIN_VALUE);
    tester.NOTEQUAL(Long.MIN_VALUE, Long.MAX_VALUE);
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void NOTEQUAL_long_long_reason()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.NOTEQUAL(0L, 0L, "");
    tester.NOTEQUAL(1L, 1L, "");
    tester.NOTEQUAL(-1L, -1L, "");
    tester.NOTEQUAL(Long.MAX_VALUE, Long.MAX_VALUE, "");
    tester.NOTEQUAL(Long.MIN_VALUE, Long.MIN_VALUE, "");
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.NOTEQUAL( 0L,  1L, "");
    tester.NOTEQUAL( 1L, -1L, "");
    tester.NOTEQUAL(-1L,  1L, "");
    tester.NOTEQUAL(Long.MAX_VALUE, Long.MIN_VALUE, "");
    tester.NOTEQUAL(Long.MIN_VALUE, Long.MAX_VALUE, "");
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void EQUAL_float_float()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(0.0f,0.0f);
    tester.EQUAL(0.1f, 0.1f);
    tester.EQUAL(-1.0f, -1.0f);
    tester.EQUAL(Float.MAX_VALUE, Float.MAX_VALUE);
    tester.EQUAL(Float.MIN_VALUE, Float.MIN_VALUE);
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.EQUAL(0.0f, 1.0f);
    tester.EQUAL(0.1f, -0.1f);
    tester.EQUAL(-1.0f, 1.0f);
    tester.EQUAL(Float.MAX_VALUE, Float.MIN_VALUE);
    tester.EQUAL(Float.MIN_VALUE, Float.MAX_VALUE);
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void EQUAL_float_float_reason()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(0.0f, 0.0f, "");
    tester.EQUAL(0.1f, 0.1f, "");
    tester.EQUAL(-1.0f, -1.0f, "");
    tester.EQUAL(Float.MAX_VALUE, Float.MAX_VALUE, "");
    tester.EQUAL(Float.MIN_VALUE, Float.MIN_VALUE, "");
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.EQUAL( 0.0f,  1.0f, "");
    tester.EQUAL( 1.0f, -1.0f, "");
    tester.EQUAL(-0.1f, -1.0f, "");
    tester.EQUAL(Float.MAX_VALUE, Float.MIN_VALUE, "");
    tester.EQUAL(Float.MIN_VALUE, Float.MAX_VALUE, "");
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void NOTEQUAL_float_float()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.NOTEQUAL(0.0f, 0.0f);
    tester.NOTEQUAL(0.1f, 0.1f);
    tester.NOTEQUAL(-1.0f, -1.0f);
    tester.NOTEQUAL(Float.MAX_VALUE, Float.MAX_VALUE);
    tester.NOTEQUAL(Float.MIN_VALUE, Float.MIN_VALUE);
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.NOTEQUAL(0.0f, 0.1f);
    tester.NOTEQUAL(1.0f, -1.0f);
    tester.NOTEQUAL(-1.0f, -0.1f);
    tester.NOTEQUAL(Float.MAX_VALUE, Float.MIN_VALUE);
    tester.NOTEQUAL(Float.MIN_VALUE, Float.MAX_VALUE);
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void NOTEQUAL_float_float_reason()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.NOTEQUAL(0.0f, 0.0f, "");
    tester.NOTEQUAL(0.1f, 0.1f, "");
    tester.NOTEQUAL(-1.0f, -1.0f, "");
    tester.NOTEQUAL(Float.MAX_VALUE, Float.MAX_VALUE, "");
    tester.NOTEQUAL(Float.MIN_VALUE, Float.MIN_VALUE, "");
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.NOTEQUAL( 0.0f,  1.0f, "");
    tester.NOTEQUAL( 1.0f, -1.0f, "");
    tester.NOTEQUAL(-0.1f, -1.0f, "");
    tester.NOTEQUAL(Float.MAX_VALUE, Float.MIN_VALUE, "");
    tester.NOTEQUAL(Float.MIN_VALUE, Float.MAX_VALUE, "");
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void EQUAL_double_double()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(0.0, 0.0);
    tester.EQUAL(0.1, 0.1);
    tester.EQUAL(-1.0, -1.0);
    tester.EQUAL(Double.MAX_VALUE, Double.MAX_VALUE);
    tester.EQUAL(Double.MIN_VALUE, Double.MIN_VALUE);
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.EQUAL(0.0, 0.1);
    tester.EQUAL(1.0, -1.0);
    tester.EQUAL(-1.0, -0.1);
    tester.EQUAL(Double.MAX_VALUE, Double.MIN_VALUE);
    tester.EQUAL(Double.MIN_VALUE, Double.MAX_VALUE);
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void EQUAL_double_double_reason()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(0.0, 0.0, "");
    tester.EQUAL(0.1, 0.1, "");
    tester.EQUAL(-1.0f, -1.0, "");
    tester.EQUAL(Float.MAX_VALUE, Float.MAX_VALUE, "");
    tester.EQUAL(Float.MIN_VALUE, Float.MIN_VALUE, "");
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.EQUAL( 0.0f,  1.0f, "");
    tester.EQUAL( 1.0f, -1.0f, "");
    tester.EQUAL(-0.1f, -1.0f, "");
    tester.EQUAL(Float.MAX_VALUE, Float.MIN_VALUE, "");
    tester.EQUAL(Float.MIN_VALUE, Float.MAX_VALUE, "");
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void NOTEQUAL_double_double()
  {
    FunctionTester.setPrinter(new ConsolePrinter());
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.NOTEQUAL(0.0, 0.0);
    tester.NOTEQUAL(0.1, 0.1);
    tester.NOTEQUAL(-1.0, -1.0);
    tester.NOTEQUAL(Double.MAX_VALUE, Double.MAX_VALUE);
    tester.NOTEQUAL(Double.MIN_VALUE, Double.MIN_VALUE);
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.NOTEQUAL(0.0, 0.1);
    tester.NOTEQUAL(1.0, -1.0);
    tester.NOTEQUAL(-1.0, -0.1);
    tester.NOTEQUAL(Double.MAX_VALUE, Double.MIN_VALUE);
    tester.NOTEQUAL(Double.MIN_VALUE, Double.MAX_VALUE);
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void NOTEQUAL_double_double_reason()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.NOTEQUAL(0.0, 0.0, "");
    tester.NOTEQUAL(0.1, 0.1, "");
    tester.NOTEQUAL(-1.0f, -1.0, "");
    tester.NOTEQUAL(Float.MAX_VALUE, Float.MAX_VALUE, "");
    tester.NOTEQUAL(Float.MIN_VALUE, Float.MIN_VALUE, "");
    tester.endInvocation("a");
    tester.initInvocation("b");
    tester.NOTEQUAL( 0.0f,  1.0f, "");
    tester.NOTEQUAL( 1.0f, -1.0f, "");
    tester.NOTEQUAL(-0.1f, -1.0f, "");
    tester.NOTEQUAL(Float.MAX_VALUE, Float.MIN_VALUE, "");
    tester.NOTEQUAL(Float.MIN_VALUE, Float.MAX_VALUE, "");
    tester.endInvocation("b");
    tester.endTesting();
  }

  public void EQUAL_ObjectArray_ObjectArray()
  {
    MSG("ʏ̔z̏ꍇ");
    Object[] arr1 = { "a", "b", "c", "d" };
    Object[] arr2 = { "a", "b", "c", "d" };
    Object[] arr3 = { "a", "x", "y", "z" };
    Object[] arr4 = { "a", "b", "c" };

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(arr1, arr1);
    tester.EQUAL(arr1, arr2);
    tester.EQUAL(arr1, arr3);
    tester.EQUAL(arr1, arr4);
    tester.EQUAL(arr4, arr1);
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_ObjectArray_ObjectArray_1()
  {
    MSG("TCY0̔z̏ꍇ");
    Object[] arr1 = { "a", "b", "c", "d" };
    Object[] arr2 = {};
    Object[] arr3 = {};

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(arr1, arr1);
    tester.EQUAL(arr1, arr2);
    tester.EQUAL(arr1, arr3);
    tester.EQUAL(arr2, arr1);
    tester.EQUAL(arr2, arr2);
    tester.EQUAL(arr2, arr3);
    tester.EQUAL(arr3, arr1);
    tester.EQUAL(arr3, arr2);
    tester.EQUAL(arr3, arr3);
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_ObjectArray_ObjectArray_2()
  {
    MSG("k̏ꍇ");

    Object[] arr1 = { "a", "b", "c", "d" };
    Object[] arr2 = {};
    Object[] arr3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(arr1, arr3);
    tester.EQUAL(arr3, arr1);
    tester.EQUAL(arr2, arr3);
    tester.EQUAL(arr3, arr2);
    tester.EQUAL(arr3, arr3);
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_ObjectArray_ObjectArray_3()
  {
    MSG("vfɃkꍇ");
    Object[] arr1 = { "a", "b", null, "d" };
    Object[] arr2 = { "a", null, "c", "d" };
    Object[] arr3 = { "a", null, null, null };
    Object[] arr4 = { "a", "b", null };

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(arr1, arr1);
    tester.EQUAL(arr1, arr2);
    tester.EQUAL(arr1, arr3);
    tester.EQUAL(arr1, arr4);
    tester.EQUAL(arr4, arr1);
    tester.EQUAL(arr3, arr4);
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_ObjectArray_ObjectArray_reason()
  {
    MSG("ʏ̔z̏ꍇ");
    Object[] arr1 = { "a", "b", "c", "d" };
    Object[] arr2 = { "a", "b", "c", "d" };
    Object[] arr3 = { "a", "x", "y", "z" };
    Object[] arr4 = { "a", "b", "c" };

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(arr1, arr1, "");
    tester.EQUAL(arr1, arr2, "");
    tester.EQUAL(arr1, arr3, "");
    tester.EQUAL(arr1, arr4, "Ă");
    tester.EQUAL(arr4, arr1, "Ȃɂʂ˂");
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_ObjectArray_ObjectArray_reason_1()
  {
    MSG("TCY0̔z̏ꍇ");
    Object[] arr1 = { "a", "b", "c", "d" };
    Object[] arr2 = {};
    Object[] arr3 = {};

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(arr1, arr1, "");
    tester.EQUAL(arr1, arr2, "");
    tester.EQUAL(arr1, arr3, "");
    tester.EQUAL(arr2, arr1, "");
    tester.EQUAL(arr2, arr2, "");
    tester.EQUAL(arr2, arr3, "");
    tester.EQUAL(arr3, arr1, "");
    tester.EQUAL(arr3, arr2, "");
    tester.EQUAL(arr3, arr3, "");
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_ObjectArray_ObjectArray_reason_2()
  {
    MSG("k̏ꍇ");

    Object[] arr1 = { "a", "b", "c", "d" };
    Object[] arr2 = {};
    Object[] arr3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(arr1, arr3, "");
    tester.EQUAL(arr3, arr1, "");
    tester.EQUAL(arr2, arr3, "");
    tester.EQUAL(arr3, arr2, "");
    tester.EQUAL(arr3, arr3, "");
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_booleanArray_booleanArray()
  {
    MSG("ʏ̔z̏ꍇ");

    boolean[] arr1 = { true, true, false, false };
    boolean[] arr2 = { true, true, false, false };
    boolean[] arr3 = { true, false, false, true };
    boolean[] arr4 = { true, true };

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(arr1, arr1);
    tester.EQUAL(arr1, arr2);
    tester.EQUAL(arr1, arr3);
    tester.EQUAL(arr1, arr4);
    tester.EQUAL(arr4, arr1);
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_booleanArray_booleanArray_0()
  {
    MSG("TCY[k̔z̏ꍇ");

    boolean[] arr1 = { true, true, false, false };
    boolean[] arr2 = {};
    boolean[] arr3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(arr1, arr1);
    tester.EQUAL(arr1, arr2);
    tester.EQUAL(arr1, arr3);
    tester.EQUAL(arr2, arr1);
    tester.EQUAL(arr2, arr2);
    tester.EQUAL(arr2, arr3);
    tester.EQUAL(arr3, arr1);
    tester.EQUAL(arr3, arr2);
    tester.EQUAL(arr3, arr3);
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_booleanArray_booleanArray_reason()
  {
    MSG("ʏ̔z̏ꍇ");

    boolean[] arr1 = { true, true, false, false };
    boolean[] arr2 = { true, true, false, false };
    boolean[] arr3 = { true, false, false, true };
    boolean[] arr4 = { true, true };

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(arr1, arr1, "");
    tester.EQUAL(arr1, arr2, "");
    tester.EQUAL(arr1, arr3, "");
    tester.EQUAL(arr1, arr4, "");
    tester.EQUAL(arr4, arr1, "");
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_booleanArray_booleanArray_reason_1()
  {
    MSG("TCY[k̔z̏ꍇ");

    boolean[] arr1 = { true, true, false, false };
    boolean[] arr2 = {};
    boolean[] arr3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.EQUAL(arr1, arr1, "");
    tester.EQUAL(arr1, arr2, "");
    tester.EQUAL(arr1, arr3, "");
    tester.EQUAL(arr2, arr1, "");
    tester.EQUAL(arr2, arr2, "");
    tester.EQUAL(arr2, arr3, "");
    tester.EQUAL(arr3, arr1, "");
    tester.EQUAL(arr3, arr2, "");
    tester.EQUAL(arr3, arr3, "");
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_byteArray_byteArray()
  {
    byte[] arr1 = { (byte)0x01, (byte)0x02, (byte)0x03, (byte)0x04 };
    byte[] arr2 = { (byte)0x01, (byte)0x02, (byte)0x03, (byte)0x04 };
    byte[] arr3 = { (byte)0x01, (byte)0xff, (byte)0x05, (byte)0x04 };
    byte[] arr4 = { (byte)0x01, (byte)0x02 };

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.MSG("ʏ̔z̏ꍇ");
    tester.EQUAL(arr1, arr1);
    tester.EQUAL(arr1, arr2);
    tester.EQUAL(arr1, arr3);
    tester.EQUAL(arr1, arr4);
    tester.EQUAL(arr4, arr1);
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_byteArray_byteArray_1()
  {
    byte[] arr1 = { (byte)0x01, (byte)0x02, (byte)0x03, (byte)0x04 };
    byte[] arr2 = {};

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.MSG("TCY[̔z̏ꍇ");
    tester.EQUAL(arr1, arr1);
    tester.EQUAL(arr1, arr2);
    tester.EQUAL(arr2, arr1);
    tester.EQUAL(arr2, arr2);
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_byteArray_byteArray_2()
  {
    byte[] arr1 = { (byte)0x01, (byte)0x02, (byte)0x03, (byte)0x04 };
    byte[] arr2 = {};
    byte[] arr3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.MSG("z񂪃k̏ꍇ");
    tester.EQUAL(arr1, arr3);
    tester.EQUAL(arr3, arr1);
    tester.EQUAL(arr2, arr3);
    tester.EQUAL(arr3, arr2);
    tester.EQUAL(arr3, arr3);
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_byteArray_byteArray_reason()
  {
    byte[] arr1 = { (byte)0x01, (byte)0x02, (byte)0x03, (byte)0x04 };
    byte[] arr2 = { (byte)0x01, (byte)0x02, (byte)0x03, (byte)0x04 };
    byte[] arr3 = { (byte)0x01, (byte)0xff, (byte)0x05, (byte)0x04 };
    byte[] arr4 = { (byte)0x01, (byte)0x02 };

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.MSG("ʏ̔z̏ꍇ");
    tester.EQUAL(arr1, arr1, "");
    tester.EQUAL(arr1, arr2, "");
    tester.EQUAL(arr1, arr3, "");
    tester.EQUAL(arr1, arr4, "");
    tester.EQUAL(arr4, arr1, "");
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_byteArray_byteArray_reason_1()
  {
    byte[] arr1 = { (byte)0x01, (byte)0x02, (byte)0x03, (byte)0x04 };
    byte[] arr2 = {};

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.MSG("TCY[̔z̏ꍇ");
    tester.EQUAL(arr1, arr1, "");
    tester.EQUAL(arr1, arr2, "");
    tester.EQUAL(arr2, arr1, "");
    tester.EQUAL(arr2, arr2, "");
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_byteArray_byteArray_reason_2()
  {
    byte[] arr1 = { (byte)0x01, (byte)0x02, (byte)0x03, (byte)0x04 };
    byte[] arr2 = {};
    byte[] arr3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.MSG("z񂪃k̏ꍇ");
    tester.EQUAL(arr1, arr3, "");
    tester.EQUAL(arr3, arr1, "");
    tester.EQUAL(arr2, arr3, "");
    tester.EQUAL(arr3, arr2, "");
    tester.EQUAL(arr3, arr3, "");
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_charArray_charArray()
  {
    char[] arr1 = { 'a', 'A', 'b', 'B' };
    char[] arr2 = { 'a', 'A', 'b', 'B' };
    char[] arr3 = { 'x', 'y', 'z', '0' };
    char[] arr4 = { 'a', 'b' };

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.MSG("ʏ̔z̏ꍇ");
    tester.EQUAL(arr1, arr1);
    tester.EQUAL(arr1, arr2);
    tester.EQUAL(arr1, arr3);
    tester.EQUAL(arr1, arr4);
    tester.EQUAL(arr4, arr1);
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_charArray_charArray_1()
  {
    char[] arr1 = { 'a', 'A', 'b', 'B' };
    char[] arr2 = {};

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("1");
    tester.MSG("TCY[̔z̏ꍇ");
    tester.EQUAL(arr1, arr2);
    tester.EQUAL(arr2, arr1);
    tester.EQUAL(arr2, arr2);
    tester.endInvocation("1");
    tester.endTesting();
  }

  public void EQUAL_charArray_charArray_2()
  {
    char[] arr1 = { 'a', 'A', 'b', 'B' };
    char[] arr2 = {};
    char[] arr3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.MSG("z񂪃k̏ꍇ");
    tester.EQUAL(arr1, arr3);
    tester.EQUAL(arr3, arr1);
    tester.EQUAL(arr2, arr3);
    tester.EQUAL(arr3, arr2);
    tester.EQUAL(arr3, arr3);
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_charArray_charArray_reason()
  {
    char[] arr1 = { 'a', 'A', 'b', 'B' };
    char[] arr2 = { 'a', 'A', 'b', 'B' };
    char[] arr3 = { 'x', 'y', 'z', '0' };
    char[] arr4 = { 'a', 'b' };

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.MSG("ʏ̔z̏ꍇ");
    tester.EQUAL(arr1, arr1, "");
    tester.EQUAL(arr1, arr2, "");
    tester.EQUAL(arr1, arr3, "");
    tester.EQUAL(arr1, arr4, "");
    tester.EQUAL(arr4, arr1, "");
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_charArray_charArray_reason_1()
  {
    char[] arr1 = { 'a', 'A', 'b', 'B' };
    char[] arr2 = {};

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("1");
    tester.MSG("TCY[̔z̏ꍇ");
    tester.EQUAL(arr1, arr2, "");
    tester.EQUAL(arr2, arr1, "");
    tester.EQUAL(arr2, arr2, "");
    tester.endInvocation("1");
    tester.endTesting();
  }

  public void EQUAL_charArray_charArray_reason_2()
  {
    char[] arr1 = { 'a', 'A', 'b', 'B' };
    char[] arr2 = {};
    char[] arr3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("a");
    tester.MSG("z񂪃k̏ꍇ");
    tester.EQUAL(arr1, arr3, "");
    tester.EQUAL(arr3, arr1, "");
    tester.EQUAL(arr2, arr3, "");
    tester.EQUAL(arr3, arr2, "");
    tester.EQUAL(arr3, arr3, "");
    tester.endInvocation("a");
    tester.endTesting();
  }

  public void EQUAL_shortArray_shortArray()
  {
    short[] arr1 = { (short)123, (short)444, (short)-56 };
    short[] arr2 = { (short)123, (short)444, (short)-56 };
    short[] arr3 = { (short)188, (short)-999, (short)0 };
    short[] arr4 = { (short)123 };

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("short array");
    tester.MSG("ʏ̔z̏ꍇ");
    tester.EQUAL(arr1, arr1);
    tester.EQUAL(arr1, arr2);
    tester.EQUAL(arr1, arr3);
    tester.EQUAL(arr1, arr4);
    tester.EQUAL(arr4, arr1);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_shortArray_shortArray_1()
  {
    short[] arr1 = { (short)123, (short)444, (short)-56 };
    short[] arr2 = {}; 

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("short array");
    tester.MSG("TCY[̔z̏ꍇ");
    tester.EQUAL(arr1, arr1);
    tester.EQUAL(arr1, arr2);
    tester.EQUAL(arr2, arr1);
    tester.EQUAL(arr2, arr2);
    tester.endInvocation("short array");
    tester.endTesting();
  }

  public void EQUAL_shortArray_shortArray_2()
  {
    short[] arr1 = { (short)123, (short)444, (short)-56 };
    short[] arr2 = {}; 
    short[] arr3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("short array");
    tester.MSG("z񂪃k̏ꍇ");
    tester.EQUAL(arr1, arr3);
    tester.EQUAL(arr3, arr1);
    tester.EQUAL(arr2, arr3);
    tester.EQUAL(arr3, arr2);
    tester.EQUAL(arr3, arr3);
    tester.endInvocation("short array");
    tester.endTesting();
  }

  public void EQUAL_shortArray_shortArray_reason()
  {
    short[] arr1 = { (short)123, (short)444, (short)-56 };
    short[] arr2 = { (short)123, (short)444, (short)-56 };
    short[] arr3 = { (short)188, (short)-999, (short)0 };
    short[] arr4 = { (short)123 };

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("short array");
    tester.MSG("ʏ̔z̏ꍇ");
    tester.EQUAL(arr1, arr1, "");
    tester.EQUAL(arr1, arr2, "");
    tester.EQUAL(arr1, arr3, "");
    tester.EQUAL(arr1, arr4, "");
    tester.EQUAL(arr4, arr1, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_shortArray_shortArray_reason_1()
  {
    short[] arr1 = { (short)123, (short)444, (short)-56 };
    short[] arr2 = {}; 

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("short array");
    tester.MSG("TCY[̔z̏ꍇ");
    tester.EQUAL(arr1, arr1, "");
    tester.EQUAL(arr1, arr2, "");
    tester.EQUAL(arr2, arr1, "");
    tester.EQUAL(arr2, arr2, "");
    tester.endInvocation("short array");
    tester.endTesting();
  }

  public void EQUAL_shortArray_shortArray_reason_2()
  {
    short[] arr1 = { (short)123, (short)444, (short)-56 };
    short[] arr2 = {}; 
    short[] arr3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("short array");
    tester.MSG("z񂪃k̏ꍇ");
    tester.EQUAL(arr1, arr3, "");
    tester.EQUAL(arr3, arr1, "");
    tester.EQUAL(arr2, arr3, "");
    tester.EQUAL(arr3, arr2, "");
    tester.EQUAL(arr3, arr3, "");
    tester.endInvocation("short array");
    tester.endTesting();
  }

  public void EQUAL_intArray_intArray()
  {
    int[] arr1 = { 99, 88, 77, 66 };
    int[] arr2 = { 99, 88, 77, 66 };
    int[] arr3 = { 99, 11, 77, 22 };
    int[] arr4 = { 99, 88 };

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("int array");
    tester.MSG("ʏ̔z̏ꍇ");
    tester.EQUAL(arr1, arr1);
    tester.EQUAL(arr1, arr2);
    tester.EQUAL(arr1, arr3);
    tester.EQUAL(arr1, arr4);
    tester.EQUAL(arr4, arr1);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_intArray_intArray_1()
  {
    int[] arr1 = { 99, 88, 77, 66 };
    int[] arr2 = {};

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("int array");
    tester.MSG("TCY[̔z");
    tester.EQUAL(arr1, arr1);
    tester.EQUAL(arr1, arr2);
    tester.EQUAL(arr2, arr1);
    tester.EQUAL(arr2, arr2);
    tester.endInvocation("int array");
    tester.endTesting();
  }

  public void EQUAL_intArray_intArray_2()
  {
    int[] arr1 = { 99, 88, 77, 66 };
    int[] arr2 = {};
    int[] arr3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("int array");
    tester.MSG("z񂪃k̏ꍇ");
    tester.EQUAL(arr1, arr3);
    tester.EQUAL(arr3, arr1);
    tester.EQUAL(arr2, arr3);
    tester.EQUAL(arr3, arr2);
    tester.EQUAL(arr3, arr3);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_intArray_intArray_reason()
  {
    int[] arr1 = { 99, 88, 77, 66 };
    int[] arr2 = { 99, 88, 77, 66 };
    int[] arr3 = { 99, 11, 77, 22 };
    int[] arr4 = { 99, 88 };

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("int array");
    tester.MSG("ʏ̔z̏ꍇ");
    tester.EQUAL(arr1, arr1, "");
    tester.EQUAL(arr1, arr2, "");
    tester.EQUAL(arr1, arr3, "");
    tester.EQUAL(arr1, arr4, "");
    tester.EQUAL(arr4, arr1, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_intArray_intArray_reason_1()
  {
    int[] arr1 = { 99, 88, 77, 66 };
    int[] arr2 = {};

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("int array");
    tester.MSG("TCY[̔z");
    tester.EQUAL(arr1, arr1, "");
    tester.EQUAL(arr1, arr2, "");
    tester.EQUAL(arr2, arr1, "");
    tester.EQUAL(arr2, arr2, "");
    tester.endInvocation("int array");
    tester.endTesting();
  }

  public void EQUAL_intArray_intArray_reason_2()
  {
    int[] arr1 = { 99, 88, 77, 66 };
    int[] arr2 = {};
    int[] arr3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("int array");
    tester.MSG("z񂪃k̏ꍇ");
    tester.EQUAL(arr1, arr3, "");
    tester.EQUAL(arr3, arr1, "");
    tester.EQUAL(arr2, arr3, "");
    tester.EQUAL(arr3, arr2, "");
    tester.EQUAL(arr3, arr3, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_longArray_longArray()
  {
    long[] arr1 = { 1234L, 5678L, 9012L, 3456L };
    long[] arr2 = { 1234L, 5678L, 9012L, 3456L };
    long[] arr3 = { 1234L, 9072L, 8888L, 5656L };
    long[] arr4 = { 1234L, 5678L };

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("long array");
    tester.MSG("ʏ̔z̏ꍇ");
    tester.EQUAL(arr1, arr1);
    tester.EQUAL(arr1, arr2);
    tester.EQUAL(arr1, arr3);
    tester.EQUAL(arr1, arr4);
    tester.EQUAL(arr4, arr1);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_longArray_longArray_1()
  {
    long[] arr1 = { 1234L, 5678L, 9012L, 3456L };
    long[] arr2 = {};

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("long array");
    tester.MSG("TCY[̔z̏ꍇ");
    tester.EQUAL(arr1, arr1);
    tester.EQUAL(arr1, arr2);
    tester.EQUAL(arr2, arr1);
    tester.EQUAL(arr2, arr2);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_longArray_longArray_2()
  {
    long[] arr1 = { 1234L, 5678L, 9012L, 3456L };
    long[] arr2 = {};
    long[] arr3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("long array");
    tester.MSG("z񂪃k̏ꍇ");
    tester.EQUAL(arr1, arr3);
    tester.EQUAL(arr3, arr1);
    tester.EQUAL(arr2, arr3);
    tester.EQUAL(arr3, arr2);
    tester.EQUAL(arr3, arr3);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_longArray_longArray_reason()
  {
    long[] arr1 = { 1234L, 5678L, 9012L, 3456L };
    long[] arr2 = { 1234L, 5678L, 9012L, 3456L };
    long[] arr3 = { 1234L, 9072L, 8888L, 5656L };
    long[] arr4 = { 1234L, 5678L };

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("long array");
    tester.MSG("ʏ̔z̏ꍇ");
    tester.EQUAL(arr1, arr1, "");
    tester.EQUAL(arr1, arr2, "");
    tester.EQUAL(arr1, arr3, "");
    tester.EQUAL(arr1, arr4, "");
    tester.EQUAL(arr4, arr1, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_longArray_longArray_reason_1()
  {
    long[] arr1 = { 1234L, 5678L, 9012L, 3456L };
    long[] arr2 = {};

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("long array");
    tester.MSG("TCY[̔z̏ꍇ");
    tester.EQUAL(arr1, arr1, "");
    tester.EQUAL(arr1, arr2, "");
    tester.EQUAL(arr2, arr1, "");
    tester.EQUAL(arr2, arr2, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_longArray_longArray_reason_2()
  {
    long[] arr1 = { 1234L, 5678L, 9012L, 3456L };
    long[] arr2 = {};
    long[] arr3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("long array");
    tester.MSG("z񂪃k̏ꍇ");
    tester.EQUAL(arr1, arr3, "");
    tester.EQUAL(arr3, arr1, "");
    tester.EQUAL(arr2, arr3, "");
    tester.EQUAL(arr3, arr2, "");
    tester.EQUAL(arr3, arr3, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_floatArray_floatArray()
  {
    float[] arr1 = { 0.123f, 0.45f, 6.78f };
    float[] arr2 = { 0.123f, 0.45f, 6.78f };
    float[] arr3 = { 0.123f, 0.99f, 8.88f };
    float[] arr4 = { 0.123f, 0.45f };

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("float array");
    tester.MSG("ʏ̔z̏ꍇ");
    tester.EQUAL(arr1, arr1);
    tester.EQUAL(arr1, arr2);
    tester.EQUAL(arr1, arr3);
    tester.EQUAL(arr1, arr4);
    tester.EQUAL(arr4, arr1);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_floatArray_floatArray_1()
  {
    float[] arr1 = { 0.123f, 0.45f, 6.78f };
    float[] arr2 = {};

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("float array");
    tester.MSG("TCY[̔z̏ꍇ");
    tester.EQUAL(arr1, arr1);
    tester.EQUAL(arr1, arr2);
    tester.EQUAL(arr2, arr1);
    tester.EQUAL(arr2, arr2);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_floatArray_floatArray_2()
  {
    float[] arr1 = { 0.123f, 0.45f, 6.78f };
    float[] arr2 = {};
    float[] arr3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("float array");
    tester.MSG("z񂪃k̏ꍇ");
    tester.EQUAL(arr1, arr3);
    tester.EQUAL(arr2, arr3);
    tester.EQUAL(arr3, arr1);
    tester.EQUAL(arr3, arr2);
    tester.EQUAL(arr3, arr3);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_floatArray_floatArray_reason()
  {
    float[] arr1 = { 0.123f, 0.45f, 6.78f };
    float[] arr2 = { 0.123f, 0.45f, 6.78f };
    float[] arr3 = { 0.123f, 0.99f, 8.88f };
    float[] arr4 = { 0.123f, 0.45f };

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("float array");
    tester.MSG("ʏ̔z̏ꍇ");
    tester.EQUAL(arr1, arr1, "");
    tester.EQUAL(arr1, arr2, "");
    tester.EQUAL(arr1, arr3, "");
    tester.EQUAL(arr1, arr4, "");
    tester.EQUAL(arr4, arr1, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_floatArray_floatArray_reason_1()
  {
    float[] arr1 = { 0.123f, 0.45f, 6.78f };
    float[] arr2 = {};

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("float array");
    tester.MSG("TCY[̔z̏ꍇ");
    tester.EQUAL(arr1, arr1, "");
    tester.EQUAL(arr1, arr2, "");
    tester.EQUAL(arr2, arr1, "");
    tester.EQUAL(arr2, arr2, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_floatArray_floatArray_reason_2()
  {
    float[] arr1 = { 0.123f, 0.45f, 6.78f };
    float[] arr2 = {};
    float[] arr3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("float array");
    tester.MSG("z񂪃k̏ꍇ");
    tester.EQUAL(arr1, arr3, "");
    tester.EQUAL(arr2, arr3, "");
    tester.EQUAL(arr3, arr1, "");
    tester.EQUAL(arr3, arr2, "");
    tester.EQUAL(arr3, arr3, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_doubleArray_doubleArray()
  {
    double[] arr1 = { 0.0123, 4.567, 8.99 };
    double[] arr2 = { 0.0123, 4.567, 8.99 };
    double[] arr3 = { 0.0123, 0.002, 8.99 };
    double[] arr4 = { 0.0123 };

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("double array");
    tester.MSG("ʏ̑̏ꍇ");
    tester.EQUAL(arr1, arr1);
    tester.EQUAL(arr1, arr2);
    tester.EQUAL(arr1, arr3);
    tester.EQUAL(arr1, arr4);
    tester.EQUAL(arr4, arr1);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_doubleArray_doubleArray_1()
  {
    double[] arr1 = { 0.0123, 4.567, 8.99 };
    double[] arr2 = {};

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("double array");
    tester.MSG("z̃TCY[̏ꍇ");
    tester.EQUAL(arr1, arr1);
    tester.EQUAL(arr1, arr2);
    tester.EQUAL(arr2, arr1);
    tester.EQUAL(arr2, arr2);
    tester.endInvocation("");
    tester.endTesting();

  }

  public void EQUAL_doubleArray_doubleArray_2()
  {
    double[] arr1 = { 0.0123, 4.567, 8.99 };
    double[] arr2 = {};
    double[] arr3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("double array");
    tester.MSG("z񂪃k̏ꍇ");
    tester.EQUAL(arr1, arr3);
    tester.EQUAL(arr3, arr1);
    tester.EQUAL(arr2, arr3);
    tester.EQUAL(arr3, arr2);
    tester.EQUAL(arr3, arr3);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_doubleArray_doubleArray_reason()
  {
    double[] arr1 = { 0.0123, 4.567, 8.99 };
    double[] arr2 = { 0.0123, 4.567, 8.99 };
    double[] arr3 = { 0.0123, 0.002, 8.99 };
    double[] arr4 = { 0.0123 };

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("double array");
    tester.MSG("ʏ̑̏ꍇ");
    tester.EQUAL(arr1, arr1, "");
    tester.EQUAL(arr1, arr2, "");
    tester.EQUAL(arr1, arr3, "");
    tester.EQUAL(arr1, arr4, "");
    tester.EQUAL(arr4, arr1, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_doubleArray_doubleArray_reason_1()
  {
    double[] arr1 = { 0.0123, 4.567, 8.99 };
    double[] arr2 = {};

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("double array");
    tester.MSG("z̃TCY[̏ꍇ");
    tester.EQUAL(arr1, arr1, "");
    tester.EQUAL(arr1, arr2, "");
    tester.EQUAL(arr2, arr1, "");
    tester.EQUAL(arr2, arr2, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_doubleArray_doubleArray_reason_2()
  {
    double[] arr1 = { 0.0123, 4.567, 8.99 };
    double[] arr2 = {};
    double[] arr3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("double array");
    tester.MSG("z񂪃k̏ꍇ");
    tester.EQUAL(arr1, arr3, "");
    tester.EQUAL(arr3, arr1, "");
    tester.EQUAL(arr2, arr3, "");
    tester.EQUAL(arr3, arr2, "");
    tester.EQUAL(arr3, arr3, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_Collection_Collection()
  {
    MSG("ʏ̑̏ꍇ");
    Collection<Integer> coll1 = new HashSet<Integer>();
    coll1.add(new Integer(1234));
    coll1.add(new Integer(56));
    coll1.add(new Integer(789));
    coll1.add(new Integer(0));
    Collection<Integer> coll2 = new HashSet<Integer>();
    coll2.add(new Integer(1234));
    coll2.add(new Integer(56));
    coll2.add(new Integer(789));
    coll2.add(new Integer(0));
    Collection<Integer> coll3 = new HashSet<Integer>();
    coll3.add(new Integer(1234));
    coll3.add(null);
    coll3.add(new Integer(765));
    coll3.add(new Integer(0));
    Collection<Integer> coll4 = new HashSet<Integer>();
    coll4.add(new Integer(1234));
    coll4.add(new Integer(5555));

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("collection");
    tester.EQUAL(coll1, coll1);
    tester.EQUAL(coll1, coll2);
    tester.EQUAL(coll1, coll3);
    tester.EQUAL(coll1, coll4);
    tester.EQUAL(coll4, coll1);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_Collection_Collection_1()
  {
    MSG("̃RNVIuWFNg̏ꍇ");
    Collection<Integer> coll1 = new HashSet<Integer>();
    coll1.add(new Integer(1234));
    coll1.add(new Integer(56));
    coll1.add(new Integer(789));
    coll1.add(new Integer(0));
    Collection<Integer> coll2 = new HashSet<Integer>();

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("collection");
    tester.EQUAL(coll1, coll1);
    tester.EQUAL(coll1, coll2);
    tester.EQUAL(coll2, coll1);
    tester.EQUAL(coll2, coll2);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_Collection_Collection_2()
  {
    MSG("RNVIuWFNgk̏ꍇ");
    Collection<Integer> coll1 = new HashSet<Integer>();
    coll1.add(new Integer(1234));
    coll1.add(new Integer(56));
    coll1.add(new Integer(789));
    coll1.add(new Integer(0));
    Collection<Integer> coll2 = new HashSet<Integer>();
    Collection<Integer> coll3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("collection");
    tester.EQUAL(coll1, coll3);
    tester.EQUAL(coll3, coll1);
    tester.EQUAL(coll2, coll3);
    tester.EQUAL(coll3, coll2);
    tester.EQUAL(coll3, coll3);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_Collection_Collection_reason()
  {
    MSG("ʏ̑̏ꍇ");
    Collection<Integer> coll1 = new HashSet<Integer>();
    coll1.add(new Integer(1234));
    coll1.add(new Integer(56));
    coll1.add(new Integer(789));
    coll1.add(new Integer(0));
    Collection<Integer> coll2 = new HashSet<Integer>();
    coll2.add(new Integer(1234));
    coll2.add(new Integer(56));
    coll2.add(new Integer(789));
    coll2.add(new Integer(0));
    Collection<Integer> coll3 = new HashSet<Integer>();
    coll3.add(new Integer(1234));
    coll3.add(null);
    coll3.add(new Integer(765));
    coll3.add(new Integer(0));
    Collection<Integer> coll4 = new HashSet<Integer>();
    coll4.add(new Integer(1234));
    coll4.add(new Integer(5555));

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("collection");
    tester.EQUAL(coll1, coll1, "");
    tester.EQUAL(coll1, coll2, "");
    tester.EQUAL(coll1, coll3, "");
    tester.EQUAL(coll1, coll4, "");
    tester.EQUAL(coll4, coll1, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_Collection_Collection_reason_1()
  {
    MSG("̃RNVIuWFNg̏ꍇ");
    Collection<Integer> coll1 = new HashSet<Integer>();
    coll1.add(new Integer(1234));
    coll1.add(new Integer(56));
    coll1.add(new Integer(789));
    coll1.add(new Integer(0));
    Collection<Integer> coll2 = new HashSet<Integer>();

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("collection");
    tester.EQUAL(coll1, coll1, "");
    tester.EQUAL(coll1, coll2, "");
    tester.EQUAL(coll2, coll1, "");
    tester.EQUAL(coll2, coll2, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_Collection_Collection_reason_2()
  {
    MSG("RNVIuWFNgk̏ꍇ");
    Collection<Integer> coll1 = new HashSet<Integer>();
    coll1.add(new Integer(1234));
    coll1.add(new Integer(56));
    coll1.add(new Integer(789));
    coll1.add(new Integer(0));
    Collection<Integer> coll2 = new HashSet<Integer>();
    Collection<Integer> coll3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("collection");
    tester.EQUAL(coll1, coll3, "");
    tester.EQUAL(coll3, coll1, "");
    tester.EQUAL(coll2, coll3, "");
    tester.EQUAL(coll3, coll2, "");
    tester.EQUAL(coll3, coll3, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_List_List()
  {
    MSG("ʏ̑̏ꍇ");
    List<Integer> list1 = new ArrayList<Integer>();
    list1.add(new Integer(1234));
    list1.add(new Integer(56));
    list1.add(new Integer(789));
    list1.add(new Integer(0));
    List<Integer> list2 = new ArrayList<Integer>();
    list2.add(new Integer(1234));
    list2.add(new Integer(56));
    list2.add(new Integer(789));
    list2.add(new Integer(0));
    List<Integer> list3 = new ArrayList<Integer>();
    list3.add(new Integer(1234));
    list3.add(null);
    list3.add(new Integer(765));
    list3.add(new Integer(0));
    List<Integer> list4 = new ArrayList<Integer>();
    list4.add(new Integer(1234));
    list4.add(new Integer(5555));

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("listection");
    tester.EQUAL(list1, list1);
    tester.EQUAL(list1, list2);
    tester.EQUAL(list1, list3);
    tester.EQUAL(list1, list4);
    tester.EQUAL(list4, list1);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_List_List_1()
  {
    MSG("̃RNVIuWFNg̏ꍇ");
    List<Integer> list1 = new ArrayList<Integer>();
    list1.add(new Integer(1234));
    list1.add(new Integer(56));
    list1.add(new Integer(789));
    list1.add(new Integer(0));
    List<Integer> list2 = new ArrayList<Integer>();

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("listection");
    tester.EQUAL(list1, list1);
    tester.EQUAL(list1, list2);
    tester.EQUAL(list2, list1);
    tester.EQUAL(list2, list2);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_List_List_2()
  {
    MSG("RNVIuWFNgk̏ꍇ");
    List<Integer> list1 = new ArrayList<Integer>();
    list1.add(new Integer(1234));
    list1.add(new Integer(56));
    list1.add(new Integer(789));
    list1.add(new Integer(0));
    List<Integer> list2 = new ArrayList<Integer>();
    List<Integer> list3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("listection");
    tester.EQUAL(list1, list3);
    tester.EQUAL(list3, list1);
    tester.EQUAL(list2, list3);
    tester.EQUAL(list3, list2);
    tester.EQUAL(list3, list3);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_List_List_reason()
  {
    MSG("ʏ̑̏ꍇ");
    List<Integer> list1 = new ArrayList<Integer>();
    list1.add(new Integer(1234));
    list1.add(new Integer(56));
    list1.add(new Integer(789));
    list1.add(new Integer(0));
    List<Integer> list2 = new ArrayList<Integer>();
    list2.add(new Integer(1234));
    list2.add(new Integer(56));
    list2.add(new Integer(789));
    list2.add(new Integer(0));
    List<Integer> list3 = new ArrayList<Integer>();
    list3.add(new Integer(1234));
    list3.add(null);
    list3.add(new Integer(765));
    list3.add(new Integer(0));
    List<Integer> list4 = new ArrayList<Integer>();
    list4.add(new Integer(1234));
    list4.add(new Integer(5555));

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("listection");
    tester.EQUAL(list1, list1, "");
    tester.EQUAL(list1, list2, "");
    tester.EQUAL(list1, list3, "");
    tester.EQUAL(list1, list4, "");
    tester.EQUAL(list4, list1, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_List_List_reason_1()
  {
    MSG("̃RNVIuWFNg̏ꍇ");
    List<Integer> list1 = new ArrayList<Integer>();
    list1.add(new Integer(1234));
    list1.add(new Integer(56));
    list1.add(new Integer(789));
    list1.add(new Integer(0));
    List<Integer> list2 = new ArrayList<Integer>();

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("listection");
    tester.EQUAL(list1, list1, "");
    tester.EQUAL(list1, list2, "");
    tester.EQUAL(list2, list1, "");
    tester.EQUAL(list2, list2, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_List_List_reason_2()
  {
    MSG("RNVIuWFNgk̏ꍇ");
    List<Integer> list1 = new ArrayList<Integer>();
    list1.add(new Integer(1234));
    list1.add(new Integer(56));
    list1.add(new Integer(789));
    list1.add(new Integer(0));
    List<Integer> list2 = new ArrayList<Integer>();
    List<Integer> list3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("listection");
    tester.EQUAL(list1, list3, "");
    tester.EQUAL(list3, list1, "");
    tester.EQUAL(list2, list3, "");
    tester.EQUAL(list3, list2, "");
    tester.EQUAL(list3, list3, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_Map_Map()
  {
    Map<String,Long> map1 = new HashMap<String,Long>();
    map1.put("key1", new Long(0L));
    map1.put("key2", new Long(987L));
    map1.put("key3", new Long(11111L));
    map1.put("key4", new Long(333L));
    Map<String,Long> map2 = new HashMap<String,Long>();
    map2.put("key1", new Long(0L));
    map2.put("key2", new Long(987L));
    map2.put("key3", new Long(11111L));
    map2.put("key4", new Long(333L));
    Map<String,Long> map3 = new HashMap<String,Long>();
    map3.put("key1", new Long(0L));
    map3.put("key2", null);
    map3.put(null, new Long(11111L));
    map3.put("key4", new Long(333L));
    Map<String,Long> map4 = new HashMap<String,Long>();
    map4.put("key1", new Long(0L));
    map4.put("key2", new Long(987L));

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("map");
    tester.MSG("ʏ̑̏ꍇ");
    tester.EQUAL(map1, map1);
    tester.EQUAL(map1, map2);
    tester.EQUAL(map1, map3);
    tester.EQUAL(map3, map1);
    tester.EQUAL(map1, map4);
    tester.EQUAL(map4, map1);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_Map_Map_1()
  {
    Map<String,Long> map1 = new HashMap<String,Long>();
    map1.put("key1", new Long(0L));
    map1.put("key2", new Long(987L));
    map1.put("key3", new Long(11111L));
    map1.put("key4", new Long(333L));
    Map<String,Long> map2 = new HashMap<String,Long>();

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("map");
    tester.MSG("ʏ̑̏ꍇ");
    tester.EQUAL(map1, map1);
    tester.EQUAL(map1, map2);
    tester.EQUAL(map2, map1);
    tester.EQUAL(map2, map2);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_Map_Map_2()
  {
    Map<String,Long> map1 = new HashMap<String,Long>();
    map1.put("key1", new Long(0L));
    map1.put("key2", new Long(987L));
    map1.put("key3", new Long(11111L));
    map1.put("key4", new Long(333L));
    Map<String,Long> map2 = new HashMap<String,Long>();
    Map<String,Long> map3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("map");
    tester.MSG("ʏ̑̏ꍇ");
    tester.EQUAL(map1, map3);
    tester.EQUAL(map3, map1);
    tester.EQUAL(map2, map3);
    tester.EQUAL(map3, map2);
    tester.EQUAL(map3, map3);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_Map_Map_reason()
  {
    Map<String,Long> map1 = new HashMap<String,Long>();
    map1.put("key1", new Long(0L));
    map1.put("key2", new Long(987L));
    map1.put("key3", new Long(11111L));
    map1.put("key4", new Long(333L));
    Map<String,Long> map2 = new HashMap<String,Long>();
    map2.put("key1", new Long(0L));
    map2.put("key2", new Long(987L));
    map2.put("key3", new Long(11111L));
    map2.put("key4", new Long(333L));
    Map<String,Long> map3 = new HashMap<String,Long>();
    map3.put("key1", new Long(0L));
    map3.put("key2", null);
    map3.put(null, new Long(11111L));
    map3.put("key4", new Long(333L));
    Map<String,Long> map4 = new HashMap<String,Long>();
    map4.put("key1", new Long(0L));
    map4.put("key2", new Long(987L));

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("map");
    tester.MSG("ʏ̑̏ꍇ");
    tester.EQUAL(map1, map1, "");
    tester.EQUAL(map1, map2, "");
    tester.EQUAL(map1, map3, "");
    tester.EQUAL(map3, map1, "");
    tester.EQUAL(map1, map4, "");
    tester.EQUAL(map4, map1, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_Map_Map_reason_1()
  {
    Map<String,Long> map1 = new HashMap<String,Long>();
    map1.put("key1", new Long(0L));
    map1.put("key2", new Long(987L));
    map1.put("key3", new Long(11111L));
    map1.put("key4", new Long(333L));
    Map<String,Long> map2 = new HashMap<String,Long>();

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("map");
    tester.MSG("ʏ̑̏ꍇ");
    tester.EQUAL(map1, map1, "");
    tester.EQUAL(map1, map2, "");
    tester.EQUAL(map2, map1, "");
    tester.EQUAL(map2, map2, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void EQUAL_Map_Map_reason_2()
  {
    Map<String,Long> map1 = new HashMap<String,Long>();
    map1.put("key1", new Long(0L));
    map1.put("key2", new Long(987L));
    map1.put("key3", new Long(11111L));
    map1.put("key4", new Long(333L));
    Map<String,Long> map2 = new HashMap<String,Long>();
    Map<String,Long> map3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("map");
    tester.MSG("ʏ̑̏ꍇ");
    tester.EQUAL(map1, map3, "");
    tester.EQUAL(map3, map1, "");
    tester.EQUAL(map2, map3, "");
    tester.EQUAL(map3, map2, "");
    tester.EQUAL(map3, map3, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void MATCH_String_String()
  {
    String s1 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    String s2 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    String s3 = "0123456789ABCDEFGHIJKLMNOPQRSTuVWXYZ";
    String s4 = "0123456789ABCDEFGHIJKL";
    
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("match strings");
    tester.MSG("ʏ̑̏ꍇ");
    tester.MATCH(s1, s1);
    tester.MATCH(s1, s2);
    tester.MATCH(s1, s3);
    tester.MATCH(s1, s4);
    tester.MATCH(s4, s1);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void MATCH_String_String_1()
  {
    String s1 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    String s2 = "";

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("match strings");
    tester.MSG("󕶎̏ꍇ");
    tester.MATCH(s1, s1);
    tester.MATCH(s1, s2);
    tester.MATCH(s2, s1);
    tester.MATCH(s2, s2);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void MATCH_String_String_2()
  {
    String s1 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    String s2 = "";
    String s3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("match strings");
    tester.MSG("󕶎̏ꍇ");
    tester.MATCH(s1, s3);
    tester.MATCH(s3, s1);
    tester.MATCH(s2, s3);
    tester.MATCH(s3, s2);
    tester.MATCH(s3, s3);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void MATCH_String_String_reason()
  {
    String s1 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    String s2 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    String s3 = "0123456789ABCDEFGHIJKLMNOPQRSTuVWXYZ";
    String s4 = "0123456789ABCDEFGHIJKL";
    
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("match strings");
    tester.MSG("ʏ̑̏ꍇ");
    tester.MATCH(s1, s1, "");
    tester.MATCH(s1, s2, "");
    tester.MATCH(s1, s3, "");
    tester.MATCH(s1, s4, "");
    tester.MATCH(s4, s1, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void MATCH_String_String_reason_1()
  {
    String s1 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    String s2 = "";

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("match strings");
    tester.MSG("󕶎̏ꍇ");
    tester.MATCH(s1, s1, "");
    tester.MATCH(s1, s2, "");
    tester.MATCH(s2, s1, "");
    tester.MATCH(s2, s2, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void MATCH_String_String_reason_2()
  {
    String s1 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    String s2 = "";
    String s3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("match strings");
    tester.MSG("󕶎̏ꍇ");
    tester.MATCH(s1, s3, "");
    tester.MATCH(s3, s1, "");
    tester.MATCH(s2, s3, "");
    tester.MATCH(s3, s2, "");
    tester.MATCH(s3, s3, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void MATCH_StringBuffer_StringBuffer()
  {
    StringBuffer s1 = new StringBuffer("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    StringBuffer s2 = new StringBuffer("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    StringBuffer s3 = new StringBuffer("0123456789ABCDEFGHIJKLMNOPQRSTuVWXYZ");
    StringBuffer s4 = new StringBuffer("0123456789ABCDEFGHIJKL");
    
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("match strings");
    tester.MSG("ʏ̑̏ꍇ");
    tester.MATCH(s1, s1);
    tester.MATCH(s1, s2);
    tester.MATCH(s1, s3);
    tester.MATCH(s1, s4);
    tester.MATCH(s4, s1);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void MATCH_StringBuffer_StringBuffer_1()
  {
    StringBuffer s1 = new StringBuffer("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    StringBuffer s2 = new StringBuffer();

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("match strings");
    tester.MSG("󕶎̏ꍇ");
    tester.MATCH(s1, s1);
    tester.MATCH(s1, s2);
    tester.MATCH(s2, s1);
    tester.MATCH(s2, s2);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void MATCH_StringBuffer_StringBuffer_2()
  {
    StringBuffer s1 = new StringBuffer("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    StringBuffer s2 = new StringBuffer();
    StringBuffer s3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("match strings");
    tester.MSG("󕶎̏ꍇ");
    tester.MATCH(s1, s3);
    tester.MATCH(s3, s1);
    tester.MATCH(s2, s3);
    tester.MATCH(s3, s2);
    tester.MATCH(s3, s3);
    tester.endInvocation("");
    tester.endTesting();
  }

  public void MATCH_StringBuffer_StringBuffer_reason()
  {
    StringBuffer s1 = new StringBuffer("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    StringBuffer s2 = new StringBuffer("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    StringBuffer s3 = new StringBuffer("0123456789ABCDEFGHIJKLMNOPQRSTuVWXYZ");
    StringBuffer s4 = new StringBuffer("0123456789ABCDEFGHIJKL");
    
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("match strings");
    tester.MSG("ʏ̑̏ꍇ");
    tester.MATCH(s1, s1, "");
    tester.MATCH(s1, s2, "");
    tester.MATCH(s1, s3, "");
    tester.MATCH(s1, s4, "");
    tester.MATCH(s4, s1, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void MATCH_StringBuffer_StringBuffer_reason_1()
  {
    StringBuffer s1 = new StringBuffer("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    StringBuffer s2 = new StringBuffer();

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("match strings");
    tester.MSG("󕶎̏ꍇ");
    tester.MATCH(s1, s1, "");
    tester.MATCH(s1, s2, "");
    tester.MATCH(s2, s1, "");
    tester.MATCH(s2, s2, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void MATCH_StringBuffer_StringBuffer_reason_2()
  {
    StringBuffer s1 = new StringBuffer("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    StringBuffer s2 = new StringBuffer();
    StringBuffer s3 = null;

    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("match strings");
    tester.MSG("󕶎̏ꍇ");
    tester.MATCH(s1, s3, "");
    tester.MATCH(s3, s1, "");
    tester.MATCH(s2, s3, "");
    tester.MATCH(s3, s2, "");
    tester.MATCH(s3, s3, "");
    tester.endInvocation("");
    tester.endTesting();
  }

  public void IDENTIFY_Object_Object()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();
    Integer i = new Integer(123);

    tester.MSG("Q̃IuWFNg̏ꍇB");
    tester.IDENTIFY(o, o);
    tester.IDENTIFY(i, i);

    tester.endInvocation("");
    tester.endTesting();
  }

  public void IDENTIFY_Object_Object_1()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o0 = new Object();
    Object o1 = new Object();
    Integer i0 = new Integer(123);
    Integer i1 = new Integer(123);

    tester.MSG("Q̃IuWFNgłȂꍇB");
    tester.IDENTIFY(o0, o1);
    tester.IDENTIFY(i0, i1);

    tester.endInvocation("");
    tester.endTesting();
  }

  public void IDENTIFY_Object_Object_2()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.MSG("Q̃IuWFNĝꂩk̏ꍇB");
    tester.IDENTIFY(o, null);
    tester.IDENTIFY(null, o);
    tester.IDENTIFY(null, null);

    tester.endInvocation("");
    tester.endTesting();
  }

  public void IDENTIFY_Object_Object_reason()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();
    Integer i = new Integer(123);

    tester.MSG("Q̃IuWFNg̏ꍇB");
    tester.IDENTIFY(o, o, "");
    tester.IDENTIFY(i, i, "");

    tester.endInvocation("");
    tester.endTesting();
  }

  public void IDENTIFY_Object_Object_reason_1()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o0 = new Object();
    Object o1 = new Object();
    Integer i0 = new Integer(123);
    Integer i1 = new Integer(123);

    tester.MSG("Q̃IuWFNgłȂꍇB");
    tester.IDENTIFY(o0, o1, "");
    tester.IDENTIFY(i0, i1, "Ă");

    tester.endInvocation("");
    tester.endTesting();
  }

  public void IDENTIFY_Object_Object_reason_2()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.MSG("Q̃IuWFNĝꂩk̏ꍇB");
    tester.IDENTIFY(o, null, "Ȃɂʂ˂");
    tester.IDENTIFY(null, o, "͂Ђӂւ");
    tester.IDENTIFY(null, null, "܂݂ނ߂");

    tester.endInvocation("");
    tester.endTesting();
  }

  public void POSITIVE_short()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.POSITIVE((short)1234);
    tester.POSITIVE((short)0);
    tester.POSITIVE((short)-1234);

    tester.endInvocation("");
    tester.endTesting();
  }

  public void POSITIVE_int()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.POSITIVE(1234);
    tester.POSITIVE(0);
    tester.POSITIVE(-1234);

    tester.endInvocation("");
    tester.endTesting();
  }

  public void POSITIVE_long()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.POSITIVE(1234L);
    tester.POSITIVE(0L);
    tester.POSITIVE(-1234L);

    tester.endInvocation("");
    tester.endTesting();
  }

  public void POSITIVE_float()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.POSITIVE(1.234f);
    tester.POSITIVE(0.0f);
    tester.POSITIVE(-1.234f);

    tester.endInvocation("");
    tester.endTesting();
  }

  public void POSITIVE_double()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.POSITIVE(1.23456789);
    tester.POSITIVE(0.0);
    tester.POSITIVE(-1.23456789);

    tester.endInvocation("");
    tester.endTesting();
  }

  public void NEGATIVE_short()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.NEGATIVE((short)1234);
    tester.NEGATIVE((short)0);
    tester.NEGATIVE((short)-1234);

    tester.endInvocation("");
    tester.endTesting();
  }

  public void NEGATIVE_int()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.NEGATIVE(1234);
    tester.NEGATIVE(0);
    tester.NEGATIVE(-1234);

    tester.endInvocation("");
    tester.endTesting();
  }

  public void NEGATIVE_long()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.NEGATIVE(1234L);
    tester.NEGATIVE(0L);
    tester.NEGATIVE(-1234L);

    tester.endInvocation("");
    tester.endTesting();
  }

  public void NEGATIVE_float()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.NEGATIVE(1.234f);
    tester.NEGATIVE(0.0f);
    tester.NEGATIVE(-1.234f);

    tester.endInvocation("");
    tester.endTesting();
  }

  public void NEGATIVE_double()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.NEGATIVE(1.23456789);
    tester.NEGATIVE(0.0);
    tester.NEGATIVE(-1.23456789);

    tester.endInvocation("");
    tester.endTesting();
  }

  public void POSITIVE_short_reason()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.POSITIVE((short)1234, "");
    tester.POSITIVE((short)0, "");
    tester.POSITIVE((short)-1234, "");

    tester.endInvocation("");
    tester.endTesting();
  }

  public void POSITIVE_int_reason()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.POSITIVE(1234, "");
    tester.POSITIVE(0, "");
    tester.POSITIVE(-1234, "");

    tester.endInvocation("");
    tester.endTesting();
  }

  public void POSITIVE_long_reason()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.POSITIVE(1234L, "");
    tester.POSITIVE(0L, "");
    tester.POSITIVE(-1234L, "");

    tester.endInvocation("");
    tester.endTesting();
  }

  public void POSITIVE_float_reason()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.POSITIVE(1.234f, "");
    tester.POSITIVE(0.0f, "");
    tester.POSITIVE(-1.234f, "");

    tester.endInvocation("");
    tester.endTesting();
  }

  public void POSITIVE_double_reason()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.POSITIVE(1.23456789, "");
    tester.POSITIVE(0.0, "");
    tester.POSITIVE(-1.23456789, "");

    tester.endInvocation("");
    tester.endTesting();
  }

  public void NEGATIVE_short_reason()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.NEGATIVE((short)1234, "");
    tester.NEGATIVE((short)0, "");
    tester.NEGATIVE((short)-1234, "");

    tester.endInvocation("");
    tester.endTesting();
  }

  public void NEGATIVE_int_reason()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.NEGATIVE(1234, "");
    tester.NEGATIVE(0, "");
    tester.NEGATIVE(-1234, "");

    tester.endInvocation("");
    tester.endTesting();
  }

  public void NEGATIVE_long_reason()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.NEGATIVE(1234L, "");
    tester.NEGATIVE(0L, "");
    tester.NEGATIVE(-1234L, "");

    tester.endInvocation("");
    tester.endTesting();
  }

  public void NEGATIVE_float_reason()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.NEGATIVE(1.234f, "");
    tester.NEGATIVE(0.0f, "");
    tester.NEGATIVE(-1.234f, "");

    tester.endInvocation("");
    tester.endTesting();
  }

  public void NEGATIVE_double_reason()
  {
    FunctionTester tester = new FunctionTester();
    tester.initTesting();
    tester.initInvocation("identify");

    Object o = new Object();

    tester.NEGATIVE(1.23456789, "");
    tester.NEGATIVE(0.0, "");
    tester.NEGATIVE(-1.23456789, "");

    tester.endInvocation("");
    tester.endTesting();
  }
}
