/*
 * FileLastModifiedFilterTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.tester.function.ObjectInspector;
import java.io.File;
import java.io.FileFilter;
import java.util.Date;
import ts.util.DateTime;

/**
 * {@link ts.util.file.FileLastModifiedFilter FileLastModifiedFilter}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/05/27 16:13:09 $
 */
public class FileLastModifiedFilterTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(FileLastModifiedFilterTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("FileLastModifiedFilter NX̋@\sB");
  }

  private ObjectInspector oi_ = new ObjectInspector(this);

  protected void preInvocation(String methodName)
  {
    oi_.expect("modifiedAfter_", null);
    oi_.expect("modifiedBefore_", null);
  }

  /* -- test case -- */

  public void constructor_start_end()
  {
    MSG("t@CŏIXV͈̔͂ɂƂRXgN^̊mFB");

    Date start = new DateTime(2007, 2, 10).getDate();
    Date end = new DateTime(2007, 2, 11).getDate();
    FileFilter filter = new FileLastModifiedFilter(start, end);

    oi_.expect("modifiedAfter_", start);
    oi_.expect("modifiedBefore_", end);
    oi_.inspect(filter);

    filter = new FileLastModifiedFilter(null, end);
    oi_.expect("modifiedAfter_", null);
    oi_.expect("modifiedBefore_", end);
    oi_.inspect(filter);

    filter = new FileLastModifiedFilter(start, null);
    oi_.expect("modifiedAfter_", start);
    oi_.expect("modifiedBefore_", null);
    oi_.inspect(filter);

    filter = new FileLastModifiedFilter(end, start);
    oi_.expect("modifiedAfter_", start);
    oi_.expect("modifiedBefore_", end);
    oi_.inspect(filter);
  }

  public void accept()
  {
    MSG("t@C̍XVɊY邩ǂ̔̊mFB");

    File file = new File("./build.xml");
    long lastModified = file.lastModified();

    Date date1 = new Date(lastModified);
    Date date2 = new Date(lastModified - 1L);
    Date date3 = new Date(lastModified + 1L);
    Date date4 = new Date(lastModified - 10L);
    Date date5 = new Date(lastModified + 10L);

    FileLastModifiedFilter filter;
    
    filter = new FileLastModifiedFilter(date1, date1);
    TRUE(filter.accept(file));

    filter = new FileLastModifiedFilter(date2, date2);
    FALSE(filter.accept(file));

    filter = new FileLastModifiedFilter(date3, date3);
    FALSE(filter.accept(file));

    filter = new FileLastModifiedFilter(date1, date2);
    TRUE(filter.accept(file));

    filter = new FileLastModifiedFilter(date2, date1);
    TRUE(filter.accept(file));

    filter = new FileLastModifiedFilter(date1, date3);
    TRUE(filter.accept(file));

    filter = new FileLastModifiedFilter(date3, date1);
    TRUE(filter.accept(file));

    filter = new FileLastModifiedFilter(date2, date3);
    TRUE(filter.accept(file));

    filter = new FileLastModifiedFilter(date3, date2);
    TRUE(filter.accept(file));

    filter = new FileLastModifiedFilter(date4, date5);
    TRUE(filter.accept(file));

    filter = new FileLastModifiedFilter(date5, date4);
    TRUE(filter.accept(file));

    filter = new FileLastModifiedFilter(date2, date4);
    FALSE(filter.accept(file));

    filter = new FileLastModifiedFilter(date4, date2);
    FALSE(filter.accept(file));

    filter = new FileLastModifiedFilter(date3, date5);
    FALSE(filter.accept(file));

    filter = new FileLastModifiedFilter(date5, date3);
    FALSE(filter.accept(file));
  }

  public void accept_1()
  {
    MSG("͈͂̊Jnl܂͏Ilk̏ꍇB");

    File file = new File("./build.xml");
    long lastModified = file.lastModified();

    Date date1 = new Date(lastModified);
    Date date2 = new Date(lastModified - 1L);
    Date date3 = new Date(lastModified + 1L);

    FileLastModifiedFilter filter;
    filter = new FileLastModifiedFilter(date1, null);
    TRUE(filter.accept(file));

    filter = new FileLastModifiedFilter(null, date1);
    TRUE(filter.accept(file));

    filter = new FileLastModifiedFilter(date2, null);
    TRUE(filter.accept(file));

    filter = new FileLastModifiedFilter(null, date2);
    FALSE(filter.accept(file));

    filter = new FileLastModifiedFilter(date3, null);
    FALSE(filter.accept(file));

    filter = new FileLastModifiedFilter(null, date3);
    TRUE(filter.accept(file));
  }

  public void accept_2()
  {
    MSG("͈͂̊JnlяIlƂɃk̏ꍇB");

    File file = new File("./build.xml");

    FileLastModifiedFilter filter = new FileLastModifiedFilter(null, null);
    TRUE(filter.accept(file));
  }

  public void accept_3()
  {
    MSG("k̏ꍇB");

    Date date = new Date();
    FileLastModifiedFilter filter = new FileLastModifiedFilter(date, date);
    try {
      filter.accept(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }
}


