/*
 * ResourceTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.resource;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.ArrayList;

/**
 * <code>Resource</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.3 $, $Date: 2007/05/27 16:13:15 $
 */
public class ResourceTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      group.addPrinter(new ConsolePrinter());
      setPrinter(group);

      run(ResourceTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  class ResourceEx implements Resource
  {
    public String getFirstValue(String key) { return ""; }
    public List<String> getValues(String key) { return null; }
    public String getFirstAttribute(String key, String attr) { return ""; }
    public List<String> getAttributes(String key, String attr) { return null; }
    public Resource getFirstChild(String key) { return Resource.EMPTY; }
    public List<Resource> getChildren(String key) { return null; }
    public void setFirstValue(String key, String value) {}
    public Resource getOrCreateFirstChild(String key) { return Resource.EMPTY; }
    public void removeChildren(String key) {};
    public void load(String path) throws FileNotFoundException, IOException {}
    public void save(String path) throws IOException {}
  }

  /* -- test case -- */

  public void constructor()
  {
    MSG("ftHgRXgN^̊mFB");
    Resource res = new ResourceEx();
    NOTNULL(res);
  }

  public void empty()
  {
    MSG("EMPTYIuWFNg");

    Resource res = Resource.EMPTY;
    EQUAL(res.getFirstValue(""), "");
    EQUAL(res.getFirstValue("aaa"), "");
    EQUAL(res.getValues(""), new ArrayList<String>());
    EQUAL(res.getValues("aaa"), new ArrayList<String>());
    EQUAL(res.getFirstAttribute("", ""), "");
    EQUAL(res.getAttributes("", ""), new ArrayList<String>());
    EQUAL(res.getFirstChild(""), Resource.EMPTY);
    EQUAL(res.getFirstChild("aaa"), Resource.EMPTY);
    EQUAL(res.getChildren(""), new ArrayList<Resource>());
    EQUAL(res.getChildren("aaa"), new ArrayList<Resource>());

    try {
      res.setFirstValue("aaa", null);
      NG();
    } catch (UnsupportedOperationException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      res.getOrCreateFirstChild("aaa");
      NG();
    } catch (UnsupportedOperationException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      res.removeChildren("aaa");
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void empty_1()
  {
    MSG("EMPTYIuWFNgɃkL[ƂĎw");

    Resource res = Resource.EMPTY;
    try {
      res.getFirstValue(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }

    try {
      res.getValues(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }

    try {
      res.getFirstAttribute(null, "a");
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
    try {
      res.getFirstAttribute("a", null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }

    try {
      res.getAttributes(null, "a");
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
    try {
      res.getAttributes("a", null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }

    try {
      res.getFirstChild(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }

    try {
      res.getChildren(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }

    try {
      res.setFirstValue(null, "a");
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
    try {
      res.setFirstValue("a", null);
      NG();
    } catch (UnsupportedOperationException e) {
      OK(e);
    }

    try {
      res.getOrCreateFirstChild(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }

    try {
      res.removeChildren(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }
}
