/*
 * Decompiled with CFR 0.152.
 */
package ts.util;

import java.io.Serializable;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import ts.util.text.StringOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTime
implements Serializable,
Cloneable,
Comparable<DateTime> {
    static final long serialVersionUID = -2327361093160202340L;
    private long dateTimeMillis_;
    private static transient ThreadLocal<Calendar> threadLocalCalendar_ = new ThreadLocal();
    private Calendar calendar_ = null;
    public static final int JANUARY = 1;
    public static final int FEBRUARY = 2;
    public static final int MARCH = 3;
    public static final int APRIL = 4;
    public static final int MAY = 5;
    public static final int JUNE = 6;
    public static final int JULY = 7;
    public static final int AUGUST = 8;
    public static final int SEPTEMBER = 9;
    public static final int OCTOBER = 10;
    public static final int NOVEMBER = 11;
    public static final int DECEMBER = 12;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;

    private static Calendar getTLCalendar() {
        Calendar calendar = threadLocalCalendar_.get();
        if (calendar == null) {
            calendar = new GregorianCalendar();
            calendar.setLenient(false);
            threadLocalCalendar_.set(calendar);
        }
        return calendar;
    }

    private Calendar getInnerCalendar() {
        return this.calendar_ != null ? this.calendar_ : DateTime.getTLCalendar();
    }

    public DateTime() {
        this(System.currentTimeMillis());
    }

    public DateTime(DateTime dateTime) {
        assert (dateTime != null) : "@param:datetime is null.";
        this.setDateTime(dateTime.getDateTimeMillis());
        if (dateTime.calendar_ != null) {
            this.calendar_ = dateTime.calendar_;
        }
    }

    public DateTime(long l) {
        this.setDateTime(l);
    }

    public DateTime(Date date) {
        this.setDateTime(date);
    }

    public DateTime(int n, int n2, int n3) throws IllegalArgumentException {
        this(n, n2, n3, 0, 0, 0);
    }

    public DateTime(int n, int n2, int n3, int n4, int n5, int n6) throws IllegalArgumentException {
        this.setDateTime(n, n2, n3, n4, n5, n6);
    }

    public DateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws IllegalArgumentException {
        this.setDateTime(n, n2, n3, n4, n5, n6, n7);
    }

    public DateTime(Calendar calendar) {
        assert (calendar != null) : "@param:calendar is null.";
        this.calendar_ = calendar;
        this.setDateTime(calendar.getTimeInMillis());
    }

    public long getDateTimeMillis() {
        return this.dateTimeMillis_;
    }

    public Date getDate() {
        return new Date(this.getDateTimeMillis());
    }

    public java.sql.Date getSQLDate() {
        return new java.sql.Date(this.getDateTimeMillis());
    }

    public Time getSQLTime() {
        return new Time(this.getDateTimeMillis());
    }

    public Timestamp getSQLTimestamp() {
        return new Timestamp(this.getDateTimeMillis());
    }

    public Calendar getCalendar() {
        Calendar calendar = (Calendar)this.getInnerCalendar().clone();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        return calendar;
    }

    public TimeZone getTimeZone() {
        return this.getInnerCalendar().getTimeZone();
    }

    public int getEra() {
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        return calendar.get(0);
    }

    public int getYear() {
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        return calendar.get(1);
    }

    public int getMonth() {
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        return calendar.get(2) + 1;
    }

    public int getDay() {
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        return calendar.get(5);
    }

    public int getWeek() {
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        return calendar.get(7);
    }

    public int getHour() {
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        return calendar.get(11);
    }

    public int getMinute() {
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        return calendar.get(12);
    }

    public int getSecond() {
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        return calendar.get(13);
    }

    public void setDateTime(long l) {
        this.dateTimeMillis_ = l;
    }

    public void setDateTime(Date date) {
        assert (date != null) : "@param:date is null.";
        this.setDateTime(date.getTime() - 0L);
    }

    public void setDateTime(int n, int n2, int n3) throws IllegalArgumentException {
        this.setDateTime(n, n2, n3, 0, 0, 0);
    }

    public void setDateTime(int n, int n2, int n3, int n4, int n5, int n6) throws IllegalArgumentException {
        Calendar calendar = this.getInnerCalendar();
        calendar.clear();
        calendar.set(0, calendar.getMaximum(0));
        calendar.set(n, n2 - 1, n3, n4, n5, n6);
        this.setDateTime(calendar.getTimeInMillis());
    }

    public void setDateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws IllegalArgumentException {
        Calendar calendar = this.getInnerCalendar();
        calendar.clear();
        calendar.set(0, n);
        calendar.set(n2, n3 - 1, n4, n5, n6, n7);
        this.setDateTime(calendar.getTimeInMillis());
    }

    public void setStartTimeOfDay() {
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        calendar.clear();
        calendar.set(n, n2, n3, 0, 0, 0);
        this.setDateTime(calendar.getTimeInMillis());
    }

    public void setEndTimeOfDay() {
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        calendar.clear();
        calendar.set(n, n2, n3, 0, 0, 0);
        calendar.add(5, 1);
        this.setDateTime(calendar.getTimeInMillis() - 1L);
    }

    public void setStartDayOfMonth() {
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        calendar.clear();
        calendar.set(n, n2, 1, 0, 0, 0);
        this.setDateTime(calendar.getTimeInMillis());
    }

    public void setEndDayOfMonth() {
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        calendar.clear();
        calendar.set(n, n2, 1, 0, 0, 0);
        calendar.add(2, 1);
        this.setDateTime(calendar.getTimeInMillis() - 1L);
    }

    public void setStartDayOfWeek() {
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        int n4 = calendar.get(7);
        calendar.clear();
        calendar.set(n, n2, n3, 0, 0, 0);
        calendar.add(5, -n4 + 1);
        this.setDateTime(calendar.getTimeInMillis());
    }

    public void setEndDayOfWeek() {
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        int n4 = calendar.get(7);
        calendar.clear();
        calendar.set(n, n2, n3, 0, 0, 0);
        calendar.add(5, 7 - n4 + 1);
        this.setDateTime(calendar.getTimeInMillis() - 1L);
    }

    public void floorMinute(int n) {
        assert (n >= 0) : "@param:minute is null.";
        if (n == 0) {
            return;
        }
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        int n2 = calendar.get(1);
        int n3 = calendar.get(2);
        int n4 = calendar.get(5);
        int n5 = calendar.get(11);
        int n6 = calendar.get(12);
        n6 = n6 / n * n;
        calendar.clear();
        calendar.set(n2, n3, n4, n5, n6, 0);
        this.setDateTime(calendar.getTimeInMillis());
    }

    public void ceilMinute(int n) {
        assert (n >= 0) : "@param:minute is null.";
        if (n == 0) {
            return;
        }
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        int n2 = calendar.get(1);
        int n3 = calendar.get(2);
        int n4 = calendar.get(5);
        int n5 = calendar.get(11);
        int n6 = calendar.get(12);
        n6 = 60 - (60 - n6) / n * n;
        calendar.clear();
        calendar.set(n2, n3, n4, n5, 0, 0);
        calendar.add(12, n6);
        this.setDateTime(calendar.getTimeInMillis());
    }

    public void addYear(int n) {
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        calendar.add(1, n);
        this.setDateTime(calendar.getTimeInMillis());
    }

    public void addMonth(int n) {
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        calendar.add(2, n);
        this.setDateTime(calendar.getTimeInMillis());
    }

    public void addDay(int n) {
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        calendar.add(5, n);
        this.setDateTime(calendar.getTimeInMillis());
    }

    public void addHour(int n) {
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        calendar.add(11, n);
        this.setDateTime(calendar.getTimeInMillis());
    }

    public void addMinute(int n) {
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        calendar.add(12, n);
        this.setDateTime(calendar.getTimeInMillis());
    }

    public void addSecond(int n) {
        Calendar calendar = this.getInnerCalendar();
        calendar.setTimeInMillis(this.getDateTimeMillis());
        calendar.add(13, n);
        this.setDateTime(calendar.getTimeInMillis());
    }

    public int hashCode() {
        return (int)this.getDateTimeMillis();
    }

    protected boolean equalsCalendar(DateTime dateTime) {
        assert (dateTime != null) : "@param:dttm is null.";
        Calendar calendar = this.getInnerCalendar();
        calendar.clear();
        Calendar calendar2 = dateTime.getInnerCalendar();
        calendar2.clear();
        return calendar.equals(calendar2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof DateTime)) {
            return false;
        }
        DateTime dateTime = (DateTime)object;
        if (this.getDateTimeMillis() != dateTime.getDateTimeMillis()) {
            return false;
        }
        return this.equalsCalendar(dateTime);
    }

    @Override
    public int compareTo(DateTime dateTime) throws NullPointerException {
        long l;
        if (!dateTime.equalsCalendar(this)) {
            throw new IllegalArgumentException("Calendar of the specified date-time is different from this.");
        }
        long l2 = this.getDateTimeMillis();
        if (l2 > (l = dateTime.getDateTimeMillis())) {
            return 1;
        }
        if (l2 < l) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return DateTime.toString(this);
    }

    public static String toString(DateTime dateTime) {
        assert (dateTime != null) : "@param:dttm is null.";
        if (dateTime.getEra() == dateTime.getInnerCalendar().getMaximum(0)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return simpleDateFormat.format(dateTime.getDate());
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss (G)");
        return simpleDateFormat.format(dateTime.getDate());
    }

    public static DateTime parseDateTime(String string) throws ParseException {
        assert (string != null) : "@param:str is null.";
        int n = StringOperation.length(string);
        SimpleDateFormat simpleDateFormat = n <= 10 ? new SimpleDateFormat("yyyy-MM-dd") : (n <= 19 ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss (G)"));
        simpleDateFormat.setLenient(false);
        return new DateTime(simpleDateFormat.parse(string));
    }
}

