/*
 * Decompiled with CFR 0.152.
 */
package ts.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedString;
import javax.imageio.ImageIO;
import ts.graph.FillStyle;
import ts.graph.LineStyle;
import ts.graph.TextStyle;

public abstract class GraphImage {
    public static final String TYPE_PNG = "png";
    public static final String TYPE_JPEG = "jpeg";
    protected static final int W = 0;
    protected static final int H = 1;
    protected static final int L = 0;
    protected static final int T = 1;
    protected static final int R = 2;
    protected static final int B = 3;
    private static final LineStyle DEFAULT_BORDER_STYLE = null;
    private static final LineStyle DEFAULT_LINE_STYLE = new LineStyle(null);
    private static final FillStyle DEFAULT_FILL_STYLE = new FillStyle(null);
    private static final TextStyle DEFAULT_TEXT_STYLE = new TextStyle();
    private int[] imageSize_ = new int[]{0, 0};
    private int[] margin_ = new int[]{0, 0, 0, 0};
    private Color bgColor_ = Color.white;
    private LineStyle borderStyle_ = DEFAULT_BORDER_STYLE;
    private LineStyle lineStyle_ = DEFAULT_LINE_STYLE;
    private boolean lineStyleChanged_ = true;
    private FillStyle fillStyle_ = DEFAULT_FILL_STYLE;
    private boolean fillStyleChanged_ = true;
    private TextStyle textStyle_ = DEFAULT_TEXT_STYLE;
    private boolean textStyleChanged_ = true;
    private AffineTransform transformer_ = new AffineTransform();
    private Graphics2D graphics_ = null;

    public GraphImage() {
        this.transformer_.setToTranslation(0.0, 0.0);
        this.transformer_.setToScale(1.0, 1.0);
    }

    public void setSize(int n, int n2) {
        this.imageSize_[0] = Math.max(n, 0);
        this.imageSize_[1] = Math.max(n2, 0);
    }

    public int getWidth() {
        return this.imageSize_[0];
    }

    public int getHeight() {
        return this.imageSize_[1];
    }

    public void setMargin(int n, int n2, int n3, int n4) {
        this.margin_[0] = Math.max(n, 0);
        this.margin_[1] = Math.max(n2, 0);
        this.margin_[2] = Math.max(n3, 0);
        this.margin_[3] = Math.max(n4, 0);
    }

    public int[] getMargin() {
        return this.margin_;
    }

    public void setBgColor(Color color) {
        if (color != null) {
            this.bgColor_ = color;
        }
    }

    public void setBorderStyle(LineStyle lineStyle) {
        this.borderStyle_ = lineStyle;
    }

    public Rectangle getDrawnBounds() {
        int n = this.margin_[0];
        int n2 = this.margin_[1];
        int n3 = this.imageSize_[0] - this.margin_[2];
        int n4 = this.imageSize_[1] - this.margin_[3];
        int n5 = Math.max(n3 - n, 0);
        int n6 = Math.max(n4 - n2, 0);
        n = Math.min(n, this.imageSize_[0]);
        n2 = Math.min(n2, this.imageSize_[1]);
        return new Rectangle(n, n2, n5, n6);
    }

    public File createImageFile(String string, String string2) throws IOException {
        return this.createImageFile(string, new File(string2));
    }

    public File createImageFile(String string, File file) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 5);
        this.graphics_ = bufferedImage.createGraphics();
        this.setAntiAliasing(true);
        this.setTextAntiAliasing(false);
        this.drawBackGround();
        Rectangle rectangle = this.getDrawnBounds();
        if (this.borderStyle_ != null) {
            this.drawBorder(rectangle);
        }
        this.drawGraph(rectangle);
        ImageIO.write((RenderedImage)bufferedImage, string, file);
        return file;
    }

    public void outputImage(String string, OutputStream outputStream) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 5);
        this.graphics_ = bufferedImage.createGraphics();
        this.drawBackGround();
        Rectangle rectangle = this.getDrawnBounds();
        if (this.borderStyle_ != null) {
            this.drawBorder(rectangle);
        }
        this.drawGraph(rectangle);
        ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
    }

    protected abstract void drawGraph(Rectangle var1);

    protected Graphics2D graphics() {
        return this.graphics_;
    }

    protected void setAntiAliasing(boolean bl) {
        Object object = bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
        this.graphics_.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    protected void setTextAntiAliasing(boolean bl) {
        Object object = bl ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        this.graphics_.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
    }

    protected LineStyle setLineStyle(LineStyle lineStyle) {
        LineStyle lineStyle2 = this.lineStyle_;
        if (this.lineStyle_ != lineStyle) {
            this.lineStyle_ = lineStyle;
            this.lineStyleChanged_ = true;
        }
        return lineStyle2;
    }

    private void loadLineStyle() {
        if (this.lineStyleChanged_) {
            this.lineStyle_.loadStyle(this.graphics());
            this.lineStyleChanged_ = false;
            this.fillStyleChanged_ = true;
        }
    }

    protected FillStyle setFillStyle(FillStyle fillStyle) {
        FillStyle fillStyle2 = this.fillStyle_;
        if (this.fillStyle_ != fillStyle) {
            this.fillStyle_ = fillStyle;
            this.fillStyleChanged_ = true;
        }
        return fillStyle2;
    }

    private void loadFillStyle() {
        if (this.fillStyleChanged_) {
            this.fillStyle_.loadStyle(this.graphics());
            this.fillStyleChanged_ = false;
            this.lineStyleChanged_ = true;
        }
    }

    protected TextStyle setTextStyle(TextStyle textStyle) {
        TextStyle textStyle2 = this.textStyle_;
        if (this.textStyle_ != textStyle) {
            this.textStyle_ = textStyle;
            this.textStyleChanged_ = true;
        }
        return textStyle2;
    }

    private void loadTextStyle() {
        if (this.textStyleChanged_) {
            this.textStyle_.loadStyle(this.graphics());
            this.textStyleChanged_ = false;
        }
    }

    protected void setOrigin(int n, int n2) {
        double d = this.transformer_.getScaleX();
        double d2 = this.transformer_.getScaleY();
        this.transformer_.setTransform(d, 0.0, 0.0, d2, n, n2);
    }

    protected void setScale(double d, double d2) {
        double d3 = this.transformer_.getTranslateX();
        double d4 = this.transformer_.getTranslateY();
        this.transformer_.setTransform(d, 0.0, 0.0, d2, d3, d4);
    }

    protected void drawBackGround() {
        this.graphics().setColor(this.bgColor_);
        this.graphics().fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    protected void drawBorder(Rectangle rectangle) {
        if (this.borderStyle_ != null) {
            this.graphics().setStroke(this.borderStyle_.getStroke());
            this.graphics().setColor(this.borderStyle_.getColor());
            this.graphics().drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }
    }

    protected void drawLine(float f, float f2, float f3, float f4) {
        this.loadLineStyle();
        this.graphics().draw(this.transformer_.createTransformedShape(new Line2D.Double(f, f2, f3, f4)));
    }

    protected void drawRect(float f, float f2, float f3, float f4) {
        this.loadLineStyle();
        this.graphics().draw(this.transformer_.createTransformedShape(new Rectangle2D.Float(f, f2, f3 - f, f4 - f2)));
    }

    protected void fillRect(float f, float f2, float f3, float f4) {
        this.loadFillStyle();
        this.graphics().fill(this.transformer_.createTransformedShape(new Rectangle2D.Float(f, f2, f3 - f, f4 - f2)));
        if (this.fillStyle_.hasOutline()) {
            this.drawRect(f, f2, f3, f4);
        }
    }

    protected void drawPolyLine(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Array size of x and y are not equal.");
        }
        this.loadLineStyle();
        GeneralPath generalPath = new GeneralPath();
        if (fArray.length > 0) {
            generalPath.moveTo(fArray[0], fArray2[0]);
            for (int i = 1; i < fArray.length; ++i) {
                generalPath.lineTo(fArray[i], fArray2[i]);
            }
        }
        this.graphics().draw(this.transformer_.createTransformedShape(generalPath));
    }

    protected void drawPolygon(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Array size of x and y are not equal.");
        }
        this.loadLineStyle();
        GeneralPath generalPath = new GeneralPath();
        if (fArray.length > 0) {
            generalPath.moveTo(fArray[0], fArray2[0]);
            for (int i = 1; i < fArray.length; ++i) {
                generalPath.lineTo(fArray[i], fArray2[i]);
            }
            generalPath.closePath();
        }
        this.graphics().draw(this.transformer_.createTransformedShape(generalPath));
    }

    protected void fillPolygon(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Array size of x and y are not equal.");
        }
        this.loadFillStyle();
        GeneralPath generalPath = new GeneralPath();
        if (fArray.length > 0) {
            generalPath.moveTo(fArray[0], fArray2[0]);
            for (int i = 1; i < fArray.length; ++i) {
                generalPath.lineTo(fArray[i], fArray2[i]);
            }
            generalPath.closePath();
        }
        this.graphics().fill(this.transformer_.createTransformedShape(generalPath));
        if (this.fillStyle_.hasOutline()) {
            this.drawPolygon(fArray, fArray2);
        }
    }

    protected void drawCircle(float f, float f2, float f3) {
        this.loadLineStyle();
        this.graphics().draw(this.transformer_.createTransformedShape(new Ellipse2D.Float(f - f3, f2 - f3, f3 * 2.0f - 1.0f, f3 * 2.0f - 1.0f)));
    }

    protected void fillCircle(float f, float f2, float f3) {
        this.loadFillStyle();
        this.graphics().fill(this.transformer_.createTransformedShape(new Ellipse2D.Float(f - f3, f2 - f3, f3 * 2.0f - 1.0f, f3 * 2.0f - 1.0f)));
        if (this.fillStyle_.hasOutline()) {
            this.drawCircle(f, f2, f3);
        }
    }

    protected void drawEllipse(float f, float f2, float f3, float f4) {
        this.loadLineStyle();
        this.graphics().draw(this.transformer_.createTransformedShape(new Ellipse2D.Float(f - f3, f2 - f4, f3 * 2.0f - 1.0f, f4 * 2.0f - 1.0f)));
    }

    protected void fillEllipse(float f, float f2, float f3, float f4) {
        this.loadFillStyle();
        this.graphics().fill(this.transformer_.createTransformedShape(new Ellipse2D.Float(f - f3, f2 - f4, f3 * 2.0f - 1.0f, f4 * 2.0f - 1.0f)));
        if (this.fillStyle_.hasOutline()) {
            this.drawEllipse(f, f2, f3, f4);
        }
    }

    protected void drawArc(float f, float f2, float f3, float f4, float f5, float f6) {
        this.loadLineStyle();
        this.graphics().draw(this.transformer_.createTransformedShape(new Arc2D.Float(f - f3, f2 - f4, f3 * 2.0f - 1.0f, f4 * 2.0f - 1.0f, f5, f6 - f5, 2)));
    }

    protected void fillArc(float f, float f2, float f3, float f4, float f5, float f6) {
        this.loadFillStyle();
        this.graphics().fill(this.transformer_.createTransformedShape(new Arc2D.Float(f - f3, f2 - f4, f3 * 2.0f - 1.0f, f4 * 2.0f - 1.0f, f5, f6 - f5, 2)));
        if (this.fillStyle_.hasOutline()) {
            this.drawArc(f, f2, f3, f4, f5, f6);
        }
    }

    protected void drawText(String string, float f, float f2) {
        this.drawText(string, f, f2, 0.0f);
    }

    protected void drawText(String string, float f, float f2, float f3) {
        this.loadTextStyle();
        Font font = this.graphics().getFont();
        AttributedString attributedString = new AttributedString(string, font.getAttributes());
        double d = (double)f3 * Math.PI / 180.0;
        double d2 = this.transformer_.getScaleX();
        double d3 = this.transformer_.getScaleY();
        double d4 = d2 * (double)f + this.transformer_.getTranslateX();
        double d5 = d3 * (double)f2 + this.transformer_.getTranslateY();
        this.graphics().translate(d4, d5);
        this.graphics().rotate(d);
        this.graphics().drawString(attributedString.getIterator(), 0, 0);
        this.graphics().rotate(-d);
        this.graphics().translate(-d4, -d5);
    }

    protected float[] getTextSize(String string) {
        this.loadTextStyle();
        FontMetrics fontMetrics = this.graphics().getFontMetrics();
        float[] fArray = new float[]{fontMetrics.stringWidth(string), fontMetrics.getHeight()};
        return fArray;
    }

    protected float[] getTextDrawnBounds(String string, float f, float f2) {
        float[] fArray;
        float[] fArray2 = this.getTextSize(string);
        double d = this.transformer_.getScaleX();
        double d2 = this.transformer_.getScaleY();
        double d3 = (double)fArray2[0] / d;
        double d4 = (double)fArray2[1] / d2;
        double d5 = 3.0 / d2;
        fArray = new float[]{f, (float)((double)f2 - d4 + d5), fArray[0] + (float)d3, fArray[1] + (float)d4};
        return fArray;
    }

    protected float[] getTextDrawnBounds(String string, float f, float f2, float f3) {
        float[] fArray = this.getTextSize(string);
        double d = this.transformer_.getScaleX();
        double d2 = this.transformer_.getScaleY();
        double d3 = (double)f3 * Math.PI / 180.0;
        double d4 = 3.0;
        float[] fArray2 = new float[]{(float)(-d4 * Math.sin(d3)), (float)(-((double)fArray[1] - d4) * Math.cos(d3)), (float)((double)fArray[0] * Math.cos(d3) + ((double)fArray[1] - d4) * Math.sin(d3)), (float)((double)fArray[0] * Math.sin(d3) + d4 * Math.cos(d3))};
        fArray2[0] = f + fArray2[0] / (float)d;
        fArray2[1] = f2 + fArray2[1] / (float)d2;
        fArray2[2] = f + fArray2[2] / (float)d;
        fArray2[3] = f2 + fArray2[3] / (float)d2;
        return fArray2;
    }

    void drawGrid(int n, int n2) {
        int n3;
        this.setLineStyle(new LineStyle(Color.lightGray, 1));
        int[] nArray = this.getMargin();
        int n4 = nArray[0];
        int n5 = nArray[1];
        int n6 = Math.max(this.getWidth() - nArray[2], 0);
        int n7 = Math.max(this.getHeight() - nArray[3], 0);
        for (n3 = n4; n3 <= n6; n3 += n) {
            this.drawLine(n3, n5, n3, n7);
        }
        for (n3 = n5; n3 <= n7; n3 += n2) {
            this.drawLine(n4, n3, n6, n3);
        }
    }
}

