/*
 * Decompiled with CFR 0.152.
 */
package ts.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class LineStyle {
    private Color color_;
    private Stroke stroke_;
    public static final int TYPE_SOLID = 0;
    public static final int TYPE_DASH = 10;
    public static final int TYPE_ROUGH_DASH = 11;
    public static final int TYPE_FINE_DASH = 12;
    public static final int TYPE_DOT = 20;
    public static final int TYPE_ROUGH_DOT = 21;
    public static final int TYPE_FINE_DOT = 22;

    public LineStyle(Color color) {
        this(color, 1, 0);
    }

    public LineStyle(Color color, int n) {
        this(color, n, 0);
    }

    public LineStyle(Color color, int n, int n2) {
        this(color, n, n2, 2, 1);
    }

    public LineStyle(Color color, int n, int n2, int n3, int n4) {
        this.color_ = color != null ? color : Color.black;
        this.stroke_ = this.createStroke(n, n2, n3, n4);
    }

    public LineStyle(Color color, int n, float[] fArray, int n2, int n3) {
        this.color_ = color != null ? color : Color.black;
        this.stroke_ = new BasicStroke(Math.max(n, 0), n2, n3, 10.0f, fArray, 0.0f);
    }

    public Stroke getStroke() {
        return this.stroke_;
    }

    public Color getColor() {
        return this.color_;
    }

    protected Stroke createStroke(int n, int n2, int n3, int n4) {
        n = Math.max(n, 0);
        switch (n2) {
            case 0: {
                return new BasicStroke(n, n3, n4);
            }
            case 10: {
                int n5 = Math.max(n, 3);
                float[] fArray = new float[]{(float)n5 * 2.0f, (float)n5 * 3.0f};
                return new BasicStroke(n, n3, n4, 10.0f, fArray, 0.0f);
            }
            case 11: {
                int n6 = Math.max(n, 3);
                float[] fArray = new float[]{(float)n6 * 2.0f, (float)n6 * 5.0f};
                return new BasicStroke(n, n3, n4, 10.0f, fArray, 0.0f);
            }
            case 12: {
                int n7 = Math.max(n, 3);
                float[] fArray = new float[]{(float)n7 * 2.0f, (float)n7 * 2.0f};
                return new BasicStroke(n, n3, n4, 10.0f, fArray, 0.0f);
            }
            case 20: {
                int n8 = Math.max(n, 3);
                float[] fArray = new float[]{1.0f, (float)n8 * 3.0f};
                return new BasicStroke(n, n3, n4, 10.0f, fArray, 0.0f);
            }
            case 21: {
                int n9 = Math.max(n, 3);
                float[] fArray = new float[]{1.0f, (float)n9 * 5.0f};
                return new BasicStroke(n, n3, n4, 10.0f, fArray, 0.0f);
            }
            case 22: {
                int n10 = Math.max(n, 3);
                float[] fArray = new float[]{1.0f, (float)n10 * 2.0f};
                return new BasicStroke(n, n3, n4, 10.0f, fArray, 0.0f);
            }
        }
        return new BasicStroke(n, n3, n4);
    }

    protected void loadStyle(Graphics2D graphics2D) {
        graphics2D.setColor(this.getColor());
        graphics2D.setStroke(this.getStroke());
    }
}

