/*
 * Decompiled with CFR 0.152.
 */
package ts.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Map;
import ts.graph.ColorStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextStyle {
    private Map<TextAttribute, Object> attrMap_ = new HashMap<TextAttribute, Object>();

    public TextStyle() {
    }

    public TextStyle(Color color) {
        this.setColor(color);
    }

    public TextStyle(Color color, float f) {
        this.setColor(color);
        this.setSize(f);
    }

    public TextStyle(Color color, String string, float f) {
        this.setColor(color);
        this.setFontFamily(string);
        this.setSize(f);
    }

    public TextStyle(Color color, float f, boolean bl, boolean bl2) {
        this.setColor(color);
        this.setSize(f);
        this.setBold(bl);
        this.setItalic(bl2);
    }

    public void setColor(Color color) {
        this.attrMap_.put(TextAttribute.FOREGROUND, color != null ? color : Color.black);
    }

    public void setBackGroundColor(Color color) {
        this.attrMap_.put(TextAttribute.BACKGROUND, color != null ? color : ColorStyle.TRANSPARENT);
    }

    public void setSize(float f) {
        this.attrMap_.put(TextAttribute.SIZE, new Float(f < 0.0f ? 0.0f : f));
    }

    public void setFontFamily(String string) {
        if (string != null) {
            this.attrMap_.put(TextAttribute.FAMILY, string);
        } else {
            this.attrMap_.remove(TextAttribute.FAMILY);
        }
    }

    public void setBold(boolean bl) {
        if (bl) {
            this.attrMap_.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else {
            this.attrMap_.remove(TextAttribute.WEIGHT);
        }
    }

    public void setItalic(boolean bl) {
        if (bl) {
            this.attrMap_.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else {
            this.attrMap_.remove(TextAttribute.POSTURE);
        }
    }

    public void setUnderline(boolean bl) {
        if (bl) {
            this.attrMap_.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        } else {
            this.attrMap_.remove(TextAttribute.UNDERLINE);
        }
    }

    public Map<TextAttribute, Object> getAttributeMap() {
        return this.attrMap_;
    }

    public void loadStyle(Graphics2D graphics2D) {
        graphics2D.setFont(new Font(this.getAttributeMap()));
    }
}

