/*
 * LineStyle class.
 *
 * Copyright (C) 2010 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.graph;

import java.awt.Stroke;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;

/**
 * ̃X^C\NXB
 * <br>
 * ̐FAAނȂǂێB
 *
 * @author V.
 * @version $Id: LineStyle.java,v 1.1 2010-10-16 13:47:01 tayu Exp $
 */
public class LineStyle
{
  /** ̐FB */
  private Color color_ ;

  /** ̃Xg[NB */
  private Stroke stroke_ ;

  /** ̎ނł邱Ƃ萔B */
  public final static int TYPE_SOLID = 0;

  /** ̎ނjł邱Ƃ萔B */
  public final static int TYPE_DASH = 10;

  /** ̎ނejł邱Ƃ萔B */
  public final static int TYPE_ROUGH_DASH = 11;

  /** ̎ނׂjł邱Ƃ萔B */
  public final static int TYPE_FINE_DASH = 12;

  /** ̎ނ_ł邱Ƃ萔B */
  public final static int TYPE_DOT = 20;
  
  /** ̎ނe_ł邱Ƃ萔B */
  public final static int TYPE_ROUGH_DOT = 21;

  /** ̎ނׂ_ł邱Ƃ萔B */
  public final static int TYPE_FINE_DOT = 22;

  /**
   * ̐FɂƂRXgN^B
   * <br>
   * ̑1A̎ނ͎ݒ肷B
   * <br>
   * Ƀkw肳ꂽꍇ͍Fݒ肷B
   *
   * @param  color ̐FB
   */
  public LineStyle(Color color)
  {
    this(color, 1, TYPE_SOLID);
  }

  /**
   * ̐FƑɂƂRXgN^B
   * <br>
   * ̎ނ͎ݒ肷B
   * <br>
   * ̐FɃkw肳ꂽꍇ͍Fݒ肷B
   * ̑ɕ̒lw肳ꂽꍇ̓[ݒ肷B
   *
   * @param  color ̐FB
   * @param  width ̑B
   */
  public LineStyle(Color color, int width)
  {
    this(color, width, TYPE_SOLID);
  }

  /**
   * ̐FƑƎނɂƂRXgN^B
   * <br>
   * ̐FɃkw肳ꂽꍇ͍Fݒ肷B
   * ̑ɕ̒lw肳ꂽꍇ̓[ݒ肷B
   * ̎ނɕsȒlݒ肳ꂽꍇ͎ݒ肷B 
   *
   * @param  color ̐FB
   * @param  width ̑B
   * @param  type  ̎ށB 
   */
  public LineStyle(Color color, int width, int type)
  {
    this(color, width, type, BasicStroke.CAP_SQUARE, BasicStroke.JOIN_ROUND);
  }

  /**
   * ̐FƑƎށA[Ɛڍ̌`ɂƂRXgN^B
   * <br>
   * ̐FɃkw肳ꂽꍇ͍Fݒ肷B
   * ̑ɕ̒lw肳ꂽꍇ̓[ݒ肷B
   * ̎ނɕsȒlݒ肳ꂽꍇ͎ݒ肷B 
   *
   * @param  color ̐FB
   * @param  width ̑B
   * @param  type  ̎ށB 
   * @param  cap   ̐[̌`B
   * @param  join  ̐ڑ̌`B
   */
  public LineStyle(Color color, int width, int type, int cap, int join)
  {
    color_ = (color != null) ? color : Color.black;
    stroke_ = createStroke(width, type, cap, join);
  }

  /**
   * ̐FƑƔjp^[A[Ɛڍ̌`ɂƂRXgN^B
   * <br>
   * ̐FɃkw肳ꂽꍇ͍Fݒ肷B
   * ̑ɕ̒lw肳ꂽꍇ̓[ݒ肷B
   * ̎ނɕsȒlݒ肳ꂽꍇ͎ݒ肷B 
   *
   * @param  color ̐FB
   * @param  width ̑B
   * @param  dash  j̃p^[zB
   * @param  cap   ̐[̌`B
   * @param  join  ̐ڑ̌`B
   */
  public LineStyle(Color color, int width, float[] dash, int cap, int join)
  {
    color_ = (color != null) ? color : Color.black;
    stroke_ = new BasicStroke(Math.max(width, 0), cap, join, 10.0f, dash, 0.0f);
  }

  /**
   * {@link java.awt.Stroke Stroke}IuWFNg擾B
   *
   * @return {@link java.awt.Stroke Stroke}IuWFNgB
   */
  public Stroke getStroke()
  {
    return stroke_;
  }

  /**
   * ̐F擾B
   *
   * @return ̐FB
   */
  public Color getColor()
  {
    return color_ ;
  }

  /**
   * {@link java.awt.Stroke Stroke}IuWFNg쐬B
   * 
   * @return {@link java.awt.Stroke Stroke}IuWFNgB
   */
  protected Stroke createStroke(int width, int type, int cap, int join)
  {
    float[] dash;
    int step;

    width = Math.max(width, 0);

    switch (type) {
    case TYPE_SOLID :
      return new BasicStroke(width, cap, join);
    case TYPE_DASH :
      step = Math.max(width, 3);
      dash = new float[2];
      dash[0] = step * 2f;
      dash[1] = step * 3f;
      return new BasicStroke(width, cap, join, 10.0f, dash, 0.0f);
    case TYPE_ROUGH_DASH :
      step = Math.max(width, 3);
      dash = new float[2];
      dash[0] = step * 2f;
      dash[1] = step * 5f;
      return new BasicStroke(width, cap, join, 10.0f, dash, 0.0f);
    case TYPE_FINE_DASH :
      step = Math.max(width, 3);
      dash = new float[2];
      dash[0] = step * 2f;
      dash[1] = step * 2f;
      return new BasicStroke(width, cap, join, 10.0f, dash, 0.0f);
    case TYPE_DOT :
      step = Math.max(width, 3);
      dash = new float[2];
      dash[0] = 1f;
      dash[1] = step * 3f;
      return new BasicStroke(width, cap, join, 10.0f, dash, 0.0f);
    case TYPE_ROUGH_DOT :
      step = Math.max(width, 3);
      dash = new float[2];
      dash[0] = 1f;
      dash[1] = step * 5f;
      return new BasicStroke(width, cap, join, 10.0f, dash, 0.0f);
    case TYPE_FINE_DOT :
      step = Math.max(width, 3);
      dash = new float[2];
      dash[0] = 1f;
      dash[1] = step * 2f;
      return new BasicStroke(width, cap, join, 10.0f, dash, 0.0f);
    default :
      return new BasicStroke(width, cap, join);
    }
  }

  /**
   * OtBbNEIuWFNgɐX^C𔽉fB
   *
   * @param  g OtBbNXEIuWFNgB
   */
  protected void loadStyle(Graphics2D g)
  {
    g.setColor(getColor());
    g.setStroke(getStroke());
  }
}

