/*
 * FillStyle class.
 *
 * Copyright (C) 2010 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.graph;

import java.awt.Color;
import java.awt.Graphics2D;

/**
 * hԂ̃X^C\NXB
 * <br>
 * hԂ̐FAOg̗LȂǂێB
 *
 * @author V.
 * @version $Id: FillStyle.java,v 1.1 2010-10-16 13:46:59 tayu Exp $
 */
public class FillStyle
{
  /** hԂ̐FB */
  private Color color_ ;

  /** Og̗LtOB */
  private boolean hasOutline_ = false;

  /**
   * hԂ̐FɂƂRXgN^B
   * <br>
   * Og͖ɐݒ肷B
   * <br>
   * Ƀkw肳ꂽꍇ͔Fݒ肷B
   *
   * @param  color hԂ̐FB
   */
  public FillStyle(Color color)
  {
    this(color, false);
  }

  /**
   * hԂ̐FƁAOg̗LɂƂRXgN^B
   * <br>
   * Ƀkw肳ꂽꍇ͓ɐݒ肷B
   *
   * @param  color hԂ̐FB
   * @param  needOutline Og̗LBOgLɂꍇ<tt>true</tt>
   *           w肷B
   */
  public FillStyle(Color color, boolean needOutline)
  {
    color_ = (color != null) ? color : ColorStyle.TRANSPARENT;
    hasOutline_ = needOutline;
  }

  /**
   * hԂ̐F擾B
   *
   * @return hԂ̐FB
   */
  public Color getColor()
  {
    return color_ ;
  }

  /**
   * Og̗L擾B
   *
   * @return Og̗LB
   */
  public boolean hasOutline()
  {
    return hasOutline_ ;
  }

  /**
   * OtBbNEIuWFNgɓhԂX^C𔽉fB
   *
   * @param  g OtBbNEIuWFNgB
   */
  protected void loadStyle(Graphics2D g)
  {
    g.setColor(getColor());
  }
}
