/*
 * Decompiled with CFR 0.152.
 */
package ts.util;

import java.math.BigDecimal;
import ts.util.OutOfRangeException;

public class CountUp {
    private long value_;
    private long limit_;

    public CountUp() {
        this(0L, Long.MAX_VALUE);
    }

    public CountUp(long l) {
        this(0L, l);
    }

    public CountUp(long l, long l2) {
        this.value_ = l;
        this.limit_ = l2;
    }

    public long currentValue() {
        return this.value_;
    }

    public long limitValue() {
        return this.limit_;
    }

    public boolean isReached() {
        return this.value_ >= this.limit_;
    }

    public long increment() throws OutOfRangeException {
        if (this.value_ >= this.limit_) {
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(this.value_));
            bigDecimal.add(BigDecimal.valueOf(1L));
            BigDecimal bigDecimal2 = BigDecimal.valueOf(this.limit_);
            throw new OutOfRangeException(bigDecimal, null, bigDecimal2);
        }
        ++this.value_;
        return this.value_;
    }

    public static CountUp synchronizedCountUp() {
        return CountUp.synchronizedCountUp(0L, Long.MAX_VALUE);
    }

    public static CountUp synchronizedCountUp(long l) {
        return CountUp.synchronizedCountUp(0L, l);
    }

    public static CountUp synchronizedCountUp(long l, long l2) {
        return new CountUp(l, l2){

            @Override
            public synchronized long currentValue() {
                return super.currentValue();
            }

            @Override
            public synchronized boolean isReached() {
                return super.isReached();
            }

            @Override
            public synchronized long increment() throws OutOfRangeException {
                return super.increment();
            }
        };
    }

    public static CountUp synchronizedCountUp(CountUp countUp) {
        assert (countUp != null) : "@param:c is null.";
        return CountUp.synchronizedCountUp(countUp.currentValue(), countUp.limitValue());
    }
}

