/*
 * Decompiled with CFR 0.152.
 */
package ts.util;

import java.math.BigDecimal;
import ts.util.OutOfRangeException;

public class CountDown {
    private long value_;
    private long limit_;

    public CountDown(long l) {
        this(l, 0L);
    }

    public CountDown(long l, long l2) {
        this.value_ = l;
        this.limit_ = l2;
    }

    public long currentValue() {
        return this.value_;
    }

    public long limitValue() {
        return this.limit_;
    }

    public boolean isReached() {
        return this.value_ <= this.limit_;
    }

    public long decrement() throws OutOfRangeException {
        if (this.value_ <= this.limit_) {
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(this.value_));
            bigDecimal.subtract(BigDecimal.valueOf(1L));
            BigDecimal bigDecimal2 = BigDecimal.valueOf(this.limit_);
            throw new OutOfRangeException(bigDecimal, bigDecimal2, null);
        }
        --this.value_;
        return this.value_;
    }

    public static CountDown synchronizedCountDown(long l) {
        return CountDown.synchronizedCountDown(l, 0L);
    }

    public static CountDown synchronizedCountDown(long l, long l2) {
        return new CountDown(l, l2){

            @Override
            public synchronized long currentValue() {
                return super.currentValue();
            }

            @Override
            public synchronized boolean isReached() {
                return super.isReached();
            }

            @Override
            public synchronized long decrement() throws OutOfRangeException {
                return super.decrement();
            }
        };
    }

    public static CountDown synchronizedCountDown(CountDown countDown) {
        assert (countDown != null) : "@param:c is null.";
        return CountDown.synchronizedCountDown(countDown.currentValue(), countDown.limitValue());
    }
}

