/*
 * Decompiled with CFR 0.152.
 */
package ts.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ts.util.DateTime;
import ts.util.TypedGetter;

public class TypedMap<K, V>
implements Map<K, V>,
TypedGetter<K> {
    private final Map<K, V> innerMap = this.createInnerMap();
    private final Set<Object> trueSet = new HashSet<Object>();
    private DateFormat dateTimeFormat;

    public TypedMap() {
        this.trueSet.add(Boolean.TRUE);
        this.trueSet.add(Boolean.TRUE.toString());
        this.dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    protected Map<K, V> createInnerMap() {
        return new HashMap();
    }

    @Override
    public int size() {
        return this.innerMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.innerMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.innerMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.innerMap.containsValue(object);
    }

    @Override
    public V get(Object object) {
        return this.innerMap.get(object);
    }

    @Override
    public V put(K k, V v) {
        return this.innerMap.put(k, v);
    }

    @Override
    public V remove(Object object) {
        return this.innerMap.remove(object);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.innerMap.putAll(map);
    }

    @Override
    public void clear() {
        this.innerMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.innerMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.innerMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.innerMap.entrySet();
    }

    @Override
    public boolean equals(Object object) {
        return ((Object)this.innerMap).equals(object);
    }

    @Override
    public int hashCode() {
        return ((Object)this.innerMap).hashCode();
    }

    public void addTrueObject(Object object) {
        this.trueSet.add(object);
    }

    public void removeTrueObject(Object object) {
        this.trueSet.remove(object);
    }

    public void setDateTimeFormat(String string) {
        assert (string != null) : "@param:formatString is null.";
        try {
            this.dateTimeFormat = new SimpleDateFormat(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDateTimeFormat(DateFormat dateFormat) {
        assert (dateFormat != null) : "@param:format is null.";
        if (dateFormat == null) {
            return;
        }
        this.dateTimeFormat = dateFormat;
    }

    @Override
    public boolean getBoolean(K k) {
        return this.trueSet.contains(this.get(k));
    }

    @Override
    public int getInteger(K k) {
        V v = this.get(k);
        if (v == null) {
            return 0;
        }
        if (v instanceof Integer) {
            return (Integer)Integer.class.cast(v);
        }
        if (v instanceof Long) {
            return (int)this.limit((Long)Long.class.cast(v), Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        if (v instanceof BigInteger) {
            return this.limit(new BigDecimal((BigInteger)BigInteger.class.cast(v)), new BigDecimal(Integer.MIN_VALUE), new BigDecimal(Integer.MAX_VALUE)).intValue();
        }
        if (v instanceof BigDecimal) {
            return this.limit((BigDecimal)BigDecimal.class.cast(v), new BigDecimal(Integer.MIN_VALUE), new BigDecimal(Integer.MAX_VALUE)).intValue();
        }
        if (v instanceof Float) {
            return (int)this.limit(((Float)Float.class.cast(v)).floatValue(), -2.1474836E9f, 2.1474836E9f);
        }
        if (v instanceof Double) {
            return (int)this.limit((Double)Double.class.cast(v), -2.147483648E9, 2.147483647E9);
        }
        if (v instanceof Number) {
            return ((Number)Number.class.cast(v)).intValue();
        }
        try {
            return this.limit(new BigDecimal(v.toString(), MathContext.DECIMAL32), new BigDecimal(Integer.MIN_VALUE), new BigDecimal(Integer.MAX_VALUE)).intValue();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public long getLong(K k) {
        V v = this.get(k);
        if (v == null) {
            return 0L;
        }
        if (v instanceof Integer) {
            return ((Integer)Integer.class.cast(v)).intValue();
        }
        if (v instanceof Long) {
            return (Long)Long.class.cast(v);
        }
        if (v instanceof BigInteger) {
            return this.limit(new BigDecimal((BigInteger)BigInteger.class.cast(v)), new BigDecimal(Long.MIN_VALUE), new BigDecimal(Long.MAX_VALUE)).longValue();
        }
        if (v instanceof BigDecimal) {
            return this.limit((BigDecimal)BigDecimal.class.cast(v), new BigDecimal(Long.MIN_VALUE), new BigDecimal(Long.MAX_VALUE)).longValue();
        }
        if (v instanceof Float) {
            return (long)this.limit(((Float)Float.class.cast(v)).floatValue(), -9.223372E18f, 9.223372E18f);
        }
        if (v instanceof Double) {
            return (long)this.limit((Double)Double.class.cast(v), -9.223372036854776E18, 9.223372036854776E18);
        }
        if (v instanceof Number) {
            return ((Number)Number.class.cast(v)).longValue();
        }
        try {
            return this.limit(new BigDecimal(v.toString(), MathContext.DECIMAL64), new BigDecimal(Long.MIN_VALUE), new BigDecimal(Long.MAX_VALUE)).intValue();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    @Override
    public float getFloat(K k) {
        V v = this.get(k);
        if (v == null) {
            return 0.0f;
        }
        if (v instanceof Float) {
            return ((Float)Float.class.cast(v)).floatValue();
        }
        if (v instanceof Double) {
            return new BigDecimal((Double)Double.class.cast(v)).floatValue();
        }
        if (v instanceof BigInteger) {
            return new BigDecimal((BigInteger)BigInteger.class.cast(v)).floatValue();
        }
        if (v instanceof BigDecimal) {
            return ((BigDecimal)BigDecimal.class.cast(v)).floatValue();
        }
        if (v instanceof Number) {
            return ((Number)Number.class.cast(v)).longValue();
        }
        try {
            return this.limit(new BigDecimal(v.toString(), MathContext.UNLIMITED), new BigDecimal(-1.4E-45f), new BigDecimal(3.4028234663852886E38)).floatValue();
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    @Override
    public double getDouble(K k) {
        V v = this.get(k);
        if (v == null) {
            return 0.0;
        }
        if (v instanceof Float) {
            return ((Float)Float.class.cast(v)).floatValue();
        }
        if (v instanceof Double) {
            return (Double)Double.class.cast(v);
        }
        if (v instanceof BigInteger) {
            return new BigDecimal((BigInteger)BigInteger.class.cast(v)).doubleValue();
        }
        if (v instanceof BigDecimal) {
            return ((BigDecimal)BigDecimal.class.cast(v)).doubleValue();
        }
        if (v instanceof Number) {
            return ((Number)Number.class.cast(v)).longValue();
        }
        try {
            return this.limit(new BigDecimal(v.toString(), MathContext.UNLIMITED), new BigDecimal(-1.7976931348623157E308), new BigDecimal(Double.MAX_VALUE)).doubleValue();
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    @Override
    public BigDecimal getBigDecimal(K k) {
        V v = this.get(k);
        if (v == null) {
            return new BigDecimal(0L);
        }
        if (v instanceof Float) {
            return new BigDecimal(((Float)Float.class.cast(v)).floatValue());
        }
        if (v instanceof Double) {
            return new BigDecimal((Double)Double.class.cast(v));
        }
        if (v instanceof BigInteger) {
            return new BigDecimal((BigInteger)BigInteger.class.cast(v));
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)BigDecimal.class.cast(v);
        }
        if (v instanceof Number) {
            return new BigDecimal(((Number)Number.class.cast(v)).longValue());
        }
        try {
            return new BigDecimal(v.toString(), MathContext.UNLIMITED);
        }
        catch (Exception exception) {
            return new BigDecimal(0L);
        }
    }

    @Override
    public String getString(K k) {
        V v = this.get(k);
        if (v == null) {
            return "";
        }
        if (v instanceof DateTime) {
            return this.dateTimeFormat.format(((DateTime)DateTime.class.cast(v)).getDate());
        }
        if (v instanceof Date) {
            return this.dateTimeFormat.format((Date)Date.class.cast(v));
        }
        return v.toString();
    }

    @Override
    public String getNumberString(K k, String string) {
        assert (string != null) : "@param:format is null.";
        try {
            V v = this.get(k);
            if (v == null) {
                return "";
            }
            if (v instanceof Float) {
                double d = ((Float)Float.class.cast(v)).doubleValue();
                return new DecimalFormat(string).format(d);
            }
            if (v instanceof Double) {
                double d = (Double)Double.class.cast(v);
                return new DecimalFormat(string).format(d);
            }
            if (v instanceof Number) {
                return new DecimalFormat(string).format(Number.class.cast(v));
            }
            return new DecimalFormat(string).format(new BigDecimal(v.toString()));
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public String getDateTimeString(K k, String string) {
        assert (string != null) : "@param:format is null.";
        try {
            V v = this.get(k);
            if (v == null) {
                return "";
            }
            if (v instanceof DateTime) {
                Date date = ((DateTime)DateTime.class.cast(v)).getDate();
                return new SimpleDateFormat(string).format(date);
            }
            if (v instanceof Date) {
                Date date = (Date)Date.class.cast(v);
                return new SimpleDateFormat(string).format(date);
            }
            Date date = this.dateTimeFormat.parse(v.toString());
            return new SimpleDateFormat(string).format(date);
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public DateTime getDateTime(K k) {
        V v = this.get(k);
        if (v == null) {
            return new DateTime(0L);
        }
        if (v instanceof DateTime) {
            return (DateTime)DateTime.class.cast(v);
        }
        if (v instanceof Date) {
            return new DateTime((Date)Date.class.cast(v));
        }
        try {
            return new DateTime(this.dateTimeFormat.parse(v.toString()));
        }
        catch (Exception exception) {
            return new DateTime(0L);
        }
    }

    @Override
    public List<? extends Object> getList(K k) {
        V v = this.get(k);
        if (v == null) {
            return new ArrayList(0);
        }
        if (v instanceof List) {
            return (List)v;
        }
        if (v instanceof Collection) {
            return new ArrayList((Collection)Collection.class.cast(v));
        }
        if (v instanceof Object[]) {
            Object[] objectArray = (Object[])Object[].class.cast(v);
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            for (Object object : objectArray) {
                arrayList.add(object);
            }
            return arrayList;
        }
        if (v instanceof boolean[]) {
            boolean[] blArray = (boolean[])boolean[].class.cast(v);
            ArrayList<Boolean> arrayList = new ArrayList<Boolean>(blArray.length);
            for (boolean bl : blArray) {
                arrayList.add(bl ? Boolean.TRUE : Boolean.FALSE);
            }
            return arrayList;
        }
        if (v instanceof int[]) {
            int[] nArray = (int[])int[].class.cast(v);
            ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
            for (int n : nArray) {
                arrayList.add(new Integer(n));
            }
            return arrayList;
        }
        if (v instanceof long[]) {
            long[] lArray = (long[])long[].class.cast(v);
            ArrayList<Long> arrayList = new ArrayList<Long>(lArray.length);
            for (long l : lArray) {
                arrayList.add(new Long(l));
            }
            return arrayList;
        }
        if (v instanceof float[]) {
            float[] fArray = (float[])float[].class.cast(v);
            ArrayList<Float> arrayList = new ArrayList<Float>(fArray.length);
            for (float f : fArray) {
                arrayList.add(new Float(f));
            }
            return arrayList;
        }
        if (v instanceof double[]) {
            double[] dArray = (double[])double[].class.cast(v);
            ArrayList<Double> arrayList = new ArrayList<Double>(dArray.length);
            for (double d : dArray) {
                arrayList.add(new Double(d));
            }
            return arrayList;
        }
        if (v instanceof short[]) {
            short[] sArray = (short[])short[].class.cast(v);
            ArrayList<Short> arrayList = new ArrayList<Short>(sArray.length);
            for (short s : sArray) {
                arrayList.add(new Short(s));
            }
            return arrayList;
        }
        if (v instanceof byte[]) {
            byte[] byArray = (byte[])byte[].class.cast(v);
            ArrayList<Byte> arrayList = new ArrayList<Byte>(byArray.length);
            for (byte by : byArray) {
                arrayList.add(new Byte(by));
            }
            return arrayList;
        }
        if (v instanceof char[]) {
            char[] cArray = (char[])char[].class.cast(v);
            ArrayList<Character> arrayList = new ArrayList<Character>(cArray.length);
            for (char c : cArray) {
                arrayList.add(new Character(c));
            }
            return arrayList;
        }
        ArrayList<V> arrayList = new ArrayList<V>(1);
        arrayList.add(v);
        return arrayList;
    }

    protected long limit(long l, long l2, long l3) {
        return Math.max(l2, Math.min(l3, l));
    }

    protected float limit(float f, float f2, float f3) {
        return Math.max(f2, Math.min(f3, f));
    }

    protected double limit(double d, double d2, double d3) {
        return Math.max(d2, Math.min(d3, d));
    }

    protected BigDecimal limit(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) {
        if (bigDecimal.compareTo(bigDecimal2) < 0) {
            return bigDecimal2;
        }
        if (bigDecimal.compareTo(bigDecimal3) > 0) {
            return bigDecimal3;
        }
        return bigDecimal;
    }
}

