/*
 * DefaultMapComparatorTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.table;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import java.util.*;

/**
 * {@link ts.util.table.DefaultMapComparator DefaultMapComparator}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:51 $
 */
public class DefaultMapComparatorTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(DefaultMapComparatorTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("DefaultMapComparator NX̋@\sB");
  }
  
  /* -- test case -- */

  public void constructor()
  {
    MSG("RXgN^B");

    DefaultMapComparator<String,Object> comp
      = new DefaultMapComparator<String,Object>();
    FALSE(comp.comparingKeys().hasMoreElements());
  }

  public void constructor_indexKeys()
  {
    MSG("CfbNXEL[̔zɂƂRXgN^B");

    DefaultMapComparator<String,Object> comp
      = new DefaultMapComparator<String,Object>("C0","C1","C2");

    String[] arr = { "C0","C1","C2" };
    List<String> lst = new ArrayList<String>(Arrays.asList(arr));

    Enumeration<String> enm = comp.comparingKeys();
    TRUE(enm.hasMoreElements());
    TRUE(lst.remove(enm.nextElement()));
    TRUE(enm.hasMoreElements());
    TRUE(lst.remove(enm.nextElement()));
    TRUE(enm.hasMoreElements());
    TRUE(lst.remove(enm.nextElement()));
    FALSE(enm.hasMoreElements());
    EQUAL(lst.size(), 0);
  }

  public void compare()
  {
    MSG("̑召̔r");

    DefaultMapComparator<String,Object> comp
      = new DefaultMapComparator<String,Object>();
    comp.addKey("C2");
    comp.addKey("C1");
    comp.addKey("C0");

    Map<String,Object> m1 = new HashMap<String,Object>();
    Map<String,Object> m2 = new HashMap<String,Object>();

    EQUAL(comp.compare(m1, m2), 0);

    m1.put("C1", "a0");
    TRUE(comp.compare(m1, m2) < 0);

    m2.put("C1", "a2");
    TRUE(comp.compare(m1, m2) < 0);

    m1.put("C1", "a8");
    TRUE(comp.compare(m1, m2) > 0);

    m2.put("C1", "a8");
    EQUAL(comp.compare(m1, m2), 0);

    m2.put("C2", "x");
    TRUE(comp.compare(m1, m2) > 0);

    m1.put("C1", "a1");
    m2.put("C1", "a0");
    m1.put("C2", "x");
    m2.put("C2", "y");
    TRUE(comp.compare(m1, m2) < 0);
  }

  public void compare_1()
  {
    MSG("k̏ꍇ");

    DefaultMapComparator<String,Object> comp
      = new DefaultMapComparator<String,Object>();
    comp.addKey("C2");
    comp.addKey("C1");
    comp.addKey("C0");

    Map<String,Object> m1 = new HashMap<String,Object>();
    Map<String,Object> m2 = new HashMap<String,Object>();

    try {
      comp.compare(m1, null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }

    try {
      comp.compare(null, m2);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void compare_2()
  {
    MSG("lComparablepĂȂꍇ");

    DefaultMapComparator<String,Object> comp =
      new DefaultMapComparator<String,Object>();
    comp.addKey("C2");
    comp.addKey("C1");
    comp.addKey("C0");

    Map<String,Object> m1 = new HashMap<String,Object>();
    Map<String,Object> m2 = new HashMap<String,Object>();

    m1.put("C1", new Object());
    m2.put("C1", new Object());
    TRUE(comp.compare(m1, m2) != 0);
  }

  public void _equals()
  {
    MSG("IuWFNgǂmF");

    DefaultMapComparator<String,Object> comp0 =
      new DefaultMapComparator<String,Object>();
    comp0.addKey("C2");
    comp0.addKey("C1");
    comp0.addKey("C0");
    DefaultMapComparator<String,Object> comp1 =
      new DefaultMapComparator<String,Object>();
    comp1.addKey("C2");
    comp1.addKey("C1");
    comp1.addKey("C0");
    TRUE(comp0.equals(comp0));
    FALSE(comp0.equals(comp1));
  }

  public void setDirection()
  {
    MSG("召֌W̔tɂB");

    DefaultMapComparator<String,Object> comp =
      new DefaultMapComparator<String,Object>();
    comp.addKey("C2");
    comp.addKey("C1");
    comp.addKey("C0");

    DefaultMapComparator<String,Object> compR =
      new DefaultMapComparator<String,Object>();
    compR.setDirection(DefaultMapComparator.Direction.REVERSE);
    compR.addKey("C2");
    compR.addKey("C1");
    compR.addKey("C0");

    Map<String,Object> m1 = new HashMap<String,Object>();
    Map<String,Object> m2 = new HashMap<String,Object>();

    EQUAL(comp.compare(m1, m2), 0);
    EQUAL(compR.compare(m1, m2), 0);

    m1.put("C1", "a0");
    TRUE(comp.compare(m1, m2) < 0);
    TRUE(compR.compare(m1, m2) > 0);

    m2.put("C1", "a2");
    TRUE(comp.compare(m1, m2) < 0);
    TRUE(compR.compare(m1, m2) > 0);

    m1.put("C1", "a8");
    TRUE(comp.compare(m1, m2) > 0);
    TRUE(compR.compare(m1, m2) < 0);

    m2.put("C1", "a8");
    EQUAL(comp.compare(m1, m2), 0);
    EQUAL(compR.compare(m1, m2), 0);

    m2.put("C2", "x");
    TRUE(comp.compare(m1, m2) > 0);
    TRUE(compR.compare(m1, m2) < 0);

    m1.put("C1", "a1");
    m2.put("C1", "a0");
    m1.put("C2", "x");
    m2.put("C2", "y");
    TRUE(comp.compare(m1, m2) < 0);
    TRUE(compR.compare(m1, m2) > 0);
  }

  public void setNullOrder()
  {
    MSG("k̑召֌WtɂB");

    DefaultMapComparator<String,Object> comp =
      new DefaultMapComparator<String,Object>();
    comp.addKey("C2");
    comp.addKey("C1");
    comp.addKey("C0");

    DefaultMapComparator<String,Object> compR =
      new DefaultMapComparator<String,Object>();
    compR.setNullOrder(DefaultMapComparator.NullOrder.LEAST);
    compR.addKey("C2");
    compR.addKey("C1");
    compR.addKey("C0");

    Map<String,Object> m1 = new HashMap<String,Object>();
    Map<String,Object> m2 = new HashMap<String,Object>();

    EQUAL(comp.compare(m1, m2), 0);
    EQUAL(compR.compare(m1, m2), 0);

    m1.put("C1", "a0");
    TRUE(comp.compare(m1, m2) < 0);
    TRUE(compR.compare(m1, m2) > 0);

    m2.put("C1", "a2");
    TRUE(comp.compare(m1, m2) < 0);
    TRUE(compR.compare(m1, m2) < 0);

    m1.put("C1", "a8");
    TRUE(comp.compare(m1, m2) > 0);
    TRUE(compR.compare(m1, m2) > 0);

    m2.put("C1", "a8");
    EQUAL(comp.compare(m1, m2), 0);
    EQUAL(compR.compare(m1, m2), 0);

    m2.put("C2", "x");
    TRUE(comp.compare(m1, m2) > 0);
    TRUE(compR.compare(m1, m2) < 0);

    m1.put("C1", "a1");
    m2.put("C1", "a0");
    m1.put("C2", "x");
    m2.put("C2", "y");
    TRUE(comp.compare(m1, m2) < 0);
    TRUE(compR.compare(m1, m2) < 0);
  }

  public void setDirectionAndSetNullOrder()
  {
    MSG("l̑召֌Wƃk̑召֌WtɂB");

    DefaultMapComparator<String,Object> comp =
      new DefaultMapComparator<String,Object>();
    comp.addKey("C2");
    comp.addKey("C1");
    comp.addKey("C0");

    DefaultMapComparator<String,Object> compR =
      new DefaultMapComparator<String,Object>();
    compR.setDirection(DefaultMapComparator.Direction.REVERSE);
    compR.setNullOrder(DefaultMapComparator.NullOrder.LEAST);
    compR.addKey("C2");
    compR.addKey("C1");
    compR.addKey("C0");

    Map<String,Object> m1 = new HashMap<String,Object>();
    Map<String,Object> m2 = new HashMap<String,Object>();

    EQUAL(comp.compare(m1, m2), 0);
    EQUAL(compR.compare(m1, m2), 0);

    m1.put("C1", "a0");
    TRUE(comp.compare(m1, m2) < 0);
    TRUE(compR.compare(m1, m2) < 0);

    m2.put("C1", "a2");
    TRUE(comp.compare(m1, m2) < 0);
    TRUE(compR.compare(m1, m2) > 0);

    m1.put("C1", "a8");
    TRUE(comp.compare(m1, m2) > 0);
    TRUE(compR.compare(m1, m2) < 0);

    m2.put("C1", "a8");
    EQUAL(comp.compare(m1, m2), 0);
    EQUAL(compR.compare(m1, m2), 0);

    m2.put("C2", "x");
    TRUE(comp.compare(m1, m2) > 0);
    TRUE(compR.compare(m1, m2) > 0);

    m1.put("C1", "a1");
    m2.put("C1", "a0");
    m1.put("C2", "x");
    m2.put("C2", "y");
    TRUE(comp.compare(m1, m2) < 0);
    TRUE(compR.compare(m1, m2) > 0);
  }
}
