/*
 * StringConverter03StrParTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.text;

import ts.tester.function.FunctionTester;
import java.util.*;

/**
 * {@link ts.util.text.StringConverter StringConverter}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:53 $
 */
public class StringConverter03StrParTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      run(StringConverter03StrParTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- test case -- */

  public void fromReadString_str_open_close_esc_spec()
  {
    MSG("k̏ꍇB");

    List<String> spL = Arrays.asList(",", "|", "\"");

    try {
      StringConverter.fromReadString(null, "\\", "(", ")", spL);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.fromReadString("abc", null, "(", ")", spL);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.fromReadString("abc", "\\", null, ")", spL);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.fromReadString("abc", "\\", "(", null, spL);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.fromReadString("abc", "\\", "(", ")", null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void fromReadString_str_open_close_esc_spec_0()
  {
    MSG("GXP[vAʂ̏ꍇB");

    Collection<String> spL = Arrays.asList(",", "|", "\"");

    try {
      StringConverter.fromReadString("abc", "", "(", ")", spL);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.fromReadString("abc", "\\", "", ")", spL);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.fromReadString("abc", "\\", "(", "", spL);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    spL = Arrays.asList(",", "");
    try {
      StringConverter.fromReadString("abc", "\\", "(", ")", spL);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    spL = Arrays.asList(",", null);
    try {
      StringConverter.fromReadString("abc", "\\", "(", ")", spL);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void fromReadString_str_open_close_esc_spec_1()
  {
    MSG("ǂݍ񂾕񂪋󕶎̏ꍇB");

    Collection<String> spL = Arrays.asList(",", "|", "\"");

    try {
      StringConverter.fromReadString("", "(", ")", "\\", spL);
    } catch (StartWithoutParenthesisException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 0);
      EQUAL(e.convertedString(), "");
    } catch (Exception e) {
      NG(e);
    }
  }

  public void fromReadString_str_open_close_esc_spec_2() throws Exception
  {
    MSG("ɕϊłꍇB");

    Collection<String> spL = Arrays.asList(",", "\"");

    EQUAL(StringConverter.fromReadString("(abc)", "(", ")", "#", spL), "abc");
    EQUAL(StringConverter.fromReadString("()", "(", ")", "#", spL), "");
    EQUAL(StringConverter.fromReadString("(a#(bc)","(",")","#",spL),"a(bc");
    EQUAL(StringConverter.fromReadString("(abc#))","(",")","#",spL),"abc)");
    EQUAL(StringConverter.fromReadString("(ab##c)","(",")","#",spL),"ab#c");
    EQUAL(StringConverter.fromReadString("(#\"abc)","(",")","#",spL),"\"abc");
    EQUAL(StringConverter.fromReadString("(  abc)","(",")","#",spL),"  abc");
    EQUAL(StringConverter.fromReadString("(abc  )","(",")","#",spL),"abc  ");
    EQUAL(StringConverter.fromReadString("(abc # )","(",")","#",spL),"abc  ");
  }

  public void fromReadString_str_open_close_esc_spec_3()
  {
    MSG("ꕶGXP[vĂȂꍇB");

    Collection<String> spL = Arrays.asList(",", "\"");

    try {
      StringConverter.fromReadString("(a(bc)", "(", ")", "\\", spL);
      NG();
    } catch (SpecialCharNotEscapedException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 2);
      EQUAL(e.convertedString(), "a");
      EQUAL(e.getSpecialChar(), "(");
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.fromReadString("(abc))", "(", ")", "\\", spL);
      NG();
    } catch (SpecialCharNotEscapedException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 4);
      EQUAL(e.convertedString(), "abc");
      EQUAL(e.getSpecialChar(), ")");
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.fromReadString("(\"abc)", "(", ")", "\\", spL);
      NG();
    } catch (SpecialCharNotEscapedException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 1);
      EQUAL(e.convertedString(), "");
      EQUAL(e.getSpecialChar(), "\"");
    } catch (Exception e) {
      NG(e);
    }
  }

  public void fromReadString_str_open_close_esc_spec_4()
  {
    MSG("GXP[vŏIĂꍇB");

    Collection<String> spL = Arrays.asList(",", "\"");

    try {
      StringConverter.fromReadString("(abc\\", "(", ")", "\\", spL);
      NG();
    } catch (EndWithEscapeCharException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 4);
      EQUAL(e.convertedString(), "abc");
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.fromReadString("(\\", "(", ")", "\\", spL);
      NG();
    } catch (EndWithEscapeCharException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 1);
      EQUAL(e.convertedString(), "");
    } catch (Exception e) {
      NG(e);
    }
  }

  public void fromReadString_str_open_close_esc_spec_5()
  {
    MSG("[ʂłȂꍇB");

    Collection<String> spL = Arrays.asList(",", "\"");

    try {
      StringConverter.fromReadString("abc)", "(", ")", "\\", spL);
      NG();
    } catch (StartWithoutParenthesisException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 0);
      EQUAL(e.convertedString(), "");
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.fromReadString("(abc", "(", ")", "\\", spL);
      NG();
    } catch (EndWithoutParenthesisException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 4);
      EQUAL(e.convertedString(), "abc");
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.fromReadString("abc", "(", ")", "\\", spL);
      NG();
    } catch (StartWithoutParenthesisException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 0);
      EQUAL(e.convertedString(), "");
    } catch (Exception e) {
      NG(e);
    }
  }

  public void fromReadString_str_open_close_esc_spec_6()
  {
    MSG("ʓ̕񂪃GXP[vŏIĂꍇB");

    Collection<String> spL = Arrays.asList(",", "\"");

    try {
      StringConverter.fromReadString("(abc\\)", "(", ")", "\\", spL);
      NG();
    } catch (EndWithEscapeCharException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 5);
      EQUAL(e.convertedString(), "abc");
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.fromReadString("(\\)", "(", ")", "\\", spL);
      NG();
    } catch (EndWithEscapeCharException e) {
      OK(e);
      EQUAL(e.getStoppedIndex(), 2);
      EQUAL(e.convertedString(), "");
    } catch (Exception e) {
      NG(e);
    }
  }

  public void fromReadString_str_open_close_esc_spec_7()
  {
    MSG("ʂGXP[v̏̕ꍇB");

    Collection<String> spL = Arrays.asList(",", "\"");
    
    try {
      EQUAL(StringConverter.fromReadString("((abc))", "((", "))", "##", spL),
        "abc");
    } catch (StringConvertException e) {
      NG(e);
    }

    try {
      EQUAL(StringConverter.fromReadString("(())", "((", "))", "##", spL),
        "");
    } catch (StringConvertException e) {
      NG(e);
    }

    try {
      EQUAL(StringConverter.fromReadString("((a##(bc))", "((", "))", "##", spL),
        "a(bc");
    } catch (StringConvertException e) {
      NG(e);
    }
  }

  public void fromReadString_str_open_close_esc_spec_8()
  {
    MSG("Jʂƕʂ̏ꍇB");

    List<String> spL = Arrays.asList(",");

    try {
      EQUAL(StringConverter.fromReadString("\"abc\"", "\"", "\"", "##", spL),
        "abc");
    } catch (StringConvertException e) {
      NG(e);
    }

    try {
      EQUAL(StringConverter.fromReadString("\"a$\"bc\"", "\"", "\"", "$", spL),
        "a\"bc");
    } catch (StringConvertException e) {
      NG(e);
    }

    try {
      EQUAL(StringConverter.fromReadString(
        "\"\"a##\"\"b\"c\"\"", "\"\"", "\"\"", "##", spL), "a\"\"b\"c");
    } catch (StringConvertException e) {
      NG(e);
    }
  }

  public void fromReadString_str_open_close_esc_spec_9()
  {
    MSG("JʂƕʂƃGXP[v񂪓̏ꍇB");

    List<String> spL = Arrays.asList(",");

    try {
      EQUAL(StringConverter.fromReadString("\"\"\"\"\"\",\"",
        "\"", "\"", "\"", spL), "\"\",");;
    } catch (StringConvertException e) {
      NG(e);
    } 

    try {
      EQUAL(StringConverter.fromReadString("\"\"\"\"\"\"\"\"\",\"\"",
        "\"\"", "\"\"", "\"\"", spL), "\"\"\",");
    } catch (StringConvertException e) {
      NG(e);
    }
  }

  public void fromReadString_str_open_close_esc_spec_10()
  {
    MSG("GXP[vAđꍇB");

    List<String> spL = Arrays.asList("#");

    try {
      EQUAL(StringConverter.fromReadString("#############",
        "##", "##", "##", spL), "###");
    } catch (StringConvertException e) {
      NG(e);
    }
  }

  public void toWriteString_str_open_close_esc_spec()
  {
    MSG("k̏ꍇB");

    List<String> spL = Arrays.asList(",");

    try {
      StringConverter.toWriteString(null, "(", ")", "\\", spL);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.toWriteString("abc", null, ")", "\\", spL);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.toWriteString("abc", "(", null, "\\", spL);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.toWriteString("abc", "(", ")", null, spL);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.toWriteString("abc", "(", ")", "\\", null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void toWriteString_str_open_close_esc_spec_0()
  {
    MSG("ʏ̏ꍇB");

    List<String> spL = Arrays.asList(",", "\"");

    EQUAL(StringConverter.toWriteString("", "(", ")", "\\", spL),
      "()");
    EQUAL(StringConverter.toWriteString("abc", "(", ")", "\\", spL),
      "(abc)");
    EQUAL(StringConverter.toWriteString("a,bc", "(", ")", "\\", spL),
      "(a\\,bc)");
    EQUAL(StringConverter.toWriteString("ab\"c", "(", ")", "\\", spL),
      "(ab\\\"c)");
    EQUAL(StringConverter.toWriteString("abc\\", "(", ")", "\\", spL),
      "(abc\\\\)");
    EQUAL(StringConverter.toWriteString("(abc", "(", ")", "\\", spL),
      "(\\(abc)");
    EQUAL(StringConverter.toWriteString(")abc", "(", ")", "\\", spL),
      "(\\)abc)");
    EQUAL(StringConverter.toWriteString("  abc", "(", ")", "\\", spL),
      "(  abc)");
    EQUAL(StringConverter.toWriteString("a bc  ", "(", ")", "\\", spL),
      "(a bc  )");
    EQUAL(StringConverter.toWriteString(" abc ", "(", ")", "\\", spL),
      "( abc )");
    EQUAL(StringConverter.toWriteString(" ", "(", ")", "\\", spL),
      "( )");
  }

  public void toWriteString_str_open_close_esc_spec_1() throws Exception
  {
    MSG("fromReadStringŌɖ߂邩B");

    String op = "(";
    String cp = ")";
    String esc = "\\";
    List<String> spec = Arrays.asList(",", "\"");

    String s = "";
    EQUAL(StringConverter.fromReadString(StringConverter.toWriteString(
      s, op, cp, esc, spec), op, cp, esc, spec), s);

    s = "abc";
    EQUAL(StringConverter.fromReadString(StringConverter.toWriteString(
      s, op, cp, esc, spec), op, cp, esc, spec), s);

    s = "ab\"c";
    EQUAL(StringConverter.fromReadString(StringConverter.toWriteString(
      s, op, cp, esc, spec), op, cp, esc, spec), s);

    s = "abc\\";
    EQUAL(StringConverter.fromReadString(StringConverter.toWriteString(
      s, op, cp, esc, spec), op, cp, esc, spec), s);

    s = "(abc";
    EQUAL(StringConverter.fromReadString(StringConverter.toWriteString(
      s, op, cp, esc, spec), op, cp, esc, spec), s);

    s = ")abc";
    EQUAL(StringConverter.fromReadString(StringConverter.toWriteString(
      s, op, cp, esc, spec), op, cp, esc, spec), s);

    s = "  abc";
    EQUAL(StringConverter.fromReadString(StringConverter.toWriteString(
      s, op, cp, esc, spec), op, cp, esc, spec), s);

    s = "a bc  ";
    EQUAL(StringConverter.fromReadString(StringConverter.toWriteString(
      s, op, cp, esc, spec), op, cp, esc, spec), s);

    s = " abc ";
    EQUAL(StringConverter.fromReadString(StringConverter.toWriteString(
      s, op, cp, esc, spec), op, cp, esc, spec), s);

    s = " ";
    EQUAL(StringConverter.fromReadString(StringConverter.toWriteString(
      s, op, cp, esc, spec), op, cp, esc, spec), s);
  }

  public void toWriteString_str_open_close_esc_spec_2()
  {
    MSG("GXP[vAꕶɋ󔒂܂܂ĂꍇB");

    String op = "(";
    String cp = ")";
    String esc = "\\";
    List<String> spec = Arrays.asList(",", "");

    try {
      StringConverter.toWriteString("abc", op, cp, esc, spec);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    spec = Arrays.asList(",", null);
    try {
      StringConverter.toWriteString("abc", op, cp, esc, spec);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    spec = Arrays.asList(",", "\"");
    try {
      StringConverter.toWriteString("abc", op, cp, "", spec);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.toWriteString("abc", "", cp, esc, spec);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      StringConverter.toWriteString("abc", op, "", esc, spec);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }
}

