/*
 * TypedGetter class.
 *
 * Copyright (C) 2011 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util;

import java.math.BigDecimal;
import java.util.List;
import java.io.Serializable;

/**
 * L[ɌтꂽlIuWFNg^ϊĎ擾邽߂̃\bh
 * 錾C^[tFCXB
 *
 * @author V
 * @version $Id: TypedGetter.java,v 1.3 2011-08-01 15:29:30 tayu Exp $
 */
public interface TypedGetter<K> extends Serializable
{
  /**
   * w肳ꂽL[ɌтꂽlIuWFNg<tt>boolean</tt>ɕϊ
   * 擾B
   *
   * @param key L[B
   * @return <tt>boolean</tt>^ɕϊꂽlB
   */
  boolean getBoolean(K key);

  /**
   * w肳ꂽL[ɌтꂽlIuWFNg<tt>int</tt>^ɕϊ
   * 擾B
   *
   * @param key L[B
   * @return <tt>int</tt>^ɕϊꂽlB
   */
  int getInteger(K key);

  /**
   * w肳ꂽL[ɌтꂽlIuWFNg<tt>long</tt>^ɕϊ
   * 擾B
   * <br>
   * lIuWFNg݂Ȃꍇk̏ꍇ<tt>0</tt>ԂB
   *
   * @param key L[B
   * @return <tt>long</tt>^ɕϊꂽlB
   */
  long getLong(K key);

  /**
   * w肳ꂽL[ɌтꂽlIuWFNg<tt>float</tt>^ɕϊ
   * 擾B
   * <br>
   * lIuWFNg݂Ȃꍇk̏ꍇ<tt>0.0</tt>ԂB
   *
   * @param key L[B
   * @return <tt>float</tt>^ɕϊꂽlB
   */
  float getFloat(K key);

  /**
   * w肳ꂽL[ɌтꂽlIuWFNg<tt>double</tt>^ɕϊ
   * 擾B
   * <br>
   * lIuWFNg݂Ȃꍇk̏ꍇ<tt>0.0</tt>ԂB
   *
   * @param key L[B
   * @return <tt>double</tt>^ɕϊꂽlB
   */
  double getDouble(K key);

  /**
   * w肳ꂽL[ɌтꂽlIuWFNg{@link BigDecimal}
   * IuWFNgɕϊĎ擾B
   * <br>
   * lIuWFNg݂Ȃꍇk̏ꍇ͒l<tt>0</tt>{@link
   * BigDecimal}IuWFNgԂB
   *
   * @param key L[B
   * @return {@link BigDecimal}IuWFNgB
   */
  BigDecimal getBigDecimal(K key);

  /**
   * w肳ꂽL[ɌтꂽlIuWFNg𕶎IuWFNgɕϊ
   * 擾B
   * <br>
   * lIuWFNg݂Ȃꍇk̏ꍇ͋󕶎ԂB
   *
   * @param key L[B
   * @return IuWFNgɕϊꂽlIuWFNgB
   */
  String getString(K key);

  /**
   * w肳ꂽL[ɌтꂽlIuWFNgAw肳ꂽl
   * gĕIuWFNgɕϊĎ擾B
   * <br>
   * w肳ꂽL[ɌтꂽlIuWFNg𐔒lɕϊłȂꍇ
   * 󕶎ԂB
   *
   * @param key L[B
   * @param formatString lB
   * @return IuWFNgɕϊꂽlIuWFNgB
   */
  String getNumberString(K key, String formatString);

  /**
   * w肳ꂽL[ɌтꂽlIuWFNgAw肳ꂽ
   * gĕIuWFNgɕϊĎ擾B
   * <br>
   * w肳ꂽL[ɌтꂽlIuWFNgɕϊłȂꍇ
   * 󕶎ԂB
   *
   * @param key L[B
   * @param formatString B
   * @return IuWFNgɕϊꂽlIuWFNgB
   */
  String getDateTimeString(K key, String formatString);

  /**
   * w肳ꂽL[ɌтꂽlIuWFNgIuWFNgɕϊ
   * 擾B
   *
   * @param key L[B
   * @return IuWFNgɕϊꂽlIuWFNgB
   */
  DateTime getDateTime(K key);

  /**
   * w肳ꂽL[ɌтꂽlIuWFNgXgEIuWFNgɕϊ
   * Ď擾B
   * <br>
   * тĂlIuWFNgPl̏ꍇ́A̒lIuWFNgB
   * vfƂ郊XgEIuWFNg쐬ĕԂB
   *
   * @param key L[B
   * @return {@link List}IuWFNgɕϊꂽlIuWFNgB
   */
  List<? extends Object> getList(K key);
}
