/*
 * Table class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.table;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

/**
 * }bvEIuWFNgR[hƂe[ũC^[tFCXB
 * <br>
 * L[\ł}bvEIuWFNgR[hƂāÃR[h̏W
 * \vfƂĎB
 * <br>
 * e[u̓e̎擾XV̓R[hPʂōsB
 * 擾XV̏ƂJEL[Ƃ̒ĺA}bvɊi[ĈƂ
 * \bhɓnB
 * R[h擾郁\bhɂ{@link #select(java.util.Map)}
 * {@link #selectFirst(java.util.Map)}B
 * R[h폜郁\bhɂ{@link #delete(java.util.Map)}B
 * R[hXV郁\bhɂ{@link #update(java.util.Map,java.util.Map)}
 * B
 * <br>
 * R[hǉɂ́A{@link #appendNew()}\bhpB
 * {@link #appendNew()}\bh́A߂lƂăe[uɒǉꂽR[h
 * }bvԂB
 *
 * @param  <C> JEL[̃^CvB
 * @param  <V> J̒l̃^CvB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2011-08-01 15:29:33 $
 */
public interface Table<C,V> extends MapAppender<C,V>, Serializable
{
  /**
   * e[u\JEL[̐擾B
   *
   * @return JEL[̐B
   */
  int columnCount();

  /**
   * e[uɊi[Ă郌R[h̐擾B
   *
   * @return R[hB
   */
  int recordCount();

  /**
   * ̃e[u\JEL[񋓂B
   *
   * @return JEL[i[񋓃IuWFNgB
   */
  Enumeration<C> columns();

  /**
   * ̃e[uɊi[Ă郌R[hɎo߂̃Ce[^擾
   * B
   *
   * @return R[h̃Ce[^B
   */
  MapIterator<C,V> records();

  /**
   * ̃e[uɊi[Ă郌R[h\[gāAɎo߂
   * Ce[^擾B
   *
   * @param  comparator \[gɎgp郌R[hrIuWFNgB
   * @return R[h̃Ce[^B
   */
  MapIterator<C,V> records(MapComparator<C,V> comparator);

  /**
   * ̃e[uɊi[Ăŏ̃R[h擾B
   *
   * @return ̃e[u̍ŏ̃R[hB
   */
  Map<C,V> recordFirst();

  /**
   * ̃e[uɊi[Ă郌R[hSč폜B
   */
  void deleteAll();

  /**
   * w肳ꂽJ̒lw肳ꂽlƈv郌R[h݂邩ǂ
   * mFB
   *
   * @param  column ƂJEL[B
   * @param  value  ƂJ̒lB
   * @return Y郌R[h݂ꍇ<tt>true</tt>ԂB
   */
  boolean exists(C column, V value);

  /**
   * ɊY郌R[h݂邩ǂmFB
   * <br>
   * ̃}bvɊi[ĂL[ƒl̑gݍ킹Ɠgݍ킹
   * R[hA1ł݂ꍇ<tt>true</tt>ԂB
   * <br>
   * <br>
   * ̃}bṽL[̒ɁÃe[ũJEL[ɑ݂Ȃ̂
   * ꍇ́A<tt>false</tt>ԂB
   * <br>
   * ΂ɁÃe[ũJEL[̒ɁÃ}bvɑ݂ȂL[
   * ĂĂA͖BȊÕJEL[̒l
   * R[h<tt>true</tt>ԂB
   * <br>
   * ̃}bv󂾂ꍇ͏ȂƂāÃe[uɃR[h1
   * łꍇ<tt>true</tt>ԂB
   *
   * @param  condition ̃JƂ̒li[}bvEIuWFNgB
   * @return Y郌R[h݂ꍇ<tt>true</tt>ԂB
   */
  boolean exists(Map<C,V> condition);

  /**
   * w肳ꂽJ̒lw肳ꂽlƍŏɈvR[hԂB
   *
   * @param  column ƂJEL[B
   * @param  value  ƂJ̒lB
   * @return w肳ꂽJ̒lƍŏɈvR[hB
   */
  Map<C,V> selectFirst(C column, V value);

  /**
   * ɍŏɊYR[h擾B
   * <br>
   * ̃}bvɊi[ĂL[ƒl̑gݍ킹Ɠgݍ킹
   * R[hA̍ŏ̃R[hԂB
   * <br>
   * Y郌R[h1݂Ȃꍇ̓kԂB
   * <br>
   * <br>
   * ̃}bṽL[̒ɁÃe[ũJEL[ɑ݂Ȃ̂
   * ꍇ́ASẴR[hYȂȂAkԂB
   * <br>
   * ΂ɁÃe[ũJEL[̒ɁÃ}bvɑ݂ȂL[
   * ĂĂA͖BȊÕJEL[̒l
   * R[h΁A̍ŏ̃R[hԂB
   * <br>
   * ̃}bv󂾂ꍇ͏ȂƂāÃe[uɊi[Ă
   * ŏ̃R[hԂB
   *
   * @param  condition ̃JƂ̒li[}bvEIuWFNgB
   * @return w肳ꂽJ̒lƈv郌R[hB
   */
  Map<C,V> selectFirst(Map<C,V> condition);

  /**
   * w肳ꂽJ̒lw肳ꂽlƈv郌R[hi[Xg
   * 擾B
   *
   * @param  column ƂJEL[B
   * @param  value  ƂJ̒lB
   * @return w肳ꂽJ̒lƈv郌R[hi[XgB
   */
  List<Map<C,V>> select(C column, V value);

  /**
   * ɊY郌R[hi[Xg擾B
   * <br>
   * ̃}bvɊi[ĂL[ƒl̑gݍ킹Ɠgݍ킹
   * R[hÃR[hi[XgԂB
   * <br>
   * Y郌R[h1݂Ȃꍇ͋̃XgԂB
   * <br>
   * <br>
   * ̃}bṽL[̒ɁÃe[ũJEL[ɑ݂Ȃ̂
   * ꍇ́ASẴR[hYȂȂÃXgԂB
   * <br>
   * ΂ɁÃe[ũJEL[̒ɁÃ}bvɑ݂ȂL[
   * ĂĂA͖BȊÕJEL[̒l
   * R[h΁AXgɊi[ĕԂB
   * <br>
   * ̃}bv󂾂ꍇ͏ȂƂāÃe[uɊi[Ă
   * SẴR[hi[XgԂB
   *
   * @param  condition ̃JƂ̒li[}bvEIuWFNgB
   * @return w肳ꂽJ̒lƈv郌R[hi[XgB
   */
  List<Map<C,V>> select(Map<C,V> condition);

  /**
   * ɊY郌R[hÃe[uEIuWFNg폜B
   * <br>
   * ̃}bvɊi[ĂL[ƒl̑gݍ킹Ɠgݍ킹
   * R[hāÃe[u폜B
   * <br>
   * 폜ꂽR[h́AXgɊi[Ė߂lƂĕԂB
   * <br>
   * <br>
   * ̃}bṽL[̒ɁÃe[ũJEL[ɑ݂Ȃ̂
   * ꍇ́ASẴR[hɊYȂȂA1폜ȂB
   * <br>
   * ΂ɁÃe[ũJEL[̒ɁÃ}bvɑ݂ȂL[
   * ĂĂA͖BȊÕJEL[̒l
   * R[h΁Ãe[u폜AXgɊi[ĕԂB
   * <br>
   * ̃}bv󂾂ꍇ͏ȂƂāÃe[uɊi[Ă
   * SẴR[h폜AXgɊi[ĕԂB
   *
   * @param  condition ƂJƂ̒li[}bvEIuWFNgB
   * @return 폜ꂽR[hi[XgB
   */
  List<Map<C,V>> delete(Map<C,V> condition);

  /**
   * ɊY郌R[hAw肳ꂽ}bv̓eōXVB
   * <br>
   * 1̃}bvɊi[ĂL[ƒl̑gݍ킹Ɠgݍ킹
   * R[hāA̒̓e2̃}bv̓eōXVB
   * <br>
   * XVꂽR[h́AVɍ쐬ꂽe[uEIuWFNgɊi[
   * ߂lƂĕԂB
   * <br>
   * <br>
   * ̃}bṽL[̒ɁÃe[ũJEL[ɑ݂Ȃ̂
   * ꍇ́ASẴR[hɊYȂȂA1XVȂB
   * <br>
   * ΂ɁÃe[ũJEL[̒ɁÃ}bvɑ݂ȂL[
   * ĂĂA͖BȊÕJEL[̒l
   * R[h΁A̓eXVAXgɊi[ĕԂB
   * <br>
   * ̃}bv󂾂ꍇ͏ȂƂāÃe[uɊi[Ă
   * SẴR[h̓eXVAXgɊi[ĕԂB
   *
   * @param  condition ƂJƂ̒li[}bvEIuWFNgB
   * @param  destination XVJƂ̒li[}bvEIuWFNgB
   * @return XVꂽR[hi[XgB
   */
  List<Map<C,V>> update(Map<C,V> condition, Map<C,V> destination);

  /**
   * w肳ꂽz̗vfCfbNXEL[ƂCfbNX擾B
   * <br>
   * YCfbNX݂Ȃꍇ́ACfbNX쐬ĕԂB
   *
   * @param  indexKeys CfbNXEL[̔zB
   * @return ̃e[ũCfbNXEIuWFNgB
   */
  Index<C,V> getIndex(C ... indexKeys);

  /**
   * gK[ǉB
   * <br>
   * ǉꂽgK[́Ãe[u̓eύX钼Oyђ
   * ĂяoAe[u̕ύX̎ނƕύX̑Oɉ\bhs
   * B
   *
   * @param  trigger gK[EIuWFNgB
   */
  void addTrigger(Trigger<C,V> trigger);
}

